/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import java.util.ArrayList;
import java.util.regex.Pattern;

public final class ThreadUtility {
    public static boolean debug = false;

    private ThreadUtility() {
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static boolean isRunning(String threadNamePattern) {
        int threadCount = ThreadUtility.getThreadCount(threadNamePattern);
        if (debug) {
            System.out.printf("\nThreadUtility.isRunning(threadNamePattern=%s):  Thread Count: %d\n", threadNamePattern, threadCount);
        }
        return threadCount > 0;
    }

    public static void waitFor(String threadNamePattern) {
        ThreadUtility.waitFor(threadNamePattern, Long.MAX_VALUE);
    }

    public static boolean waitFor(String threadNamePattern, long timeout) {
        if (debug) {
            System.out.printf("\n\nThreadUtility.waitFor(threadNamePattern=%s, timeout=%d)\n", threadNamePattern, timeout);
        }
        long startTime = System.currentTimeMillis();
        long timeElapsed = 0L;
        while (!ThreadUtility.isRunning(threadNamePattern) && timeElapsed < timeout) {
            ThreadUtility.sleep(100L);
            timeElapsed = System.currentTimeMillis() - startTime;
        }
        return ThreadUtility.isRunning(threadNamePattern);
    }

    public static void waitThenYield(String threadNamePattern) {
        ThreadUtility.waitThenYield(threadNamePattern, Long.MAX_VALUE);
    }

    public static boolean waitThenYield(String threadNamePattern, long timeout) {
        boolean threadsExist = ThreadUtility.waitFor(threadNamePattern, timeout);
        if (threadsExist) {
            return ThreadUtility.yieldTo(threadNamePattern, timeout);
        }
        return threadsExist;
    }

    public static void yieldTo(String threadNamePattern) {
        ThreadUtility.yieldTo(threadNamePattern, Long.MAX_VALUE);
    }

    public static boolean yieldTo(String threadNamePattern, long timeout) {
        if (debug) {
            System.out.printf("\n\nThreadUtility.yieldTo(threadNamePattern=%s, timeout=%d)\n", threadNamePattern, timeout);
        }
        long startTime = System.currentTimeMillis();
        long timeElapsed = 0L;
        while (ThreadUtility.isRunning(threadNamePattern) && timeElapsed < timeout) {
            ThreadUtility.sleep(100L);
            timeElapsed = System.currentTimeMillis() - startTime;
        }
        return ThreadUtility.isRunning(threadNamePattern);
    }

    public static void yieldAndInvoke(String threadNamePattern, Object targetObject, String methodToInvoke) {
        ThreadUtility.yieldAndInvoke(threadNamePattern, Long.MAX_VALUE, targetObject, methodToInvoke);
    }

    public static void yieldAndInvoke(String threadNamePattern, long timeout, Object targetObject, String methodToInvoke) {
        new AsynchMethodInvoker(ThreadUtility.class, "_yieldAndInvoke", new Object[]{threadNamePattern, timeout, targetObject, methodToInvoke});
    }

    public static void _yieldAndInvoke(String threadNamePattern, long timeout, Object targetObject, String methodToInvoke) {
        long startTime = System.currentTimeMillis();
        long timeElapsed = 0L;
        while (ThreadUtility.isRunning(threadNamePattern) && timeElapsed < timeout) {
            ThreadUtility.sleep(100L);
            timeElapsed = System.currentTimeMillis() - startTime;
        }
        MethodInvoker mi = new MethodInvoker(targetObject, methodToInvoke, new Object[0]);
        mi.invoke();
    }

    public static int getThreadCount() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        return ThreadUtility.getThreadCount(threadGroup);
    }

    public static int getThreadCount(ThreadGroup threadGroup) {
        if (threadGroup == null) {
            return 0;
        }
        int activeCount = threadGroup.activeCount();
        int activeGroups = threadGroup.activeGroupCount();
        ThreadGroup[] children = new ThreadGroup[activeGroups * 2];
        threadGroup.enumerate(children);
        ThreadGroup[] threadGroupArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadGroup child = threadGroupArray[n2];
            activeCount += ThreadUtility.getThreadCount(child);
            ++n2;
        }
        return activeCount;
    }

    public static int getThreadCount(String threadName) {
        return ThreadUtility.getThreadCount(Thread.currentThread().getThreadGroup(), Pattern.compile(threadName));
    }

    public static int getThreadCount(ThreadGroup threadGroup, Pattern namePattern) {
        int threadCount = 0;
        int numThreads = threadGroup.activeCount();
        Thread[] threads = new Thread[numThreads * 10];
        numThreads = threadGroup.enumerate(threads, false);
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            String threadName;
            Thread thread = threadArray[n2];
            if (thread != null && namePattern.matcher(threadName = thread.getName()).find() && thread.isAlive() && !thread.isDaemon()) {
                ++threadCount;
            }
            ++n2;
        }
        int numGroups = threadGroup.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = threadGroup.enumerate(groups, false);
        ThreadGroup[] threadGroupArray = groups;
        int n3 = groups.length;
        int n4 = 0;
        while (n4 < n3) {
            ThreadGroup tGroup = threadGroupArray[n4];
            threadCount += ThreadUtility.getThreadCount(tGroup, namePattern);
            ++n4;
        }
        return threadCount;
    }

    public static ArrayList<Thread> getActiveThreads() {
        ArrayList<Thread> activeThreads = new ArrayList<Thread>();
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        ThreadUtility.getThreadGroupThreads(threadGroup, activeThreads);
        return activeThreads;
    }

    private static void getThreadGroupThreads(ThreadGroup threadGroup, ArrayList<Thread> activeThreads) {
        int numThreads = threadGroup.activeCount();
        Thread[] threads = new Thread[numThreads * 2];
        numThreads = threadGroup.enumerate(threads, false);
        Thread[] threadArray = threads;
        int n = threads.length;
        int n2 = 0;
        while (n2 < n) {
            Thread t = threadArray[n2];
            if (t != null) {
                activeThreads.add(t);
            }
            ++n2;
        }
        int numGroups = threadGroup.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[numGroups * 2];
        numGroups = threadGroup.enumerate(groups, false);
        ThreadGroup[] threadGroupArray = groups;
        int n3 = groups.length;
        int n4 = 0;
        while (n4 < n3) {
            ThreadGroup tGroup = threadGroupArray[n4];
            ThreadUtility.getThreadGroupThreads(tGroup, activeThreads);
            ++n4;
        }
    }

    public static void showActiveThreads() {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        threadGroup.list();
    }

    public static void killThreads(String name) {
        ThreadUtility.killThreads(Thread.currentThread().getThreadGroup(), Pattern.compile(name));
    }

    private static void killThreads(ThreadGroup threadGroup, Pattern namePattern) {
        ArrayList<Thread> activeThreads = new ArrayList<Thread>();
        ThreadUtility.getThreadGroupThreads(threadGroup, activeThreads);
        for (Thread thread : activeThreads) {
            String threadName;
            if (thread == null || !namePattern.matcher(threadName = thread.getName()).find() || !thread.isAlive() || thread.isDaemon()) continue;
            thread.interrupt();
        }
    }
}

