/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util;

import com.jmorgan.lang.ExceptionUtility;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.TimeException;
import java.io.Serializable;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public class Time
implements Comparable<Object>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 3237912715639071099L;
    public static final SimpleDateFormat FULL_FORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    public static final SimpleDateFormat LONG_FORMAT_24 = new SimpleDateFormat("HH:mm:ss");
    public static final SimpleDateFormat LONG_FORMAT_12 = new SimpleDateFormat("hh:mm:ss a");
    public static final SimpleDateFormat SHORT_FORMAT_24 = new SimpleDateFormat("HH:mm");
    public static final SimpleDateFormat SHORT_FORMAT_12 = new SimpleDateFormat("hh:mm a");
    public static final SimpleDateFormat COMPRESSED_FORMAT = new SimpleDateFormat("HHmmss");
    public static final SimpleDateFormat COMPRESSED_FRACTIONAL_FORMAT = new SimpleDateFormat("HHmmss.SSS");
    public static final SimpleDateFormat FILENAME_FRIENDLY_FORMAT = new SimpleDateFormat("HH-mm-ss");
    private SimpleDateFormat format = LONG_FORMAT_24;
    private Calendar calendar;

    public Time() {
        this.calendar = Calendar.getInstance();
    }

    public Time(Calendar time) {
        this.calendar = time;
    }

    public Time(String time) throws TimeException {
        this();
        this.setTime(time);
    }

    public Time(int hour, int minute, int second) throws TimeException {
        this();
        this.setTime(hour, minute, second);
    }

    public Time(long timeInMilliseconds) {
        this();
        this.calendar.setTimeInMillis(timeInMilliseconds);
    }

    public Time(Timestamp timestamp) {
        this(timestamp.getTime());
    }

    public Calendar getCalendar() {
        return (Calendar)this.calendar.clone();
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public int getMillisecond() {
        return this.calendar.get(14);
    }

    public TimeZone getTimeZone() {
        return this.calendar.getTimeZone();
    }

    public long getDifferenceInSeconds(Time that) {
        that.calendar.set(1, this.calendar.get(1));
        that.calendar.set(2, this.calendar.get(2));
        that.calendar.set(5, this.calendar.get(5));
        long thisMillis = this.calendar.getTimeInMillis();
        long thatMillis = that.calendar.getTimeInMillis();
        return (thisMillis - thatMillis) / 1000L;
    }

    public long getDifferenceInMinutes(Time that) {
        long secondsDiff = this.getDifferenceInSeconds(that);
        return secondsDiff / 60L;
    }

    public long getDifferenceInHours(Time that) {
        long secondsDiff = this.getDifferenceInSeconds(that);
        return secondsDiff / 3600L;
    }

    public void addSeconds(int seconds) {
        this.calendar.add(13, seconds);
    }

    public void addMinutes(int minutes) {
        this.calendar.add(12, minutes);
    }

    public void addHours(int hours) {
        this.calendar.add(11, hours);
    }

    public void setHour(int hour) throws TimeException {
        if (hour < 0 || hour > 23) {
            throw new TimeException("The hour " + hour + " is invalid.");
        }
        this.calendar.set(11, hour);
    }

    public void setMinute(int minute) throws TimeException {
        if (minute < 0 || minute > 59) {
            throw new TimeException("The minute " + minute + " is invalid.");
        }
        this.calendar.set(12, minute);
    }

    public void setSecond(int second) throws TimeException {
        if (second < 0 || second > 59) {
            throw new TimeException("The second " + second + " is invalid.");
        }
        this.calendar.set(13, second);
    }

    public void setMillisecond(int millseconds) throws TimeException {
        if (millseconds < 0) {
            throw new TimeException("The fraction " + millseconds + " is invalid");
        }
        this.calendar.set(14, millseconds);
    }

    public int setTimeZone(int timeZoneOffset) {
        TimeZone timezoneA = this.calendar.getTimeZone();
        boolean inDaylightSavingsTime = timezoneA.observesDaylightTime();
        int rawOffsetA = timezoneA.getRawOffset();
        String[] availableIDs = TimeZone.getAvailableIDs(timeZoneOffset * 60000);
        this.calendar.setTimeZone(TimeZone.getTimeZone(availableIDs[0]));
        TimeZone timezoneB = this.calendar.getTimeZone();
        int rawOffsetB = timezoneB.getRawOffset();
        int diff = rawOffsetA - rawOffsetB;
        int diffInSecs = diff / 1000;
        int diffInMins = diffInSecs / 60;
        int diffInHours = diffInMins / 60;
        if (!inDaylightSavingsTime && rawOffsetB == 0) {
            ++diffInHours;
        }
        this.addHours(diffInHours);
        return diffInHours;
    }

    public void setTime(int hour, int minute, int second) throws TimeException {
        this.calendar.clear();
        this.setHour(hour);
        this.setMinute(minute);
        this.setSecond(second);
    }

    public void setTime(String time) throws TimeException {
        if (time == null) {
            throw new TimeException("The given time cannot be null.");
        }
        this.calendar.clear();
        String lcTime = time.trim().toLowerCase();
        String[] tokens = lcTime.split("[: \\\\.-]");
        int fraction = 0;
        int second = 0;
        int minute = 0;
        int hour = 0;
        if (tokens[0].length() > 2) {
            String fractionToken = tokens.length > 1 ? tokens[1] : null;
            int newTokensLength = 0;
            if (tokens[0].length() == 4) {
                newTokensLength = 2 + (fractionToken == null ? 0 : 1);
                tokens = new String[newTokensLength];
                tokens[0] = StringUtility.getLeftSubstring(lcTime, 2);
                tokens[1] = lcTime.substring(2);
            } else if (tokens[0].length() == 6) {
                newTokensLength = 3 + (fractionToken == null ? 0 : 1);
                tokens = new String[newTokensLength];
                tokens[0] = StringUtility.getLeftSubstring(lcTime, 2);
                tokens[1] = StringUtility.getLeftSubstring(lcTime.substring(2), 2);
                tokens[2] = StringUtility.getLeftSubstring(lcTime.substring(4), 2);
            }
            if (fractionToken != null) {
                tokens[newTokensLength - 1] = fractionToken;
            }
        }
        int tokenCount = tokens.length;
        hour = Time.getTimeElement(tokens[0]);
        if (lcTime.endsWith("p") || lcTime.endsWith("pm") && hour < 12) {
            hour += 12;
        }
        while (hour >= 24) {
            hour -= 24;
        }
        this.setHour(hour);
        int tokenIndex = Time.getNextTokenIndex(tokens, 0);
        if (tokenCount > tokenIndex) {
            minute = Time.getTimeElement(tokens[tokenIndex]);
            while (minute >= 60) {
                minute -= 60;
                this.setHour(++hour);
            }
            this.setMinute(minute);
        }
        if (tokenCount > (tokenIndex = Time.getNextTokenIndex(tokens, tokenIndex))) {
            second = Time.getTimeElement(tokens[tokenIndex]);
            while (second >= 60) {
                second -= 60;
                if (++minute > 59) {
                    minute = 0;
                    this.setHour(++hour);
                }
                this.setMinute(minute);
            }
            this.setSecond(second);
        }
        if (tokenCount > (tokenIndex = Time.getNextTokenIndex(tokens, tokenIndex))) {
            fraction = Time.getTimeElement(tokens[tokenIndex]);
            if (fraction < 10) {
                fraction *= 100;
            } else if (fraction < 100) {
                fraction *= 10;
            }
            this.setMillisecond(fraction);
        }
    }

    private static int getNextTokenIndex(String[] tokens, int tokenIndex) {
        int i = ++tokenIndex;
        while (i < tokens.length && tokens[tokenIndex].length() == 0) {
            ++i;
            ++tokenIndex;
        }
        return tokenIndex;
    }

    private static int getTimeElement(String token) {
        if ((token = token.toLowerCase()).equals("a") || token.equals("am") || token.equals("p") || token.equals("pm")) {
            return 0;
        }
        if (NumberUtility.isInteger(token)) {
            return Integer.parseInt(token);
        }
        if (token.endsWith("a") || token.endsWith("p") || token.endsWith("am") || token.endsWith("pm")) {
            int suffixIndex = token.indexOf(97);
            if (suffixIndex == -1) {
                suffixIndex = token.indexOf(112);
            }
            if (!NumberUtility.isInteger(token = token.substring(0, suffixIndex))) {
                return -1;
            }
            return Integer.parseInt(token);
        }
        return -1;
    }

    public boolean isBefore(Time that) {
        long diff = this.getDifferenceInSeconds(that);
        return diff < 0L;
    }

    public boolean isAfter(Time that) {
        long diff = this.getDifferenceInSeconds(that);
        return diff > 0L;
    }

    public SimpleDateFormat getFormat() {
        return this.format;
    }

    public void setFormat(SimpleDateFormat format) {
        if (format == null) {
            return;
        }
        this.format = format;
    }

    public Object clone() {
        return new Time((Calendar)this.calendar.clone());
    }

    public java.sql.Time toJavaSQLTime() {
        return new java.sql.Time(this.calendar.getTime().getTime());
    }

    @Override
    public int compareTo(Object o) {
        if (this.equals(o)) {
            return 0;
        }
        if (o instanceof Time) {
            Time that = (Time)o;
            int hourCmp = this.getHour() - that.getHour();
            int minCmp = this.getMinute() - that.getMinute();
            int secCmp = this.getSecond() - that.getSecond();
            if (hourCmp != 0) {
                return hourCmp;
            }
            if (minCmp != 0) {
                return minCmp;
            }
            return secCmp;
        }
        if (o instanceof Calendar) {
            Time that = new Time((Calendar)o);
            return this.compareTo(that);
        }
        if (o instanceof String) {
            Time that = new Time((String)o);
            return this.compareTo(that);
        }
        ExceptionUtility.throwStandardComparableException(this, o);
        return 0;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.getHour();
        result = 31 * result + this.getMinute();
        result = 31 * result + this.getSecond();
        result = 31 * result + this.getMillisecond();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o instanceof Time) {
            Time that = (Time)o;
            return this.getHour() == that.getHour() && this.getMinute() == that.getMinute() && this.getSecond() == that.getSecond();
        }
        if (o instanceof Calendar) {
            Time that = new Time((Calendar)o);
            return this.equals(that);
        }
        if (o instanceof String) {
            Time that = new Time((String)o);
            return this.equals(that);
        }
        return false;
    }

    public String toString() {
        if (this.calendar == null) {
            return "null";
        }
        try {
            return this.format.format(this.calendar.getTime());
        }
        catch (Exception e) {
            int hour = this.getHour();
            int minute = this.getMinute();
            int second = this.getSecond();
            int millis = this.getMillisecond();
            String formattedTime = String.format("%02d:%02d:%02d.%03d", hour, minute, second, millis);
            return formattedTime;
        }
    }
}

