/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.StringUtility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class CollectionPropertySelector<BeanType> {
    private Collection<BeanType> beans;

    public CollectionPropertySelector() {
    }

    public CollectionPropertySelector(Collection<BeanType> beans) {
        this();
        this.beans = beans;
    }

    public CollectionPropertySelector(BeanType[] beanArray) {
        this(Arrays.asList(beanArray));
    }

    public Collection<BeanType> getBeans() {
        return this.beans;
    }

    public void setBeans(Collection<BeanType> beans) {
        this.beans = beans;
    }

    public <T> Collection<T> get(String propertyName, Class<T> type) {
        if (this.beans == null) {
            throw new IllegalStateException("No beans are set for property selection.");
        }
        if (StringUtility.isEmpty(propertyName)) {
            throw new IllegalArgumentException("The propertyName is null or empty");
        }
        ArrayList allFields = new ArrayList(this.beans.size());
        for (BeanType bean : this.beans) {
            Object field = BeanService.getPropertyValue(bean, propertyName);
            allFields.add(field);
        }
        return allFields;
    }
}

