/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Index;
import com.jmorgan.util.Pair;
import com.jmorgan.util.collection.PropertyIterator;
import com.jmorgan.util.comparator.AnyObjectComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class CollectionUtility {
    private static AnyObjectComparator comparator = new AnyObjectComparator();

    private CollectionUtility() {
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Index<?, ?> index) {
        return index == null || index.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtility.isEmpty(collection);
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !CollectionUtility.isEmpty(map);
    }

    public static <ET> ArrayList<ET> createListFrom(ET ... elements) {
        ArrayList<ET> list = new ArrayList<ET>(elements.length);
        ET[] ETArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            ET element = ETArray[n2];
            list.add(element);
            ++n2;
        }
        return list;
    }

    public static <ET> ArrayList<ET> createOrClear(ArrayList<ET> list) {
        if (list == null) {
            list = new ArrayList();
        } else {
            list.clear();
        }
        return list;
    }

    public static <ET> ET get(Collection<ET> collection, int index) throws NullPointerException, IndexOutOfBoundsException {
        if (collection == null) {
            throw new NullPointerException("The provided collection cannot be null.");
        }
        if (collection.size() == 0) {
            throw new IndexOutOfBoundsException("The provided collection is empty.");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.format("The provided index %d is less than zero.", index));
        }
        if (collection.size() - 1 < index) {
            throw new IndexOutOfBoundsException(String.format("The index %d exceeds the size (%d) of the provided collection.", index, collection.size()));
        }
        if (collection instanceof ArrayList) {
            ArrayList list = (ArrayList)collection;
            return (ET)list.get(index);
        }
        ET elementAtIndex = null;
        int i = 0;
        for (ET element : collection) {
            if (i != index) continue;
            elementAtIndex = element;
            break;
        }
        return elementAtIndex;
    }

    public static <PropertyType, ElementType> Collection<PropertyType> getPropertyValues(Collection<ElementType> collection, String propertyName) {
        if (collection == null) {
            return null;
        }
        ArrayList propertyCollection = new ArrayList();
        if (CollectionUtility.isEmpty(collection)) {
            return propertyCollection;
        }
        PropertyIterator propertyIterator = new PropertyIterator(collection, propertyName);
        while (propertyIterator.hasNext()) {
            propertyCollection.add(propertyIterator.next());
        }
        return propertyCollection;
    }

    public static <ElementType> boolean contains(Collection<ElementType> collection, ElementType element, Comparator<ElementType> comparator) {
        if (CollectionUtility.isEmpty(collection)) {
            return false;
        }
        for (ElementType e : collection) {
            if (e != element && comparator.compare(e, element) != 0) continue;
            return true;
        }
        return false;
    }

    public static boolean containsElementStartingWith(Collection<String> collection, String substring) {
        if (CollectionUtility.isEmpty(collection)) {
            return false;
        }
        for (String s : collection) {
            if (!s.startsWith(substring)) continue;
            return true;
        }
        return false;
    }

    public static ArrayList<String> removeElementsStartingWith(Collection<String> collection, String substring) {
        ArrayList<String> elementsRemoved = new ArrayList<String>();
        if (CollectionUtility.isEmpty(collection)) {
            return elementsRemoved;
        }
        ArrayList<String> searchClone = new ArrayList<String>(collection);
        for (String ipAddress : searchClone) {
            if (!ipAddress.startsWith(substring)) continue;
            elementsRemoved.add(ipAddress);
            collection.remove(ipAddress);
        }
        return elementsRemoved;
    }

    public static <ElementType> void addAll(ElementType[] elements, ArrayList<ElementType> list) {
        if (ArrayUtility.isEmpty(elements) || list == null) {
            return;
        }
        list.addAll(Arrays.asList(elements));
    }

    public static <ElementType> void addAll(ArrayList<ElementType> list, ElementType ... elements) {
        if (ArrayUtility.isEmpty(elements) || list == null) {
            return;
        }
        list.addAll(Arrays.asList(elements));
    }

    public static <ElementType> void addAll(HashSet<ElementType> set, ElementType ... elements) {
        if (ArrayUtility.isEmpty(elements) || set == null) {
            return;
        }
        set.addAll(Arrays.asList(elements));
    }

    public static <ElementType> boolean addNoDuplicate(ArrayList<ElementType> list, ElementType element) {
        if (list != null && !list.contains(element)) {
            list.add(element);
            return true;
        }
        return false;
    }

    public static <T1, T2> Collection<Pair<T1, T2>> getDiff(Collection<T1> collection1, Collection<T2> collection2, String ... compareProperties) {
        if (collection1 == null || collection2 == null || compareProperties == null) {
            return null;
        }
        return CollectionUtility.getDiff(collection1, collection2, Arrays.asList(compareProperties));
    }

    public static <T1, T2> Collection<Pair<T1, T2>> getDiff(Collection<T1> collection1, Collection<T2> collection2, Collection<String> compareProperties) {
        if (collection1 == null || collection2 == null || compareProperties == null) {
            return null;
        }
        ArrayList<Pair<T1, T2>> diff = new ArrayList<Pair<T1, T2>>();
        int c1Size = collection1.size();
        int c2Size = collection2.size();
        if (c1Size == 0 && c2Size == 0) {
            return diff;
        }
        if (c1Size == 0) {
            for (T2 e : collection2) {
                diff.add(new Pair<Object, T2>(null, e));
            }
            return diff;
        }
        if (c2Size == 0) {
            for (T1 e : collection1) {
                diff.add(new Pair<T1, Object>(e, null));
            }
            return diff;
        }
        String[] propertiesArray = compareProperties.toArray(new String[compareProperties.size()]);
        HashMap<Integer, T1> leftIndex = CollectionUtility.toIndexed(collection1);
        HashMap<Integer, T2> rightIndex = CollectionUtility.toIndexed(collection2);
        int i = 0;
        while (i < c1Size) {
            T1 leftElement = leftIndex.remove(i);
            int leftHashCode = BeanService.hashCode(leftElement, propertiesArray);
            Pair<T1, Object> diffMatch = null;
            int j = 0;
            while (j < c2Size) {
                T2 rightElement = rightIndex.get(j);
                int rightHashCode = BeanService.hashCode(rightElement, propertiesArray);
                if (leftHashCode == rightHashCode) {
                    rightIndex.remove(j);
                    diffMatch = new Pair<T1, T2>(leftElement, rightElement);
                    break;
                }
                ++j;
            }
            if (diffMatch == null) {
                diffMatch = new Pair<T1, Object>(leftElement, null);
            }
            diff.add(diffMatch);
            ++i;
        }
        for (int index2 : rightIndex.keySet()) {
            Pair<Object, T2> right = new Pair<Object, T2>(null, rightIndex.get(index2));
            diff.add(index2, right);
        }
        return diff;
    }

    private static <T> HashMap<Integer, T> toIndexed(Collection<T> elements) {
        HashMap<Integer, T> indexMap = new HashMap<Integer, T>(elements.size());
        int i = 0;
        for (T element : elements) {
            indexMap.put(i++, element);
        }
        return indexMap;
    }

    public static int compare(Object v1, Object v2, Collection<String> compareProperties) {
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        for (String property : compareProperties) {
            Object p2;
            Object p1 = BeanService.getPropertyValue(v1, property);
            int cmp = comparator.compare(p1, p2 = BeanService.getPropertyValue(v2, property));
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public static final int getHashCode(Collection<?> elements) {
        if (elements == null) {
            return 0;
        }
        int hashCode = 1;
        for (Object element : elements) {
            hashCode = 31 * hashCode + (element == null ? 0 : element.hashCode());
        }
        return hashCode;
    }

    public static <T> T[] toArray(Collection<T> collection) {
        if (collection == null) {
            return null;
        }
        Object[] array = new Object[collection.size()];
        int i = 0;
        for (T e : collection) {
            array[i++] = e;
        }
        return array;
    }

    public static <T> Set<T> union(Collection<T> ... collections) {
        HashSet<T> union = new HashSet<T>();
        Collection<T>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            Collection<T> collection = collectionArray[n2];
            if (!CollectionUtility.isEmpty(collection)) {
                union.addAll(collection);
            }
            ++n2;
        }
        return union;
    }

    public static <T> Set<T> intersection(Collection<T> ... collections) {
        Collection<T> collection;
        HashSet intersection = new HashSet();
        Collection<T>[] collectionArray = collections;
        int n = collections.length;
        int n2 = 0;
        while (n2 < n) {
            collection = collectionArray[n2];
            if (CollectionUtility.isEmpty(collection)) {
                return intersection;
            }
            intersection.addAll(collection);
            ++n2;
        }
        collectionArray = collections;
        n = collections.length;
        n2 = 0;
        while (n2 < n) {
            collection = collectionArray[n2];
            intersection = (HashSet)intersection.stream().filter(collection::contains).distinct().collect(Collectors.toSet());
            ++n2;
        }
        return intersection;
    }
}

