/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.collection.CachedCollection;
import com.jmorgan.util.collection.HugeArrayListIterator;
import com.jmorgan.util.collection.HugeArrayListListIterator;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Random;
import java.util.Vector;

public class HugeArrayList<E>
extends CachedCollection<E>
implements List<E> {
    public HugeArrayList() {
        this(1000);
    }

    public HugeArrayList(int capacity) {
        super(capacity);
    }

    @Override
    public E get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("HugeArrayList.get(int " + index + "):  Negative index not allowed.");
        }
        int firstElement = 0;
        int lastElement = 0;
        for (File file : this.cacheFiles) {
            Vector list = this.loadFromFile(file);
            if (list == null) continue;
            if ((lastElement += list.size()) > index) {
                return list.get(index - firstElement);
            }
            firstElement = lastElement;
        }
        if ((lastElement += this.localQueue.size()) > index) {
            return this.localQueue.get(index - firstElement);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int indexOf(Object o) {
        return this.indexOf(o, 0);
    }

    @Override
    public int lastIndexOf(Object o) {
        int index = -1;
        int currentIndex = -1;
        do {
            index = currentIndex;
        } while ((currentIndex = this.indexOf(o, currentIndex + 1)) >= 0);
        return index;
    }

    private int indexOf(Object o, int startIndex) {
        int firstElement = 0;
        int lastElement = 0;
        for (File file : this.cacheFiles) {
            int actualIndex;
            Vector list = this.loadFromFile(file);
            if (list == null) continue;
            lastElement += list.size();
            int localIndex = list.indexOf(o);
            if (localIndex >= 0 && (actualIndex = firstElement + localIndex) >= startIndex) {
                return actualIndex;
            }
            firstElement = lastElement;
        }
        int localIndex = this.localQueue.indexOf(o);
        if (localIndex >= 0) {
            return firstElement + localIndex;
        }
        return -1;
    }

    @Override
    public Iterator<E> iterator() {
        return new HugeArrayListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new HugeArrayListListIterator(this);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        HugeArrayList<E> subList = new HugeArrayList<E>();
        subList.addAll(this.subList(index, this.size));
        return subList.listIterator();
    }

    @Override
    public E remove(int index) {
        return null;
    }

    @Override
    public E set(int index, E element) {
        return null;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        HugeArrayList subList = new HugeArrayList(toIndex - fromIndex + 1);
        int firstElement = 0;
        int lastElement = 0;
        for (File file : this.cacheFiles) {
            Vector list = this.loadFromFile(file);
            if (list == null) continue;
            if (fromIndex < (lastElement += list.size()) && toIndex >= firstElement) {
                int toOffset;
                int beginOffset = fromIndex - firstElement;
                if (beginOffset < 0) {
                    beginOffset = 0;
                }
                if ((toOffset = lastElement - toIndex) < 0) {
                    toOffset = list.size();
                }
                subList.addAll(list.subList(beginOffset, toOffset));
            }
            firstElement = lastElement;
        }
        if (fromIndex < (lastElement += this.localQueue.size()) && toIndex >= firstElement) {
            int toOffset;
            int beginOffset = fromIndex - firstElement;
            if (beginOffset < 0) {
                beginOffset = 0;
            }
            if ((toOffset = lastElement - toIndex) < 0) {
                toOffset = this.localQueue.size();
            }
            subList.addAll(this.localQueue.subList(beginOffset, toOffset));
        }
        return subList;
    }

    @Override
    protected String getTempFilePrefix() {
        return "hugeal";
    }

    public static void main(String[] args) {
        Random r = new Random(System.currentTimeMillis());
        int capacity = 0;
        while ((capacity = Math.abs(r.nextInt())) < 100) {
        }
        capacity = capacity % 90 + 10;
        System.out.println("Capacity is: " + capacity);
        HugeArrayList<Integer> list = new HugeArrayList<Integer>(capacity);
        int count = 0;
        while ((count = Math.abs(r.nextInt())) < 1000) {
        }
        count = count % 400 + 100;
        System.out.println("\n\nAdding " + count + " elements");
        int n = 0;
        while (n < count) {
            list.add(n);
            ++n;
        }
        System.out.println("\nQueue Size is: " + list.size());
        n = 1;
        for (Integer i : list) {
            System.out.print(String.valueOf(i) + (n % 10 == 0 ? "\n" : ", "));
            ++n;
        }
    }
}

