/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.collection.CollectionSelector;
import java.util.ArrayList;
import java.util.Collection;

public class IndexSelector<E>
extends CollectionSelector<E> {
    private int beginIndex;
    private int endIndex;
    private int index;

    public IndexSelector(Collection<E> collection) throws NullPointerException {
        this(collection, 0, collection.size());
    }

    public IndexSelector(Collection<? extends E> collection, int beginIndex, int endIndex) throws NullPointerException, IndexOutOfBoundsException {
        super(collection);
        this.setBeginIndex(beginIndex);
        this.setEndIndex(endIndex);
        this.beginIndex = beginIndex;
        this.endIndex = endIndex;
    }

    public int getBeginIndex() {
        return this.beginIndex;
    }

    public void setBeginIndex(int beginIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("The beginning index in IndexSelector cannot be less than 0.");
        }
        this.beginIndex = beginIndex;
    }

    public int getEndIndex() {
        return this.endIndex;
    }

    public void setEndIndex(int endIndex) {
        if (endIndex < 0) {
            throw new IndexOutOfBoundsException("The ending index in IndexSelector cannot be less than 0.");
        }
        this.endIndex = endIndex;
    }

    @Override
    public synchronized Collection<E> getSelectedElements(int maxResultSize) throws IndexOutOfBoundsException {
        boolean reverseOrder;
        int collectionSize = this.collection.size();
        if (this.beginIndex >= collectionSize) {
            throw new IndexOutOfBoundsException("Begin index is greater than the size of the collection within IndexSelector.");
        }
        if (this.endIndex >= collectionSize) {
            throw new IndexOutOfBoundsException("End index is greater than the size of the collection within IndexSeletor.");
        }
        boolean bl = reverseOrder = this.beginIndex > this.endIndex;
        if (reverseOrder) {
            int oldBegin = this.beginIndex;
            this.beginIndex = this.endIndex;
            this.endIndex = oldBegin;
        }
        this.index = 0;
        ArrayList selection = (ArrayList)super.getSelectedElements(maxResultSize);
        int selectionSize = selection.size();
        if (reverseOrder && selectionSize > 0) {
            ArrayList newSelection = new ArrayList(selection.size());
            int i = selectionSize - 1;
            while (i >= 0) {
                newSelection.add(selection.get(i));
                --i;
            }
            return newSelection;
        }
        return selection;
    }

    @Override
    protected boolean isElementSelected(Object element) {
        boolean isSelected = this.index >= this.beginIndex && this.index <= this.endIndex;
        ++this.index;
        return isSelected;
    }
}

