/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.collection.CollectionSelector;
import java.util.Collection;

public class InstanceSelector<T>
extends CollectionSelector<T> {
    private Class<?> type;

    public InstanceSelector(Collection<T> collection, Class<?> type) throws NullPointerException {
        super(collection);
        this.setInstanceType(type);
    }

    @Override
    protected boolean isElementSelected(Object element) {
        return this.type.isInstance(element);
    }

    public Class<?> getInstanceType() {
        return this.type;
    }

    public void setInstanceType(Class<?> type) throws NullPointerException {
        if (type == null) {
            throw new NullPointerException("The given type cannot be null.");
        }
        this.type = type;
    }
}

