/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.collection.CollectionSelector;
import java.util.Collection;
import java.util.regex.Pattern;

public class RegexSelector
extends CollectionSelector<String> {
    private Pattern pattern;

    public RegexSelector(Collection<String> collection) {
        this(collection, ".*");
    }

    public RegexSelector(Collection<String> collection, String regularExpression) throws NullPointerException {
        this(collection, Pattern.compile(regularExpression));
    }

    public RegexSelector(Collection<String> collection, Pattern pattern) {
        super(collection);
        this.setPattern(pattern);
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public void setPattern(String regularExpression) {
        this.setPattern(Pattern.compile(regularExpression));
    }

    public void setPattern(Pattern pattern) {
        this.pattern = pattern;
    }

    @Override
    protected boolean isElementSelected(String element) {
        return this.pattern.matcher(element).find();
    }
}

