/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.collection;

import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.collection.CollectionSelector;
import java.util.Collection;

public class SubstringSelector
extends CollectionSelector<String> {
    public static final int STARTS_WITH = 0;
    public static final int CONTAINS_ANY_OF = 1;
    public static final int CONTAINS_ALL_OF = 2;
    public static final int ENDS_WITH = 3;
    private String[] substringsToMatch;
    private String[] actualSubstringsToMatch;
    private int matchType;
    private boolean isCaseSensitive;

    public SubstringSelector(Collection<? extends String> collection, int matchType, String ... subStringsToMatch) throws NullPointerException {
        this(collection, matchType, true, subStringsToMatch);
    }

    public SubstringSelector(Collection<? extends String> collection, int matchType, boolean isCaseSensitive, String ... subStringsToMatch) throws NullPointerException {
        super(collection);
        this.setSubStringsMatch(subStringsToMatch);
        this.setMatchType(matchType);
        this.setCaseSensitive(isCaseSensitive);
    }

    public String[] getSubStringsMatch() {
        return this.substringsToMatch;
    }

    public void setSubStringsMatch(String ... substringsToMatch) throws IllegalArgumentException {
        if (ArrayUtility.isEmpty(substringsToMatch)) {
            throw new IllegalArgumentException("The parameter substringsToMatch cannot be null or empty.");
        }
        this.substringsToMatch = substringsToMatch;
        this.actualSubstringsToMatch = new String[substringsToMatch.length];
        this.setActualSubstringMatch();
    }

    public int getMatchType() {
        return this.matchType;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
        this.setActualSubstringMatch();
    }

    private void setActualSubstringMatch() {
        if (this.substringsToMatch == null) {
            this.actualSubstringsToMatch = null;
            return;
        }
        int i = 0;
        while (i < this.substringsToMatch.length) {
            this.actualSubstringsToMatch[i] = this.isCaseSensitive ? this.substringsToMatch[i] : this.substringsToMatch[i].toLowerCase();
            ++i;
        }
    }

    public void setMatchType(int matchType) throws IllegalArgumentException {
        switch (matchType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.matchType = matchType;
                break;
            }
            default: {
                throw new IllegalArgumentException("The parameter 'matchType' is not valid.");
            }
        }
    }

    @Override
    protected boolean isElementSelected(String element) {
        if (!this.isCaseSensitive) {
            element = element.toLowerCase();
        }
        if (element != null) {
            switch (this.matchType) {
                case 0: {
                    String[] stringArray = this.actualSubstringsToMatch;
                    int n = this.actualSubstringsToMatch.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String stringToMatch = stringArray[n2];
                        if (element.startsWith(stringToMatch)) {
                            return true;
                        }
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    String[] stringArray = this.actualSubstringsToMatch;
                    int n = this.actualSubstringsToMatch.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String stringToMatch = stringArray[n3];
                        if (!element.contains(stringToMatch)) {
                            return false;
                        }
                        ++n3;
                    }
                    return true;
                }
                case 1: {
                    String[] stringArray = this.actualSubstringsToMatch;
                    int n = this.actualSubstringsToMatch.length;
                    int n4 = 0;
                    while (n4 < n) {
                        String stringToMatch = stringArray[n4];
                        if (element.contains(stringToMatch)) {
                            return true;
                        }
                        ++n4;
                    }
                    break;
                }
                case 3: {
                    String[] stringArray = this.actualSubstringsToMatch;
                    int n = this.actualSubstringsToMatch.length;
                    int n5 = 0;
                    while (n5 < n) {
                        String stringToMatch = stringArray[n5];
                        if (element.endsWith(stringToMatch)) {
                            return true;
                        }
                        ++n5;
                    }
                    break;
                }
            }
        }
        return false;
    }
}

