/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.comparator;

import java.util.Comparator;

public abstract class AbstractComparator<T>
implements Comparator<T> {
    public static final int NULLS_ARE_NULL = 0;
    public static final int NULLS_ARE_FIRST = 1;
    public static final int NULLS_ARE_LAST = 2;
    private int nullHandling = 0;

    public AbstractComparator() {
    }

    public AbstractComparator(int nullHandling) {
        this();
        this.setNullHandling(nullHandling);
    }

    public void setNullHandling(int nullHandling) {
        switch (nullHandling) {
            case 0: 
            case 1: 
            case 2: {
                this.nullHandling = nullHandling;
                break;
            }
            default: {
                throw new IllegalArgumentException("The value [" + nullHandling + "] has no meaning to " + this.getClass().getName() + ".setNullHandling(int)");
            }
        }
    }

    @Override
    public int compare(T o1, T o2) {
        if (o1 == null || o2 == null) {
            switch (this.nullHandling) {
                case 0: {
                    throw new NullPointerException("The arguments for the comparator cannot be null.");
                }
                case 1: {
                    if (o1 == null && o2 != null) {
                        return -1;
                    }
                    if (o1 == null || o2 != null) break;
                    return 1;
                }
                case 2: {
                    if (o1 == null && o2 != null) {
                        return 1;
                    }
                    if (o1 == null || o2 != null) break;
                    return -1;
                }
            }
        }
        return 0;
    }
}

