/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.comparator;

import com.jmorgan.util.comparator.AbstractComparator;
import com.jmorgan.util.comparator.AnyObjectComparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class CollectionComparator<T>
extends AbstractComparator<Collection<T>> {
    public CollectionComparator() {
    }

    public CollectionComparator(int nullHandling) {
        super(nullHandling);
    }

    @Override
    public int compare(Collection<T> o1, Collection<T> o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null && o2 != null) {
            return 1;
        }
        if (o1 != null && o2 == null) {
            return -1;
        }
        if (o1.isEmpty() && o2.isEmpty()) {
            return 0;
        }
        if (o1.size() == o2.size() && o1.containsAll(o2)) {
            return 0;
        }
        if (o1.size() < o2.size() && o2.containsAll(o1)) {
            return -1;
        }
        if (o1.size() > o2.size() && o1.containsAll(o2)) {
            return 1;
        }
        ArrayList<T> uniqueIn1 = new ArrayList<T>();
        for (T t : o1) {
            if (o2.contains(t)) continue;
            uniqueIn1.add(t);
        }
        ArrayList<T> uniqueIn2 = new ArrayList<T>();
        for (T t : o2) {
            if (o1.contains(t)) continue;
            uniqueIn2.add(t);
        }
        AnyObjectComparator comparator = new AnyObjectComparator(1);
        Collections.sort(uniqueIn1, comparator);
        Collections.sort(uniqueIn2, comparator);
        int i = 0;
        while (i < uniqueIn1.size() && i < uniqueIn2.size()) {
            Object t2;
            Object t1 = uniqueIn1.get(i);
            int cmp = comparator.compare(t1, t2 = uniqueIn2.get(i));
            if (cmp != 0) {
                return cmp;
            }
            ++i;
        }
        if (i == uniqueIn1.size()) {
            return -1;
        }
        if (i == uniqueIn2.size()) {
            return 1;
        }
        return 0;
    }
}

