/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.comparator;

import com.jmorgan.io.IOColumnObject;
import com.jmorgan.io.IORowObject;
import com.jmorgan.util.comparator.AbstractComparator;
import java.util.ArrayList;
import java.util.Collections;

public class DEOComparator
extends AbstractComparator<IORowObject> {
    public static final String DIRECTION_ASCENDING = "A";
    public static final String DIRECTION_DESCENDING = "D";
    private ArrayList<ColumnOrderInfo> columnOrderInfo = new ArrayList();

    public void addColumnOrderInfo(String columnName, int order) {
        this.addColumnOrderInfo(columnName, order, DIRECTION_ASCENDING);
    }

    public void addColumnOrderInfo(String columnName, int order, String direction) {
        this.columnOrderInfo.add(new ColumnOrderInfo(columnName, order, direction));
        Collections.sort(this.columnOrderInfo);
    }

    public ArrayList<ColumnOrderInfo> getColumnOrderInfo() {
        return this.columnOrderInfo;
    }

    @Override
    public int compare(IORowObject row1, IORowObject row2) {
        int c = super.compare(row1, row2);
        if (c != 0) {
            return c;
        }
        for (ColumnOrderInfo cinfo : this.columnOrderInfo) {
            IOColumnObject col1 = row1.getColumn(cinfo.getColumnName());
            IOColumnObject col2 = row2.getColumn(cinfo.getColumnName());
            if (col1 == null || col2 == null) {
                throw new NullPointerException("DEOComparator.compare found a null column for " + cinfo.getColumnName());
            }
            int cmp = col1.compareTo(col2);
            if (cinfo.getDirection().equals(DIRECTION_DESCENDING)) {
                cmp *= -1;
            }
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public static class ColumnOrderInfo
    implements Comparable<ColumnOrderInfo> {
        private String columnName;
        private int order;
        private String direction;

        ColumnOrderInfo(String columnName, int order, String direction) {
            this.columnName = columnName;
            this.order = order;
            this.direction = direction;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getDirection() {
            return this.direction;
        }

        public int getOrder() {
            return this.order;
        }

        @Override
        public int compareTo(ColumnOrderInfo that) {
            if (this.equals(that)) {
                return 0;
            }
            int orderCmp = this.order - that.order;
            if (orderCmp != 0) {
                return orderCmp;
            }
            int nameCmp = this.columnName.compareTo(that.columnName);
            if (nameCmp != 0) {
                return nameCmp;
            }
            return this.direction.compareTo(that.direction);
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (this == o) {
                return true;
            }
            if (o instanceof ColumnOrderInfo) {
                ColumnOrderInfo that = (ColumnOrderInfo)o;
                return this.order == that.order && this.columnName.equals(that.columnName) && this.direction.equals(that.direction);
            }
            return false;
        }

        public String toString() {
            return this.columnName + " - " + this.order + " " + this.direction;
        }
    }
}

