/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.logging;

import com.jmorgan.util.logging.StandardLogFormatter;
import java.io.OutputStream;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class StandardConsoleHandler
extends StreamHandler {
    public static final int SYSTEM_OUT = 0;
    public static final int SYSTEM_ERR = 1;
    private Level minLevel;
    private Level maxLevel;

    private static OutputStream getConsoleStream(int consoleType) {
        switch (consoleType) {
            case 0: {
                return System.out;
            }
            case 1: {
                return System.err;
            }
        }
        throw new IllegalArgumentException("The value for \"consoleType\" in \"StandardConsoleHandler\" must be either 0 or 1.");
    }

    public StandardConsoleHandler() {
        this(0);
    }

    public StandardConsoleHandler(int consoleType) {
        super(StandardConsoleHandler.getConsoleStream(consoleType), new StandardLogFormatter());
        Handler[] handlers;
        this.setMinLevel(Level.INFO);
        this.setMaxLevel(Level.SEVERE);
        Logger rootLogger = Logger.getLogger("");
        Handler[] handlerArray = handlers = rootLogger.getHandlers();
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            rootLogger.removeHandler(handler);
            ++n2;
        }
    }

    @Override
    public synchronized void setLevel(Level newLevel) throws SecurityException {
        if (newLevel.equals(Level.OFF)) {
            super.setLevel(newLevel);
        } else {
            super.setLevel(Level.ALL);
        }
    }

    public Level getMinLevel() {
        return this.minLevel;
    }

    public void setMinLevel(Level minLevel) {
        this.minLevel = minLevel;
    }

    public Level getMaxLevel() {
        return this.maxLevel;
    }

    public void setMaxLevel(Level maxLevel) {
        this.maxLevel = maxLevel;
    }

    @Override
    public void publish(LogRecord record) {
        Level level = record.getLevel();
        if (level.equals(Level.OFF)) {
            return;
        }
        int levelValue = level.intValue();
        if (levelValue >= this.minLevel.intValue() && levelValue <= this.maxLevel.intValue()) {
            super.publish(record);
            this.flush();
        }
    }

    @Override
    public void close() {
        this.flush();
    }
}

