/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.logging;

import com.jmorgan.util.DateTime;
import java.text.SimpleDateFormat;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class StandardLogFormatter
extends Formatter {
    @Override
    public String format(LogRecord record) {
        long threadID = record.getLongThreadID();
        long sequenceNumber = record.getSequenceNumber();
        Level level = record.getLevel();
        long logTime = record.getMillis();
        DateTime dt = new DateTime(logTime);
        dt.setFormatter(new SimpleDateFormat("yyyy-MMM-dd HH:mm:ss.SSS"));
        String sourceClassName = record.getSourceClassName();
        sourceClassName = sourceClassName.substring(sourceClassName.indexOf(46) + 1);
        String sourceMethodName = record.getSourceMethodName();
        String message = record.getMessage();
        Object[] parameters = record.getParameters();
        if (parameters != null) {
            int i = 0;
            while (i < parameters.length) {
                System.out.printf("StandardLogFormatter.format(): parameter %d: %s\n", i, parameters[i]);
                ++i;
            }
        }
        String logString = String.format("%s\t(tid: %d)\t(sn: %d)\t(%s)\t%s.%s\t%s\n", dt.toString(), threadID, sequenceNumber, level.toString(), sourceClassName, sourceMethodName, message);
        return logString;
    }
}

