/*
 * Decompiled with CFR 0.152.
 */
package com.jmorgan.util.logging;

import com.jmorgan.lang.StackTrace;
import com.jmorgan.net.HTTPProxy;
import com.jmorgan.util.logging.LoggingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class URLHandler
extends Handler {
    private URL remoteLoggingURL;
    private HTTPProxy httpProxy;

    public URLHandler(String remoteLoggingURL) throws MalformedURLException {
        this(new URL(remoteLoggingURL));
    }

    public URLHandler(URL remoteLoggingURL) {
        this.remoteLoggingURL = remoteLoggingURL;
        this.httpProxy = new HTTPProxy();
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        HashMap<String, Object> logMap = new HashMap<String, Object>();
        logMap.put("levelName", record.getLevel().getName());
        logMap.put("levelValue", record.getLevel().intValue());
        logMap.put("loggerName", record.getLoggerName());
        logMap.put("logMessage", record.getMessage());
        logMap.put("logTime", record.getMillis());
        logMap.put("parameters", Arrays.toString(record.getParameters()));
        logMap.put("sourceClass", record.getSourceClassName());
        logMap.put("sourceMethod", record.getSourceMethodName());
        Throwable thrown = record.getThrown();
        if (thrown != null) {
            new StackTrace();
            logMap.put("stackTrace", StackTrace.getStackTrace(record.getThrown()));
        }
        logMap.put("sequenceNumber", record.getSequenceNumber());
        try {
            int httpStatusCode = this.httpProxy.putRequest(this.remoteLoggingURL, logMap, 0);
            System.out.println("URLHandler.publish(record):  Http Status Code: " + httpStatusCode);
        }
        catch (Exception e) {
            throw new LoggingException(Level.SEVERE, "Error in logging", e);
        }
    }
}

