/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.app;

import com.jmorgan.beans.util.BeanService;
import com.kumbasoft.core.annotations.PreferencesInfo;
import com.kumbasoft.core.util.FileUtility;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;

public final class KumbaCoreConstants {
    public static final int EXIT_CODE_STARTUP_ERROR = -10;
    public static final int EXIT_CODE_OK = 0;
    public static final int EXIT_CODE_INVALID_CREDENTIALS = 10;
    public static final String DEFAULT_LICENSE_FILE_LOCATION = "./configs/License.txt";
    public static final String ACCEPTED_LICENSE_DATE = "acceptedLicenseDate";
    public static final String APPLIANCES = "Appliances";
    public static final String APPLIANCE_GROUPS = "Appliance Groups";
    public static final String DOMAIN_GROUPS = "Domain Groups";
    public static final String HEALTH_CHECKS_ALLOWED = "healthChecksAllowed";
    private static final String GENERAL_PREFERENCES_CATEGORY_NAME = "General";
    private static final int GENERAL_PREFERENCES_CATEGORY_ORDER = 10;
    private static final String APPLICATION_IDLE_CONTROL_PREFERENCES_GROUP_NAME = "Application Idle Controls";
    private static final String HEALTH_CHECK_PREFERENCE_CATEGORY_NAME = "Health Checks";
    private static final int HEALTH_CHECK_PREFERENCE_CATEGORY_ORDER = 20;
    private static final String DATAPOWER_CONNECTION_PREFERENCES_CATEGORY_NAME = "DataPower Connections";
    private static final int DATAPOWER_CONNECTION_PREFERENCES_CATEGORY_ORDER = 30;
    private static final String FIRMWARE_UPGRADE_PREFERENCES_GROUP_NAME = "Firmware Upgrades";
    private static final String XMI_SOMA_INTERFACE_PREFERENCES_GROUP_NAME = "XMI (SOMA) Settings";
    private static final String ADVANCED_PREFERENCES_CATEGORY_NAME = "Advanced";
    private static final int ADVANCED_PREFERENCES_CATEGORY_ORDER = 40;
    private static final String ADVANCED_FILE_CONTROLS_GROUP_NAME = "File Read Controls";
    private static final String THREAD_MANAGEMENT_PREFERENCES_GROUP_NAME = "Thread Management";
    private static final String LOG_PROCESSING_PREFERENCES_GROUP_NAME = "Log Processing Controls";
    public static final String OPEN_APPLIANCE_MANAGEMENT_ON_STARTUP = "openApplianceManagementOnStartup";
    public static final String CLI_NAME_MAP = "CLI Name Map";
    public static final String ETHERNET_INTERFACES = "Ethernet Interfaces";
    @PreferencesInfo(categoryName="Health Checks", displayName="Health Check Interval", helpFile="HealthCheckInterval.txt", categoryOrder=20, minimum=1000, maximum=600000, defaultIntValue=10000)
    public static int HEALTH_CHECK_INTERVAL;
    @PreferencesInfo(categoryName="Health Checks", displayName="Domain Health Check Interval", helpFile="DomainHealthCheckInterval.txt", categoryOrder=21, minimum=1000, maximum=0x7FFFFFFF, defaultIntValue=10000)
    public static int DOMAIN_HEALTH_CHECK_INTERVAL;
    @PreferencesInfo(categoryName="Health Checks", displayName="Un-Reachable Appliance Health Check Interval", helpFile="ApplianceNotConnectedHealthCHeckInterval.txt", categoryOrder=22, minimum=1000, maximum=600000, defaultIntValue=5000)
    public static int APPLIANCE_NOT_CONNECTED_HEALTH_CHECK_INTERVAL;
    @PreferencesInfo(categoryName="Advanced", groupName="File Read Controls", displayName="Data Read Buffer Size", helpFile="FileReadBufferSize.txt", categoryOrder=40, groupOrder=10, minimum=1024, maximum=1048575, defaultIntValue=65535)
    public static int FILE_READ_BUFFER_SIZE;
    @PreferencesInfo(categoryName="Advanced", groupName="File Read Controls", displayName="Maximum File Read Size", helpFile="MaxFileReadSize.txt", categoryOrder=40, groupOrder=20, minimum=4096, defaultIntValue=10000000)
    public static long MAX_FILE_READ_SIZE;
    @PreferencesInfo(categoryName="Advanced", groupName="File Read Controls", displayName="File Read Timeout", helpFile="FileReadTimeout.txt", categoryOrder=40, groupOrder=30, minimum=2000, maximum=30000, defaultIntValue=10000)
    public static long FILE_READ_TIMEOUT;
    @PreferencesInfo(categoryName="Advanced", groupName="Log Processing Controls", displayName="Log Process Timeout", helpFile="LogProcessReadTimeout.txt", categoryOrder=40, groupOrder=10, minimum=10000, maximum=120000, defaultIntValue=40000)
    public static long LOG_READ_TIMEOUT;
    @PreferencesInfo(categoryName="Advanced", groupName="Log Processing Controls", displayName="Log Process Cancellation Timeout", helpFile="LogProcessCanellationTimeout.txt", categoryOrder=40, groupOrder=20, minimum=1000, maximum=60000, defaultIntValue=10000)
    public static long LOG_ABORT_TIMEOUT;
    @PreferencesInfo(categoryName="Advanced", groupName="Log Processing Controls", displayName="Log Polling Interval", helpFile="LogPollingInterval.txt", categoryOrder=40, groupOrder=30, minimum=1000, maximum=600000, defaultIntValue=5000)
    public static int LOG_POLLING_INTERVAL;
    @PreferencesInfo(categoryName="Advanced", groupName="Thread Management", displayName="Maximum Concurrent Threads", helpFile="MaxThreads.txt", categoryOrder=40, groupOrder=10, minimum=1, maximum=1000, defaultIntValue=10)
    public static int MAX_THREADS;
    @PreferencesInfo(categoryName="Advanced", groupName="Thread Management", displayName="Thread Startup Delay", helpFile="ThreadStartupDelay.txt", categoryOrder=40, groupOrder=20, minimum=100, maximum=5000, defaultIntValue=100)
    public static int STARTUP_DELAY;
    @PreferencesInfo(categoryName="Advanced", groupName="Thread Management", displayName="Thread Wait Time", helpFile="ThreadWait.txt", categoryOrder=40, groupOrder=30, minimum=250, maximum=10000, defaultIntValue=250)
    public static int THREAD_WAIT;
    @PreferencesInfo(categoryName="Advanced", groupName="Thread Management", displayName="Thread Timeout", helpFile="ThreadTimeout.txt", categoryOrder=40, groupOrder=40, minimum=10000, maximum=600000, defaultIntValue=30000)
    public static int THREAD_TIMEOUT;
    @PreferencesInfo(categoryName="Advanced", displayName="Maximum Timeout", helpFile="MaximumTimeout.txt", categoryOrder=60, minimum=10000, maximum=600000, defaultIntValue=120000)
    public static int MAXIMUM_TIMEOUT;
    @PreferencesInfo(categoryName="Advanced", displayName="Retry Interval", helpFile="RetryInterval.txt", categoryOrder=56, minimum=1000, maximum=600000, defaultIntValue=10000)
    public static int RETRY_INTERVAL;
    @PreferencesInfo(categoryName="DataPower Connections", groupName="Export Settings", displayName="Export Timeout", helpFile="ExportCacheTimeout.txt", categoryOrder=20, groupOrder=10, minimum=10000, maximum=1200000, defaultIntValue=60000)
    public static int EXPORT_CACHE_TIMEOUT;
    @PreferencesInfo(categoryName="DataPower Connections", groupName="Firmware Upgrades", displayName="Firmware Upgrade Appliance Down Wait Time", helpFile="FirmwareUpgradeApplianceDownDelay.txt", categoryOrder=30, groupOrder=20, minimum=10000, maximum=600000, defaultIntValue=30000)
    public static int FIRMWARE_UPGRADE_APPLIANCE_DOWN_DELAY;
    @PreferencesInfo(categoryName="DataPower Connections", groupName="Firmware Upgrades", displayName="Firmware Upgrade Verification Check Interval", helpFile="FirmwareUpgradeCheckRetryInterval.txt", categoryOrder=30, groupOrder=30, minimum=1000, maximum=60000, defaultIntValue=10000)
    public static int FIRMWARE_UPGRADE_CHECK_RETRY_RECHECK_DELAY;
    @PreferencesInfo(categoryName="DataPower Connections", groupName="Firmware Upgrades", displayName="Firmware Upgrade Verification Maximum Retries", helpFile="FirmwareUpgradeCheckRetryCount.txt", categoryOrder=30, groupOrder=40, minimum=1, maximum=100, defaultIntValue=10)
    public static int FIRMWARE_UPGRADE_CHECK_RETRY_COUNT;
    @PreferencesInfo(categoryName="DataPower Connections", groupName="Firmware Upgrades", displayName="Firmware Upgrade Status Sleep Time", helpFile="FirmwareUpgradeWaitSleepTime.txt", categoryOrder=30, groupOrder=10, minimum=1000, maximum=60000, defaultIntValue=10000)
    public static int FIRMWARE_UPGRADE_WAIT_SLEEP_TIME;
    @PreferencesInfo(categoryName="DataPower Connections", displayName="Appliance Quiesce Wait Time", helpFile="ApplianceQuiesceWaitSleepTime.txt", categoryOrder=40, minimum=1000, maximum=120000, defaultIntValue=10000)
    public static int APPLIANCE_QUIESCE_WAIT_SLEEP_TIME;
    @PreferencesInfo(categoryName="DataPower Connections", groupName="XMI (SOMA) Settings", displayName="Read Timeout", helpFile="SOMAReadTimeout.txt", categoryOrder=30, groupOrder=20, minimum=1000, maximum=600000, defaultIntValue=120000)
    public static int SOMA_READ_TIMEOUT;
    @PreferencesInfo(categoryName="DataPower Connections", groupName="XMI (SOMA) Settings", displayName="Connection Timeout", helpFile="SOMAConnectionTimeout.txt", categoryOrder=30, groupOrder=10, minimum=1000, maximum=600000, defaultIntValue=30000)
    public static int SOMA_CONNECTION_TIMEOUT;
    @PreferencesInfo(categoryName="DataPower Connections", groupName="XMI (SOMA) Settings", displayName="XMI (SOMA) Connection Maximum Retries", helpFile="SOMARetryCount.txt", categoryOrder=30, groupOrder=30, minimum=1, maximum=100, defaultIntValue=10)
    public static int SOMA_RETRY_COUNT;
    @PreferencesInfo(categoryName="DataPower Connections", groupName="XMI (SOMA) Settings", displayName="XMI (SOMA) Large File Connection Timeout", helpFile="LargeFileConnectionTimeout.txt", categoryOrder=30, groupOrder=40, minimum=5000, maximum=600000, defaultIntValue=90000)
    public static int LARGE_FILE_CONNECTION_TIMEOUT;
    @PreferencesInfo(categoryName="DataPower Connections", groupName="XMI (SOMA) Settings", displayName="XMI (SOMA) Large File Read Timeout", helpFile="LargeFileReadTimeout.txt", categoryOrder=30, groupOrder=50, minimum=1000, maximum=600000, defaultIntValue=360000)
    public static int LARGE_FILE_READ_TIMEOUT;
    @PreferencesInfo(categoryName="DataPower Connections", displayName="CLI (SSH) Connection Timeout", helpFile="CLIConnectionTimeout.txt", categoryOrder=30, minimum=1000, maximum=120000, defaultIntValue=30000)
    public static int CLI_CONNECTION_TIMEOUT;
    @PreferencesInfo(categoryName="DataPower Connections", displayName="Probe Data Refresh Interval", helpFile="ProbeRefreshInterval.txt", categoryOrder=50, minimum=1000, maximum=600000, defaultIntValue=30000)
    public static int PROBE_REFRESH_INTERVAL;
    @PreferencesInfo(categoryName="General", groupName="Application Idle Controls", displayName="Idle Warning Notification Time", helpFile="IdleWarningNotificationTime.txt", categoryOrder=10, groupOrder=10, defaultIntValue=240000)
    public static int IDLE_WARNING_NOTIFICATION_TIME;
    @PreferencesInfo(categoryName="General", groupName="Application Idle Controls", displayName="Idle Shutdown Time", helpFile="IdleShutdownTime.txt", categoryOrder=10, groupOrder=20, defaultIntValue=300000)
    public static int IDLE_SHUTDOWN_TIME;

    static {
        HashMap<String, Object> savedPreferences = KumbaCoreConstants.readLastSavedPreferences();
        if (savedPreferences != null) {
            for (String fieldName : savedPreferences.keySet()) {
                Object value = savedPreferences.get(fieldName);
                BeanService.setPropertyValue(KumbaCoreConstants.class, fieldName, value);
            }
        } else {
            KumbaCoreConstants.setNonFinalStaticDefaults();
        }
    }

    private KumbaCoreConstants() {
    }

    private static HashMap<String, Object> readLastSavedPreferences() {
        File lastSavedPreferences = new File("./configs/CorePreferences.dat");
        if (!lastSavedPreferences.exists()) {
            return null;
        }
        HashMap savedPreferences = (HashMap)FileUtility.readObject(lastSavedPreferences, true);
        return savedPreferences;
    }

    public static void savePreferences() {
        File lastUsedThemeFile = new File("./configs/CorePreferences.dat");
        HashMap<String, Object> corePreferences = KumbaCoreConstants.getConstanValues(KumbaCoreConstants.class);
        FileUtility.writeObject(lastUsedThemeFile, corePreferences, true);
    }

    private static HashMap<String, Object> getConstanValues(Class<?> constantsType) {
        HashMap<String, Field> preferenceFields = BeanService.getFieldMap(constantsType, PreferencesInfo.class);
        HashMap<String, Object> preferenceValues = new HashMap<String, Object>(preferenceFields.size());
        for (String fieldName : preferenceFields.keySet()) {
            Field field = preferenceFields.get(fieldName);
            try {
                Object value = field.get(constantsType);
                preferenceValues.put(fieldName, value);
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return preferenceValues;
    }

    public static void setNonFinalStaticDefaults() {
        HEALTH_CHECK_INTERVAL = 10000;
        DOMAIN_HEALTH_CHECK_INTERVAL = 10000;
        APPLIANCE_NOT_CONNECTED_HEALTH_CHECK_INTERVAL = 5000;
        FILE_READ_BUFFER_SIZE = 65535;
        MAX_FILE_READ_SIZE = 10000000L;
        FILE_READ_TIMEOUT = 10000L;
        LOG_READ_TIMEOUT = 40000L;
        LOG_ABORT_TIMEOUT = 10000L;
        LOG_POLLING_INTERVAL = 5000;
        MAX_THREADS = 10;
        STARTUP_DELAY = 100;
        THREAD_WAIT = 250;
        THREAD_TIMEOUT = 30000;
        MAXIMUM_TIMEOUT = 120000;
        EXPORT_CACHE_TIMEOUT = 600000;
        RETRY_INTERVAL = 10000;
        FIRMWARE_UPGRADE_APPLIANCE_DOWN_DELAY = 30000;
        FIRMWARE_UPGRADE_CHECK_RETRY_COUNT = 10;
        FIRMWARE_UPGRADE_CHECK_RETRY_RECHECK_DELAY = 10000;
        FIRMWARE_UPGRADE_WAIT_SLEEP_TIME = 10000;
        APPLIANCE_QUIESCE_WAIT_SLEEP_TIME = 10000;
        SOMA_READ_TIMEOUT = 120000;
        SOMA_CONNECTION_TIMEOUT = 30000;
        SOMA_RETRY_COUNT = 10;
        LARGE_FILE_CONNECTION_TIMEOUT = SOMA_CONNECTION_TIMEOUT * 3;
        LARGE_FILE_READ_TIMEOUT = SOMA_READ_TIMEOUT * 3;
        CLI_CONNECTION_TIMEOUT = 30000;
        PROBE_REFRESH_INTERVAL = 30000;
        IDLE_WARNING_NOTIFICATION_TIME = 240000;
        IDLE_SHUTDOWN_TIME = 300000;
    }
}

