/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.beans.ApplianceGroupObject;
import com.kumbasoft.core.beans.Domain;
import java.util.ArrayList;
import java.util.Objects;

public class Appliance
extends ApplianceGroupObject
implements Cloneable {
    private ArrayList<String> categories;
    private String name;
    @Deprecated(since="2023-10-06")
    private String host;
    private String xmlManagementHost;
    private String sshManagementHost;
    private char[] xmlManagementUserName;
    private char[] xmlManagementPassword;
    private char[] sshManagementUserName;
    private char[] sshManagementPassword;
    private boolean useApplicationCredentialsForLogin;
    private int webMgmtPort;
    private int xmlPort;
    private int restPort;
    private int sshPort;
    private boolean active;
    private ArrayList<Domain> domains;
    private String firmwareVersion;
    private boolean connected;
    private final Object LOCK = new Object();

    public Appliance() {
        this.webMgmtPort = 9090;
        this.xmlPort = 5550;
        this.restPort = 5554;
        this.sshPort = 22;
        this.active = true;
        this.useApplicationCredentialsForLogin = false;
        this.categories = new ArrayList();
        this.setupDomains();
        this.addAppliance(this);
        this.setCreatedFromCategory(false);
    }

    public Appliance(String name) {
        this();
        this.setName(name);
    }

    private Appliance(Appliance source) {
        ArrayList<String> sourceCategories;
        this.setName(source.getName());
        this.setSshManagementHost(source.getSshManagementHost());
        this.setXmlManagementHost(source.getXmlManagementHost());
        this.setHost(source.getHost());
        this.setWebMgmtPort(source.getWebMgmtPort());
        this.setXmlPort(source.getXmlPort());
        this.setRestPort(source.getRestPort());
        this.setSshPort(source.getSshPort());
        this.setActive(source.isActive());
        this.setFirmwareVersion(source.getFirmwareVersion());
        this.setUseApplicationCredentialsForLogin(source.useApplicationCredentialsForLogin);
        this.setCreatedFromCategory(false);
        ArrayList<Domain> sourceDomains = source.getDomains();
        if (sourceDomains != null) {
            ArrayList<Domain> thisDomains = new ArrayList<Domain>(sourceDomains.size());
            for (Domain sourceDomain : thisDomains) {
                Domain thisDomain = sourceDomain.clone();
                thisDomains.add(thisDomain);
            }
            this.setDomains(thisDomains);
        }
        if (CollectionUtility.isNotEmpty(sourceCategories = source.getCategories())) {
            ArrayList<String> thisCategories = new ArrayList<String>(sourceCategories);
            this.setCategories(thisCategories);
        }
        this.setXmlManagementUserName(source.getXmlManagementUserName());
        this.setXmlManagementPassword(source.getXmlManagementPassword());
        this.setSshManagementUserName(source.getSshManagementUserName());
        this.setSshManagementPassword(source.getSshManagementPassword());
        this.setConnected(source.isConnected());
    }

    public Appliance clone() {
        return new Appliance(this);
    }

    @Override
    public String getGroupName() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDomain(Domain domain) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.domains == null) {
                this.domains = new ArrayList();
            }
            if (!this.domains.contains(domain)) {
                this.domains.add(domain);
            }
        }
    }

    public void removeDomain(String domainName) {
        Domain domain = this.getDomain(domainName);
        this.removeDomain(domain);
    }

    public void removeDomain(Domain domain) {
        if (CollectionUtility.isEmpty(this.domains)) {
            return;
        }
        this.domains.remove(domain);
    }

    public void setupDomains() {
        if (this.domains == null) {
            this.domains = new ArrayList();
        } else {
            this.domains.clear();
        }
    }

    public Domain getDomain(String domainName) {
        return this.getDomain(domainName, false);
    }

    public Domain getDomain(String domainNameToGet, boolean caseSensitive) {
        if (domainNameToGet == null) {
            throw new IllegalArgumentException("The domain name for 'Appliance.getDomain(String domainName)' cannot be null.");
        }
        if (this.domains == null) {
            throw new IllegalStateException("No domains have been set for the " + this.name + " appliance.");
        }
        ArrayList<Domain> copy = new ArrayList<Domain>(this.domains);
        for (Domain domain : copy) {
            String domainName = domain.getName();
            if (caseSensitive && domainNameToGet.equals(domainName)) {
                return domain;
            }
            if (caseSensitive || !domainNameToGet.equalsIgnoreCase(domainName)) continue;
            return domain;
        }
        return null;
    }

    public ArrayList<Domain> getDomains() {
        return this.domains;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.setGroupName(name);
    }

    @Deprecated(since="2023-10-06")
    public String getHost() {
        return this.host;
    }

    @Deprecated(since="2023-10-06")
    public void setHost(String host) {
        this.host = host;
        if (StringUtility.isEmpty(this.xmlManagementHost)) {
            this.setXmlManagementHost(this.host);
        }
    }

    public String getXmlManagementHost() {
        return this.xmlManagementHost;
    }

    public void setXmlManagementHost(String xmlManagementHost) {
        this.xmlManagementHost = xmlManagementHost;
        if (StringUtility.isEmpty(this.sshManagementHost)) {
            this.setSshManagementHost(this.xmlManagementHost);
        }
    }

    public String getSshManagementHost() {
        return this.sshManagementHost;
    }

    public void setSshManagementHost(String sshManagementHost) {
        this.sshManagementHost = sshManagementHost;
    }

    public char[] getXmlManagementUserName() {
        return this.xmlManagementUserName;
    }

    public void setXmlManagementUserName(char[] xmlManagementUserName) {
        this.xmlManagementUserName = xmlManagementUserName;
        if (ArrayUtility.isEmpty(this.sshManagementUserName)) {
            this.setSshManagementUserName(xmlManagementUserName);
        }
    }

    public char[] getXmlManagementPassword() {
        return this.xmlManagementPassword;
    }

    public void setXmlManagementPassword(char[] xmlManagementPassword) {
        this.xmlManagementPassword = xmlManagementPassword;
        if (ArrayUtility.isEmpty(this.sshManagementPassword)) {
            this.setSshManagementPassword(xmlManagementPassword);
        }
    }

    public char[] getSshManagementUserName() {
        return this.sshManagementUserName;
    }

    public void setSshManagementUserName(char[] sshManagementUserName) {
        this.sshManagementUserName = sshManagementUserName;
    }

    public char[] getSshManagementPassword() {
        return this.sshManagementPassword;
    }

    public void setSshManagementPassword(char[] sshManagementPassword) {
        this.sshManagementPassword = sshManagementPassword;
    }

    public ArrayList<String> getCategories() {
        return this.categories;
    }

    public void addCategories(String categories) {
        this.setCategories(categories, true);
    }

    public void setCategories(String categories) {
        this.setCategories(categories, false);
    }

    private void setCategories(String categories, boolean append) {
        String[] cats;
        if (!append && this.categories != null) {
            this.categories.clear();
        }
        if (StringUtility.isEmpty(categories)) {
            return;
        }
        String[] stringArray = cats = categories.split("[^\\w]");
        int n = cats.length;
        int n2 = 0;
        while (n2 < n) {
            String cat = stringArray[n2];
            this.addCategory(cat);
            ++n2;
        }
    }

    public void addCategory(String category) {
        if (StringUtility.isEmpty(category)) {
            return;
        }
        if (this.categories == null) {
            this.categories = new ArrayList();
        }
        this.categories.add(category.trim());
    }

    public void setCategories(ArrayList<String> categories) {
        if (this.categories != null) {
            this.categories.clear();
            this.categories = null;
        }
        for (String category : categories) {
            this.addCategory(category);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDomains(ArrayList<Domain> domains) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.domains != null) {
                this.domains.clear();
                this.domains = null;
            }
            this.domains = domains;
        }
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public void setFirmwareVersion(String firmwareVersion) {
        this.firmwareVersion = firmwareVersion;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnected(boolean connected) {
        this.connected = connected;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.connected && this.domains != null) {
                this.domains.clear();
                this.domains = null;
            }
        }
    }

    public boolean isQuiesced() {
        if (!this.connected || this.domains == null) {
            return false;
        }
        boolean allQuiesced = true;
        for (Domain domain : this.domains) {
            if (domain.isQuiesced()) continue;
            allQuiesced = false;
            break;
        }
        return allQuiesced;
    }

    public boolean isInDiagnosticMode() {
        if (!this.connected || this.domains == null) {
            return false;
        }
        boolean allInDiagMode = true;
        for (Domain domain : this.domains) {
            if (domain.isDiagMode()) continue;
            allInDiagMode = false;
            break;
        }
        return allInDiagMode;
    }

    public boolean isInFailsafeMode() {
        if (!this.connected || this.domains == null) {
            return false;
        }
        boolean anyInFailsafeMode = false;
        for (Domain domain : this.domains) {
            if (!domain.isFailsafeMode()) continue;
            anyInFailsafeMode = true;
            break;
        }
        return anyInFailsafeMode;
    }

    public boolean hasInterfaceLinkError() {
        if (!this.connected || this.domains == null) {
            return false;
        }
        boolean hasInterfaceLinkError = false;
        for (Domain domain : this.domains) {
            if (!domain.hasInterfaceLinkError()) continue;
            hasInterfaceLinkError = true;
            break;
        }
        return hasInterfaceLinkError;
    }

    public boolean isQuarantined() {
        if (!this.connected || this.domains == null) {
            return false;
        }
        boolean isQuarantined = false;
        for (Domain domain : this.domains) {
            if (!domain.isQuarantined()) continue;
            isQuarantined = true;
            break;
        }
        return isQuarantined;
    }

    @Override
    public double getPercentOfAppliancesConnected() {
        return this.connected ? 1.0 : 0.0;
    }

    public boolean getUseApplicationCredentialsForLogin() {
        return this.useApplicationCredentialsForLogin;
    }

    public void setUseApplicationCredentialsForLogin(boolean useApplicationCredentialsForLogin) {
        this.useApplicationCredentialsForLogin = useApplicationCredentialsForLogin;
    }

    public int getWebMgmtPort() {
        return this.webMgmtPort;
    }

    public void setWebMgmtPort(int webMgmtPort) {
        this.webMgmtPort = webMgmtPort;
    }

    public int getXmlPort() {
        return this.xmlPort;
    }

    public void setXmlPort(int xmlPort) {
        this.xmlPort = xmlPort;
    }

    public int getRestPort() {
        return this.restPort;
    }

    public void setRestPort(int restPort) {
        this.restPort = restPort;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public void setSshPort(int sshPort) {
        this.sshPort = sshPort;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.host, this.name);
    }

    @Override
    public boolean equals(Object that) {
        return this.equals(that, "host", "name");
    }

    @Override
    public String toString() {
        return this.toString("categories", "name", "host");
    }
}

