/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.beans.JMBean;
import com.jmorgan.math.DateMath;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.NumberUtility;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.PrincipalInformation;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;

public class CertificateInformation
extends JMBean
implements Comparable<CertificateInformation> {
    private Appliance appliance;
    private Domain domain;
    private String fileName;
    private Date lastModifiedDate;
    private String certificateObjectName;
    private int version;
    private String serialNumber;
    private String fingerPrint;
    private PrincipalInformation subjectPrincipal;
    private String subjectDN;
    private String issuer;
    private PrincipalInformation issuerPrincipal;
    private String issuerDN;
    private DateTime notBefore;
    private DateTime notAfter;
    private String publicKeyAlgorithm;
    private String publicKeyFormat;
    private String signatureAlgoritm;
    private String signature;
    private String subjectAlternativeNames;
    private String issuerAlternativeNames;
    private int basicConstraints;
    private String extendedKeyUsage;
    private int daysUntilExpiration;
    private X509Certificate certificate;

    public CertificateInformation() {
    }

    public CertificateInformation(Appliance appliance, Domain domain, String fileName, X509Certificate certificate) {
        this();
        this.setAppliance(appliance);
        this.setDomain(domain);
        this.setFileName(fileName);
        this.setCertificate(certificate);
        if (fileName == null || StringUtility.coalesce(fileName, "/").equals("cert:/")) {
            this.setSubjectDN("*** Error:  No file configured");
        }
    }

    public X509Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(X509Certificate certificate) {
        if (certificate == null) {
            this.setSubjectDN(String.format("*** Error Reading Certificate %s ***", this.getFileName()));
        } else {
            this.certificate = certificate;
            BigInteger serialNumber = certificate.getSerialNumber();
            this.setSerialNumber(CertificateInformation.encodeToHexString(serialNumber));
            try {
                byte[] encodedCert = certificate.getEncoded();
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                md.update(encodedCert);
                byte[] digest = md.digest();
                StringBuilder sb = new StringBuilder();
                byte[] byArray = digest;
                int n = digest.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    Object hexByte = Integer.toHexString(b);
                    if (((String)hexByte).startsWith("ffffff")) {
                        hexByte = ((String)hexByte).substring(6, ((String)hexByte).length());
                    } else if (((String)hexByte).length() == 1) {
                        hexByte = "0" + (String)hexByte;
                    }
                    if (sb.length() > 0) {
                        sb.append(":");
                    }
                    sb.append(((String)hexByte).toUpperCase());
                    ++n2;
                }
                String fingerPrint = sb.toString();
                this.setFingerPrint(fingerPrint);
            }
            catch (NoSuchAlgorithmException | CertificateEncodingException e1) {
                e1.printStackTrace();
            }
            X500Principal subjectDN = certificate.getSubjectX500Principal();
            this.subjectPrincipal = new PrincipalInformation(subjectDN);
            this.setSubjectDN(subjectDN.getName());
            X500Principal x509Principal = certificate.getIssuerX500Principal();
            String x509PrincipalName = x509Principal.getName();
            this.setIssuer(x509PrincipalName);
            X500Principal issuerDN = certificate.getIssuerX500Principal();
            this.issuerPrincipal = new PrincipalInformation(x509Principal);
            String issuerDNStr = issuerDN.getName();
            this.setIssuerDN(issuerDNStr);
            Date notBefore = certificate.getNotBefore();
            this.setNotBefore(new DateTime(notBefore.getTime()));
            Date notAfter = certificate.getNotAfter();
            this.setNotAfter(new DateTime(notAfter.getTime()));
            PublicKey publicKey = certificate.getPublicKey();
            String pubKeyAlgorithm = publicKey.getAlgorithm();
            this.setPublicKeyAlgorithm(pubKeyAlgorithm);
            String pubKeyFormat = publicKey.getFormat();
            this.setPublicKeyFormat(pubKeyFormat);
            String signatureAlgorithm = certificate.getSigAlgName();
            this.setSignatureAlgoritm(signatureAlgorithm);
            byte[] signature = certificate.getSignature();
            BigInteger sigInt = new BigInteger(signature);
            this.setSignature(CertificateInformation.encodeToHexString(sigInt));
            int basicConstraints = certificate.getBasicConstraints();
            this.setBasicConstraints(basicConstraints);
            try {
                List<String> extKeyUsage;
                Collection<List<?>> issuerAltNames;
                Collection<List<?>> subjectAltNames = certificate.getSubjectAlternativeNames();
                if (subjectAltNames != null) {
                    StringBuilder sans = new StringBuilder();
                    for (List<?> saltNames : subjectAltNames) {
                        int i = 0;
                        String san = null;
                        for (Object o : saltNames) {
                            if (i != 0 && i % 2 != 0) {
                                String s;
                                san = o instanceof String ? (s = (String)o) : "** Error reading SAN **";
                                if (sans.length() > 0) {
                                    sans.append(", ");
                                }
                                sans.append(san);
                            }
                            ++i;
                        }
                        this.setSubjectAlternativeNames(sans.toString());
                    }
                }
                if ((issuerAltNames = this.certificate.getIssuerAlternativeNames()) != null) {
                    StringBuilder isan = new StringBuilder();
                    for (List<?> saltNames : issuerAltNames) {
                        for (Object o : saltNames) {
                            if (isan.length() > 0) {
                                isan.append(", ");
                            }
                            isan.append(o.toString());
                        }
                    }
                    this.setIssuerAlternativeNames(isan.toString());
                }
                if ((extKeyUsage = this.certificate.getExtendedKeyUsage()) != null && extKeyUsage.size() > 0) {
                    StringBuilder extKeys = new StringBuilder();
                    for (String s : extKeyUsage) {
                        extKeys.append(s);
                    }
                    this.setExtendedKeyUsage(extKeys.toString());
                }
            }
            catch (CertificateParsingException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static String encodeToHexString(BigInteger value) {
        String hexSerial = value.toString(16).toUpperCase();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < hexSerial.length()) {
            sb.append(StringUtility.getSubstring(hexSerial, i, 2));
            if (i + 2 < hexSerial.length()) {
                sb.append(":");
            }
            i += 2;
        }
        return sb.toString();
    }

    public Appliance getAppliance() {
        return this.appliance;
    }

    public void setAppliance(Appliance appliance) {
        this.appliance = appliance;
    }

    public Domain getDomain() {
        return this.domain;
    }

    public void setDomain(Domain domain) {
        this.domain = domain;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Date getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(Date lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getCertificateObjectName() {
        return this.certificateObjectName;
    }

    public void setCertificateObjectName(String certificateObjectName) {
        this.certificateObjectName = certificateObjectName;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        if (StringUtility.isNotEmpty(serialNumber) && !serialNumber.contains(":") && NumberUtility.isNumber(serialNumber)) {
            BigInteger serialNumberInt = new BigInteger(serialNumber);
            serialNumber = CertificateInformation.encodeToHexString(serialNumberInt);
        }
        this.serialNumber = serialNumber;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public String getSubjectDN() {
        return this.subjectDN;
    }

    public void setSubjectDN(String subjectDN) {
        this.subjectDN = subjectDN;
    }

    public PrincipalInformation getSubjectPrincipal() {
        return this.subjectPrincipal;
    }

    public void setSubjectPrincipal(PrincipalInformation subjectPrincipal) {
        this.subjectPrincipal = subjectPrincipal;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuerDN() {
        return this.issuerDN;
    }

    public PrincipalInformation getIssuerPrincipal() {
        return this.issuerPrincipal;
    }

    public void setIssuerPrincipal(PrincipalInformation issuerPrincipal) {
        this.issuerPrincipal = issuerPrincipal;
    }

    public void setIssuerDN(String issuerDN) {
        this.issuerDN = issuerDN;
    }

    public DateTime getNotBefore() {
        return this.notBefore;
    }

    public void setNotBefore(DateTime notBefore) {
        this.notBefore = notBefore;
    }

    public String getPublicKeyAlgorithm() {
        return this.publicKeyAlgorithm;
    }

    public void setPublicKeyAlgorithm(String publicKeyAlgorithm) {
        this.publicKeyAlgorithm = publicKeyAlgorithm;
    }

    public String getPublicKeyFormat() {
        return this.publicKeyFormat;
    }

    public void setPublicKeyFormat(String publicKeyFormat) {
        this.publicKeyFormat = publicKeyFormat;
    }

    public String getSignatureAlgoritm() {
        return this.signatureAlgoritm;
    }

    public void setSignatureAlgoritm(String signatureAlgoritm) {
        this.signatureAlgoritm = signatureAlgoritm;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public void setSubjectAlternativeNames(String subjectAlternativeNames) {
        this.subjectAlternativeNames = subjectAlternativeNames;
    }

    public String getIssuerAlternativeNames() {
        return this.issuerAlternativeNames;
    }

    public void setIssuerAlternativeNames(String issuerAlternativeNames) {
        this.issuerAlternativeNames = issuerAlternativeNames;
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public void setBasicConstraints(int basicConstraints) {
        this.basicConstraints = basicConstraints;
    }

    public String getExtendedKeyUsage() {
        return this.extendedKeyUsage;
    }

    public void setExtendedKeyUsage(String extendedKeyUsage) {
        this.extendedKeyUsage = extendedKeyUsage;
    }

    public DateTime getNotAfter() {
        return this.notAfter;
    }

    public int getDaysUntilExpiration() {
        return this.daysUntilExpiration;
    }

    public void setNotAfter(DateTime notAfter) {
        this.notAfter = notAfter;
        if (this.notAfter != null) {
            DateTime today = new DateTime();
            this.daysUntilExpiration = (int)DateMath.getDayDifference(today.getDate(), this.notAfter.getDate());
        }
    }

    public void setDaysUntilExpiration(int daysUntilExpiration) {
    }

    @Override
    public int compareTo(CertificateInformation that) {
        return this.compareTo(that, "appliance", "domain", "certificateObjectName", "fileName", "lastModifiedDate", "serialNumber");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appliance, this.domain, this.certificateObjectName, this.fileName, this.serialNumber);
    }

    public boolean equals(Object o) {
        return this.equals(o, "appliance", "domain", "certificateObjectName", "fileName", "serialNumber");
    }
}

