/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.DynamicBean;
import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.PropertyNotFoundException;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.io.ASCFileReader;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.AsynchMethodInvoker;
import com.jmorgan.lang.MethodInvoker;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.lang.SingleThreadInvocationListener;
import com.jmorgan.util.ArrayUtility;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.DynamicClassLoader;
import com.jmorgan.util.Index;
import com.jmorgan.util.Pair;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.ThreadUtility;
import com.jmorgan.util.collection.CollectionUtility;
import com.jmorgan.util.collection.PropertyValueSelector;
import com.jmorgan.util.comparator.FileNameComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerConfig;
import com.kumbasoft.core.beans.DataPowerStatusCache;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.ExportOptions;
import com.kumbasoft.core.beans.ManagementCommandError;
import com.kumbasoft.core.beans.ManagementCommandStatus;
import com.kumbasoft.core.beans.ManagementCommandSubscriber;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.actions.ActionSaveConfig;
import com.kumbasoft.core.beans.config.AnyConfigElement;
import com.kumbasoft.core.beans.config.ConfigLogTarget;
import com.kumbasoft.core.beans.modify.AnyModifyElement;
import com.kumbasoft.core.beans.status.AnyStatusElement;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ActionTool;
import com.kumbasoft.core.tools.DataPowerStatusMonitor;
import com.kumbasoft.core.tools.ExportConfiguration;
import com.kumbasoft.core.tools.GetConfiguration;
import com.kumbasoft.core.tools.GetConfigurations;
import com.kumbasoft.core.tools.ThreadManager;
import com.kumbasoft.core.util.DataStructureUtility;
import com.kumbasoft.core.util.RegexUtility;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ConfigurationManager
extends AbstractTool
implements ManagementCommandSubscriber {
    private static Class<? extends DataPowerConfig>[] ALL_TYPES;
    private static String[] PSEUDO_LOG_NAMES;
    private static ConfigLogTarget[] PSEUDO_LOG_TARGETS;
    private static final ExportOptions EXPORT_OPTIONS;
    private static final File CONFIG_EXPORTS_DIRECTORY;
    private static final ActionSaveConfig SAVE_CONFIG_ACTION;
    private static final String CONFIG_PACKAGE_FQN = "com.kumbasoft.core.beans.config";
    public static final String TYPE_PACKAGE_FQN = "com.kumbasoft.core.beans.types";
    private static final String OBJECT_REFERENCE_CLASSNAME = "com.kumbasoft.core.beans.ObjectReference";
    private static final HashMap<Pair<Appliance, Domain>, Boolean> EXPORT_PROCESS_MANAGER;
    public static final String[] SERVICE_TYPES;
    public static final String[] QUIESCABLE_TYPES;
    public static final String INVALID_OBJECT_NAME_CHARACTERS = " !@#$%^&*()+=`~[]{};:'\"/\\|?,<>";
    private static HashMap<String, Boolean> classesHavingPasswords;
    private Index<Pair<Appliance, Domain>, DataPowerConfig> exportObjectList;

    static {
        PSEUDO_LOG_NAMES = new String[]{"cli-log", "compile-log", "diag-log", "usage-log", "xact-log", "startup-errors"};
        SERVICE_TYPES = new String[]{"APIGateway", "B2BGateway", "HTTPService", "MQGW", "MultiProtocolGateway", "SSHService", "SSLProxyService", "TCPProxyService", "TelnetService", "WSGateway", "XMLFirewallService", "XSLCoprocService", "XSLProxyService", "WebAppFW", "WebTokenService"};
        QUIESCABLE_TYPES = new String[]{"APIGateway", "AS1PollerSourceProtocolHandler", "AS2ProxySourceProtocolHandler", "AS2SourceProtocolHandler", "AS3SourceProtocolHandler", "B2BGateway", "Domain", "EBMS2SourceProtocolHandler", "EBMS3SourceProtocolHandler", "FTPFilePollerSourceProtocolHandler", "FTPServerSourceProtocolHandler", "HTTPService", "HTTPSourceProtocolHandler", "HTTPSSourceProtocolHandler", "IMSCalloutSourceProtocolHandler", "IMSConnectSourceProtocolHandler", "JMSSourceProtocolHandler", "MgmtInterface", "MQFTESourceProtocolHandler", "MQGW", "MQSourceProtocolHandler", "MultiProtocolGateway", "NFSFilePollerSourceProtocolHandler", "POPPollerSourceProtocolHandler", "RestMgmtInterface", "SFTPFilePollerSourceProtocolHandler", "SSHServerSourceProtocolHandler", "SSHService", "SSLProxyService", "StatelessTCPSourceProtocolHandler", "TCPProxyService", "TelnetService", "TibcoEMSSourceProtocolHandler", "WebB2BViewer", "WebSphereJMSSourceProtocolHandler", "WSGateway", "WebGUI", "XMLFirewallService", "XSLCoprocService", "XSLProxyService", "XTCProtocolHandler", "WebAppFW", "WebTokenService"};
        KumbaCoreApplicationProperties appProps = (KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties();
        String exports = appProps.getConfigExportsDirectory();
        CONFIG_EXPORTS_DIRECTORY = new File(exports);
        EXPORT_OPTIONS = new ExportOptions();
        EXPORT_OPTIONS.setAllFiles(false);
        EXPORT_OPTIONS.setPersisted(false);
        EXPORT_OPTIONS.setExportDebug(false);
        EXPORT_OPTIONS.setExportFiles(false);
        EXPORT_OPTIONS.setExportFormat(DPEnumerations.EXPORT_FORMAT[1]);
        EXPORT_OPTIONS.setOutputDirectory(CONFIG_EXPORTS_DIRECTORY);
        SAVE_CONFIG_ACTION = new ActionSaveConfig();
        EXPORT_PROCESS_MANAGER = new HashMap();
        PSEUDO_LOG_TARGETS = new ConfigLogTarget[6];
        ConfigurationManager.PSEUDO_LOG_TARGETS[0] = ConfigurationManager.createPseudoLogTarget("cli-log", 3, "logtemp:///cli-log");
        ConfigurationManager.PSEUDO_LOG_TARGETS[1] = ConfigurationManager.createPseudoLogTarget("compile-log", 3, "logtemp:///compile-log");
        ConfigurationManager.PSEUDO_LOG_TARGETS[2] = ConfigurationManager.createPseudoLogTarget("diag-log", 3, "logtemp:///diag-log");
        ConfigurationManager.PSEUDO_LOG_TARGETS[3] = ConfigurationManager.createPseudoLogTarget("usage-log", 3, "logtemp:///usage-log");
        ConfigurationManager.PSEUDO_LOG_TARGETS[4] = ConfigurationManager.createPseudoLogTarget("xact-log", 3, "logtemp:///xact-log");
        ConfigurationManager.PSEUDO_LOG_TARGETS[5] = ConfigurationManager.createPseudoLogTarget("startup-errors", 1, "logtemp:///startup-errors");
        new AsynchMethodInvoker(ConfigurationManager.class, "loadTypes");
    }

    public static final ArrayList<AsynchMethodInvoker<Void>> saveConfiguration(Index<Appliance, Domain> domains, ManagementCommandSubscriber ... commandSubscribers) {
        if (domains == null) {
            return null;
        }
        ArrayList<AsynchMethodInvoker<Void>> saveActionThreads = new ArrayList<AsynchMethodInvoker<Void>>();
        for (Appliance appliance : domains.getKeys()) {
            for (Domain domain : domains.get(appliance)) {
                AsynchMethodInvoker<Void> thread = ConfigurationManager.saveConfiguration(appliance, domain, commandSubscribers);
                saveActionThreads.add(thread);
            }
        }
        return saveActionThreads;
    }

    public static final AsynchMethodInvoker<Void> saveConfiguration(Appliance appliance, Domain domain, ManagementCommandSubscriber ... commandSubscribers) {
        ActionTool saveConfigAction = new ActionTool(appliance, domain, SAVE_CONFIG_ACTION);
        if (!ArrayUtility.isEmpty(commandSubscribers)) {
            ManagementCommandSubscriber[] managementCommandSubscriberArray = commandSubscribers;
            int n = commandSubscribers.length;
            int n2 = 0;
            while (n2 < n) {
                ManagementCommandSubscriber subscriber = managementCommandSubscriberArray[n2];
                saveConfigAction.addManagementCommandSubscriber(subscriber);
                ++n2;
            }
        }
        return saveConfigAction.getProcessThread();
    }

    public static final List<String> getConfigTypes() {
        return ConfigurationManager.getTypes(AnyConfigElement.class, "Config");
    }

    public static final List<String> getModifyTypes() {
        return ConfigurationManager.getTypes(AnyModifyElement.class, "Modify");
    }

    public static final List<String> getStatusTypes() {
        return ConfigurationManager.getTypes(AnyStatusElement.class, "Status");
    }

    private static final List<String> getTypes(Class<?> typeSet, String prefix) {
        logger.finer(() -> LMG.log("(typeSet=%s, prefix=%s): Starting.", () -> typeSet.getSimpleName(), () -> prefix));
        ArrayList<String> types = BeanService.getPropertyNames(typeSet);
        ArrayList<String> typeNames = new ArrayList<String>(types.size());
        int prefixLength = prefix.length();
        for (String type : types) {
            String typeName = BeanService.getPropertyType(typeSet, type).getSimpleName().substring(prefixLength);
            logger.finer(() -> LMG.log("(typeSet=%s, prefix=%s): Got type name '%s' from type '%s'.", () -> typeSet.getSimpleName(), () -> prefix, () -> typeName, () -> type));
            typeNames.add(typeName);
        }
        Collections.sort(typeNames);
        logger.finer(() -> LMG.log("(typeSet=%s, prefix=%s): Done.", () -> typeSet.getSimpleName(), () -> prefix));
        return typeNames;
    }

    @Reflected
    private static final void loadTypes() {
        ALL_TYPES = new Class[DPEnumerations.CONFIG_ENUM.length];
        int i = 0;
        while (i < DPEnumerations.CONFIG_ENUM.length) {
            Class<? extends DataPowerConfig> type = ConfigurationManager.getConfigObjectClass(DPEnumerations.CONFIG_ENUM[i]);
            ConfigurationManager.ALL_TYPES[i] = type;
            ++i;
        }
    }

    public static boolean isObjectNameValid(String objectName) {
        if (StringUtility.isEmpty(objectName)) {
            return false;
        }
        boolean containsInvalidChars = StringUtility.containsAnyOf(objectName, INVALID_OBJECT_NAME_CHARACTERS);
        return !containsInvalidChars;
    }

    public static final String getStandardInvalidObjectNameMessage(String objectType) {
        return String.format("<html><body><p>Please enter a valid name for the %s.</p><br/><p>The name cannot contain any of the following characters:</p><br/>%s</p></body></html>", objectType, INVALID_OBJECT_NAME_CHARACTERS);
    }

    public static XMLInfo getXMLInfo(Class<?> configObjectClass, String propertyName) {
        String methodName = String.format("get%s", StringUtility.capitalize(propertyName));
        XMLInfo xmlInfo = null;
        try {
            xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(configObjectClass, methodName, XMLInfo.class);
        }
        catch (PropertyNotFoundException pnfE) {
            methodName = String.format("is%s", StringUtility.capitalize(propertyName));
            xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(configObjectClass, methodName, XMLInfo.class);
        }
        return xmlInfo;
    }

    public static final void updateExportOptionsSessionTime() {
        ConfigurationManager.setExportOptionsSessionTime(System.currentTimeMillis());
    }

    public static final void setExportOptionsSessionTime(long sessionTime) {
        EXPORT_OPTIONS.setSessionTime(sessionTime);
    }

    private static StatusObjectStatus createPseudoLogStatus(Appliance appliance, Domain domain, String name) {
        StatusObjectStatus status = new StatusObjectStatus();
        status.setAppliance(appliance);
        status.setSourceDomain(domain);
        status.setDataPowerClass("LogTarget");
        status.setName(name);
        status.setConfigState("intrinsic");
        status.setAdminState("enabled");
        status.setOpState("up");
        return status;
    }

    private static ConfigLogTarget createPseudoLogTarget(String name, int logRotations, String localFileName) {
        ConfigLogTarget ltc = new ConfigLogTarget();
        ltc.setConfigObjectType("LogTarget");
        ltc.setIsReadOnly(true);
        ltc.setIsIntrinsic(true);
        ltc.setName(name);
        ltc.setAdminState("enabled");
        ltc.setRotate(logRotations);
        ltc.setType("file");
        ltc.setFormat("text");
        ltc.setLocalFile(localFileName);
        return ltc;
    }

    public static String getCorrectedObjectName(StatusObjectStatus objectStatus) {
        String dataPowerClass = objectStatus.getDataPowerClass();
        String objectName = objectStatus.getName();
        return ConfigurationManager.getCorrectedObjectName(dataPowerClass, objectName);
    }

    public static String getCorrectedObjectName(DataPowerConfig dataPowerObject) {
        String dataPowerClass = dataPowerObject.getConfigObjectType();
        String objectName = dataPowerObject.getName();
        return ConfigurationManager.getCorrectedObjectName(dataPowerClass, objectName);
    }

    public static String getCorrectedObjectName(String dataPowerClass, String objectName) {
        switch (dataPowerClass) {
            case "DNSNameService": {
                return "Main-Name-Service";
            }
            case "Statistics": {
                return "default";
            }
        }
        return objectName;
    }

    public static String getJavaKeywordAdjustedName(String elementName) {
        String name = elementName;
        switch (elementName.toLowerCase()) {
            case "class": {
                name = "DataPowerClass";
                break;
            }
            case "interface": {
                name = "EthernetInterface";
                break;
            }
            case "enum": {
                name = "EnumType";
                break;
            }
            case "default": {
                name = "DefaultType";
                break;
            }
            case "static": {
                name = "StaticType";
                break;
            }
            case "public": {
                name = "TypePublic";
                break;
            }
            case "switch": {
                name = "LogicSwitch";
                break;
            }
            case "case": {
                name = "LogicCase";
                break;
            }
            case "catch": {
                name = "CatchClause";
                break;
            }
            case "finally": {
                name = "FinallyClause";
            }
        }
        return name;
    }

    public static ArrayList<JMBean> xmlToObjects(Appliance appliance, Domain domain, String xmlString) {
        ArrayList<JMBean> objects = new ArrayList<JMBean>();
        XMLElement rootElement = XMLElement.parseXMLString(xmlString);
        if (rootElement == null) {
            int endOfFirstElement = xmlString.indexOf(62);
            String firstElement = xmlString.substring(0, endOfFirstElement + 1);
            int space = firstElement.indexOf(32);
            String firstTag = "";
            firstTag = space >= 0 && space < endOfFirstElement ? firstElement.substring(1, space) : firstElement.substring(1, endOfFirstElement);
            int beginningOfLastElement = xmlString.lastIndexOf(60);
            int endingOfLastElement = xmlString.indexOf(62, beginningOfLastElement);
            if (beginningOfLastElement < 0 || endingOfLastElement < 0) {
                String xmlStringF = xmlString;
                AbstractTool.logger.severe(() -> LMG.log("(appliance=%s, domain=%s, xmlString): xmlString.length=%d, beginningOfLastElement: %d, endingOfLastElement=%d", () -> appliance.getName(), () -> domain.getName(), () -> xmlStringF.length(), () -> beginningOfLastElement, () -> endingOfLastElement));
            } else {
                String endTag = xmlString.substring(beginningOfLastElement + 2, endingOfLastElement);
                String firstTagF = firstTag;
                AbstractTool.logger.severe(() -> LMG.log("(appliance=%s, domain=%s, xmlString):  firstTag: %s, endTag=%s", () -> appliance.getName(), () -> domain.getName(), () -> firstTagF, () -> endTag));
            }
            return objects;
        }
        xmlString = null;
        XMLElement dataPowerConfiguration = rootElement.getNode("datapower-configuration");
        XMLElement configurationElement = dataPowerConfiguration.getNode("configuration");
        ArrayList objectElements = (ArrayList)configurationElement.getNodes();
        for (XMLElement objectElement : objectElements) {
            DataPowerConfig object = (DataPowerConfig)ConfigurationManager.xmlToObject(appliance, domain, objectElement);
            if (object == null) continue;
            objects.add(object);
        }
        return objects;
    }

    public static <T> T xmlToObject(Appliance appliance, Domain domain, XMLElement objectNode) {
        Collection<XMLElement> childNodes = objectNode.getNodes();
        BeanIndexer<XMLElement> bi = new BeanIndexer<XMLElement>(childNodes);
        Index<Object, XMLElement> nodeIndex = bi.getIndexOf("name", null);
        String objectNodeName = objectNode.getName();
        String objectName = objectNode.getAttributeValue("name");
        String configObjectClassName = null;
        configObjectClassName = objectName != null && Comparison.isIn(objectNodeName, DPEnumerations.CONFIG_ENUM) ? String.format("%s.Config%s", CONFIG_PACKAGE_FQN, objectNodeName) : (objectNodeName.equals("ConfigModifyType") ? String.format("%s.%s", CONFIG_PACKAGE_FQN, objectNodeName) : (objectNodeName.equals("ObjectReference") ? OBJECT_REFERENCE_CLASSNAME : String.format("%s.%s", TYPE_PACKAGE_FQN, objectNodeName)));
        JMBean dataPowerConfig = null;
        try {
            dataPowerConfig = (JMBean)BeanService.getBean(configObjectClassName);
            if (dataPowerConfig instanceof ObjectReference) {
                ObjectReference objectRefConfig = (ObjectReference)dataPowerConfig;
                String className = objectNode.getAttributeValue("class");
                objectName = objectNode.getValue();
                objectRefConfig.setClassName(className);
                objectRefConfig.setName(objectName);
                return (T)dataPowerConfig;
            }
            ArrayList<String> propertyNames = BeanService.getPropertyNames(dataPowerConfig);
            Iterator<String> iterator = propertyNames.iterator();
            block17: while (iterator.hasNext()) {
                String propertyName;
                switch (propertyName = iterator.next()) {
                    case "appliance": {
                        BeanService.setPropertyValue(dataPowerConfig, "appliance", appliance);
                        break;
                    }
                    case "sourceDomain": {
                        BeanService.setPropertyValue(dataPowerConfig, "sourceDomain", domain);
                        break;
                    }
                    case "configObjectType": {
                        BeanService.setPropertyValue(dataPowerConfig, "configObjectType", objectNodeName);
                        break;
                    }
                    case "name": {
                        if (objectName != null) {
                            BeanService.setPropertyValue(dataPowerConfig, "name", objectName);
                            break;
                        }
                    }
                    default: {
                        Method propertyAccessor = BeanService.getPropertyAccessor(dataPowerConfig, propertyName);
                        XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(propertyAccessor, XMLInfo.class);
                        if (xmlInfo == null) continue block17;
                        String elementType = xmlInfo.elementType();
                        String elementName = xmlInfo.elementName();
                        String javaType = xmlInfo.javaType();
                        int multiplicity = xmlInfo.multiplicity();
                        if (multiplicity == 1) {
                            try {
                                XMLElement propertyNode = null;
                                propertyNode = elementType.equals("attribute") ? objectNode : nodeIndex.get(elementName, 0);
                                ConfigurationManager.processPropertyNode(appliance, domain, objectNode, propertyNode, propertyName, dataPowerConfig, elementName, elementType, javaType, multiplicity);
                            }
                            catch (IndexOutOfBoundsException propertyNode) {
                            }
                            catch (IllegalStateException e) {
                                if (dataPowerConfig instanceof ObjectReference) {
                                    ObjectReference ref = (ObjectReference)dataPowerConfig;
                                    String nodeValue = objectNode.getValue();
                                    ref.setName(nodeValue);
                                    break;
                                }
                                AbstractTool.logger.severe(() -> LMG.log("(objectNode):  nodeIndex is empty!  NodeName=%s, elementName=%s", () -> objectNodeName, () -> elementName));
                            }
                            continue block17;
                        }
                        ArrayList propertyNodes = (ArrayList)nodeIndex.get(elementName);
                        if (!CollectionUtility.isNotEmpty(propertyNodes)) continue block17;
                        for (XMLElement propertyNode : propertyNodes) {
                            ConfigurationManager.processPropertyNode(appliance, domain, objectNode, propertyNode, propertyName, dataPowerConfig, elementName, elementType, javaType, multiplicity);
                        }
                        continue block17;
                    }
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            String configObjectClassNameF = configObjectClassName;
            AbstractTool.logger.severe(() -> LMG.log("(objectNode):  Class %s not found or loadable!\n%s\n", () -> configObjectClassNameF, () -> objectNode.toString()));
        }
        return (T)dataPowerConfig;
    }

    private static void processPropertyNode(Appliance appliance, Domain domain, XMLElement objectNode, XMLElement propertyNode, String propertyName, JMBean dpObject, String elementName, String elementType, String javaType, int multiplicity) {
        String elementValue = null;
        if (javaType.startsWith("ObjectReference")) {
            javaType = "ObjectReference";
        }
        switch (elementType) {
            case "element": {
                if (propertyNode == null) break;
                if (ConfigurationManager.isJavaPrimitive(javaType)) {
                    elementValue = propertyNode.getValue();
                    break;
                }
                propertyNode.setName(javaType);
                elementValue = ConfigurationManager.xmlToObject(appliance, domain, propertyNode);
                break;
            }
            case "attribute": {
                elementValue = objectNode.getAttributeValue(elementName);
            }
        }
        if (elementValue != null) {
            if (multiplicity == 1) {
                BeanService.setPropertyValue(dpObject, propertyName, elementValue);
            } else {
                String goodName = ConfigurationManager.getJavaKeywordAdjustedName(elementName);
                String addMethodName = String.format("add%s", goodName);
                MethodInvoker addMethod = new MethodInvoker((Object)dpObject, addMethodName, elementValue);
                addMethod.invoke();
            }
        }
    }

    private static boolean isJavaPrimitive(String javaType) {
        switch (javaType) {
            case "String": 
            case "java.math.BigInteger": 
            case "int": 
            case "long": 
            case "boolean": {
                return true;
            }
        }
        return false;
    }

    private static void mapStatusToObjects(ArrayList<DataPowerConfig> objectList, ArrayList<StatusObjectStatus> statusList) {
        String loggerPrefix = String.format("(ArrayList<DataPowerConfig> objectList=%d, ArrayList<StatusObjectStatus> statusList=%d)", objectList.size(), statusList.size());
        AbstractTool.logger.finer(() -> LMG.log("%s: Starting", () -> loggerPrefix));
        try {
            HashMap<Appliance, Index<Domain, StatusObjectStatus>> statusByAppliance = DataStructureUtility.mapByApplianceDomain(statusList);
            BeanIndexer<StatusObjectStatus> statusIndexer = new BeanIndexer<StatusObjectStatus>(statusList);
            for (DataPowerConfig config : objectList) {
                Appliance objectAppliance = config.getAppliance();
                Domain objectDomain = config.getSourceDomain();
                String objectType = config.getConfigObjectType();
                String objectName = config.getName();
                Index<Domain, StatusObjectStatus> statusByDomain = statusByAppliance.get(objectAppliance);
                if (statusByDomain == null) {
                    AbstractTool.logger.info(() -> LMG.log("%s  No object status for appliance %s.  Connection hangup?", () -> loggerPrefix, () -> objectAppliance.getName()));
                    continue;
                }
                ArrayList statusInDomain = (ArrayList)statusByDomain.get(objectDomain);
                if (statusInDomain == null) {
                    AbstractTool.logger.info(() -> LMG.log("%s  No object status for domain %s of appliance %s.  Connection hangup?", () -> loggerPrefix, () -> objectDomain.getName(), () -> objectAppliance.getName()));
                    continue;
                }
                statusIndexer.setBeanCollection(statusInDomain);
                Index<Object, StatusObjectStatus> statusByType = statusIndexer.getIndexOf("dataPowerClass", null);
                ArrayList typeList = (ArrayList)statusByType.get(objectType);
                if (typeList == null) {
                    AbstractTool.logger.info(() -> LMG.log("%s  No object status types of %s for domain %s of appliance %s.  Connection hangup?", () -> loggerPrefix, () -> objectType, () -> objectDomain.getName(), () -> objectAppliance.getName()));
                    continue;
                }
                statusIndexer.setBeanCollection(typeList);
                HashMap<Object, StatusObjectStatus> objectMap = statusIndexer.getMapOf("name", null);
                StatusObjectStatus matchingStatus = objectMap.get(objectName);
                config.setStatus(matchingStatus);
            }
        }
        catch (ConcurrentModificationException ex) {
            AbstractTool.logger.warning(() -> LMG.log("%s: Concurrent Modification Exception.  Retrying.", () -> loggerPrefix));
            new AsynchMethodInvoker(ConfigurationManager.class, "mapStatusToObjects", new Object[]{objectList, statusList});
        }
        AbstractTool.logger.finer(() -> LMG.log("%s: Done", () -> loggerPrefix));
    }

    public static void clearCache(Index<Appliance, Domain> domains) {
        for (Appliance appliance : domains.getKeys()) {
            for (Domain domain : domains.get(appliance)) {
                File cacheDir = new File(CONFIG_EXPORTS_DIRECTORY, String.format("%s%s%s", appliance.getName(), File.separator, domain.getName()));
                if (!cacheDir.exists()) continue;
                com.jmorgan.io.File specialFile = new com.jmorgan.io.File(cacheDir);
                File[] files = specialFile.recursiveListFiles();
                FileNameComparator fileNameComparator = new FileNameComparator();
                Arrays.sort(files, fileNameComparator);
                int i = files.length - 1;
                while (i >= 0) {
                    files[i].delete();
                    --i;
                }
                cacheDir.delete();
            }
        }
    }

    public static Class<? extends DataPowerConfig> getConfigObjectClass(String dataPowerClassName) {
        String fqcn = String.format("com.kumbasoft.core.beans.config.Config%s", dataPowerClassName);
        try {
            Class<?> objectClass = DynamicClassLoader.loadClass(fqcn);
            return objectClass;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean doesObjectContainPassword(String dataPowerClass) {
        Boolean hasPassword;
        AbstractTool.logger.finer(() -> LMG.log("(dataPowerClass=%s):  Starting.", () -> dataPowerClass));
        if (dataPowerClass.equals("PasswordAlias")) {
            return true;
        }
        if (classesHavingPasswords == null) {
            classesHavingPasswords = new HashMap();
        }
        if ((hasPassword = classesHavingPasswords.get(dataPowerClass)) != null) {
            boolean b = hasPassword;
            AbstractTool.logger.finer(() -> LMG.log("(dataPowerClass=%s):  Class found in cache.  Returning %b.", () -> dataPowerClass, () -> b));
            return hasPassword;
        }
        hasPassword = Boolean.FALSE;
        Class<? extends DataPowerConfig> objectClass = ConfigurationManager.getConfigObjectClass(dataPowerClass);
        if (objectClass == null) {
            return false;
        }
        ArrayList<String> propertyNames = BeanService.getPropertyNames(objectClass);
        for (String propertyName : propertyNames) {
            XMLInfo xmlInfo = ConfigurationManager.getXMLInfo(objectClass, propertyName);
            if (xmlInfo == null || !xmlInfo.isPassword() && !xmlInfo.refType().equals("PasswordAlias")) continue;
            hasPassword = Boolean.TRUE;
            break;
        }
        classesHavingPasswords.put(dataPowerClass, (boolean)hasPassword);
        boolean b = hasPassword;
        AbstractTool.logger.finer(() -> LMG.log("(dataPowerClass=%s):  Done.  Returning %b.", () -> dataPowerClass, () -> b));
        return hasPassword;
    }

    public ArrayList<StatusObjectStatus> listObjects(ArrayList<Appliance> appliances, String objectTypeExpression, String objectNameExpression) {
        Index<Appliance, Domain> domains = new Index<Appliance, Domain>();
        for (Appliance appliance : appliances) {
            domains.put(appliance, appliance.getDomain("default"));
        }
        return this.listObjects(domains, objectTypeExpression, objectNameExpression);
    }

    public ArrayList<StatusObjectStatus> listObjects(Index<Appliance, Domain> domains, String objectTypeExpression, String objectNameExpression) {
        return this.listObjects(domains, objectTypeExpression, objectNameExpression, false);
    }

    public ArrayList<StatusObjectStatus> listObjects(Index<Appliance, Domain> domains, String objectTypeExpression, String objectNameExpression, boolean caseSensitiveSearch) {
        String objectTypeExpressionF = RegexUtility.normalizeRegex(objectTypeExpression, caseSensitiveSearch);
        String objectNameExpressionF = RegexUtility.normalizeRegex(objectNameExpression, caseSensitiveSearch);
        DataPowerStatusCache<StatusObjectStatus> statusCache = new DataPowerStatusCache<StatusObjectStatus>();
        AbstractTool.logger.finer(() -> LMG.log("(domains, objectTypeExpressionF=%s, objectNameExpressionF=%s, caseSensitiveSearch=%b):  Starting", () -> objectTypeExpressionF, () -> objectNameExpressionF, () -> caseSensitiveSearch));
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        int appliancesConnected = 0;
        for (Appliance appliance : domains.getKeys()) {
            AbstractTool.logger.finer(() -> LMG.log("(domains, objectTypeExpressionF=%s, objectNameExpressionF=%s, caseSensitiveSearch=%b):  Appliance %s %s connected", () -> objectTypeExpressionF, () -> objectNameExpressionF, () -> caseSensitiveSearch, () -> appliance.getName(), () -> appliance.isConnected() ? "is" : "is not"));
            if (appliance.isConnected()) {
                ++appliancesConnected;
                for (Domain domain : domains.get(appliance)) {
                    if (domain.getName().equals("default") && "LogTarget".matches(objectTypeExpressionF)) {
                        AbstractTool.logger.fine(() -> LMG.log("(domains, objectTypeExpressionF=%s, objectNameExpressionF=%s, caseSensitiveSearch=%b):  Creating pseudo logging targets for default domain of %s", () -> objectTypeExpressionF, () -> objectNameExpressionF, () -> caseSensitiveSearch, () -> appliance.getName()));
                        String[] stringArray = PSEUDO_LOG_NAMES;
                        int n = PSEUDO_LOG_NAMES.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String logTargetName = stringArray[n2];
                            StatusObjectStatus logTargetStatus = ConfigurationManager.createPseudoLogStatus(appliance, domain, logTargetName);
                            statusCache.statusEvent(logTargetStatus);
                            ++n2;
                        }
                    }
                    AbstractTool.logger.finer(() -> LMG.log("(domains, objectTypeExpressionF=%s, objectNameExpressionF=%s, caseSensitiveSearch=%b):  Getting object status for %s->%s", () -> objectTypeExpressionF, () -> objectNameExpressionF, () -> caseSensitiveSearch, () -> appliance.getName(), () -> domain.getName()));
                    DataPowerStatusMonitor statusMonitor = new DataPowerStatusMonitor(appliance, domain, "ObjectStatus", 0L);
                    statusCache.incrementMonitorCount();
                    statusMonitor.addStatusListener(statusCache);
                    mtil.addThread(statusMonitor.getProcessThread());
                }
                continue;
            }
            AbstractTool.logger.info(() -> LMG.log("(domains, objectTypeExpressionF=%s, objectNameExpressionF=%s, caseSensitiveSearch=%b):  Appliance %s appears to be down.", () -> objectTypeExpressionF, () -> objectNameExpressionF, () -> caseSensitiveSearch, () -> appliance.getName()));
        }
        if (appliancesConnected == 0) {
            AbstractTool.logger.warning(() -> LMG.log("(domains, objectTypeExpressionF=%s, objectNameExpressionF=%s, caseSensitiveSearch=%b):  No appliances were connected!  Is this accurate?", () -> objectTypeExpressionF, () -> objectNameExpressionF, () -> caseSensitiveSearch));
            return new ArrayList<StatusObjectStatus>();
        }
        ThreadManager.monitorAsynchThreadLifeCycle("ConfigurationManager.listObjects(...)", mtil, domains.totalSize() * KumbaCoreConstants.STARTUP_DELAY, 0);
        while (!statusCache.isComplete()) {
            AbstractTool.logger.finer(() -> LMG.log("(domains, objectTypeExpressionF=%s, objectNameExpressionF=%s, caseSensitiveSearch=%b):  Status cache still not complete after threads appear to have finished.", () -> objectTypeExpressionF, () -> objectNameExpressionF, () -> caseSensitiveSearch));
            ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
        }
        AbstractTool.logger.finer(() -> LMG.log("(domains, objectTypeExpressionF=%s, objectNameExpressionF=%s, caseSensitiveSearch=%b):  Status cache complete.", () -> objectTypeExpressionF, () -> objectNameExpressionF, () -> caseSensitiveSearch));
        ArrayList objects = statusCache.getStatusCache();
        AbstractTool.logger.fine(() -> LMG.log("(domains, objectTypeExpressionF=%s, objectNameExpressionF=%s, caseSensitiveSearch=%b):  Found %d total objects.  Extracting Matching Objects", () -> objectTypeExpressionF, () -> objectNameExpressionF, () -> caseSensitiveSearch, () -> objects.size()));
        PropertyValueSelector selector = new PropertyValueSelector(objects);
        selector.addPropertyValueMap("dataPowerClass", objectTypeExpressionF, 11);
        selector.addPropertyValueMap("name", objectNameExpressionF, 11);
        ArrayList selectedObjects = (ArrayList)selector.getSelectedElements();
        AbstractTool.logger.finer(() -> LMG.log("(domains, objectTypeExpressionF=%s, objectNameExpressionF=%s, caseSensitiveSearch=%b):  Done.  Found %d objects", () -> objectTypeExpressionF, () -> objectNameExpressionF, () -> caseSensitiveSearch, () -> selectedObjects.size()));
        return selectedObjects;
    }

    public DataPowerConfig getObject(StatusObjectStatus dataPowerObject) {
        SingleThreadInvocationListener invocationListener = new SingleThreadInvocationListener();
        GetConfiguration getConfiguration = new GetConfiguration(dataPowerObject);
        getConfiguration.getProcessThread().addInvocationListener(invocationListener);
        invocationListener.waitForCompletion(Integer.MAX_VALUE);
        DataPowerConfig config = getConfiguration.getDataPowerConfig();
        return config;
    }

    public DataPowerConfig getObject(Appliance appliance, Domain domain, String objectClass, String objectName) {
        if (objectClass.equals("LogTarget") && Comparison.isIn(objectName, PSEUDO_LOG_NAMES)) {
            ConfigLogTarget[] configLogTargetArray = PSEUDO_LOG_TARGETS;
            int n = PSEUDO_LOG_TARGETS.length;
            int n2 = 0;
            while (n2 < n) {
                ConfigLogTarget logTarget = configLogTargetArray[n2];
                if (logTarget.getName().equals(objectName)) {
                    return logTarget;
                }
                ++n2;
            }
        }
        SingleThreadInvocationListener invocationListener = new SingleThreadInvocationListener();
        GetConfiguration getConfiguration = new GetConfiguration(appliance, domain, objectClass, objectName);
        getConfiguration.getProcessThread().addInvocationListener(invocationListener);
        boolean completedOnTime = invocationListener.waitForCompletion(KumbaCoreConstants.THREAD_TIMEOUT);
        if (!completedOnTime) {
            AbstractTool.logger.fine(() -> LMG.log("Failed to get configuration of %s->%s from the %s domain of %s in time.", () -> objectClass, () -> objectName, () -> domain.getName(), () -> appliance.getName()));
        }
        return getConfiguration.getDataPowerConfig();
    }

    public ArrayList<DataPowerConfig> getObjects(ArrayList<StatusObjectStatus> objectList) {
        AbstractTool.logger.finer("(ArrayList<StatusObjectStatus> objectList):  Starting");
        if (CollectionUtility.isEmpty(objectList)) {
            AbstractTool.logger.info("(ArrayList<StatusObjectStatus> objectList):  objectList is empty.");
            return new ArrayList<DataPowerConfig>();
        }
        AbstractTool.logger.fine(() -> LMG.log("Preparing to get %d objects in no more than %dms", () -> objectList.size(), () -> KumbaCoreConstants.THREAD_TIMEOUT));
        MultiThreadInvocationListener threadWait = new MultiThreadInvocationListener();
        ArrayList<GetConfigurations> threads = new ArrayList<GetConfigurations>(objectList.size());
        ArrayList<DataPowerConfig> objectConfigs = new ArrayList<DataPowerConfig>(objectList.size());
        HashMap<Appliance, Index<Domain, StatusObjectStatus>> objectMap = DataStructureUtility.mapByApplianceDomain(objectList);
        for (Appliance appliance : objectMap.keySet()) {
            Index<Domain, StatusObjectStatus> objectsByAppliance = objectMap.get(appliance);
            for (Domain domain : objectsByAppliance.getKeys()) {
                Collection<StatusObjectStatus> objectsByDomain = objectsByAppliance.get(domain);
                ArrayList<StatusObjectStatus> actualObjectsToGet = new ArrayList<StatusObjectStatus>();
                for (StatusObjectStatus object : objectsByDomain) {
                    boolean isPseudoObject = false;
                    if (domain.getName().equals("default") && object.getDataPowerClass().equals("LogTarget")) {
                        ConfigLogTarget[] configLogTargetArray = PSEUDO_LOG_TARGETS;
                        int n = PSEUDO_LOG_TARGETS.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ConfigLogTarget pseudoLogTarget = configLogTargetArray[n2];
                            if (pseudoLogTarget.getName().equals(object.getName())) {
                                ConfigLogTarget pseudoClone = BeanService.getClone(pseudoLogTarget);
                                pseudoClone.setAppliance(appliance);
                                pseudoClone.setSourceDomain(domain);
                                pseudoClone.setStatus(object);
                                objectConfigs.add(pseudoClone);
                                isPseudoObject = true;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (isPseudoObject) continue;
                    actualObjectsToGet.add(object);
                }
                if (!CollectionUtility.isNotEmpty(actualObjectsToGet)) continue;
                GetConfigurations getConfiguration = new GetConfigurations(appliance, domain, actualObjectsToGet);
                threadWait.addThread(getConfiguration.getProcessThread());
                threads.add(getConfiguration);
            }
        }
        ThreadManager.monitorAsynchThreadLifeCycle("ConfigurationManager.getObjects(...)", threadWait, objectList.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
        for (GetConfigurations getConfig : threads) {
            ArrayList<DataPowerConfig> configs = getConfig.getDataPowerConfigs();
            if (!CollectionUtility.isNotEmpty(configs)) continue;
            objectConfigs.addAll(configs);
        }
        AbstractTool.logger.finer("(ArrayList<StatusObjectStatus> objectList):  Done");
        return objectConfigs;
    }

    public ArrayList<DataPowerConfig> getObjects(Appliance appliance, Domain domain, String objectTypeExpression, String objectNameExpression) {
        Index<Appliance, Domain> domains = new Index<Appliance, Domain>();
        domains.put(appliance, domain);
        return this.getObjects(domains, objectTypeExpression, objectNameExpression);
    }

    public <ConfigType> ArrayList<ConfigType> getObjects(ArrayList<Appliance> appliances, Class<ConfigType> configType, String objectNameExpression) {
        logger.finer("(ArrayList<Appliance> appliances, Class<ConfigType> configType, String objectNameExpression): Starting.  Aggregating default domains.");
        Index<Appliance, Domain> domains = new Index<Appliance, Domain>();
        for (Appliance appliance : appliances) {
            Domain domain = appliance.getDomain("default");
            if (domain == null) {
                logger.warning(() -> LMG.log("(ArrayList<Appliance> appliances, Class<ConfigType> configType, String objectNameExpression):  Default domain not found for applaince %s", () -> appliance.getName()));
                continue;
            }
            logger.finer(() -> LMG.log("(ArrayList<Appliance> appliances, Class<ConfigType> configType, String objectNameExpression): Found default domain for %s.", () -> appliance.getName()));
            domains.put(appliance, domain);
        }
        logger.finer("(ArrayList<Appliance> appliances, Class<ConfigType> configType, String objectNameExpression): Done.  Getting objects.");
        return this.getObjects(domains, configType, objectNameExpression);
    }

    public <ConfigType> ArrayList<ConfigType> getObjects(Index<Appliance, Domain> searchDomains, Class<ConfigType> configType, String objectNameExpression) {
        String configTypeClassName = configType.getSimpleName().substring(6);
        return this.getObjects(searchDomains, String.format("(^%s$)", configTypeClassName), objectNameExpression);
    }

    public ArrayList<DataPowerConfig> getObjects(Index<Appliance, Domain> searchDomains, String objectTypeExpression, String objectNameExpression) {
        AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains, String objectTypeExpression=%s, String objectNameExpressionF=%s):  Starting.", () -> objectTypeExpression, () -> objectNameExpression));
        ArrayList<DataPowerConfig> objectConfigs = null;
        if (objectTypeExpression == null && objectNameExpression == null) {
            AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains, String objectTypeExpression=%s, String objectNameExpressionF=%s):  No type or name given...retrieving all objects.", () -> objectTypeExpression, () -> objectNameExpression));
            objectConfigs = this.getAllObjects(searchDomains);
        } else {
            ArrayList<StatusObjectStatus> selectedObjects = this.listObjects(searchDomains, objectTypeExpression, objectNameExpression);
            AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains, String objectTypeExpression=%s, String objectNameExpressionF=%s):  Listed %d objects of the given type/name.", () -> objectTypeExpression, () -> objectNameExpression, () -> selectedObjects.size()));
            objectConfigs = this.getObjects(selectedObjects);
        }
        int objectConfigsSize = objectConfigs.size();
        AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains, String objectTypeExpression=%s, String objectNameExpressionF=%s):  Done, returning %d objects.", () -> objectTypeExpression, () -> objectNameExpression, () -> objectConfigsSize));
        return objectConfigs;
    }

    private ArrayList<DataPowerConfig> getAllObjects(Index<Appliance, Domain> searchDomains) {
        AbstractTool.logger.finer("(Index<Appliance, Domain> searchDomains): Starting");
        long currentTime = System.currentTimeMillis();
        ArrayList<DataPowerConfig> objectConfigs = new ArrayList<DataPowerConfig>();
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        if (this.exportObjectList == null) {
            this.exportObjectList = new Index();
        }
        for (Appliance appliance : searchDomains.getKeys()) {
            for (Domain domain : searchDomains.get(appliance)) {
                String applianceName = appliance.getName();
                String domainName = domain.getName();
                Pair<Appliance, Domain> key = new Pair<Appliance, Domain>(appliance, domain);
                AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains):  Hash Key for Pair<%s, %s> = %d", () -> applianceName, () -> domainName, () -> key.hashCode()));
                while (EXPORT_PROCESS_MANAGER.containsKey(key)) {
                    AbstractTool.logger.info(() -> LMG.log("(Index<Appliance, Domain> searchDomains):  Waiting for export of all objects from %s -> %s", () -> applianceName, () -> domainName));
                    ThreadUtility.sleep(KumbaCoreConstants.THREAD_WAIT);
                }
                EXPORT_PROCESS_MANAGER.put(key, null);
                AbstractTool.logger.info(() -> LMG.log("(Index<Appliance, Domain> searchDomains):  Starting process for export of all objects from %s -> %s", () -> applianceName, () -> domainName));
                String allObjectsXMLPath = String.format("%s%s%s%sall-classes%sall-objects.xml", applianceName, File.separator, domainName, File.separator, File.separator);
                File allObjectsXMLFile = new File(CONFIG_EXPORTS_DIRECTORY, allObjectsXMLPath);
                String allObjectsXMLFileAbsolutePath = allObjectsXMLFile.getAbsolutePath();
                AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains):  Checking for existing XML Export: %s", () -> allObjectsXMLFileAbsolutePath));
                if (allObjectsXMLFile.exists()) {
                    AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains):  XML Export %s exists.", () -> allObjectsXMLFileAbsolutePath));
                    long lastModified = allObjectsXMLFile.lastModified();
                    long timeDelta = currentTime - lastModified;
                    if (timeDelta < (long)KumbaCoreConstants.EXPORT_CACHE_TIMEOUT) {
                        AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains):  Using XML Export %s due to time delta of %d < %d.", () -> allObjectsXMLFileAbsolutePath, () -> timeDelta, () -> KumbaCoreConstants.EXPORT_CACHE_TIMEOUT));
                        this.processExportXML(appliance, domain, allObjectsXMLFile.getAbsolutePath());
                        EXPORT_PROCESS_MANAGER.remove(key);
                        continue;
                    }
                    AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains):  XML Export %s exists, but is old.  Getting new export.", () -> allObjectsXMLFileAbsolutePath));
                }
                StatusObjectStatus objectSearchInfo = new StatusObjectStatus();
                objectSearchInfo.setAppliance(appliance);
                objectSearchInfo.setSourceDomain(domain);
                objectSearchInfo.setDataPowerClass("all-classes");
                objectSearchInfo.setName("all-objects");
                AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains):  Exporting all objects and classes for %s->%s", () -> applianceName, () -> domainName));
                SingleThreadInvocationListener stil = new SingleThreadInvocationListener();
                ExportConfiguration exportConfiguration = new ExportConfiguration(objectSearchInfo, EXPORT_OPTIONS);
                AsynchMethodInvoker<?> processThread = exportConfiguration.getProcessThread();
                processThread.addInvocationListener(stil);
                mtil.addThread(processThread);
                exportConfiguration.addManagementCommandSubscriber(this);
                boolean completedOnTime = stil.waitForCompletion(KumbaCoreConstants.SOMA_READ_TIMEOUT);
                if (!completedOnTime) {
                    AbstractTool.logger.warning(() -> LMG.log("(Index<Appliance, Domain> searchDomains):  Exports did not complete for %s->%s within %d.", () -> applianceName, () -> domainName, () -> KumbaCoreConstants.SOMA_READ_TIMEOUT));
                }
                EXPORT_PROCESS_MANAGER.remove(key);
            }
            if (mtil.getRunningThreadCount() > 0) {
                AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains):  Waiting for %d remaining exports to complete.", () -> mtil.getRunningThreadCount()));
                ThreadManager.monitorAsynchThreadLifeCycle("ConfigurationManager.getAllObjects(...)", mtil, KumbaCoreConstants.STARTUP_DELAY * 5, 0);
            }
            AbstractTool.logger.finer("(Index<Appliance, Domain> searchDomains):  All Exports completed.");
            for (Pair pair : this.exportObjectList.getKeys()) {
                Collection<DataPowerConfig> configs = this.exportObjectList.get(pair);
                objectConfigs.addAll(configs);
                configs.clear();
            }
            this.exportObjectList.clear();
        }
        AbstractTool.logger.finer(() -> LMG.log("(Index<Appliance, Domain> searchDomains):  Object Count: %s", () -> objectConfigs.size()));
        return objectConfigs;
    }

    private void processExportXML(Appliance appliance, Domain domain, String exportFileName) {
        String loggerPrefix = String.format("(appliance=%s, domain=%s, exportFileName=%s)", appliance.getName(), domain.getName(), exportFileName);
        AbstractTool.logger.finer(() -> LMG.log("%s:  Getting Status.", () -> loggerPrefix));
        Index<Appliance, Domain> searchDomains = new Index<Appliance, Domain>();
        searchDomains.put(appliance, domain);
        ArrayList<StatusObjectStatus> objectsInDomain = this.listObjects(searchDomains, ".*", ".*");
        Pair<Appliance, Domain> key = new Pair<Appliance, Domain>(appliance, domain);
        String xmlString = "";
        try {
            File exportFile = new File(exportFileName);
            ASCFileReader fileReader = new ASCFileReader(exportFile);
            xmlString = fileReader.readAll();
            ArrayList<JMBean> dataPowerObjects = ConfigurationManager.xmlToObjects(appliance, domain, xmlString);
            for (JMBean bean : dataPowerObjects) {
                DataPowerConfig object = (DataPowerConfig)bean;
                this.exportObjectList.put(key, object);
            }
            ArrayList allObjects = (ArrayList)this.exportObjectList.get(key);
            ConfigurationManager.mapStatusToObjects(allObjects, objectsInDomain);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void commandSucceeded(ManagementCommandStatus commandStatus) {
        DynamicBean additionalInfo = commandStatus.getAdditionalCommandInfo();
        String outputFileName = (String)additionalInfo.getProperty("outputFileName");
        this.processExportXML(commandStatus.getAppliance(), commandStatus.getDomain(), outputFileName);
    }

    @Override
    public void commandFailed(ManagementCommandError commandError) {
    }
}

