/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.Appliance;
import com.kumbasoft.core.beans.DataPowerObject;
import com.kumbasoft.core.beans.Domain;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class DataPowerConfig
extends DataPowerObject {
    private boolean quiesceState;
    private String adminState;
    private String name;
    private boolean isLocal;
    private boolean isIntrinsic;
    private boolean isReadOnly;
    private boolean isExternal;
    private String configObjectType;
    private StatusObjectStatus status;

    public DataPowerConfig() {
    }

    public DataPowerConfig(Appliance appliance, Domain domain) {
        super(appliance, domain);
    }

    public String getConfigObjectType() {
        if (this.configObjectType == null) {
            int lastDot;
            String fqcn = this.getClass().getName();
            String type = fqcn.substring((lastDot = fqcn.lastIndexOf(46)) + 1);
            if (type.startsWith("Config") || type.startsWith("Modify") || type.startsWith("Status")) {
                type = type.substring(6);
            }
            return type;
        }
        return this.configObjectType;
    }

    public void setConfigObjectType(String objectType) {
        this.configObjectType = objectType;
    }

    @XMLInfo(elementType="element", elementName="mAdminState", elementOrder=0, dataPowerType="tns:dmAdminState", isPassword=false, isEnumeration=true, javaName="adminState", javaType="String", isRequired=true, displayValue="Quiesced", multiplicity=1)
    public String getAdminState() {
        return this.adminState;
    }

    @XMLInfo(elementType="element", elementName="mAdminState", elementOrder=0, dataPowerType="tns:dmAdminState", isPassword=false, isEnumeration=true, javaName="adminState", javaType="String", isRequired=true, displayValue="Quiesced", multiplicity=1)
    public void setAdminState(String adminState) {
        if (Comparison.isIn(adminState, DPEnumerations.ADMIN_STATE)) {
            this.adminState = adminState;
        }
    }

    @XMLInfo(elementType="element", elementName="quiesced", elementOrder=0, dataPowerType="boolean", isPassword=false, isEnumeration=false, javaName="quiesceState", javaType="boolean", isRequired=true, displayValue="Quiesced", multiplicity=1)
    public boolean isQuiesceState() {
        return this.quiesceState;
    }

    @XMLInfo(elementType="element", elementName="quiesced", elementOrder=0, dataPowerType="boolean", isPassword=false, isEnumeration=false, javaName="quiesceState", javaType="boolean", isRequired=true, displayValue="Quiesced", multiplicity=1)
    public void setQuiesceState(boolean quiesceState) {
        this.quiesceState = quiesceState;
    }

    @XMLInfo(elementType="attribute", elementName="name", elementOrder=0, dataPowerType="String", isPassword=false, isEnumeration=false, javaName="name", javaType="String", isRequired=true, displayValue="Name", multiplicity=1)
    public String getName() {
        return this.name;
    }

    @XMLInfo(elementType="attribute", elementName="name", elementOrder=0, dataPowerType="String", isPassword=false, isEnumeration=false, javaName="name", javaType="String", isRequired=true, displayValue="Name", multiplicity=1)
    public void setName(String name) {
        this.name = name;
    }

    @XMLInfo(elementType="attribute", elementName="local", elementOrder=0, dataPowerType="boolean", isPassword=false, isEnumeration=false, javaName="isLocal", javaType="boolean", isRequired=true, displayValue="Is Local", multiplicity=1)
    public boolean getIsLocal() {
        return this.isLocal;
    }

    @XMLInfo(elementType="attribute", elementName="local", elementOrder=0, dataPowerType="boolean", isPassword=false, isEnumeration=false, javaName="isLocal", javaType="boolean", isRequired=true, displayValue="Is Local", multiplicity=1)
    public void setIsLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    @XMLInfo(elementType="attribute", elementName="intrinsic", elementOrder=0, dataPowerType="boolean", isPassword=false, isEnumeration=false, javaName="isIntrinsic", javaType="boolean", isRequired=true, displayValue="Is Intrinsic", multiplicity=1)
    public boolean getIsIntrinsic() {
        return this.isIntrinsic;
    }

    @XMLInfo(elementType="attribute", elementName="intrinsic", elementOrder=0, dataPowerType="boolean", isPassword=false, isEnumeration=false, javaName="isIntrinsic", javaType="boolean", isRequired=true, displayValue="Is Intrinsic", multiplicity=1)
    public void setIsIntrinsic(boolean isIntrinsic) {
        this.isIntrinsic = isIntrinsic;
    }

    @XMLInfo(elementType="attribute", elementName="read-only", elementOrder=0, dataPowerType="boolean", isPassword=false, isEnumeration=false, javaName="isReadOnly", javaType="boolean", isRequired=true, displayValue="Read Only", multiplicity=1)
    public boolean getIsReadOnly() {
        return this.isReadOnly;
    }

    @XMLInfo(elementType="attribute", elementName="read-only", elementOrder=0, dataPowerType="boolean", isPassword=false, isEnumeration=false, javaName="isReadOnly", javaType="boolean", isRequired=true, displayValue="Read Only", multiplicity=1)
    public void setIsReadOnly(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @XMLInfo(elementType="attribute", elementName="external", elementOrder=0, dataPowerType="boolean", isPassword=false, isEnumeration=false, javaName="isExternal", javaType="boolean", isRequired=true, displayValue="Is External", multiplicity=1)
    public boolean getIsExternal() {
        return this.isExternal;
    }

    @XMLInfo(elementType="attribute", elementName="external", elementOrder=0, dataPowerType="boolean", isPassword=false, isEnumeration=false, javaName="isExternal", javaType="boolean", isRequired=true, displayValue="Is External", multiplicity=1)
    public void setIsExternal(boolean isExternal) {
        this.isExternal = isExternal;
    }

    public StatusObjectStatus getStatus() {
        return this.status;
    }

    public void setStatus(StatusObjectStatus status) {
        this.status = status;
    }

    @Override
    public String getFQON() {
        return String.format("%s->%s->%s", super.getFQON(), this.getConfigObjectType(), this.getName());
    }

    @Override
    public int compareTo(DataPowerConfig that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "adminState", "quiesceState", "isExternal", "isIntrinsic", "isLocal", "isReadOnly", "name");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.adminState, this.quiesceState, this.isExternal, this.isIntrinsic, this.isLocal, this.isReadOnly, this.name);
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        return this.equals(o, "adminState", "quiesceState", "isExternal", "isIntrinsic", "isLocal", "isReadOnly", "name");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("adminState", "quiesceState", "isExternal", "isIntrinsic", "isLocal", "isReadOnly", "name"));
    }
}

