/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.StringUtility;
import com.kumbasoft.core.beans.status.StatusDomainStatus;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import java.util.Objects;

public class Domain
extends JMBean
implements Cloneable,
Comparable<Domain> {
    private String name;
    private boolean isDefault;
    private StatusDomainStatus domainStatus;
    private StatusObjectStatus objectStatus;

    public Domain() {
    }

    public Domain(String name) {
        this();
        this.setName(name);
    }

    public Domain clone() {
        return new Domain(this.getName());
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.isDefault = name.trim().equalsIgnoreCase("default");
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public boolean isQuiesced() {
        if (this.domainStatus == null) {
            return false;
        }
        String quiesceState = this.domainStatus.getQuiesceState();
        if (quiesceState == null) {
            return false;
        }
        return quiesceState.equals("quiesced");
    }

    public boolean isDiagMode() {
        if (this.domainStatus == null) {
            return false;
        }
        String diagMode = this.domainStatus.getDiagEnabled();
        return diagMode.equals("on");
    }

    public boolean isFailsafeMode() {
        if (this.domainStatus == null) {
            return false;
        }
        String failsafeMode = this.domainStatus.getFailsafeMode();
        return !failsafeMode.equals("none");
    }

    public boolean hasInterfaceLinkError() {
        if (this.domainStatus == null) {
            return false;
        }
        String interfaceState = this.domainStatus.getInterfaceState();
        return !interfaceState.equals("ok");
    }

    public boolean isQuarantined() {
        if (this.domainStatus == null) {
            return false;
        }
        String quarantinedState = this.domainStatus.getQuarantineEnabled();
        return StringUtility.isEmpty(quarantinedState) ? false : quarantinedState.equals("on");
    }

    public StatusDomainStatus getStatusDomainStatus() {
        return this.domainStatus;
    }

    public void setStatusDomainStatus(StatusDomainStatus domainStatus) {
        StatusDomainStatus oldDomainStatus = this.domainStatus;
        this.domainStatus = domainStatus;
        this.handlePropertyChange("domainStatus", oldDomainStatus, this.domainStatus);
    }

    public StatusObjectStatus getObjectStatus() {
        return this.objectStatus;
    }

    public void setObjectStatus(StatusObjectStatus objectStatus) {
        StatusObjectStatus oldObjectStatus = this.objectStatus;
        this.objectStatus = objectStatus;
        this.handlePropertyChange("objectStatus", oldObjectStatus, this.objectStatus);
    }

    @Override
    public int compareTo(Domain that) {
        return this.compareTo(that, "name");
    }

    public boolean equals(Object that) {
        return this.equals(that, "name");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name);
    }

    @Override
    public String toString() {
        return this.toString("name");
    }
}

