/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.beans.JMBean;
import com.jmorgan.beans.util.BeanService;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.DataPowerConfig;
import java.lang.reflect.Method;
import java.util.Objects;

public class ObjectPropertyDefinition
extends JMBean
implements Comparable<ObjectPropertyDefinition> {
    private Class<? extends DataPowerConfig> objectClass;
    private String propertyName;
    private String displayName;

    public ObjectPropertyDefinition() {
    }

    public ObjectPropertyDefinition(Class<? extends DataPowerConfig> objectClass, String propertyName) {
        this.setObjectClass(objectClass);
        this.setPropertyName(propertyName);
        Method accessor = BeanService.getPropertyAccessor(objectClass, propertyName);
        XMLInfo xmlInfo = (XMLInfo)BeanService.getMethodAnnotation(accessor, XMLInfo.class);
        if (xmlInfo == null) {
            System.out.printf("ObjectPropertyDefinition.ObjectPropertyDefinition(objectClass=%s, propertyName=%s):  XMLInfo is null\n", objectClass.getSimpleName(), propertyName);
        }
        String displayName = xmlInfo.displayValue();
        this.setDisplayName(displayName);
    }

    public ObjectPropertyDefinition(Class<? extends DataPowerConfig> objectClass, String propertyName, String displayName) {
        this.setObjectClass(objectClass);
        this.setPropertyName(propertyName);
        this.setDisplayName(displayName);
    }

    public Class<? extends DataPowerConfig> getObjectClass() {
        return this.objectClass;
    }

    public void setObjectClass(Class<? extends DataPowerConfig> objectClass) {
        this.objectClass = objectClass;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public int compareTo(ObjectPropertyDefinition that) {
        return this.compareTo(that, "objectClass", "propertyName", "displayName");
    }

    public boolean equals(Object that) {
        return this.equals(that, "objectClass", "propertyName", "displayName");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.objectClass, this.propertyName, this.displayName);
    }

    @Override
    public String toString() {
        return this.toString("objectClass", "propertyName", "displayName");
    }
}

