/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans;

import com.jmorgan.annotations.Reflected;
import com.jmorgan.beans.util.BeanIndexer;
import com.jmorgan.beans.util.BeanService;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCorePersistenceHandler;
import com.kumbasoft.core.beans.StatusProviderInfo;
import com.kumbasoft.core.beans.status.AnyStatusElement;
import com.kumbasoft.core.tools.AbstractTool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class StatusProviderManager
extends AbstractTool {
    private StatusProviderManager() {
    }

    @Reflected
    public static ArrayList<StatusProviderInfo> loadStatusProviders() {
        ArrayList<String> statusProviderClasses = BeanService.getPropertyNames(AnyStatusElement.class);
        Collections.sort(statusProviderClasses);
        ArrayList<StatusProviderInfo> statusProviderDefinitions = KumbaCorePersistenceHandler.readStatusProviderDefinitions();
        BeanIndexer<StatusProviderInfo> definitionIndexer = new BeanIndexer<StatusProviderInfo>(statusProviderDefinitions);
        HashMap<String, StatusProviderInfo> definitionIndex = definitionIndexer.getMapOf("name", "");
        ArrayList<StatusProviderInfo> statusProviderInfo = KumbaCorePersistenceHandler.readStatusProviderInfo();
        if (statusProviderInfo == null) {
            statusProviderInfo = new ArrayList();
            statusProviderInfo.addAll(statusProviderDefinitions);
        } else {
            BeanIndexer<StatusProviderInfo> statusProviderIndexer = new BeanIndexer<StatusProviderInfo>(statusProviderInfo);
            HashMap<String, StatusProviderInfo> statusProviderIndex = statusProviderIndexer.getMapOf("name", "");
            for (String statusProviderClass : statusProviderClasses) {
                String spiName = StringUtility.capitalize(statusProviderClass);
                StatusProviderInfo spiDefinition = definitionIndex.get(spiName);
                if (spiDefinition == null) {
                    AbstractTool.logger.severe(() -> LMG.log("():  *** WARNING: Status Definition '%s' is missing.  Installation issue?", () -> statusProviderClass));
                    continue;
                }
                StatusProviderInfo spi = statusProviderIndex.get(spiName);
                if (spi == null) {
                    AbstractTool.logger.fine(() -> LMG.log("():  *** WARNING: Status Class '%s' is missing from StatusProviders.xml.  Need to check its settings.", () -> statusProviderClass));
                    spi = (StatusProviderInfo)spiDefinition.clone();
                    statusProviderInfo.add(spi);
                    continue;
                }
                spi.setDisplayName(spiDefinition.getDisplayName());
                spi.setApplicableDomain(spiDefinition.getApplicableDomain());
                boolean isGraphable = spiDefinition.isGraphable();
                spi.setGraphable(isGraphable);
                if (isGraphable) {
                    spi.setGraphableProperties(spiDefinition.getGraphableProperties());
                }
                boolean popupSupported = spiDefinition.isDynamicPopupItemsSupported();
                spi.setDynamicPopupItemsSupported(popupSupported);
                if (!popupSupported) continue;
                spi.setMenuItems(spiDefinition.getMenuItems());
            }
        }
        KumbaCorePersistenceHandler.writeStatusProviderInfo(statusProviderInfo);
        Collections.sort(statusProviderInfo);
        return statusProviderInfo;
    }
}

