/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.actions;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ActionCreateProbeCapture
extends DataPowerAction {
    private String captureName;
    private String serviceType;
    private String serviceName;
    private int captureCount;
    private int interval;
    private String sendTIDInResponseHeader;
    private String encryptionAlgorithm;
    private String encryptionCertificate;
    private String logLevel;
    private String filterByRequiredHeader;
    private String filterByAPI;
    private String filterByAPICatalog;
    private String filterByIP;
    private String filterByPath;
    private String filterByAPIClientID;

    @XMLInfo(elementType="element", elementName="CaptureName", elementOrder=0, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="captureName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="^[-_a-zA-Z0-9.]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCaptureName() {
        return this.captureName;
    }

    @XMLInfo(elementType="element", elementName="CaptureName", elementOrder=0, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="captureName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="^[-_a-zA-Z0-9.]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCaptureName(String captureName) {
        if (captureName != null && captureName.matches("^[-_a-zA-Z0-9.]+$")) {
            this.captureName = captureName;
        }
    }

    @XMLInfo(elementType="element", elementName="ServiceType", elementOrder=1, dataPowerType="dmProbeServiceType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="serviceType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Service type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getServiceType() {
        return this.serviceType;
    }

    @XMLInfo(elementType="element", elementName="ServiceType", elementOrder=1, dataPowerType="dmProbeServiceType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="serviceType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Service type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setServiceType(String serviceType) {
        if (Comparison.isIn(serviceType, DPEnumerations.PROBE_SERVICE_TYPE)) {
            this.serviceType = serviceType;
        }
    }

    @XMLInfo(elementType="element", elementName="ServiceName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="serviceName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Service name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getServiceName() {
        return this.serviceName;
    }

    @XMLInfo(elementType="element", elementName="ServiceName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="serviceName", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Service name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @XMLInfo(elementType="element", elementName="CaptureCount", elementOrder=3, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="captureCount", javaType="int", isRequired=true, squelchNull=false, minimum=10, maximum=200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="20", displayOrder=0, displayValue="Max capture count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getCaptureCount() {
        return this.captureCount;
    }

    @XMLInfo(elementType="element", elementName="CaptureCount", elementOrder=3, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="captureCount", javaType="int", isRequired=true, squelchNull=false, minimum=10, maximum=200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="20", displayValue="Max capture count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCaptureCount(int captureCount) {
        this.captureCount = captureCount;
    }

    @XMLInfo(elementType="element", elementName="Interval", elementOrder=4, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="interval", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=3600L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1", displayOrder=0, displayValue="Interval", units="Seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getInterval() {
        return this.interval;
    }

    @XMLInfo(elementType="element", elementName="Interval", elementOrder=4, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="interval", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=3600L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1", displayValue="Interval", units="Seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setInterval(int interval) {
        this.interval = interval;
    }

    @XMLInfo(elementType="element", elementName="SendTIDInResponseHeader", elementOrder=5, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sendTIDInResponseHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Response probe ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSendTIDInResponseHeader() {
        return this.sendTIDInResponseHeader;
    }

    @XMLInfo(elementType="element", elementName="SendTIDInResponseHeader", elementOrder=5, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sendTIDInResponseHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Response probe ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSendTIDInResponseHeader(String sendTIDInResponseHeader) {
        if (sendTIDInResponseHeader == null || Comparison.isIn(sendTIDInResponseHeader, DPEnumerations.TOGGLE)) {
            this.sendTIDInResponseHeader = sendTIDInResponseHeader;
        }
    }

    @XMLInfo(elementType="element", elementName="EncryptionAlgorithm", elementOrder=6, dataPowerType="dmProbeCryptoEncryptionAlgorithm", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="encryptionAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Encryption algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncryptionAlgorithm() {
        return this.encryptionAlgorithm;
    }

    @XMLInfo(elementType="element", elementName="EncryptionAlgorithm", elementOrder=6, dataPowerType="dmProbeCryptoEncryptionAlgorithm", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="encryptionAlgorithm", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Encryption algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptionAlgorithm(String encryptionAlgorithm) {
        if (encryptionAlgorithm == null || Comparison.isIn(encryptionAlgorithm, DPEnumerations.PROBE_CRYPTO_ENCRYPTION_ALGORITHM)) {
            this.encryptionAlgorithm = encryptionAlgorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="EncryptionCertificate", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="encryptionCertificate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Encryption certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncryptionCertificate() {
        return this.encryptionCertificate;
    }

    @XMLInfo(elementType="element", elementName="EncryptionCertificate", elementOrder=7, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="encryptionCertificate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Encryption certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptionCertificate(String encryptionCertificate) {
        this.encryptionCertificate = encryptionCertificate;
    }

    @XMLInfo(elementType="element", elementName="LogLevel", elementOrder=8, dataPowerType="dmProbeLogLevelType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="logLevel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Log Level", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLogLevel() {
        return this.logLevel;
    }

    @XMLInfo(elementType="element", elementName="LogLevel", elementOrder=8, dataPowerType="dmProbeLogLevelType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="logLevel", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Log Level", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLogLevel(String logLevel) {
        if (logLevel == null || Comparison.isIn(logLevel, DPEnumerations.PROBE_LOG_LEVEL_TYPE)) {
            this.logLevel = logLevel;
        }
    }

    @XMLInfo(elementType="element", elementName="FilterByRequiredHeader", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByRequiredHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Match against header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFilterByRequiredHeader() {
        return this.filterByRequiredHeader;
    }

    @XMLInfo(elementType="element", elementName="FilterByRequiredHeader", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByRequiredHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Match against header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFilterByRequiredHeader(String filterByRequiredHeader) {
        this.filterByRequiredHeader = filterByRequiredHeader;
    }

    @XMLInfo(elementType="element", elementName="FilterByAPI", elementOrder=10, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByAPI", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Match against API", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFilterByAPI() {
        return this.filterByAPI;
    }

    @XMLInfo(elementType="element", elementName="FilterByAPI", elementOrder=10, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByAPI", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Match against API", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFilterByAPI(String filterByAPI) {
        this.filterByAPI = filterByAPI;
    }

    @XMLInfo(elementType="element", elementName="FilterByAPICatalog", elementOrder=11, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByAPICatalog", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Match against catalog", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFilterByAPICatalog() {
        return this.filterByAPICatalog;
    }

    @XMLInfo(elementType="element", elementName="FilterByAPICatalog", elementOrder=11, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByAPICatalog", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Match against catalog", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFilterByAPICatalog(String filterByAPICatalog) {
        this.filterByAPICatalog = filterByAPICatalog;
    }

    @XMLInfo(elementType="element", elementName="FilterByIP", elementOrder=12, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByIP", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Match against IP", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFilterByIP() {
        return this.filterByIP;
    }

    @XMLInfo(elementType="element", elementName="FilterByIP", elementOrder=12, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByIP", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Match against IP", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFilterByIP(String filterByIP) {
        this.filterByIP = filterByIP;
    }

    @XMLInfo(elementType="element", elementName="FilterByPath", elementOrder=13, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByPath", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Match against path", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFilterByPath() {
        return this.filterByPath;
    }

    @XMLInfo(elementType="element", elementName="FilterByPath", elementOrder=13, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByPath", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Match against path", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFilterByPath(String filterByPath) {
        this.filterByPath = filterByPath;
    }

    @XMLInfo(elementType="element", elementName="FilterByAPIClientID", elementOrder=14, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByAPIClientID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Match against client ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFilterByAPIClientID() {
        return this.filterByAPIClientID;
    }

    @XMLInfo(elementType="element", elementName="FilterByAPIClientID", elementOrder=14, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="filterByAPIClientID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Match against client ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFilterByAPIClientID(String filterByAPIClientID) {
        this.filterByAPIClientID = filterByAPIClientID;
    }

    public int compareTo(ActionCreateProbeCapture that) {
        return this.compareTo(that, "captureName", "serviceType", "serviceName", "captureCount", "interval", "sendTIDInResponseHeader", "encryptionAlgorithm", "encryptionCertificate", "logLevel", "filterByRequiredHeader", "filterByAPI", "filterByAPICatalog", "filterByIP", "filterByPath", "filterByAPIClientID");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.captureName, this.serviceType, this.serviceName, this.captureCount, this.interval, this.sendTIDInResponseHeader, this.encryptionAlgorithm, this.encryptionCertificate, this.logLevel, this.filterByRequiredHeader, this.filterByAPI, this.filterByAPICatalog, this.filterByIP, this.filterByPath, this.filterByAPIClientID);
    }

    public boolean equals(Object that) {
        return this.equals(that, "captureName", "serviceType", "serviceName", "captureCount", "interval", "sendTIDInResponseHeader", "encryptionAlgorithm", "encryptionCertificate", "logLevel", "filterByRequiredHeader", "filterByAPI", "filterByAPICatalog", "filterByIP", "filterByPath", "filterByAPIClientID");
    }

    @Override
    public String toString() {
        return this.toString("captureName", "serviceType", "serviceName", "captureCount", "interval", "sendTIDInResponseHeader", "encryptionAlgorithm", "encryptionCertificate", "logLevel", "filterByRequiredHeader", "filterByAPI", "filterByAPICatalog", "filterByIP", "filterByPath", "filterByAPIClientID");
    }
}

