/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.actions;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ActionSecureBackup
extends DataPowerAction {
    private ObjectReference<ConfigCryptoCertificate> cert;
    private String destination;
    private String includeIscsi;
    private String includeRaid;

    @XMLInfo(elementType="element", elementName="cert", elementOrder=0, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="CryptoCertificate", isEnumeration=false, javaName="cert", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoCertificate> getCert() {
        return this.cert;
    }

    @XMLInfo(elementType="element", elementName="cert", elementOrder=0, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="CryptoCertificate", isEnumeration=false, javaName="cert", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCert(ObjectReference<ConfigCryptoCertificate> cert) {
        this.cert = cert;
    }

    @XMLInfo(elementType="element", elementName="destination", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="destination", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(temporary|local):/{2,3}|^ftp://[^/]+(/[^/]+)*$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Destination", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDestination() {
        return this.destination;
    }

    @XMLInfo(elementType="element", elementName="destination", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="destination", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(temporary|local):/{2,3}|^ftp://[^/]+(/[^/]+)*$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Destination", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDestination(String destination) {
        if (destination != null && destination.matches("^(temporary|local):/{2,3}|^ftp://[^/]+(/[^/]+)*$")) {
            this.destination = destination;
        }
    }

    @XMLInfo(elementType="element", elementName="include-iscsi", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="includeIscsi", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Include iSCSI", units="", label="", multiplicity=1, status="obsolete", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getIncludeIscsi() {
        return this.includeIscsi;
    }

    @XMLInfo(elementType="element", elementName="include-iscsi", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="includeIscsi", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Include iSCSI", units="", label="", multiplicity=1, status="obsolete", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIncludeIscsi(String includeIscsi) {
        if (includeIscsi == null || Comparison.isIn(includeIscsi, DPEnumerations.TOGGLE)) {
            this.includeIscsi = includeIscsi;
        }
    }

    @XMLInfo(elementType="element", elementName="include-raid", elementOrder=3, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="includeRaid", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Include RAID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getIncludeRaid() {
        return this.includeRaid;
    }

    @XMLInfo(elementType="element", elementName="include-raid", elementOrder=3, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="includeRaid", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Include RAID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIncludeRaid(String includeRaid) {
        if (includeRaid == null || Comparison.isIn(includeRaid, DPEnumerations.TOGGLE)) {
            this.includeRaid = includeRaid;
        }
    }

    public int compareTo(ActionSecureBackup that) {
        return this.compareTo(that, "cert", "destination", "includeIscsi", "includeRaid");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cert, this.destination, this.includeIscsi, this.includeRaid);
    }

    public boolean equals(Object that) {
        return this.equals(that, "cert", "destination", "includeIscsi", "includeRaid");
    }

    @Override
    public String toString() {
        return this.toString("cert", "destination", "includeIscsi", "includeRaid");
    }
}

