/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.actions;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCryptoIdentCred;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ActionSecureRestore
extends DataPowerAction {
    private ObjectReference<ConfigCryptoIdentCred> cred;
    private String source;
    private String validate;
    private String backupMachineType;

    @XMLInfo(elementType="element", elementName="cred", elementOrder=0, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="CryptoIdentCred", isEnumeration=false, javaName="cred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoIdentCred> getCred() {
        return this.cred;
    }

    @XMLInfo(elementType="element", elementName="cred", elementOrder=0, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="CryptoIdentCred", isEnumeration=false, javaName="cred", javaType="ObjectReference<ConfigCryptoIdentCred>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Identification credentials", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCred(ObjectReference<ConfigCryptoIdentCred> cred) {
        this.cred = cred;
    }

    @XMLInfo(elementType="element", elementName="source", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="source", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(temporary|local):/{2,3}|^ftp://[^/]+(/[^/]+)*$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Source", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSource() {
        return this.source;
    }

    @XMLInfo(elementType="element", elementName="source", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="source", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(temporary|local):/{2,3}|^ftp://[^/]+(/[^/]+)*$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Source", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSource(String source) {
        if (source != null && source.matches("^(temporary|local):/{2,3}|^ftp://[^/]+(/[^/]+)*$")) {
            this.source = source;
        }
    }

    @XMLInfo(elementType="element", elementName="validate", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="validate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Only validate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getValidate() {
        return this.validate;
    }

    @XMLInfo(elementType="element", elementName="validate", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="validate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Only validate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setValidate(String validate) {
        if (validate == null || Comparison.isIn(validate, DPEnumerations.TOGGLE)) {
            this.validate = validate;
        }
    }

    @XMLInfo(elementType="element", elementName="BackupMachineType", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="backupMachineType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex=" *5725T09|719832X|7199(4|6)2X|84365(2|3)X|84415(2|3)X|84965(2|3)X *", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Backup model", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getBackupMachineType() {
        return this.backupMachineType;
    }

    @XMLInfo(elementType="element", elementName="BackupMachineType", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="backupMachineType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex=" *5725T09|719832X|7199(4|6)2X|84365(2|3)X|84415(2|3)X|84965(2|3)X *", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Backup model", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBackupMachineType(String backupMachineType) {
        this.backupMachineType = backupMachineType;
    }

    public int compareTo(ActionSecureRestore that) {
        return this.compareTo(that, "cred", "source", "validate", "backupMachineType");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.cred, this.source, this.validate, this.backupMachineType);
    }

    public boolean equals(Object that) {
        return this.equals(that, "cred", "source", "validate", "backupMachineType");
    }

    @Override
    public String toString() {
        return this.toString("cred", "source", "validate", "backupMachineType");
    }
}

