/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.actions;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.DataPowerAction;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAPICollection;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ActionUpdateAPISubscription
extends DataPowerAction {
    private ObjectReference<ConfigAPICollection> aPICollection;
    private String appID;
    private String plans;
    private String status;

    @XMLInfo(elementType="element", elementName="APICollection", elementOrder=0, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="APICollection", isEnumeration=false, javaName="aPICollection", javaType="ObjectReference<ConfigAPICollection>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="API collection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAPICollection> getAPICollection() {
        return this.aPICollection;
    }

    @XMLInfo(elementType="element", elementName="APICollection", elementOrder=0, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="APICollection", isEnumeration=false, javaName="aPICollection", javaType="ObjectReference<ConfigAPICollection>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="API collection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICollection(ObjectReference<ConfigAPICollection> aPICollection) {
        this.aPICollection = aPICollection;
    }

    @XMLInfo(elementType="element", elementName="AppID", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="appID", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[0-9a-z-]{1,36}$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Application ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAppID() {
        return this.appID;
    }

    @XMLInfo(elementType="element", elementName="AppID", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="appID", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[0-9a-z-]{1,36}$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Application ID", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAppID(String appID) {
        if (appID != null && appID.matches("^[0-9a-z-]{1,36}$")) {
            this.appID = appID;
        }
    }

    @XMLInfo(elementType="element", elementName="Plans", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="plans", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[a-zA-Z0-9_\\-.]+(,[a-zA-Z0-9_\\-.]+)*$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Plans", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPlans() {
        return this.plans;
    }

    @XMLInfo(elementType="element", elementName="Plans", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="plans", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[a-zA-Z0-9_\\-.]+(,[a-zA-Z0-9_\\-.]+)*$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Plans", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPlans(String plans) {
        if (plans != null && plans.matches("^[a-zA-Z0-9_\\-.]+(,[a-zA-Z0-9_\\-.]+)*$")) {
            this.plans = plans;
        }
    }

    @XMLInfo(elementType="element", elementName="Status", elementOrder=3, dataPowerType="dmPlanStatus", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="status", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Status", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStatus() {
        return this.status;
    }

    @XMLInfo(elementType="element", elementName="Status", elementOrder=3, dataPowerType="dmPlanStatus", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="status", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Status", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStatus(String status) {
        if (status == null || Comparison.isIn(status, DPEnumerations.PLAN_STATUS)) {
            this.status = status;
        }
    }

    public int compareTo(ActionUpdateAPISubscription that) {
        return this.compareTo(that, "aPICollection", "appID", "plans", "status");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.aPICollection, this.appID, this.plans, this.status);
    }

    public boolean equals(Object that) {
        return this.equals(that, "aPICollection", "appID", "plans", "status");
    }

    @Override
    public String toString() {
        return this.toString("aPICollection", "appID", "plans", "status");
    }
}

