/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAAAPolicy;
import com.kumbasoft.core.beans.config.ConfigAccessControlList;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.config.ConfigSSLSNIServerProfile;
import com.kumbasoft.core.beans.config.ConfigSSLServerProfile;
import com.kumbasoft.core.beans.config.ConfigSourceProtocolHandler;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.SourceHTTPFeatureType;
import java.util.Objects;

public class ConfigAS2SourceProtocolHandler
extends ConfigSourceProtocolHandler {
    private String userSummary;
    private String localAddress;
    private int localPort;
    private String hTTPVersion;
    private SourceHTTPFeatureType allowedFeatures;
    private String persistentConnections;
    private String allowCompression;
    private long maxURLLen;
    private long maxTotalHdrLen;
    private int maxHdrCount;
    private int maxNameHdrLen;
    private int maxValueHdrLen;
    private int maxQueryStringLen;
    private ObjectReference<ConfigSSLProxyProfile> sSLProxy;
    private ObjectReference<ConfigAccessControlList> aCL;
    private ObjectReference<ConfigAAAPolicy> aAAPolicy;
    private String credentialCharset;
    private String sSLServerConfigType;
    private ObjectReference<ConfigSSLServerProfile> sSLServer;
    private ObjectReference<ConfigSSLSNIServerProfile> sSLSNIServer;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=2, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="local-address", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0.0.0.0", displayOrder=0, displayValue="Local IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLocalAddress() {
        return this.localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalAddress", elementOrder=2, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="local-address", refType="", isEnumeration=false, javaName="localAddress", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0.0.0.0", displayValue="Local IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalAddress(String localAddress) {
        this.localAddress = localAddress;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="80", displayOrder=0, displayValue="Local port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLocalPort() {
        return this.localPort;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=3, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="80", displayValue="Local port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @XMLInfo(elementType="element", elementName="HTTPVersion", elementOrder=4, dataPowerType="dmHTTPVersion", subType="", benign=false, isPassword=false, cliAlias="http-client-version", refType="", isEnumeration=true, javaName="hTTPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="HTTP/1.1", displayOrder=0, displayValue="HTTP version to client", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHTTPVersion() {
        return this.hTTPVersion;
    }

    @XMLInfo(elementType="element", elementName="HTTPVersion", elementOrder=4, dataPowerType="dmHTTPVersion", subType="", benign=false, isPassword=false, cliAlias="http-client-version", refType="", isEnumeration=true, javaName="hTTPVersion", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="HTTP/1.1", displayValue="HTTP version to client", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHTTPVersion(String hTTPVersion) {
        if (hTTPVersion == null || Comparison.isIn(hTTPVersion, DPEnumerations.HTTPVERSION)) {
            this.hTTPVersion = hTTPVersion;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowedFeatures", elementOrder=5, dataPowerType="dmSourceHTTPFeatureType", subType="", benign=false, isPassword=false, cliAlias="allowed-features", refType="", isEnumeration=false, javaName="allowedFeatures", javaType="SourceHTTPFeatureType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0x0617", displayOrder=0, displayValue="Allowed methods and versions", units="", label="", multiplicity=1, status="obsolete", isDeprecated=true, deprecatedIn="3.8.1.0", isObsolete=true, obsoletedIn="3.8.1.0")
    public SourceHTTPFeatureType getAllowedFeatures() {
        return this.allowedFeatures;
    }

    @XMLInfo(elementType="element", elementName="AllowedFeatures", elementOrder=5, dataPowerType="dmSourceHTTPFeatureType", subType="", benign=false, isPassword=false, cliAlias="allowed-features", refType="", isEnumeration=false, javaName="allowedFeatures", javaType="SourceHTTPFeatureType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0x0617", displayValue="Allowed methods and versions", units="", label="", multiplicity=1, status="obsolete", isDeprecated=true, deprecatedIn="3.8.1.0", isObsolete=true, obsoletedIn="3.8.1.0")
    public void setAllowedFeatures(SourceHTTPFeatureType allowedFeatures) {
        this.allowedFeatures = allowedFeatures;
    }

    @XMLInfo(elementType="element", elementName="PersistentConnections", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="persistent-connections", refType="", isEnumeration=true, javaName="persistentConnections", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Persistent connections", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPersistentConnections() {
        return this.persistentConnections;
    }

    @XMLInfo(elementType="element", elementName="PersistentConnections", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="persistent-connections", refType="", isEnumeration=true, javaName="persistentConnections", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Persistent connections", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPersistentConnections(String persistentConnections) {
        if (persistentConnections == null || Comparison.isIn(persistentConnections, DPEnumerations.TOGGLE)) {
            this.persistentConnections = persistentConnections;
        }
    }

    @XMLInfo(elementType="element", elementName="AllowCompression", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="compression", refType="", isEnumeration=true, javaName="allowCompression", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Compression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAllowCompression() {
        return this.allowCompression;
    }

    @XMLInfo(elementType="element", elementName="AllowCompression", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="compression", refType="", isEnumeration=true, javaName="allowCompression", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Compression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAllowCompression(String allowCompression) {
        if (allowCompression == null || Comparison.isIn(allowCompression, DPEnumerations.TOGGLE)) {
            this.allowCompression = allowCompression;
        }
    }

    @XMLInfo(elementType="element", elementName="MaxURLLen", elementOrder=8, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-url-len", refType="", isEnumeration=false, javaName="maxURLLen", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=128000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="16384", displayOrder=0, displayValue="Max URL length", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxURLLen() {
        return this.maxURLLen;
    }

    @XMLInfo(elementType="element", elementName="MaxURLLen", elementOrder=8, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-url-len", refType="", isEnumeration=false, javaName="maxURLLen", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=128000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="16384", displayValue="Max URL length", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxURLLen(long maxURLLen) {
        this.maxURLLen = maxURLLen;
    }

    @XMLInfo(elementType="element", elementName="MaxTotalHdrLen", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-total-header-len", refType="", isEnumeration=false, javaName="maxTotalHdrLen", javaType="long", isRequired=false, squelchNull=false, minimum=5, maximum=128000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="128000", displayOrder=0, displayValue="Max total header length", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxTotalHdrLen() {
        return this.maxTotalHdrLen;
    }

    @XMLInfo(elementType="element", elementName="MaxTotalHdrLen", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-total-header-len", refType="", isEnumeration=false, javaName="maxTotalHdrLen", javaType="long", isRequired=false, squelchNull=false, minimum=5, maximum=128000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="128000", displayValue="Max total header length", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxTotalHdrLen(long maxTotalHdrLen) {
        this.maxTotalHdrLen = maxTotalHdrLen;
    }

    @XMLInfo(elementType="element", elementName="MaxHdrCount", elementOrder=10, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-header-count", refType="", isEnumeration=false, javaName="maxHdrCount", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Max request headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMaxHdrCount() {
        return this.maxHdrCount;
    }

    @XMLInfo(elementType="element", elementName="MaxHdrCount", elementOrder=10, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-header-count", refType="", isEnumeration=false, javaName="maxHdrCount", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Max request headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxHdrCount(int maxHdrCount) {
        this.maxHdrCount = maxHdrCount;
    }

    @XMLInfo(elementType="element", elementName="MaxNameHdrLen", elementOrder=11, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-header-name-len", refType="", isEnumeration=false, javaName="maxNameHdrLen", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Max length of header name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMaxNameHdrLen() {
        return this.maxNameHdrLen;
    }

    @XMLInfo(elementType="element", elementName="MaxNameHdrLen", elementOrder=11, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-header-name-len", refType="", isEnumeration=false, javaName="maxNameHdrLen", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Max length of header name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxNameHdrLen(int maxNameHdrLen) {
        this.maxNameHdrLen = maxNameHdrLen;
    }

    @XMLInfo(elementType="element", elementName="MaxValueHdrLen", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-header-value-len", refType="", isEnumeration=false, javaName="maxValueHdrLen", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Max length of header value", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMaxValueHdrLen() {
        return this.maxValueHdrLen;
    }

    @XMLInfo(elementType="element", elementName="MaxValueHdrLen", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-header-value-len", refType="", isEnumeration=false, javaName="maxValueHdrLen", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Max length of header value", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxValueHdrLen(int maxValueHdrLen) {
        this.maxValueHdrLen = maxValueHdrLen;
    }

    @XMLInfo(elementType="element", elementName="MaxQueryStringLen", elementOrder=13, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-querystring-len", refType="", isEnumeration=false, javaName="maxQueryStringLen", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Max length of query string", units="", label="", multiplicity=1, status="obsolete", isDeprecated=true, deprecatedIn="3.8.1.0", isObsolete=true, obsoletedIn="3.8.1.0")
    public int getMaxQueryStringLen() {
        return this.maxQueryStringLen;
    }

    @XMLInfo(elementType="element", elementName="MaxQueryStringLen", elementOrder=13, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-querystring-len", refType="", isEnumeration=false, javaName="maxQueryStringLen", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Max length of query string", units="", label="", multiplicity=1, status="obsolete", isDeprecated=true, deprecatedIn="3.8.1.0", isObsolete=true, obsoletedIn="3.8.1.0")
    public void setMaxQueryStringLen(int maxQueryStringLen) {
        this.maxQueryStringLen = maxQueryStringLen;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=14, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getSSLProxy() {
        return this.sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=14, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLProxy(ObjectReference<ConfigSSLProxyProfile> sSLProxy) {
        this.sSLProxy = sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Access control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAccessControlList> getACL() {
        return this.aCL;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Access control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setACL(ObjectReference<ConfigAccessControlList> aCL) {
        this.aCL = aCL;
    }

    @XMLInfo(elementType="element", elementName="AAAPolicy", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="aaa-policy", refType="AAAPolicy", isEnumeration=false, javaName="aAAPolicy", javaType="ObjectReference<ConfigAAAPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="AAA policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAAAPolicy> getAAAPolicy() {
        return this.aAAPolicy;
    }

    @XMLInfo(elementType="element", elementName="AAAPolicy", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="aaa-policy", refType="AAAPolicy", isEnumeration=false, javaName="aAAPolicy", javaType="ObjectReference<ConfigAAAPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="AAA policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAAAPolicy(ObjectReference<ConfigAAAPolicy> aAAPolicy) {
        this.aAAPolicy = aAAPolicy;
    }

    @XMLInfo(elementType="element", elementName="CredentialCharset", elementOrder=17, dataPowerType="dmCredentialCharset", subType="", benign=false, isPassword=false, cliAlias="credential-charset", refType="", isEnumeration=true, javaName="credentialCharset", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="protocol", displayOrder=0, displayValue="Credential character set", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCredentialCharset() {
        return this.credentialCharset;
    }

    @XMLInfo(elementType="element", elementName="CredentialCharset", elementOrder=17, dataPowerType="dmCredentialCharset", subType="", benign=false, isPassword=false, cliAlias="credential-charset", refType="", isEnumeration=true, javaName="credentialCharset", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="protocol", displayValue="Credential character set", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCredentialCharset(String credentialCharset) {
        if (credentialCharset == null || Comparison.isIn(credentialCharset, DPEnumerations.CREDENTIAL_CHARSET)) {
            this.credentialCharset = credentialCharset;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLServerConfigType", elementOrder=18, dataPowerType="dmSSLConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-config-type", refType="", isEnumeration=true, javaName="sSLServerConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="proxy", displayOrder=0, displayValue="TLS server type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLServerConfigType() {
        return this.sSLServerConfigType;
    }

    @XMLInfo(elementType="element", elementName="SSLServerConfigType", elementOrder=18, dataPowerType="dmSSLConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-config-type", refType="", isEnumeration=true, javaName="sSLServerConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="proxy", displayValue="TLS server type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLServerConfigType(String sSLServerConfigType) {
        if (sSLServerConfigType == null || Comparison.isIn(sSLServerConfigType, DPEnumerations.SSLCONFIG_TYPE)) {
            this.sSLServerConfigType = sSLServerConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=19, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-server", refType="SSLServerProfile", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference<ConfigSSLServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLServerProfile> getSSLServer() {
        return this.sSLServer;
    }

    @XMLInfo(elementType="element", elementName="SSLServer", elementOrder=19, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-server", refType="SSLServerProfile", isEnumeration=false, javaName="sSLServer", javaType="ObjectReference<ConfigSSLServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLServer(ObjectReference<ConfigSSLServerProfile> sSLServer) {
        this.sSLServer = sSLServer;
    }

    @XMLInfo(elementType="element", elementName="SSLSNIServer", elementOrder=20, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-sni-server", refType="SSLSNIServerProfile", isEnumeration=false, javaName="sSLSNIServer", javaType="ObjectReference<ConfigSSLSNIServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS SNI server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLSNIServerProfile> getSSLSNIServer() {
        return this.sSLSNIServer;
    }

    @XMLInfo(elementType="element", elementName="SSLSNIServer", elementOrder=20, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-sni-server", refType="SSLSNIServerProfile", isEnumeration=false, javaName="sSLSNIServer", javaType="ObjectReference<ConfigSSLSNIServerProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS SNI server profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLSNIServer(ObjectReference<ConfigSSLSNIServerProfile> sSLSNIServer) {
        this.sSLSNIServer = sSLSNIServer;
    }

    @Override
    public int compareTo(ConfigAS2SourceProtocolHandler that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "localAddress", "localPort", "hTTPVersion", "allowedFeatures", "persistentConnections", "allowCompression", "maxURLLen", "maxTotalHdrLen", "maxHdrCount", "maxNameHdrLen", "maxValueHdrLen", "maxQueryStringLen", "sSLProxy", "aCL", "aAAPolicy", "credentialCharset", "sSLServerConfigType", "sSLServer", "sSLSNIServer");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.localAddress, this.localPort, this.hTTPVersion, this.allowedFeatures, this.persistentConnections, this.allowCompression, this.maxURLLen, this.maxTotalHdrLen, this.maxHdrCount, this.maxNameHdrLen, this.maxValueHdrLen, this.maxQueryStringLen, this.sSLProxy, this.aCL, this.aAAPolicy, this.credentialCharset, this.sSLServerConfigType, this.sSLServer, this.sSLSNIServer);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "localAddress", "localPort", "hTTPVersion", "allowedFeatures", "persistentConnections", "allowCompression", "maxURLLen", "maxTotalHdrLen", "maxHdrCount", "maxNameHdrLen", "maxValueHdrLen", "maxQueryStringLen", "sSLProxy", "aCL", "aAAPolicy", "credentialCharset", "sSLServerConfigType", "sSLServer", "sSLSNIServer");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "localAddress", "localPort", "hTTPVersion", "allowedFeatures", "persistentConnections", "allowCompression", "maxURLLen", "maxTotalHdrLen", "maxHdrCount", "maxNameHdrLen", "maxValueHdrLen", "maxQueryStringLen", "sSLProxy", "aCL", "aAAPolicy", "credentialCharset", "sSLServerConfigType", "sSLServer", "sSLSNIServer"));
    }
}

