/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAssembly;
import com.kumbasoft.core.beans.config.ConfigAssemblyAction;
import com.kumbasoft.core.beans.config.ConfigControlList;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigAssemblyActionWebSocketUpgrade
extends ConfigAssemblyAction {
    private String url;
    private String sSLClient;
    private long timeout;
    private String userName;
    private ObjectReference<ConfigPasswordAlias> password;
    private String followRedirects;
    private String decodeRequestParams;
    private String encodePlusChar;
    private String injectUserAgentHeader;
    private String injectProxyHeaders;
    private ObjectReference<ConfigControlList> headerControlList;
    private ObjectReference<ConfigControlList> parameterControlList;
    private ObjectReference<ConfigAssembly> aPIRequestProcessingAssembly;
    private ObjectReference<ConfigAssembly> aPIResponseProcessingAssembly;

    @XMLInfo(elementType="element", elementName="Url", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="url", refType="", isEnumeration=false, javaName="url", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUrl() {
        return this.url;
    }

    @XMLInfo(elementType="element", elementName="Url", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="url", refType="", isEnumeration=false, javaName="url", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUrl(String url) {
        this.url = url;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=6, dataPowerType="dmString", subType="dmReference", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=6, dataPowerType="dmString", subType="dmReference", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(String sSLClient) {
        this.sSLClient = sSLClient;
    }

    @XMLInfo(elementType="element", elementName="Timeout", elementOrder=7, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="timeout", refType="", isEnumeration=false, javaName="timeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="60", displayOrder=0, displayValue="Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getTimeout() {
        return this.timeout;
    }

    @XMLInfo(elementType="element", elementName="Timeout", elementOrder=7, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="timeout", refType="", isEnumeration=false, javaName="timeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="60", displayValue="Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^ ]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="User name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserName() {
        return this.userName;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^ ]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="User name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserName(String userName) {
        if (userName != null && userName.matches("^[^ ]+$")) {
            this.userName = userName;
        }
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password", refType="PasswordAlias", isEnumeration=false, javaName="password", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getPassword() {
        return this.password;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password", refType="PasswordAlias", isEnumeration=false, javaName="password", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPassword(ObjectReference<ConfigPasswordAlias> password) {
        this.password = password;
    }

    @XMLInfo(elementType="element", elementName="FollowRedirects", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="follow-redirects", refType="", isEnumeration=true, javaName="followRedirects", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Follow redirects", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getFollowRedirects() {
        return this.followRedirects;
    }

    @XMLInfo(elementType="element", elementName="FollowRedirects", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="follow-redirects", refType="", isEnumeration=true, javaName="followRedirects", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Follow redirects", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFollowRedirects(String followRedirects) {
        if (followRedirects == null || Comparison.isIn(followRedirects, DPEnumerations.TOGGLE)) {
            this.followRedirects = followRedirects;
        }
    }

    @XMLInfo(elementType="element", elementName="DecodeRequestParams", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="decode-request-params", refType="", isEnumeration=true, javaName="decodeRequestParams", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Decode request parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDecodeRequestParams() {
        return this.decodeRequestParams;
    }

    @XMLInfo(elementType="element", elementName="DecodeRequestParams", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="decode-request-params", refType="", isEnumeration=true, javaName="decodeRequestParams", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Decode request parameters", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDecodeRequestParams(String decodeRequestParams) {
        if (decodeRequestParams == null || Comparison.isIn(decodeRequestParams, DPEnumerations.TOGGLE)) {
            this.decodeRequestParams = decodeRequestParams;
        }
    }

    @XMLInfo(elementType="element", elementName="EncodePlusChar", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="encode-plus-char", refType="", isEnumeration=true, javaName="encodePlusChar", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Encode + characters in query", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncodePlusChar() {
        return this.encodePlusChar;
    }

    @XMLInfo(elementType="element", elementName="EncodePlusChar", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="encode-plus-char", refType="", isEnumeration=true, javaName="encodePlusChar", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Encode + characters in query", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncodePlusChar(String encodePlusChar) {
        if (encodePlusChar == null || Comparison.isIn(encodePlusChar, DPEnumerations.TOGGLE)) {
            this.encodePlusChar = encodePlusChar;
        }
    }

    @XMLInfo(elementType="element", elementName="InjectUserAgentHeader", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="inject-user-agent", refType="", isEnumeration=true, javaName="injectUserAgentHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Inject User-Agent header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getInjectUserAgentHeader() {
        return this.injectUserAgentHeader;
    }

    @XMLInfo(elementType="element", elementName="InjectUserAgentHeader", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="inject-user-agent", refType="", isEnumeration=true, javaName="injectUserAgentHeader", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Inject User-Agent header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setInjectUserAgentHeader(String injectUserAgentHeader) {
        if (injectUserAgentHeader == null || Comparison.isIn(injectUserAgentHeader, DPEnumerations.TOGGLE)) {
            this.injectUserAgentHeader = injectUserAgentHeader;
        }
    }

    @XMLInfo(elementType="element", elementName="InjectProxyHeaders", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="inject-proxy-headers", refType="", isEnumeration=true, javaName="injectProxyHeaders", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Inject proxy headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getInjectProxyHeaders() {
        return this.injectProxyHeaders;
    }

    @XMLInfo(elementType="element", elementName="InjectProxyHeaders", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="inject-proxy-headers", refType="", isEnumeration=true, javaName="injectProxyHeaders", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Inject proxy headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setInjectProxyHeaders(String injectProxyHeaders) {
        if (injectProxyHeaders == null || Comparison.isIn(injectProxyHeaders, DPEnumerations.TOGGLE)) {
            this.injectProxyHeaders = injectProxyHeaders;
        }
    }

    @XMLInfo(elementType="element", elementName="HeaderControlList", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="header-control-list", refType="ControlList", isEnumeration=false, javaName="headerControlList", javaType="ObjectReference<ConfigControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default-accept-all", displayOrder=0, displayValue="Header control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigControlList> getHeaderControlList() {
        return this.headerControlList;
    }

    @XMLInfo(elementType="element", elementName="HeaderControlList", elementOrder=15, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="header-control-list", refType="ControlList", isEnumeration=false, javaName="headerControlList", javaType="ObjectReference<ConfigControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default-accept-all", displayValue="Header control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHeaderControlList(ObjectReference<ConfigControlList> headerControlList) {
        this.headerControlList = headerControlList;
    }

    @XMLInfo(elementType="element", elementName="ParameterControlList", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="parameter-control-list", refType="ControlList", isEnumeration=false, javaName="parameterControlList", javaType="ObjectReference<ConfigControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default-reject-all", displayOrder=0, displayValue="Parameter control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigControlList> getParameterControlList() {
        return this.parameterControlList;
    }

    @XMLInfo(elementType="element", elementName="ParameterControlList", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="parameter-control-list", refType="ControlList", isEnumeration=false, javaName="parameterControlList", javaType="ObjectReference<ConfigControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default-reject-all", displayValue="Parameter control list", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setParameterControlList(ObjectReference<ConfigControlList> parameterControlList) {
        this.parameterControlList = parameterControlList;
    }

    @XMLInfo(elementType="element", elementName="APIRequestProcessingAssembly", elementOrder=17, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-processing-assembly", refType="Assembly", isEnumeration=false, javaName="aPIRequestProcessingAssembly", javaType="ObjectReference<ConfigAssembly>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="API request processing assembly", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAssembly> getAPIRequestProcessingAssembly() {
        return this.aPIRequestProcessingAssembly;
    }

    @XMLInfo(elementType="element", elementName="APIRequestProcessingAssembly", elementOrder=17, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="request-processing-assembly", refType="Assembly", isEnumeration=false, javaName="aPIRequestProcessingAssembly", javaType="ObjectReference<ConfigAssembly>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="API request processing assembly", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPIRequestProcessingAssembly(ObjectReference<ConfigAssembly> aPIRequestProcessingAssembly) {
        this.aPIRequestProcessingAssembly = aPIRequestProcessingAssembly;
    }

    @XMLInfo(elementType="element", elementName="APIResponseProcessingAssembly", elementOrder=18, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="response-processing-assembly", refType="Assembly", isEnumeration=false, javaName="aPIResponseProcessingAssembly", javaType="ObjectReference<ConfigAssembly>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="API response processing assembly", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAssembly> getAPIResponseProcessingAssembly() {
        return this.aPIResponseProcessingAssembly;
    }

    @XMLInfo(elementType="element", elementName="APIResponseProcessingAssembly", elementOrder=18, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="response-processing-assembly", refType="Assembly", isEnumeration=false, javaName="aPIResponseProcessingAssembly", javaType="ObjectReference<ConfigAssembly>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="API response processing assembly", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPIResponseProcessingAssembly(ObjectReference<ConfigAssembly> aPIResponseProcessingAssembly) {
        this.aPIResponseProcessingAssembly = aPIResponseProcessingAssembly;
    }

    @Override
    public int compareTo(ConfigAssemblyActionWebSocketUpgrade that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "url", "sSLClient", "timeout", "userName", "password", "followRedirects", "decodeRequestParams", "encodePlusChar", "injectUserAgentHeader", "injectProxyHeaders", "headerControlList", "parameterControlList", "aPIRequestProcessingAssembly", "aPIResponseProcessingAssembly");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.url, this.sSLClient, this.timeout, this.userName, this.password, this.followRedirects, this.decodeRequestParams, this.encodePlusChar, this.injectUserAgentHeader, this.injectProxyHeaders, this.headerControlList, this.parameterControlList, this.aPIRequestProcessingAssembly, this.aPIResponseProcessingAssembly);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "url", "sSLClient", "timeout", "userName", "password", "followRedirects", "decodeRequestParams", "encodePlusChar", "injectUserAgentHeader", "injectProxyHeaders", "headerControlList", "parameterControlList", "aPIRequestProcessingAssembly", "aPIResponseProcessingAssembly");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("url", "sSLClient", "timeout", "userName", "password", "followRedirects", "decodeRequestParams", "encodePlusChar", "injectUserAgentHeader", "injectProxyHeaders", "headerControlList", "parameterControlList", "aPIRequestProcessingAssembly", "aPIResponseProcessingAssembly"));
    }
}

