/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigB2BXPathRoutingPolicy;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigSMTPServerConnection;
import com.kumbasoft.core.beans.config.ConfigSQLDataSource;
import com.kumbasoft.core.beans.config.ConfigXMLManager;
import com.kumbasoft.core.beans.types.ASFrontProtocol;
import com.kumbasoft.core.beans.types.B2BActiveGroup;
import com.kumbasoft.core.beans.types.B2BActiveProfile;
import com.kumbasoft.core.beans.types.B2BBackupMsgType;
import com.kumbasoft.core.beans.types.B2BCPAEntry;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigB2BGateway
extends ConfigConfigBase {
    private String userSummary;
    private String priority;
    private String docStoreLocation;
    private ArrayList<ASFrontProtocol> aSFrontProtocol;
    private String aS1MDNEmail;
    private ObjectReference<ConfigSMTPServerConnection> aS1MDNSMTPServerConnection;
    private String aS2MDNURL;
    private String aS3MDNURL;
    private ArrayList<B2BActiveProfile> b2BProfiles;
    private ArrayList<B2BActiveGroup> b2BGroups;
    private String documentRoutingPreprocessorType;
    private String documentRoutingPreprocessor;
    private String documentRoutingPreprocessorDebug;
    private String archiveMode;
    private String archiveLocation;
    private String archiveFileName;
    private long archiveMinimumSize;
    private int archiveDocumentAge;
    private int archiveMinimumDocuments;
    private int diskUseCheckInterval;
    private long maxDocumentDiskUse;
    private String archiveMonitor;
    private int shapingThreshold;
    private B2BBackupMsgType archiveBackupDocuments;
    private ArrayList<ObjectReference<ConfigB2BXPathRoutingPolicy>> xPathRoutingPolicies;
    private ObjectReference<ConfigXMLManager> xMLManager;
    private String debugMode;
    private long debugHistory;
    private ArrayList<B2BCPAEntry> cPAEntries;
    private ObjectReference<ConfigSQLDataSource> sQLDataSource;
    private long frontSideTimeout;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=2, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="normal", displayOrder=0, displayValue="Service priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPriority() {
        return this.priority;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=2, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="normal", displayValue="Service priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPriority(String priority) {
        if (priority == null || Comparison.isIn(priority, DPEnumerations.SCHEDULER_PRIORITY)) {
            this.priority = priority;
        }
    }

    @XMLInfo(elementType="element", elementName="DocStoreLocation", elementOrder=3, dataPowerType="dmFSDirectory", subType="", benign=false, isPassword=false, cliAlias="doc-location", refType="", isEnumeration=false, javaName="docStoreLocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="(default)", displayOrder=0, displayValue="Document storage location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDocStoreLocation() {
        return this.docStoreLocation;
    }

    @XMLInfo(elementType="element", elementName="DocStoreLocation", elementOrder=3, dataPowerType="dmFSDirectory", subType="", benign=false, isPassword=false, cliAlias="doc-location", refType="", isEnumeration=false, javaName="docStoreLocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="(default)", displayValue="Document storage location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocStoreLocation(String docStoreLocation) {
        this.docStoreLocation = docStoreLocation;
    }

    public void addASFrontProtocol(ASFrontProtocol element) {
        if (element == null) {
            return;
        }
        if (this.aSFrontProtocol == null) {
            this.aSFrontProtocol = new ArrayList();
        }
        this.aSFrontProtocol.add(element);
    }

    public boolean removeASFrontProtocol(ASFrontProtocol element) {
        if (element == null || this.aSFrontProtocol == null) {
            return false;
        }
        return this.aSFrontProtocol.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ASFrontProtocol", elementOrder=4, dataPowerType="dmASFrontProtocol", subType="", benign=false, isPassword=false, cliAlias="as-fsph", refType="", isEnumeration=false, javaName="aSFrontProtocol", javaType="ASFrontProtocol", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Protocol handlers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ASFrontProtocol> getASFrontProtocol() {
        return this.aSFrontProtocol;
    }

    @XMLInfo(elementType="element", elementName="ASFrontProtocol", elementOrder=4, dataPowerType="dmASFrontProtocol", subType="", benign=false, isPassword=false, cliAlias="as-fsph", refType="", isEnumeration=false, javaName="aSFrontProtocol", javaType="ASFrontProtocol", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Protocol handlers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setASFrontProtocol(ArrayList<ASFrontProtocol> aSFrontProtocol) {
        this.aSFrontProtocol = aSFrontProtocol;
    }

    @XMLInfo(elementType="element", elementName="AS1MDNEmail", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="as1-mdn-email", refType="", isEnumeration=false, javaName="aS1MDNEmail", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Default AS1 MDN return email", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAS1MDNEmail() {
        return this.aS1MDNEmail;
    }

    @XMLInfo(elementType="element", elementName="AS1MDNEmail", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="as1-mdn-email", refType="", isEnumeration=false, javaName="aS1MDNEmail", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Default AS1 MDN return email", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAS1MDNEmail(String aS1MDNEmail) {
        this.aS1MDNEmail = aS1MDNEmail;
    }

    @XMLInfo(elementType="element", elementName="AS1MDNSMTPServerConnection", elementOrder=6, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="as1-mdn-smtp-server-connection", refType="SMTPServerConnection", isEnumeration=false, javaName="aS1MDNSMTPServerConnection", javaType="ObjectReference<ConfigSMTPServerConnection>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="AS1 MDN SMTP server connection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSMTPServerConnection> getAS1MDNSMTPServerConnection() {
        return this.aS1MDNSMTPServerConnection;
    }

    @XMLInfo(elementType="element", elementName="AS1MDNSMTPServerConnection", elementOrder=6, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="as1-mdn-smtp-server-connection", refType="SMTPServerConnection", isEnumeration=false, javaName="aS1MDNSMTPServerConnection", javaType="ObjectReference<ConfigSMTPServerConnection>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="AS1 MDN SMTP server connection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAS1MDNSMTPServerConnection(ObjectReference<ConfigSMTPServerConnection> aS1MDNSMTPServerConnection) {
        this.aS1MDNSMTPServerConnection = aS1MDNSMTPServerConnection;
    }

    @XMLInfo(elementType="element", elementName="AS2MDNURL", elementOrder=7, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="as2-mdn-url", refType="", isEnumeration=false, javaName="aS2MDNURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Default AS2 MDN Return URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAS2MDNURL() {
        return this.aS2MDNURL;
    }

    @XMLInfo(elementType="element", elementName="AS2MDNURL", elementOrder=7, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="as2-mdn-url", refType="", isEnumeration=false, javaName="aS2MDNURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Default AS2 MDN Return URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAS2MDNURL(String aS2MDNURL) {
        this.aS2MDNURL = aS2MDNURL;
    }

    @XMLInfo(elementType="element", elementName="AS3MDNURL", elementOrder=8, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="as3-mdn-url", refType="", isEnumeration=false, javaName="aS3MDNURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Default AS3 MDN return URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAS3MDNURL() {
        return this.aS3MDNURL;
    }

    @XMLInfo(elementType="element", elementName="AS3MDNURL", elementOrder=8, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="as3-mdn-url", refType="", isEnumeration=false, javaName="aS3MDNURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Default AS3 MDN return URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAS3MDNURL(String aS3MDNURL) {
        this.aS3MDNURL = aS3MDNURL;
    }

    public void addB2BProfiles(B2BActiveProfile element) {
        if (element == null) {
            return;
        }
        if (this.b2BProfiles == null) {
            this.b2BProfiles = new ArrayList();
        }
        this.b2BProfiles.add(element);
    }

    public boolean removeB2BProfiles(B2BActiveProfile element) {
        if (element == null || this.b2BProfiles == null) {
            return false;
        }
        return this.b2BProfiles.remove(element);
    }

    @XMLInfo(elementType="element", elementName="B2BProfiles", elementOrder=9, dataPowerType="dmB2BActiveProfile", subType="", benign=false, isPassword=false, cliAlias="b2b-profile", refType="", isEnumeration=false, javaName="b2BProfiles", javaType="B2BActiveProfile", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Active partner profiles", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<B2BActiveProfile> getB2BProfiles() {
        return this.b2BProfiles;
    }

    @XMLInfo(elementType="element", elementName="B2BProfiles", elementOrder=9, dataPowerType="dmB2BActiveProfile", subType="", benign=false, isPassword=false, cliAlias="b2b-profile", refType="", isEnumeration=false, javaName="b2BProfiles", javaType="B2BActiveProfile", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Active partner profiles", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setB2BProfiles(ArrayList<B2BActiveProfile> b2BProfiles) {
        this.b2BProfiles = b2BProfiles;
    }

    public void addB2BGroups(B2BActiveGroup element) {
        if (element == null) {
            return;
        }
        if (this.b2BGroups == null) {
            this.b2BGroups = new ArrayList();
        }
        this.b2BGroups.add(element);
    }

    public boolean removeB2BGroups(B2BActiveGroup element) {
        if (element == null || this.b2BGroups == null) {
            return false;
        }
        return this.b2BGroups.remove(element);
    }

    @XMLInfo(elementType="element", elementName="B2BGroups", elementOrder=10, dataPowerType="dmB2BActiveGroup", subType="", benign=false, isPassword=false, cliAlias="b2b-group", refType="", isEnumeration=false, javaName="b2BGroups", javaType="B2BActiveGroup", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Active profile groups", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<B2BActiveGroup> getB2BGroups() {
        return this.b2BGroups;
    }

    @XMLInfo(elementType="element", elementName="B2BGroups", elementOrder=10, dataPowerType="dmB2BActiveGroup", subType="", benign=false, isPassword=false, cliAlias="b2b-group", refType="", isEnumeration=false, javaName="b2BGroups", javaType="B2BActiveGroup", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Active profile groups", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setB2BGroups(ArrayList<B2BActiveGroup> b2BGroups) {
        this.b2BGroups = b2BGroups;
    }

    @XMLInfo(elementType="element", elementName="DocumentRoutingPreprocessorType", elementOrder=11, dataPowerType="dmB2BDocumentRoutingPreprocessorType", subType="", benign=false, isPassword=false, cliAlias="document-routing-preprocessor-type", refType="", isEnumeration=true, javaName="documentRoutingPreprocessorType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="stylesheet", displayOrder=0, displayValue="Processor type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDocumentRoutingPreprocessorType() {
        return this.documentRoutingPreprocessorType;
    }

    @XMLInfo(elementType="element", elementName="DocumentRoutingPreprocessorType", elementOrder=11, dataPowerType="dmB2BDocumentRoutingPreprocessorType", subType="", benign=false, isPassword=false, cliAlias="document-routing-preprocessor-type", refType="", isEnumeration=true, javaName="documentRoutingPreprocessorType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="stylesheet", displayValue="Processor type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocumentRoutingPreprocessorType(String documentRoutingPreprocessorType) {
        if (documentRoutingPreprocessorType == null || Comparison.isIn(documentRoutingPreprocessorType, DPEnumerations.B2BDOCUMENT_ROUTING_PREPROCESSOR_TYPE)) {
            this.documentRoutingPreprocessorType = documentRoutingPreprocessorType;
        }
    }

    @XMLInfo(elementType="element", elementName="DocumentRoutingPreprocessor", elementOrder=12, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="document-routing-preprocessor", refType="", isEnumeration=false, javaName="documentRoutingPreprocessor", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="store:///b2b-routing.xsl", displayOrder=0, displayValue="File location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDocumentRoutingPreprocessor() {
        return this.documentRoutingPreprocessor;
    }

    @XMLInfo(elementType="element", elementName="DocumentRoutingPreprocessor", elementOrder=12, dataPowerType="dmURL", subType="dmURLProtocol", benign=false, isPassword=false, cliAlias="document-routing-preprocessor", refType="", isEnumeration=false, javaName="documentRoutingPreprocessor", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="store:///b2b-routing.xsl", displayValue="File location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocumentRoutingPreprocessor(String documentRoutingPreprocessor) {
        this.documentRoutingPreprocessor = documentRoutingPreprocessor;
    }

    @XMLInfo(elementType="element", elementName="DocumentRoutingPreprocessorDebug", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="document-routing-preprocessor-debug", refType="", isEnumeration=true, javaName="documentRoutingPreprocessorDebug", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable GatewayScript debugger", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDocumentRoutingPreprocessorDebug() {
        return this.documentRoutingPreprocessorDebug;
    }

    @XMLInfo(elementType="element", elementName="DocumentRoutingPreprocessorDebug", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="document-routing-preprocessor-debug", refType="", isEnumeration=true, javaName="documentRoutingPreprocessorDebug", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable GatewayScript debugger", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDocumentRoutingPreprocessorDebug(String documentRoutingPreprocessorDebug) {
        if (documentRoutingPreprocessorDebug == null || Comparison.isIn(documentRoutingPreprocessorDebug, DPEnumerations.TOGGLE)) {
            this.documentRoutingPreprocessorDebug = documentRoutingPreprocessorDebug;
        }
    }

    @XMLInfo(elementType="element", elementName="ArchiveMode", elementOrder=14, dataPowerType="dmB2BArchiveMode", subType="", benign=false, isPassword=false, cliAlias="arch-mode", refType="", isEnumeration=true, javaName="archiveMode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Purge mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getArchiveMode() {
        return this.archiveMode;
    }

    @XMLInfo(elementType="element", elementName="ArchiveMode", elementOrder=14, dataPowerType="dmB2BArchiveMode", subType="", benign=false, isPassword=false, cliAlias="arch-mode", refType="", isEnumeration=true, javaName="archiveMode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Purge mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setArchiveMode(String archiveMode) {
        if (Comparison.isIn(archiveMode, DPEnumerations.B2BARCHIVE_MODE)) {
            this.archiveMode = archiveMode;
        }
    }

    @XMLInfo(elementType="element", elementName="ArchiveLocation", elementOrder=15, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="arch-dir", refType="", isEnumeration=false, javaName="archiveLocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Archive location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getArchiveLocation() {
        return this.archiveLocation;
    }

    @XMLInfo(elementType="element", elementName="ArchiveLocation", elementOrder=15, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="arch-dir", refType="", isEnumeration=false, javaName="archiveLocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Archive location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setArchiveLocation(String archiveLocation) {
        this.archiveLocation = archiveLocation;
    }

    @XMLInfo(elementType="element", elementName="ArchiveFileName", elementOrder=16, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="arch-file", refType="", isEnumeration=false, javaName="archiveFileName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="^[_a-zA-Z0-9.-]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Archive file base name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getArchiveFileName() {
        return this.archiveFileName;
    }

    @XMLInfo(elementType="element", elementName="ArchiveFileName", elementOrder=16, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="arch-file", refType="", isEnumeration=false, javaName="archiveFileName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=128, validationRegex="^[_a-zA-Z0-9.-]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Archive file base name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setArchiveFileName(String archiveFileName) {
        if (archiveFileName != null && archiveFileName.matches("^[_a-zA-Z0-9.-]+$")) {
            this.archiveFileName = archiveFileName;
        }
    }

    @XMLInfo(elementType="element", elementName="ArchiveMinimumSize", elementOrder=17, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="arch-minimum-size", refType="", isEnumeration=false, javaName="archiveMinimumSize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1024", displayOrder=0, displayValue="Min size", units="KB", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getArchiveMinimumSize() {
        return this.archiveMinimumSize;
    }

    @XMLInfo(elementType="element", elementName="ArchiveMinimumSize", elementOrder=17, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="arch-minimum-size", refType="", isEnumeration=false, javaName="archiveMinimumSize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1024", displayValue="Min size", units="KB", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setArchiveMinimumSize(long archiveMinimumSize) {
        this.archiveMinimumSize = archiveMinimumSize;
    }

    @XMLInfo(elementType="element", elementName="ArchiveDocumentAge", elementOrder=18, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="arch-document-age", refType="", isEnumeration=false, javaName="archiveDocumentAge", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=3650L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="90", displayOrder=0, displayValue="Document age", units="days", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getArchiveDocumentAge() {
        return this.archiveDocumentAge;
    }

    @XMLInfo(elementType="element", elementName="ArchiveDocumentAge", elementOrder=18, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="arch-document-age", refType="", isEnumeration=false, javaName="archiveDocumentAge", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=3650L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="90", displayValue="Document age", units="days", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setArchiveDocumentAge(int archiveDocumentAge) {
        this.archiveDocumentAge = archiveDocumentAge;
    }

    @XMLInfo(elementType="element", elementName="ArchiveMinimumDocuments", elementOrder=19, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="arch-minimum-documents", refType="", isEnumeration=false, javaName="archiveMinimumDocuments", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="100", displayOrder=0, displayValue="Min documents", units="documents", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getArchiveMinimumDocuments() {
        return this.archiveMinimumDocuments;
    }

    @XMLInfo(elementType="element", elementName="ArchiveMinimumDocuments", elementOrder=19, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="arch-minimum-documents", refType="", isEnumeration=false, javaName="archiveMinimumDocuments", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="100", displayValue="Min documents", units="documents", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setArchiveMinimumDocuments(int archiveMinimumDocuments) {
        this.archiveMinimumDocuments = archiveMinimumDocuments;
    }

    @XMLInfo(elementType="element", elementName="DiskUseCheckInterval", elementOrder=20, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="diskuse-check-interval", refType="", isEnumeration=false, javaName="diskUseCheckInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=1440L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="60", displayOrder=0, displayValue="Check interval", units="minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getDiskUseCheckInterval() {
        return this.diskUseCheckInterval;
    }

    @XMLInfo(elementType="element", elementName="DiskUseCheckInterval", elementOrder=20, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="diskuse-check-interval", refType="", isEnumeration=false, javaName="diskUseCheckInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=1440L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="60", displayValue="Check interval", units="minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDiskUseCheckInterval(int diskUseCheckInterval) {
        this.diskUseCheckInterval = diskUseCheckInterval;
    }

    @XMLInfo(elementType="element", elementName="MaxDocumentDiskUse", elementOrder=21, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-diskuse", refType="", isEnumeration=false, javaName="maxDocumentDiskUse", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="25165824", displayOrder=0, displayValue="Max document storage", units="KB", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxDocumentDiskUse() {
        return this.maxDocumentDiskUse;
    }

    @XMLInfo(elementType="element", elementName="MaxDocumentDiskUse", elementOrder=21, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-diskuse", refType="", isEnumeration=false, javaName="maxDocumentDiskUse", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="25165824", displayValue="Max document storage", units="KB", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxDocumentDiskUse(long maxDocumentDiskUse) {
        this.maxDocumentDiskUse = maxDocumentDiskUse;
    }

    @XMLInfo(elementType="element", elementName="ArchiveMonitor", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="arch-monitor", refType="", isEnumeration=true, javaName="archiveMonitor", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Monitor during archival", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getArchiveMonitor() {
        return this.archiveMonitor;
    }

    @XMLInfo(elementType="element", elementName="ArchiveMonitor", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="arch-monitor", refType="", isEnumeration=true, javaName="archiveMonitor", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Monitor during archival", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setArchiveMonitor(String archiveMonitor) {
        if (archiveMonitor == null || Comparison.isIn(archiveMonitor, DPEnumerations.TOGGLE)) {
            this.archiveMonitor = archiveMonitor;
        }
    }

    @XMLInfo(elementType="element", elementName="ShapingThreshold", elementOrder=23, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="arch-shaping-threshold", refType="", isEnumeration=false, javaName="shapingThreshold", javaType="int", isRequired=false, squelchNull=false, minimum=10, maximum=10000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="200", displayOrder=0, displayValue="Monitor threshold", units="TPS", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getShapingThreshold() {
        return this.shapingThreshold;
    }

    @XMLInfo(elementType="element", elementName="ShapingThreshold", elementOrder=23, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="arch-shaping-threshold", refType="", isEnumeration=false, javaName="shapingThreshold", javaType="int", isRequired=false, squelchNull=false, minimum=10, maximum=10000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="200", displayValue="Monitor threshold", units="TPS", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setShapingThreshold(int shapingThreshold) {
        this.shapingThreshold = shapingThreshold;
    }

    @XMLInfo(elementType="element", elementName="ArchiveBackupDocuments", elementOrder=24, dataPowerType="dmB2BBackupMsgType", subType="", benign=false, isPassword=false, cliAlias="arch-backup-documents", refType="", isEnumeration=false, javaName="archiveBackupDocuments", javaType="B2BBackupMsgType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Document types to archive", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public B2BBackupMsgType getArchiveBackupDocuments() {
        return this.archiveBackupDocuments;
    }

    @XMLInfo(elementType="element", elementName="ArchiveBackupDocuments", elementOrder=24, dataPowerType="dmB2BBackupMsgType", subType="", benign=false, isPassword=false, cliAlias="arch-backup-documents", refType="", isEnumeration=false, javaName="archiveBackupDocuments", javaType="B2BBackupMsgType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Document types to archive", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setArchiveBackupDocuments(B2BBackupMsgType archiveBackupDocuments) {
        this.archiveBackupDocuments = archiveBackupDocuments;
    }

    public void addXPathRoutingPolicies(ObjectReference<ConfigB2BXPathRoutingPolicy> element) {
        if (element == null) {
            return;
        }
        if (this.xPathRoutingPolicies == null) {
            this.xPathRoutingPolicies = new ArrayList();
        }
        this.xPathRoutingPolicies.add(element);
    }

    public boolean removeXPathRoutingPolicies(ObjectReference<ConfigB2BXPathRoutingPolicy> element) {
        if (element == null || this.xPathRoutingPolicies == null) {
            return false;
        }
        return this.xPathRoutingPolicies.remove(element);
    }

    @XMLInfo(elementType="element", elementName="XPathRoutingPolicies", elementOrder=25, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xpath-routing", refType="B2BXPathRoutingPolicy", isEnumeration=false, javaName="xPathRoutingPolicies", javaType="ObjectReference<ConfigB2BXPathRoutingPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="XPath routing policies", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ObjectReference<ConfigB2BXPathRoutingPolicy>> getXPathRoutingPolicies() {
        return this.xPathRoutingPolicies;
    }

    @XMLInfo(elementType="element", elementName="XPathRoutingPolicies", elementOrder=25, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xpath-routing", refType="B2BXPathRoutingPolicy", isEnumeration=false, javaName="xPathRoutingPolicies", javaType="ObjectReference<ConfigB2BXPathRoutingPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="XPath routing policies", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXPathRoutingPolicies(ArrayList<ObjectReference<ConfigB2BXPathRoutingPolicy>> xPathRoutingPolicies) {
        this.xPathRoutingPolicies = xPathRoutingPolicies;
    }

    @XMLInfo(elementType="element", elementName="XMLManager", elementOrder=26, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xml-manager", refType="XMLManager", isEnumeration=false, javaName="xMLManager", javaType="ObjectReference<ConfigXMLManager>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default", displayOrder=0, displayValue="XML manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigXMLManager> getXMLManager() {
        return this.xMLManager;
    }

    @XMLInfo(elementType="element", elementName="XMLManager", elementOrder=26, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xml-manager", refType="XMLManager", isEnumeration=false, javaName="xMLManager", javaType="ObjectReference<ConfigXMLManager>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default", displayValue="XML manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXMLManager(ObjectReference<ConfigXMLManager> xMLManager) {
        this.xMLManager = xMLManager;
    }

    @XMLInfo(elementType="element", elementName="DebugMode", elementOrder=27, dataPowerType="dmDebugMode", subType="", benign=false, isPassword=false, cliAlias="debug-mode", refType="", isEnumeration=true, javaName="debugMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Probe setting", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDebugMode() {
        return this.debugMode;
    }

    @XMLInfo(elementType="element", elementName="DebugMode", elementOrder=27, dataPowerType="dmDebugMode", subType="", benign=false, isPassword=false, cliAlias="debug-mode", refType="", isEnumeration=true, javaName="debugMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Probe setting", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDebugMode(String debugMode) {
        if (debugMode == null || Comparison.isIn(debugMode, DPEnumerations.DEBUG_MODE)) {
            this.debugMode = debugMode;
        }
    }

    @XMLInfo(elementType="element", elementName="DebugHistory", elementOrder=28, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="debug-history", refType="", isEnumeration=false, javaName="debugHistory", javaType="long", isRequired=false, squelchNull=false, minimum=10, maximum=250L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="25", displayOrder=0, displayValue="Transaction history", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getDebugHistory() {
        return this.debugHistory;
    }

    @XMLInfo(elementType="element", elementName="DebugHistory", elementOrder=28, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="debug-history", refType="", isEnumeration=false, javaName="debugHistory", javaType="long", isRequired=false, squelchNull=false, minimum=10, maximum=250L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="25", displayValue="Transaction history", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDebugHistory(long debugHistory) {
        this.debugHistory = debugHistory;
    }

    public void addCPAEntries(B2BCPAEntry element) {
        if (element == null) {
            return;
        }
        if (this.cPAEntries == null) {
            this.cPAEntries = new ArrayList();
        }
        this.cPAEntries.add(element);
    }

    public boolean removeCPAEntries(B2BCPAEntry element) {
        if (element == null || this.cPAEntries == null) {
            return false;
        }
        return this.cPAEntries.remove(element);
    }

    @XMLInfo(elementType="element", elementName="CPAEntries", elementOrder=29, dataPowerType="dmB2BCPAEntry", subType="", benign=false, isPassword=false, cliAlias="cpa-entry", refType="", isEnumeration=false, javaName="cPAEntries", javaType="B2BCPAEntry", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="CPA", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<B2BCPAEntry> getCPAEntries() {
        return this.cPAEntries;
    }

    @XMLInfo(elementType="element", elementName="CPAEntries", elementOrder=29, dataPowerType="dmB2BCPAEntry", subType="", benign=false, isPassword=false, cliAlias="cpa-entry", refType="", isEnumeration=false, javaName="cPAEntries", javaType="B2BCPAEntry", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="CPA", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCPAEntries(ArrayList<B2BCPAEntry> cPAEntries) {
        this.cPAEntries = cPAEntries;
    }

    @XMLInfo(elementType="element", elementName="SQLDataSource", elementOrder=30, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="sql-source", refType="SQLDataSource", isEnumeration=false, javaName="sQLDataSource", javaType="ObjectReference<ConfigSQLDataSource>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="SQL data source", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSQLDataSource> getSQLDataSource() {
        return this.sQLDataSource;
    }

    @XMLInfo(elementType="element", elementName="SQLDataSource", elementOrder=30, dataPowerType="dmReference", subType="", benign=true, isPassword=false, cliAlias="sql-source", refType="SQLDataSource", isEnumeration=false, javaName="sQLDataSource", javaType="ObjectReference<ConfigSQLDataSource>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="SQL data source", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSQLDataSource(ObjectReference<ConfigSQLDataSource> sQLDataSource) {
        this.sQLDataSource = sQLDataSource;
    }

    @XMLInfo(elementType="element", elementName="FrontSideTimeout", elementOrder=31, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-side-timeout", refType="", isEnumeration=false, javaName="frontSideTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="120", displayOrder=0, displayValue="Front timeout", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getFrontSideTimeout() {
        return this.frontSideTimeout;
    }

    @XMLInfo(elementType="element", elementName="FrontSideTimeout", elementOrder=31, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="front-side-timeout", refType="", isEnumeration=false, javaName="frontSideTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="120", displayValue="Front timeout", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setFrontSideTimeout(long frontSideTimeout) {
        this.frontSideTimeout = frontSideTimeout;
    }

    @Override
    public int compareTo(ConfigB2BGateway that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "priority", "docStoreLocation", "aSFrontProtocol", "aS1MDNEmail", "aS1MDNSMTPServerConnection", "aS2MDNURL", "aS3MDNURL", "b2BProfiles", "b2BGroups", "documentRoutingPreprocessorType", "documentRoutingPreprocessor", "documentRoutingPreprocessorDebug", "archiveMode", "archiveLocation", "archiveFileName", "archiveMinimumSize", "archiveDocumentAge", "archiveMinimumDocuments", "diskUseCheckInterval", "maxDocumentDiskUse", "archiveMonitor", "shapingThreshold", "archiveBackupDocuments", "xPathRoutingPolicies", "xMLManager", "debugMode", "debugHistory", "cPAEntries", "sQLDataSource", "frontSideTimeout");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.priority, this.docStoreLocation, this.aSFrontProtocol, this.aS1MDNEmail, this.aS1MDNSMTPServerConnection, this.aS2MDNURL, this.aS3MDNURL, this.b2BProfiles, this.b2BGroups, this.documentRoutingPreprocessorType, this.documentRoutingPreprocessor, this.documentRoutingPreprocessorDebug, this.archiveMode, this.archiveLocation, this.archiveFileName, this.archiveMinimumSize, this.archiveDocumentAge, this.archiveMinimumDocuments, this.diskUseCheckInterval, this.maxDocumentDiskUse, this.archiveMonitor, this.shapingThreshold, this.archiveBackupDocuments, this.xPathRoutingPolicies, this.xMLManager, this.debugMode, this.debugHistory, this.cPAEntries, this.sQLDataSource, this.frontSideTimeout);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "priority", "docStoreLocation", "aSFrontProtocol", "aS1MDNEmail", "aS1MDNSMTPServerConnection", "aS2MDNURL", "aS3MDNURL", "b2BProfiles", "b2BGroups", "documentRoutingPreprocessorType", "documentRoutingPreprocessor", "documentRoutingPreprocessorDebug", "archiveMode", "archiveLocation", "archiveFileName", "archiveMinimumSize", "archiveDocumentAge", "archiveMinimumDocuments", "diskUseCheckInterval", "maxDocumentDiskUse", "archiveMonitor", "shapingThreshold", "archiveBackupDocuments", "xPathRoutingPolicies", "xMLManager", "debugMode", "debugHistory", "cPAEntries", "sQLDataSource", "frontSideTimeout");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "priority", "docStoreLocation", "aSFrontProtocol", "aS1MDNEmail", "aS1MDNSMTPServerConnection", "aS2MDNURL", "aS3MDNURL", "b2BProfiles", "b2BGroups", "documentRoutingPreprocessorType", "documentRoutingPreprocessor", "documentRoutingPreprocessorDebug", "archiveMode", "archiveLocation", "archiveFileName", "archiveMinimumSize", "archiveDocumentAge", "archiveMinimumDocuments", "diskUseCheckInterval", "maxDocumentDiskUse", "archiveMonitor", "shapingThreshold", "archiveBackupDocuments", "xPathRoutingPolicies", "xMLManager", "debugMode", "debugHistory", "cPAEntries", "sQLDataSource", "frontSideTimeout"));
    }
}

