/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.config.ConfigNetworkConfiguration;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.NameServer;
import com.kumbasoft.core.beans.types.SearchDomain;
import com.kumbasoft.core.beans.types.StaticHost;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigDNSNameService
extends ConfigNetworkConfiguration {
    private String userSummary;
    private ArrayList<SearchDomain> searchDomains;
    private ArrayList<NameServer> nameServers;
    private ArrayList<StaticHost> staticHosts;
    private String iPPreference;
    private String forceIPPreference;
    private String loadBalanceAlgorithm;
    private long maxRetries;
    private long timeout;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    public void addSearchDomains(SearchDomain element) {
        if (element == null) {
            return;
        }
        if (this.searchDomains == null) {
            this.searchDomains = new ArrayList();
        }
        this.searchDomains.add(element);
    }

    public boolean removeSearchDomains(SearchDomain element) {
        if (element == null || this.searchDomains == null) {
            return false;
        }
        return this.searchDomains.remove(element);
    }

    @XMLInfo(elementType="element", elementName="SearchDomains", elementOrder=2, dataPowerType="dmSearchDomain", subType="", benign=false, isPassword=false, cliAlias="search-domain", refType="", isEnumeration=false, javaName="searchDomains", javaType="SearchDomain", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Search domains", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<SearchDomain> getSearchDomains() {
        return this.searchDomains;
    }

    @XMLInfo(elementType="element", elementName="SearchDomains", elementOrder=2, dataPowerType="dmSearchDomain", subType="", benign=false, isPassword=false, cliAlias="search-domain", refType="", isEnumeration=false, javaName="searchDomains", javaType="SearchDomain", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Search domains", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSearchDomains(ArrayList<SearchDomain> searchDomains) {
        this.searchDomains = searchDomains;
    }

    public void addNameServers(NameServer element) {
        if (element == null) {
            return;
        }
        if (this.nameServers == null) {
            this.nameServers = new ArrayList();
        }
        this.nameServers.add(element);
    }

    public boolean removeNameServers(NameServer element) {
        if (element == null || this.nameServers == null) {
            return false;
        }
        return this.nameServers.remove(element);
    }

    @XMLInfo(elementType="element", elementName="NameServers", elementOrder=3, dataPowerType="dmNameServer", subType="", benign=false, isPassword=false, cliAlias="name-server", refType="", isEnumeration=false, javaName="nameServers", javaType="NameServer", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="DNS servers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<NameServer> getNameServers() {
        return this.nameServers;
    }

    @XMLInfo(elementType="element", elementName="NameServers", elementOrder=3, dataPowerType="dmNameServer", subType="", benign=false, isPassword=false, cliAlias="name-server", refType="", isEnumeration=false, javaName="nameServers", javaType="NameServer", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="DNS servers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setNameServers(ArrayList<NameServer> nameServers) {
        this.nameServers = nameServers;
    }

    public void addStaticHosts(StaticHost element) {
        if (element == null) {
            return;
        }
        if (this.staticHosts == null) {
            this.staticHosts = new ArrayList();
        }
        this.staticHosts.add(element);
    }

    public boolean removeStaticHosts(StaticHost element) {
        if (element == null || this.staticHosts == null) {
            return false;
        }
        return this.staticHosts.remove(element);
    }

    @XMLInfo(elementType="element", elementName="StaticHosts", elementOrder=4, dataPowerType="dmStaticHost", subType="", benign=false, isPassword=false, cliAlias="static-host", refType="", isEnumeration=false, javaName="staticHosts", javaType="StaticHost", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Static hosts", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<StaticHost> getStaticHosts() {
        return this.staticHosts;
    }

    @XMLInfo(elementType="element", elementName="StaticHosts", elementOrder=4, dataPowerType="dmStaticHost", subType="", benign=false, isPassword=false, cliAlias="static-host", refType="", isEnumeration=false, javaName="staticHosts", javaType="StaticHost", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Static hosts", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStaticHosts(ArrayList<StaticHost> staticHosts) {
        this.staticHosts = staticHosts;
    }

    @XMLInfo(elementType="element", elementName="IPPreference", elementOrder=5, dataPowerType="dmDnsHostIPVersion", subType="", benign=false, isPassword=false, cliAlias="ip-preference", refType="", isEnumeration=true, javaName="iPPreference", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="IP preference", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getIPPreference() {
        return this.iPPreference;
    }

    @XMLInfo(elementType="element", elementName="IPPreference", elementOrder=5, dataPowerType="dmDnsHostIPVersion", subType="", benign=false, isPassword=false, cliAlias="ip-preference", refType="", isEnumeration=true, javaName="iPPreference", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="IP preference", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIPPreference(String iPPreference) {
        if (iPPreference == null || Comparison.isIn(iPPreference, DPEnumerations.DNS_HOST_IPVERSION)) {
            this.iPPreference = iPPreference;
        }
    }

    @XMLInfo(elementType="element", elementName="ForceIPPreference", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="force-ip-preference", refType="", isEnumeration=true, javaName="forceIPPreference", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Force IP preference", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getForceIPPreference() {
        return this.forceIPPreference;
    }

    @XMLInfo(elementType="element", elementName="ForceIPPreference", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="force-ip-preference", refType="", isEnumeration=true, javaName="forceIPPreference", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Force IP preference", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setForceIPPreference(String forceIPPreference) {
        if (forceIPPreference == null || Comparison.isIn(forceIPPreference, DPEnumerations.TOGGLE)) {
            this.forceIPPreference = forceIPPreference;
        }
    }

    @XMLInfo(elementType="element", elementName="LoadBalanceAlgorithm", elementOrder=7, dataPowerType="dmDNSLoadBalanceAlgorithm", subType="", benign=false, isPassword=false, cliAlias="load-balance", refType="", isEnumeration=true, javaName="loadBalanceAlgorithm", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="first-alive", displayOrder=0, displayValue="Load distribution algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLoadBalanceAlgorithm() {
        return this.loadBalanceAlgorithm;
    }

    @XMLInfo(elementType="element", elementName="LoadBalanceAlgorithm", elementOrder=7, dataPowerType="dmDNSLoadBalanceAlgorithm", subType="", benign=false, isPassword=false, cliAlias="load-balance", refType="", isEnumeration=true, javaName="loadBalanceAlgorithm", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="first-alive", displayValue="Load distribution algorithm", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLoadBalanceAlgorithm(String loadBalanceAlgorithm) {
        if (Comparison.isIn(loadBalanceAlgorithm, DPEnumerations.DNSLOAD_BALANCE_ALGORITHM)) {
            this.loadBalanceAlgorithm = loadBalanceAlgorithm;
        }
    }

    @XMLInfo(elementType="element", elementName="MaxRetries", elementOrder=8, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="retries", refType="", isEnumeration=false, javaName="maxRetries", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="2", displayOrder=0, displayValue="Attempts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxRetries() {
        return this.maxRetries;
    }

    @XMLInfo(elementType="element", elementName="MaxRetries", elementOrder=8, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="retries", refType="", isEnumeration=false, javaName="maxRetries", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="2", displayValue="Attempts", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxRetries(long maxRetries) {
        this.maxRetries = maxRetries;
    }

    @XMLInfo(elementType="element", elementName="Timeout", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="timeout", refType="", isEnumeration=false, javaName="timeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="5", displayOrder=0, displayValue="Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getTimeout() {
        return this.timeout;
    }

    @XMLInfo(elementType="element", elementName="Timeout", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="timeout", refType="", isEnumeration=false, javaName="timeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="5", displayValue="Timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public int compareTo(ConfigDNSNameService that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "searchDomains", "nameServers", "staticHosts", "iPPreference", "forceIPPreference", "loadBalanceAlgorithm", "maxRetries", "timeout");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.searchDomains, this.nameServers, this.staticHosts, this.iPPreference, this.forceIPPreference, this.loadBalanceAlgorithm, this.maxRetries, this.timeout);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "searchDomains", "nameServers", "staticHosts", "iPPreference", "forceIPPreference", "loadBalanceAlgorithm", "maxRetries", "timeout");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "searchDomains", "nameServers", "staticHosts", "iPPreference", "forceIPPreference", "loadBalanceAlgorithm", "maxRetries", "timeout"));
    }
}

