/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAccessControlList;
import com.kumbasoft.core.beans.config.ConfigService;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigHTTPService
extends ConfigService {
    private String userSummary;
    private String priority;
    private int localPort;
    private String mode;
    private String identifier;
    private String baseDir;
    private String startPage;
    private ObjectReference<ConfigAccessControlList> aCL;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=3, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="normal", displayOrder=0, displayValue="Service Priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPriority() {
        return this.priority;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=3, dataPowerType="dmSchedulerPriority", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=true, javaName="priority", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="normal", displayValue="Service Priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPriority(String priority) {
        if (priority == null || Comparison.isIn(priority, DPEnumerations.SCHEDULER_PRIORITY)) {
            this.priority = priority;
        }
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=4, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="80", displayOrder=0, displayValue="Port Number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLocalPort() {
        return this.localPort;
    }

    @XMLInfo(elementType="element", elementName="LocalPort", elementOrder=4, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="localPort", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="80", displayValue="Port Number", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalPort(int localPort) {
        this.localPort = localPort;
    }

    @XMLInfo(elementType="element", elementName="Mode", elementOrder=5, dataPowerType="dmHTTPServiceMode", subType="", benign=false, isPassword=false, cliAlias="mode", refType="", isEnumeration=true, javaName="mode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="normal", displayOrder=0, displayValue="Mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMode() {
        return this.mode;
    }

    @XMLInfo(elementType="element", elementName="Mode", elementOrder=5, dataPowerType="dmHTTPServiceMode", subType="", benign=false, isPassword=false, cliAlias="mode", refType="", isEnumeration=true, javaName="mode", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="normal", displayValue="Mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMode(String mode) {
        if (Comparison.isIn(mode, DPEnumerations.HTTPSERVICE_MODE)) {
            this.mode = mode;
        }
    }

    @XMLInfo(elementType="element", elementName="Identifier", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="identifier", refType="", isEnumeration=false, javaName="identifier", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Identifier", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getIdentifier() {
        return this.identifier;
    }

    @XMLInfo(elementType="element", elementName="Identifier", elementOrder=6, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="identifier", refType="", isEnumeration=false, javaName="identifier", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Identifier", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    @XMLInfo(elementType="element", elementName="BaseDir", elementOrder=7, dataPowerType="dmFSDirectory", subType="", benign=false, isPassword=false, cliAlias="local-directory", refType="", isEnumeration=false, javaName="baseDir", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(store|config|image|temporary|logtemp|logstore|audit|local):", allowedValues={}, defaultValue="store:///", displayOrder=0, displayValue="Base Directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getBaseDir() {
        return this.baseDir;
    }

    @XMLInfo(elementType="element", elementName="BaseDir", elementOrder=7, dataPowerType="dmFSDirectory", subType="", benign=false, isPassword=false, cliAlias="local-directory", refType="", isEnumeration=false, javaName="baseDir", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(store|config|image|temporary|logtemp|logstore|audit|local):", allowedValues={}, displayOrder=0, defaultValue="store:///", displayValue="Base Directory", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBaseDir(String baseDir) {
        if (baseDir != null && baseDir.matches("^(store|config|image|temporary|logtemp|logstore|audit|local):")) {
            this.baseDir = baseDir;
        }
    }

    @XMLInfo(elementType="element", elementName="StartPage", elementOrder=8, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="start-page", refType="", isEnumeration=false, javaName="startPage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Start Page", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStartPage() {
        return this.startPage;
    }

    @XMLInfo(elementType="element", elementName="StartPage", elementOrder=8, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="start-page", refType="", isEnumeration=false, javaName="startPage", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Start Page", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStartPage(String startPage) {
        this.startPage = startPage;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Access Control List", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAccessControlList> getACL() {
        return this.aCL;
    }

    @XMLInfo(elementType="element", elementName="ACL", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="acl", refType="AccessControlList", isEnumeration=false, javaName="aCL", javaType="ObjectReference<ConfigAccessControlList>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Access Control List", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setACL(ObjectReference<ConfigAccessControlList> aCL) {
        this.aCL = aCL;
    }

    @Override
    public int compareTo(ConfigHTTPService that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "priority", "localPort", "mode", "identifier", "baseDir", "startPage", "aCL");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.priority, this.localPort, this.mode, this.identifier, this.baseDir, this.startPage, this.aCL);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "priority", "localPort", "mode", "identifier", "baseDir", "startPage", "aCL");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "priority", "localPort", "mode", "identifier", "baseDir", "startPage", "aCL"));
    }
}

