/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigCryptoSSKey;
import java.util.Objects;

public class ConfigIPMulticast
extends ConfigConfigBase {
    private String userSummary;
    private String multicastGroup;
    private String ethernetInterface;
    private int port;
    private ObjectReference<ConfigCryptoSSKey> sSKey;
    private int maxDataSize;
    private int nAKRetransmissionTime;
    private int nAKRetries;
    private int bufferResendTime;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="MulticastGroup", elementOrder=2, dataPowerType="dmIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="multicast-group", refType="", isEnumeration=false, javaName="multicastGroup", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^((([fF][fF]).*)|(((22[4-9])|(23[0-9]))\\..*))$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Multicast Group", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMulticastGroup() {
        return this.multicastGroup;
    }

    @XMLInfo(elementType="element", elementName="MulticastGroup", elementOrder=2, dataPowerType="dmIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="multicast-group", refType="", isEnumeration=false, javaName="multicastGroup", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^((([fF][fF]).*)|(((22[4-9])|(23[0-9]))\\..*))$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Multicast Group", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMulticastGroup(String multicastGroup) {
        if (multicastGroup != null && multicastGroup.matches("^((([fF][fF]).*)|(((22[4-9])|(23[0-9]))\\..*))$")) {
            this.multicastGroup = multicastGroup;
        }
    }

    @XMLInfo(elementType="element", elementName="Interface", elementOrder=3, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="interface", refType="", isEnumeration=false, javaName="ethernetInterface", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Local Interface", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEthernetInterface() {
        return this.ethernetInterface;
    }

    @XMLInfo(elementType="element", elementName="Interface", elementOrder=3, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="interface", refType="", isEnumeration=false, javaName="ethernetInterface", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Local Interface", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEthernetInterface(String ethernetInterface) {
        this.ethernetInterface = ethernetInterface;
    }

    @XMLInfo(elementType="element", elementName="Port", elementOrder=4, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="port", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getPort() {
        return this.port;
    }

    @XMLInfo(elementType="element", elementName="Port", elementOrder=4, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="port", refType="", isEnumeration=false, javaName="port", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPort(int port) {
        this.port = port;
    }

    @XMLInfo(elementType="element", elementName="SSKey", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="key", refType="CryptoSSKey", isEnumeration=false, javaName="sSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Shared Secret Key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoSSKey> getSSKey() {
        return this.sSKey;
    }

    @XMLInfo(elementType="element", elementName="SSKey", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="key", refType="CryptoSSKey", isEnumeration=false, javaName="sSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Shared Secret Key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSKey(ObjectReference<ConfigCryptoSSKey> sSKey) {
        this.sSKey = sSKey;
    }

    @XMLInfo(elementType="element", elementName="MaxDataSize", elementOrder=6, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-data-size", refType="", isEnumeration=false, javaName="maxDataSize", javaType="int", isRequired=true, squelchNull=false, minimum=200, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="512", displayOrder=0, displayValue="Maximum Transmit Data Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMaxDataSize() {
        return this.maxDataSize;
    }

    @XMLInfo(elementType="element", elementName="MaxDataSize", elementOrder=6, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-data-size", refType="", isEnumeration=false, javaName="maxDataSize", javaType="int", isRequired=true, squelchNull=false, minimum=200, maximum=65535L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="512", displayValue="Maximum Transmit Data Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxDataSize(int maxDataSize) {
        this.maxDataSize = maxDataSize;
    }

    @XMLInfo(elementType="element", elementName="NAKRetransmissionTime", elementOrder=7, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="nak-time", refType="", isEnumeration=false, javaName="nAKRetransmissionTime", javaType="int", isRequired=true, squelchNull=false, minimum=100, maximum=60000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="200", displayOrder=0, displayValue="NAK Retransmission Time", units="ms", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getNAKRetransmissionTime() {
        return this.nAKRetransmissionTime;
    }

    @XMLInfo(elementType="element", elementName="NAKRetransmissionTime", elementOrder=7, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="nak-time", refType="", isEnumeration=false, javaName="nAKRetransmissionTime", javaType="int", isRequired=true, squelchNull=false, minimum=100, maximum=60000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="200", displayValue="NAK Retransmission Time", units="ms", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setNAKRetransmissionTime(int nAKRetransmissionTime) {
        this.nAKRetransmissionTime = nAKRetransmissionTime;
    }

    @XMLInfo(elementType="element", elementName="NAKRetries", elementOrder=8, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="nak-retries", refType="", isEnumeration=false, javaName="nAKRetries", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=100L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="5", displayOrder=0, displayValue="NAK Retries", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getNAKRetries() {
        return this.nAKRetries;
    }

    @XMLInfo(elementType="element", elementName="NAKRetries", elementOrder=8, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="nak-retries", refType="", isEnumeration=false, javaName="nAKRetries", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=100L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="5", displayValue="NAK Retries", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setNAKRetries(int nAKRetries) {
        this.nAKRetries = nAKRetries;
    }

    @XMLInfo(elementType="element", elementName="BufferResendTime", elementOrder=9, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="buffer-resend-time", refType="", isEnumeration=false, javaName="bufferResendTime", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=60L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="2", displayOrder=0, displayValue="Buffer Resend Time", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getBufferResendTime() {
        return this.bufferResendTime;
    }

    @XMLInfo(elementType="element", elementName="BufferResendTime", elementOrder=9, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="buffer-resend-time", refType="", isEnumeration=false, javaName="bufferResendTime", javaType="int", isRequired=true, squelchNull=false, minimum=1, maximum=60L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="2", displayValue="Buffer Resend Time", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setBufferResendTime(int bufferResendTime) {
        this.bufferResendTime = bufferResendTime;
    }

    @Override
    public int compareTo(ConfigIPMulticast that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "multicastGroup", "ethernetInterface", "port", "sSKey", "maxDataSize", "nAKRetransmissionTime", "nAKRetries", "bufferResendTime");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.multicastGroup, this.ethernetInterface, this.port, this.sSKey, this.maxDataSize, this.nAKRetransmissionTime, this.nAKRetries, this.bufferResendTime);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "multicastGroup", "ethernetInterface", "port", "sSKey", "maxDataSize", "nAKRetransmissionTime", "nAKRetries", "bufferResendTime");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "multicastGroup", "ethernetInterface", "port", "sSKey", "maxDataSize", "nAKRetransmissionTime", "nAKRetries", "bufferResendTime"));
    }
}

