/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigCryptoProfile;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigJMSServer
extends ConfigConfigBase {
    private String userSummary;
    private String userName;
    private String password;
    private ObjectReference<ConfigPasswordAlias> passwordAlias;
    private String transactional;
    private long memoryThreshold;
    private long maximumMessageSize;
    private String defaultMessageType;
    private int totalConnectionLimit;
    private int sessionsPerConnection;
    private String autoRetry;
    private int retryInterval;
    private ObjectReference<ConfigCryptoProfile> sSLProfile;
    private String enableLogging;
    private String sSLClientConfigType;
    private ObjectReference<ConfigSSLClientProfile> sSLClient;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^ ]+$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserName() {
        return this.userName;
    }

    @XMLInfo(elementType="element", elementName="UserName", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="username", refType="", isEnumeration=false, javaName="userName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^ ]+$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserName(String userName) {
        if (userName != null && userName.matches("^[^ ]+$")) {
            this.userName = userName;
        }
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="password", refType="", isEnumeration=false, javaName="password", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public String getPassword() {
        return this.password;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=true, cliAlias="password", refType="", isEnumeration=false, javaName="password", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.2.0.0", isObsolete=false, obsoletedIn="")
    public void setPassword(String password) {
        this.password = password;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getPasswordAlias() {
        return this.passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasswordAlias(ObjectReference<ConfigPasswordAlias> passwordAlias) {
        this.passwordAlias = passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="Transactional", elementOrder=5, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="transactional", refType="", isEnumeration=true, javaName="transactional", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Transactional", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTransactional() {
        return this.transactional;
    }

    @XMLInfo(elementType="element", elementName="Transactional", elementOrder=5, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="transactional", refType="", isEnumeration=true, javaName="transactional", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Transactional", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTransactional(String transactional) {
        if (transactional == null || Comparison.isIn(transactional, DPEnumerations.TOGGLE)) {
            this.transactional = transactional;
        }
    }

    @XMLInfo(elementType="element", elementName="MemoryThreshold", elementOrder=6, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="memory-threshold", refType="", isEnumeration=false, javaName="memoryThreshold", javaType="long", isRequired=false, squelchNull=false, minimum=0xA00000, maximum=0x40000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="268435456", displayOrder=0, displayValue="Memory threshold", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMemoryThreshold() {
        return this.memoryThreshold;
    }

    @XMLInfo(elementType="element", elementName="MemoryThreshold", elementOrder=6, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="memory-threshold", refType="", isEnumeration=false, javaName="memoryThreshold", javaType="long", isRequired=false, squelchNull=false, minimum=0xA00000, maximum=0x40000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="268435456", displayValue="Memory threshold", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMemoryThreshold(long memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    @XMLInfo(elementType="element", elementName="MaximumMessageSize", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maximum-message-size", refType="", isEnumeration=false, javaName="maximumMessageSize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x40000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1048576", displayOrder=0, displayValue="Max message size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaximumMessageSize() {
        return this.maximumMessageSize;
    }

    @XMLInfo(elementType="element", elementName="MaximumMessageSize", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="maximum-message-size", refType="", isEnumeration=false, javaName="maximumMessageSize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x40000000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1048576", displayValue="Max message size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaximumMessageSize(long maximumMessageSize) {
        this.maximumMessageSize = maximumMessageSize;
    }

    @XMLInfo(elementType="element", elementName="DefaultMessageType", elementOrder=8, dataPowerType="dmJMSMessageType", subType="", benign=false, isPassword=false, cliAlias="default-message-type", refType="", isEnumeration=true, javaName="defaultMessageType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="byte", displayOrder=0, displayValue="Default message type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDefaultMessageType() {
        return this.defaultMessageType;
    }

    @XMLInfo(elementType="element", elementName="DefaultMessageType", elementOrder=8, dataPowerType="dmJMSMessageType", subType="", benign=false, isPassword=false, cliAlias="default-message-type", refType="", isEnumeration=true, javaName="defaultMessageType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="byte", displayValue="Default message type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDefaultMessageType(String defaultMessageType) {
        if (defaultMessageType == null || Comparison.isIn(defaultMessageType, DPEnumerations.JMSMESSAGE_TYPE)) {
            this.defaultMessageType = defaultMessageType;
        }
    }

    @XMLInfo(elementType="element", elementName="TotalConnectionLimit", elementOrder=9, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="total-connection-limit", refType="", isEnumeration=false, javaName="totalConnectionLimit", javaType="int", isRequired=false, squelchNull=true, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="64", displayOrder=0, displayValue="Total connection limit", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getTotalConnectionLimit() {
        return this.totalConnectionLimit;
    }

    @XMLInfo(elementType="element", elementName="TotalConnectionLimit", elementOrder=9, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="total-connection-limit", refType="", isEnumeration=false, javaName="totalConnectionLimit", javaType="int", isRequired=false, squelchNull=true, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="64", displayValue="Total connection limit", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTotalConnectionLimit(int totalConnectionLimit) {
        this.totalConnectionLimit = totalConnectionLimit;
    }

    @XMLInfo(elementType="element", elementName="SessionsPerConnection", elementOrder=10, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="sessions-per-connection", refType="", isEnumeration=false, javaName="sessionsPerConnection", javaType="int", isRequired=false, squelchNull=true, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="100", displayOrder=0, displayValue="Max number of sessions per connection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getSessionsPerConnection() {
        return this.sessionsPerConnection;
    }

    @XMLInfo(elementType="element", elementName="SessionsPerConnection", elementOrder=10, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="sessions-per-connection", refType="", isEnumeration=false, javaName="sessionsPerConnection", javaType="int", isRequired=false, squelchNull=true, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="100", displayValue="Max number of sessions per connection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSessionsPerConnection(int sessionsPerConnection) {
        this.sessionsPerConnection = sessionsPerConnection;
    }

    @XMLInfo(elementType="element", elementName="AutoRetry", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="auto-retry", refType="", isEnumeration=true, javaName="autoRetry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Automatic retry", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAutoRetry() {
        return this.autoRetry;
    }

    @XMLInfo(elementType="element", elementName="AutoRetry", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="auto-retry", refType="", isEnumeration=true, javaName="autoRetry", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Automatic retry", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAutoRetry(String autoRetry) {
        if (autoRetry == null || Comparison.isIn(autoRetry, DPEnumerations.TOGGLE)) {
            this.autoRetry = autoRetry;
        }
    }

    @XMLInfo(elementType="element", elementName="RetryInterval", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-interval", refType="", isEnumeration=false, javaName="retryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1", displayOrder=0, displayValue="Retry interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getRetryInterval() {
        return this.retryInterval;
    }

    @XMLInfo(elementType="element", elementName="RetryInterval", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="retry-interval", refType="", isEnumeration=false, javaName="retryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1", displayValue="Retry interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRetryInterval(int retryInterval) {
        this.retryInterval = retryInterval;
    }

    @XMLInfo(elementType="element", elementName="SSLProfile", elementOrder=13, dataPowerType="dmReference", subType="ForwardCryptoProfile", benign=false, isPassword=false, cliAlias="ssl", refType="CryptoProfile", isEnumeration=false, javaName="sSLProfile", javaType="ObjectReference<ConfigCryptoProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Crypto Profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoProfile> getSSLProfile() {
        return this.sSLProfile;
    }

    @XMLInfo(elementType="element", elementName="SSLProfile", elementOrder=13, dataPowerType="dmReference", subType="ForwardCryptoProfile", benign=false, isPassword=false, cliAlias="ssl", refType="CryptoProfile", isEnumeration=false, javaName="sSLProfile", javaType="ObjectReference<ConfigCryptoProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Crypto Profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLProfile(ObjectReference<ConfigCryptoProfile> sSLProfile) {
        this.sSLProfile = sSLProfile;
    }

    @XMLInfo(elementType="element", elementName="EnableLogging", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-logging", refType="", isEnumeration=true, javaName="enableLogging", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable JMS-specific logging", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnableLogging() {
        return this.enableLogging;
    }

    @XMLInfo(elementType="element", elementName="EnableLogging", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-logging", refType="", isEnumeration=true, javaName="enableLogging", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable JMS-specific logging", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnableLogging(String enableLogging) {
        if (enableLogging == null || Comparison.isIn(enableLogging, DPEnumerations.TOGGLE)) {
            this.enableLogging = enableLogging;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLClientConfigType", elementOrder=15, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-client-type", refType="", isEnumeration=true, javaName="sSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="client", displayOrder=0, displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLClientConfigType() {
        return this.sSLClientConfigType;
    }

    @XMLInfo(elementType="element", elementName="SSLClientConfigType", elementOrder=15, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-client-type", refType="", isEnumeration=true, javaName="sSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="client", displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClientConfigType(String sSLClientConfigType) {
        if (sSLClientConfigType == null || Comparison.isIn(sSLClientConfigType, DPEnumerations.SSLCLIENT_CONFIG_TYPE)) {
            this.sSLClientConfigType = sSLClientConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=16, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(ObjectReference<ConfigSSLClientProfile> sSLClient) {
        this.sSLClient = sSLClient;
    }

    @Override
    public int compareTo(ConfigJMSServer that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "userName", "password", "passwordAlias", "transactional", "memoryThreshold", "maximumMessageSize", "defaultMessageType", "totalConnectionLimit", "sessionsPerConnection", "autoRetry", "retryInterval", "sSLProfile", "enableLogging", "sSLClientConfigType", "sSLClient");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.userName, this.password, this.passwordAlias, this.transactional, this.memoryThreshold, this.maximumMessageSize, this.defaultMessageType, this.totalConnectionLimit, this.sessionsPerConnection, this.autoRetry, this.retryInterval, this.sSLProfile, this.enableLogging, this.sSLClientConfigType, this.sSLClient);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "userName", "password", "passwordAlias", "transactional", "memoryThreshold", "maximumMessageSize", "defaultMessageType", "totalConnectionLimit", "sessionsPerConnection", "autoRetry", "retryInterval", "sSLProfile", "enableLogging", "sSLClientConfigType", "sSLClient");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "userName", "password", "passwordAlias", "transactional", "memoryThreshold", "maximumMessageSize", "defaultMessageType", "totalConnectionLimit", "sessionsPerConnection", "autoRetry", "retryInterval", "sSLProfile", "enableLogging", "sSLClientConfigType", "sSLClient"));
    }
}

