/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.jmorgan.util.collection.CollectionUtility;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.config.ConfigCryptoSSKey;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.JOSEHeader;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigJOSESignatureIdentifier
extends ConfigCrypto {
    private String userSummary;
    private String type;
    private ObjectReference<ConfigCryptoSSKey> sSKey;
    private ObjectReference<ConfigCryptoCertificate> certificate;
    private ArrayList<String> validAlgorithms;
    private ArrayList<JOSEHeader> headerParam;
    private String verify;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Type", elementOrder=2, dataPowerType="dmVerifyKeyType", subType="", benign=false, isPassword=false, cliAlias="type", refType="", isEnumeration=true, javaName="type", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Key Material Type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getType() {
        return this.type;
    }

    @XMLInfo(elementType="element", elementName="Type", elementOrder=2, dataPowerType="dmVerifyKeyType", subType="", benign=false, isPassword=false, cliAlias="type", refType="", isEnumeration=true, javaName="type", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Key Material Type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setType(String type) {
        if (type == null || Comparison.isIn(type, DPEnumerations.VERIFY_KEY_TYPE)) {
            this.type = type;
        }
    }

    @XMLInfo(elementType="element", elementName="SSKey", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sskey", refType="CryptoSSKey", isEnumeration=false, javaName="sSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Key Material", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoSSKey> getSSKey() {
        return this.sSKey;
    }

    @XMLInfo(elementType="element", elementName="SSKey", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="sskey", refType="CryptoSSKey", isEnumeration=false, javaName="sSKey", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Key Material", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSKey(ObjectReference<ConfigCryptoSSKey> sSKey) {
        this.sSKey = sSKey;
    }

    @XMLInfo(elementType="element", elementName="Certificate", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="cert", refType="CryptoCertificate", isEnumeration=false, javaName="certificate", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Key Material", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoCertificate> getCertificate() {
        return this.certificate;
    }

    @XMLInfo(elementType="element", elementName="Certificate", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="cert", refType="CryptoCertificate", isEnumeration=false, javaName="certificate", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Key Material", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCertificate(ObjectReference<ConfigCryptoCertificate> certificate) {
        this.certificate = certificate;
    }

    public void addValidAlgorithms(String element) {
        if (element == null) {
            return;
        }
        if (this.validAlgorithms == null) {
            this.validAlgorithms = new ArrayList();
        }
        this.validAlgorithms.add(element);
    }

    public boolean removeValidAlgorithms(String element) {
        if (element == null || this.validAlgorithms == null) {
            return false;
        }
        return this.validAlgorithms.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ValidAlgorithms", elementOrder=5, dataPowerType="dmJWSSignAlgorithm", subType="", benign=false, isPassword=false, cliAlias="alg", refType="", isEnumeration=true, javaName="validAlgorithms", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Valid algorithms", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getValidAlgorithms() {
        return this.validAlgorithms;
    }

    @XMLInfo(elementType="element", elementName="ValidAlgorithms", elementOrder=5, dataPowerType="dmJWSSignAlgorithm", subType="", benign=false, isPassword=false, cliAlias="alg", refType="", isEnumeration=true, javaName="validAlgorithms", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Valid algorithms", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setValidAlgorithms(ArrayList<String> validAlgorithms) {
        if (CollectionUtility.isEmpty(validAlgorithms)) {
            this.validAlgorithms = null;
            return;
        }
        this.validAlgorithms = validAlgorithms;
    }

    public void addHeaderParam(JOSEHeader element) {
        if (element == null) {
            return;
        }
        if (this.headerParam == null) {
            this.headerParam = new ArrayList();
        }
        this.headerParam.add(element);
    }

    public boolean removeHeaderParam(JOSEHeader element) {
        if (element == null || this.headerParam == null) {
            return false;
        }
        return this.headerParam.remove(element);
    }

    @XMLInfo(elementType="element", elementName="HeaderParam", elementOrder=6, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="header-param", refType="", isEnumeration=false, javaName="headerParam", javaType="JOSEHeader", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Header Parameters", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<JOSEHeader> getHeaderParam() {
        return this.headerParam;
    }

    @XMLInfo(elementType="element", elementName="HeaderParam", elementOrder=6, dataPowerType="dmJOSEHeader", subType="", benign=false, isPassword=false, cliAlias="header-param", refType="", isEnumeration=false, javaName="headerParam", javaType="JOSEHeader", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Header Parameters", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHeaderParam(ArrayList<JOSEHeader> headerParam) {
        this.headerParam = headerParam;
    }

    @XMLInfo(elementType="element", elementName="Verify", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="verify", refType="", isEnumeration=true, javaName="verify", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Verify (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.5.0", isObsolete=false, obsoletedIn="")
    public String getVerify() {
        return this.verify;
    }

    @XMLInfo(elementType="element", elementName="Verify", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="verify", refType="", isEnumeration=true, javaName="verify", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Verify (deprecated)", units="", label="", multiplicity=1, status="deprecated", isDeprecated=true, deprecatedIn="7.5.0", isObsolete=false, obsoletedIn="")
    public void setVerify(String verify) {
        if (Comparison.isIn(verify, DPEnumerations.TOGGLE)) {
            this.verify = verify;
        }
    }

    @Override
    public int compareTo(ConfigJOSESignatureIdentifier that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "type", "sSKey", "certificate", "validAlgorithms", "headerParam", "verify");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.type, this.sSKey, this.certificate, this.validAlgorithms, this.headerParam, this.verify);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "type", "sSKey", "certificate", "validAlgorithms", "headerParam", "verify");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "type", "sSKey", "certificate", "validAlgorithms", "headerParam", "verify"));
    }
}

