/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.config.ConfigAccessControl;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigLDAPSearchParameters
extends ConfigAccessControl {
    private String userSummary;
    private String lDAPBaseDN;
    private String lDAPReturnedAttribute;
    private String lDAPFilterPrefix;
    private String lDAPFilterSuffix;
    private String lDAPScope;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="LDAPBaseDN", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="base-dn", refType="", isEnumeration=false, javaName="lDAPBaseDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP base DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPBaseDN() {
        return this.lDAPBaseDN;
    }

    @XMLInfo(elementType="element", elementName="LDAPBaseDN", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="base-dn", refType="", isEnumeration=false, javaName="lDAPBaseDN", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP base DN", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPBaseDN(String lDAPBaseDN) {
        this.lDAPBaseDN = lDAPBaseDN;
    }

    @XMLInfo(elementType="element", elementName="LDAPReturnedAttribute", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="returned-attribute", refType="", isEnumeration=false, javaName="lDAPReturnedAttribute", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="dn", displayOrder=0, displayValue="LDAP returned attribute", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPReturnedAttribute() {
        return this.lDAPReturnedAttribute;
    }

    @XMLInfo(elementType="element", elementName="LDAPReturnedAttribute", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="returned-attribute", refType="", isEnumeration=false, javaName="lDAPReturnedAttribute", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="dn", displayValue="LDAP returned attribute", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPReturnedAttribute(String lDAPReturnedAttribute) {
        this.lDAPReturnedAttribute = lDAPReturnedAttribute;
    }

    @XMLInfo(elementType="element", elementName="LDAPFilterPrefix", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="filter-prefix", refType="", isEnumeration=false, javaName="lDAPFilterPrefix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP filter prefix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPFilterPrefix() {
        return this.lDAPFilterPrefix;
    }

    @XMLInfo(elementType="element", elementName="LDAPFilterPrefix", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="filter-prefix", refType="", isEnumeration=false, javaName="lDAPFilterPrefix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP filter prefix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPFilterPrefix(String lDAPFilterPrefix) {
        this.lDAPFilterPrefix = lDAPFilterPrefix;
    }

    @XMLInfo(elementType="element", elementName="LDAPFilterSuffix", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="filter-suffix", refType="", isEnumeration=false, javaName="lDAPFilterSuffix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="LDAP filter suffix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPFilterSuffix() {
        return this.lDAPFilterSuffix;
    }

    @XMLInfo(elementType="element", elementName="LDAPFilterSuffix", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="filter-suffix", refType="", isEnumeration=false, javaName="lDAPFilterSuffix", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="LDAP filter suffix", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPFilterSuffix(String lDAPFilterSuffix) {
        this.lDAPFilterSuffix = lDAPFilterSuffix;
    }

    @XMLInfo(elementType="element", elementName="LDAPScope", elementOrder=6, dataPowerType="dmLDAPSearchScope", subType="", benign=false, isPassword=false, cliAlias="scope", refType="", isEnumeration=true, javaName="lDAPScope", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="subtree", displayOrder=0, displayValue="LDAP scope", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLDAPScope() {
        return this.lDAPScope;
    }

    @XMLInfo(elementType="element", elementName="LDAPScope", elementOrder=6, dataPowerType="dmLDAPSearchScope", subType="", benign=false, isPassword=false, cliAlias="scope", refType="", isEnumeration=true, javaName="lDAPScope", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="subtree", displayValue="LDAP scope", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLDAPScope(String lDAPScope) {
        if (lDAPScope == null || Comparison.isIn(lDAPScope, DPEnumerations.LDAPSEARCH_SCOPE)) {
            this.lDAPScope = lDAPScope;
        }
    }

    @Override
    public int compareTo(ConfigLDAPSearchParameters that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "lDAPBaseDN", "lDAPReturnedAttribute", "lDAPFilterPrefix", "lDAPFilterSuffix", "lDAPScope");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.lDAPBaseDN, this.lDAPReturnedAttribute, this.lDAPFilterPrefix, this.lDAPFilterSuffix, this.lDAPScope);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "lDAPBaseDN", "lDAPReturnedAttribute", "lDAPFilterPrefix", "lDAPFilterSuffix", "lDAPScope");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "lDAPBaseDN", "lDAPReturnedAttribute", "lDAPFilterPrefix", "lDAPFilterSuffix", "lDAPScope"));
    }
}

