/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigNFSStaticMount
extends ConfigConfigBase {
    private String userSummary;
    private String remote;
    private String localFilesystemAccess;
    private long version;
    private String transport;
    private String mountType;
    private String readOnly;
    private long readSize;
    private long writeSize;
    private long timeout;
    private long retransmissions;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="remote", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="remote", refType="", isEnumeration=false, javaName="remote", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^:/]+:/[^/]*(/[^/]+)*$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Remote NFS export", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRemote() {
        return this.remote;
    }

    @XMLInfo(elementType="element", elementName="remote", elementOrder=2, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="remote", refType="", isEnumeration=false, javaName="remote", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^[^:/]+:/[^/]*(/[^/]+)*$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Remote NFS export", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRemote(String remote) {
        if (remote != null && remote.matches("^[^:/]+:/[^/]*(/[^/]+)*$")) {
            this.remote = remote;
        }
    }

    @XMLInfo(elementType="element", elementName="LocalFilesystemAccess", elementOrder=3, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="local-filesystem-access", refType="", isEnumeration=true, javaName="localFilesystemAccess", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Local file system access", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLocalFilesystemAccess() {
        return this.localFilesystemAccess;
    }

    @XMLInfo(elementType="element", elementName="LocalFilesystemAccess", elementOrder=3, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="local-filesystem-access", refType="", isEnumeration=true, javaName="localFilesystemAccess", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Local file system access", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLocalFilesystemAccess(String localFilesystemAccess) {
        if (localFilesystemAccess == null || Comparison.isIn(localFilesystemAccess, DPEnumerations.TOGGLE)) {
            this.localFilesystemAccess = localFilesystemAccess;
        }
    }

    @XMLInfo(elementType="element", elementName="Version", elementOrder=4, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="version", refType="", isEnumeration=false, javaName="version", javaType="long", isRequired=false, squelchNull=false, minimum=2, maximum=4L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="3", displayOrder=0, displayValue="NFS version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getVersion() {
        return this.version;
    }

    @XMLInfo(elementType="element", elementName="Version", elementOrder=4, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="version", refType="", isEnumeration=false, javaName="version", javaType="long", isRequired=false, squelchNull=false, minimum=2, maximum=4L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="3", displayValue="NFS version", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setVersion(long version) {
        this.version = version;
    }

    @XMLInfo(elementType="element", elementName="Transport", elementOrder=5, dataPowerType="dmNFSTransportType", subType="", benign=false, isPassword=false, cliAlias="transport", refType="", isEnumeration=true, javaName="transport", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="tcp", displayOrder=0, displayValue="Transport protocol", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTransport() {
        return this.transport;
    }

    @XMLInfo(elementType="element", elementName="Transport", elementOrder=5, dataPowerType="dmNFSTransportType", subType="", benign=false, isPassword=false, cliAlias="transport", refType="", isEnumeration=true, javaName="transport", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="tcp", displayValue="Transport protocol", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTransport(String transport) {
        if (transport == null || Comparison.isIn(transport, DPEnumerations.NFSTRANSPORT_TYPE)) {
            this.transport = transport;
        }
    }

    @XMLInfo(elementType="element", elementName="MountType", elementOrder=6, dataPowerType="dmNFSMountHardSoft", subType="", benign=false, isPassword=false, cliAlias="mount-type", refType="", isEnumeration=true, javaName="mountType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="hard", displayOrder=0, displayValue="Mount type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMountType() {
        return this.mountType;
    }

    @XMLInfo(elementType="element", elementName="MountType", elementOrder=6, dataPowerType="dmNFSMountHardSoft", subType="", benign=false, isPassword=false, cliAlias="mount-type", refType="", isEnumeration=true, javaName="mountType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="hard", displayValue="Mount type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMountType(String mountType) {
        if (mountType == null || Comparison.isIn(mountType, DPEnumerations.NFSMOUNT_HARD_SOFT)) {
            this.mountType = mountType;
        }
    }

    @XMLInfo(elementType="element", elementName="ReadOnly", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="read-only", refType="", isEnumeration=true, javaName="readOnly", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Read-Only", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getReadOnly() {
        return this.readOnly;
    }

    @XMLInfo(elementType="element", elementName="ReadOnly", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="read-only", refType="", isEnumeration=true, javaName="readOnly", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Read-Only", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setReadOnly(String readOnly) {
        if (readOnly == null || Comparison.isIn(readOnly, DPEnumerations.TOGGLE)) {
            this.readOnly = readOnly;
        }
    }

    @XMLInfo(elementType="element", elementName="ReadSize", elementOrder=8, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="rsize", refType="", isEnumeration=false, javaName="readSize", javaType="long", isRequired=false, squelchNull=false, minimum=1024, maximum=32768L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="4096", displayOrder=0, displayValue="Read size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getReadSize() {
        return this.readSize;
    }

    @XMLInfo(elementType="element", elementName="ReadSize", elementOrder=8, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="rsize", refType="", isEnumeration=false, javaName="readSize", javaType="long", isRequired=false, squelchNull=false, minimum=1024, maximum=32768L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="4096", displayValue="Read size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setReadSize(long readSize) {
        this.readSize = readSize;
    }

    @XMLInfo(elementType="element", elementName="WriteSize", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="wsize", refType="", isEnumeration=false, javaName="writeSize", javaType="long", isRequired=false, squelchNull=false, minimum=1024, maximum=32768L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="4096", displayOrder=0, displayValue="Write size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getWriteSize() {
        return this.writeSize;
    }

    @XMLInfo(elementType="element", elementName="WriteSize", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="wsize", refType="", isEnumeration=false, javaName="writeSize", javaType="long", isRequired=false, squelchNull=false, minimum=1024, maximum=32768L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="4096", displayValue="Write size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setWriteSize(long writeSize) {
        this.writeSize = writeSize;
    }

    @XMLInfo(elementType="element", elementName="Timeout", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="timeo", refType="", isEnumeration=false, javaName="timeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=600L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="7", displayOrder=0, displayValue="Retransmission timeout", units="tenths of seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getTimeout() {
        return this.timeout;
    }

    @XMLInfo(elementType="element", elementName="Timeout", elementOrder=10, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="timeo", refType="", isEnumeration=false, javaName="timeout", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=600L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="7", displayValue="Retransmission timeout", units="tenths of seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @XMLInfo(elementType="element", elementName="Retransmissions", elementOrder=11, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="retrans", refType="", isEnumeration=false, javaName="retransmissions", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=60L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="3", displayOrder=0, displayValue="Max retransmissions", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getRetransmissions() {
        return this.retransmissions;
    }

    @XMLInfo(elementType="element", elementName="Retransmissions", elementOrder=11, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="retrans", refType="", isEnumeration=false, javaName="retransmissions", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=60L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="3", displayValue="Max retransmissions", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRetransmissions(long retransmissions) {
        this.retransmissions = retransmissions;
    }

    @Override
    public int compareTo(ConfigNFSStaticMount that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "remote", "localFilesystemAccess", "version", "transport", "mountType", "readOnly", "readSize", "writeSize", "timeout", "retransmissions");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.remote, this.localFilesystemAccess, this.version, this.transport, this.mountType, this.readOnly, this.readSize, this.writeSize, this.timeout, this.retransmissions);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "remote", "localFilesystemAccess", "version", "transport", "mountType", "readOnly", "readSize", "writeSize", "timeout", "retransmissions");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "remote", "localFilesystemAccess", "version", "transport", "mountType", "readOnly", "readSize", "writeSize", "timeout", "retransmissions"));
    }
}

