/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.ValidationType;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigNameValueProfile
extends ConfigConfigBase {
    private String userSummary;
    private long maxAttributes;
    private long maxAggregateSize;
    private long maxNameSize;
    private long maxValueSize;
    private ArrayList<ValidationType> validationList;
    private String defaultFixup;
    private String defaultMapValue;
    private String defaultXSS;
    private String noMatchXSSPatternsFile;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="MaxAttributes", elementOrder=2, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-attributes", refType="", isEnumeration=false, javaName="maxAttributes", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="256", displayOrder=0, displayValue="Maximum Count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxAttributes() {
        return this.maxAttributes;
    }

    @XMLInfo(elementType="element", elementName="MaxAttributes", elementOrder=2, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-attributes", refType="", isEnumeration=false, javaName="maxAttributes", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="256", displayValue="Maximum Count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxAttributes(long maxAttributes) {
        this.maxAttributes = maxAttributes;
    }

    @XMLInfo(elementType="element", elementName="MaxAggregateSize", elementOrder=3, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-aggregate-size", refType="", isEnumeration=false, javaName="maxAggregateSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="128000", displayOrder=0, displayValue="Total Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxAggregateSize() {
        return this.maxAggregateSize;
    }

    @XMLInfo(elementType="element", elementName="MaxAggregateSize", elementOrder=3, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-aggregate-size", refType="", isEnumeration=false, javaName="maxAggregateSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="128000", displayValue="Total Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxAggregateSize(long maxAggregateSize) {
        this.maxAggregateSize = maxAggregateSize;
    }

    @XMLInfo(elementType="element", elementName="MaxNameSize", elementOrder=4, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-name-size", refType="", isEnumeration=false, javaName="maxNameSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="512", displayOrder=0, displayValue="Maximum Name Length", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxNameSize() {
        return this.maxNameSize;
    }

    @XMLInfo(elementType="element", elementName="MaxNameSize", elementOrder=4, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-name-size", refType="", isEnumeration=false, javaName="maxNameSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="512", displayValue="Maximum Name Length", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxNameSize(long maxNameSize) {
        this.maxNameSize = maxNameSize;
    }

    @XMLInfo(elementType="element", elementName="MaxValueSize", elementOrder=5, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-value-size", refType="", isEnumeration=false, javaName="maxValueSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1024", displayOrder=0, displayValue="Maximum Value Length", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxValueSize() {
        return this.maxValueSize;
    }

    @XMLInfo(elementType="element", elementName="MaxValueSize", elementOrder=5, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="max-value-size", refType="", isEnumeration=false, javaName="maxValueSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1024", displayValue="Maximum Value Length", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxValueSize(long maxValueSize) {
        this.maxValueSize = maxValueSize;
    }

    public void addValidationList(ValidationType element) {
        if (element == null) {
            return;
        }
        if (this.validationList == null) {
            this.validationList = new ArrayList();
        }
        this.validationList.add(element);
    }

    public boolean removeValidationList(ValidationType element) {
        if (element == null || this.validationList == null) {
            return false;
        }
        return this.validationList.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ValidationList", elementOrder=6, dataPowerType="dmValidationType", subType="", benign=false, isPassword=false, cliAlias="validation", refType="", isEnumeration=false, javaName="validationList", javaType="ValidationType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Validation List", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ValidationType> getValidationList() {
        return this.validationList;
    }

    @XMLInfo(elementType="element", elementName="ValidationList", elementOrder=6, dataPowerType="dmValidationType", subType="", benign=false, isPassword=false, cliAlias="validation", refType="", isEnumeration=false, javaName="validationList", javaType="ValidationType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Validation List", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setValidationList(ArrayList<ValidationType> validationList) {
        this.validationList = validationList;
    }

    @XMLInfo(elementType="element", elementName="DefaultFixup", elementOrder=7, dataPowerType="dmValidationFixupType", subType="", benign=false, isPassword=false, cliAlias="unvalidated-fixup-policy", refType="", isEnumeration=true, javaName="defaultFixup", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="strip", displayOrder=0, displayValue="No Match Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDefaultFixup() {
        return this.defaultFixup;
    }

    @XMLInfo(elementType="element", elementName="DefaultFixup", elementOrder=7, dataPowerType="dmValidationFixupType", subType="", benign=false, isPassword=false, cliAlias="unvalidated-fixup-policy", refType="", isEnumeration=true, javaName="defaultFixup", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="strip", displayValue="No Match Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDefaultFixup(String defaultFixup) {
        if (Comparison.isIn(defaultFixup, DPEnumerations.VALIDATION_FIXUP_TYPE)) {
            this.defaultFixup = defaultFixup;
        }
    }

    @XMLInfo(elementType="element", elementName="DefaultMapValue", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="unvalidated-fixup-map", refType="", isEnumeration=false, javaName="defaultMapValue", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="No Match Map Value", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDefaultMapValue() {
        return this.defaultMapValue;
    }

    @XMLInfo(elementType="element", elementName="DefaultMapValue", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="unvalidated-fixup-map", refType="", isEnumeration=false, javaName="defaultMapValue", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="No Match Map Value", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDefaultMapValue(String defaultMapValue) {
        this.defaultMapValue = defaultMapValue;
    }

    @XMLInfo(elementType="element", elementName="DefaultXSS", elementOrder=9, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="unvalidated-xss-check", refType="", isEnumeration=true, javaName="defaultXSS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="No Match XSS Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDefaultXSS() {
        return this.defaultXSS;
    }

    @XMLInfo(elementType="element", elementName="DefaultXSS", elementOrder=9, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="unvalidated-xss-check", refType="", isEnumeration=true, javaName="defaultXSS", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="No Match XSS Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDefaultXSS(String defaultXSS) {
        if (defaultXSS == null || Comparison.isIn(defaultXSS, DPEnumerations.TOGGLE)) {
            this.defaultXSS = defaultXSS;
        }
    }

    @XMLInfo(elementType="element", elementName="NoMatchXSSPatternsFile", elementOrder=10, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="unvalidated-xss-patternsfile", refType="", isEnumeration=false, javaName="noMatchXSSPatternsFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="store:///XSS-Patterns.xml", displayOrder=0, displayValue="XSS (Cross Site Scripting) Protection Patterns File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getNoMatchXSSPatternsFile() {
        return this.noMatchXSSPatternsFile;
    }

    @XMLInfo(elementType="element", elementName="NoMatchXSSPatternsFile", elementOrder=10, dataPowerType="dmFSFile", subType="", benign=false, isPassword=false, cliAlias="unvalidated-xss-patternsfile", refType="", isEnumeration=false, javaName="noMatchXSSPatternsFile", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="store:///XSS-Patterns.xml", displayValue="XSS (Cross Site Scripting) Protection Patterns File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setNoMatchXSSPatternsFile(String noMatchXSSPatternsFile) {
        this.noMatchXSSPatternsFile = noMatchXSSPatternsFile;
    }

    @Override
    public int compareTo(ConfigNameValueProfile that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "maxAttributes", "maxAggregateSize", "maxNameSize", "maxValueSize", "validationList", "defaultFixup", "defaultMapValue", "defaultXSS", "noMatchXSSPatternsFile");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.maxAttributes, this.maxAggregateSize, this.maxNameSize, this.maxValueSize, this.validationList, this.defaultFixup, this.defaultMapValue, this.defaultXSS, this.noMatchXSSPatternsFile);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "maxAttributes", "maxAggregateSize", "maxNameSize", "maxValueSize", "validationList", "defaultFixup", "defaultMapValue", "defaultXSS", "noMatchXSSPatternsFile");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "maxAttributes", "maxAggregateSize", "maxNameSize", "maxValueSize", "validationList", "defaultFixup", "defaultMapValue", "defaultXSS", "noMatchXSSPatternsFile"));
    }
}

