/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigAPISecurityTokenManager;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigCryptoSSKey;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.types.AllowedClientType;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.MetadataFromType;
import com.kumbasoft.core.beans.types.OAuthProviderGrantType;
import com.kumbasoft.core.beans.types.OIDCHybridResponseType;
import com.kumbasoft.core.beans.types.SecurityType;
import java.util.Objects;

public class ConfigOAuthProviderSettings
extends ConfigConfigBase {
    private String userSummary;
    private String enableDebugMode;
    private String providerType;
    private String scopesAllowed;
    private String defaultScopes;
    private OAuthProviderGrantType supportedGrantTypes;
    private AllowedClientType supportedClientTypes;
    private String aPICProviderBasePath;
    private String aPICAuthorizeEndpoint;
    private String aPICTokenEndpoint;
    private String aPICEnableIntrospection;
    private String aPICIntrospectEndpoint;
    private ObjectReference<ConfigCryptoSSKey> aPICTokenSecret;
    private String aPICOneTimeUseAccesstoken;
    private long aPICAccessTokenTTL;
    private long aPICAuthCodeTTL;
    private String aPICEnableRefreshToken;
    private String aPICOneTimeUseRefreshtoken;
    private long aPICRefreshTokenLimit;
    private long aPICRefreshTokenTTL;
    private long aPICMaximumConsentTTL;
    private String advScopeValidationEnabled;
    private String advancedScopeURLOverride;
    private String advancedScopeURL;
    private ObjectReference<ConfigSSLClientProfile> advScopeTLSProfile;
    private String advScopeURLSecurityEnabled;
    private SecurityType advScopeURLSecurity;
    private String advScopeBasicAuthUserName;
    private ObjectReference<ConfigPasswordAlias> advScopeBasicAuthPassword;
    private String advScopeBasicAuthHeaderName;
    private String advancedScopeCustomHeaders;
    private String advancedScopeCustomContexts;
    private String aPICEnableOIDC;
    private OIDCHybridResponseType aPICOIDCHybridResponseTypes;
    private String aPICSupportPKCE;
    private String aPICRequirePKCE;
    private String aPICSupportPKCEPlain;
    private String aPICTokenTypeToGenerate;
    private MetadataFromType metadataFrom;
    private String metadataURL;
    private ObjectReference<ConfigSSLClientProfile> metadataSSLProfile;
    private String metadataHeaderForAccessToken;
    private String metadataHeaderForPayload;
    private String externalRevocationURL;
    private ObjectReference<ConfigSSLClientProfile> externalRevocationSSLProfile;
    private SecurityType externalRevocationURLSecurity;
    private String externalRevocationBasicAuthUserName;
    private ObjectReference<ConfigPasswordAlias> externalRevocationBasicAuthPassword;
    private String externalRevocationBasicAuthHeaderName;
    private String externalRevocationCustomHeaderFormat;
    private String externalRevocationCacheType;
    private long externalRevocationCacheTimeToLive;
    private String externalRevocationFailOnError;
    private String enableTokenManagement;
    private String tokenManagerType;
    private ObjectReference<ConfigAPISecurityTokenManager> aPISecurityTokenManager;
    private String enableApplicationRevocation;
    private String applicationRevocationEndpoint;
    private String enableOwnerRevocation;
    private String ownerRevocationEndpoint;
    private String tokenValidationReq;
    private String thirdPartyAZURL;
    private String thirdPartyTokenURL;
    private String thirdPartyIntrospectURL;
    private String thirdPartyIntrospectCacheType;
    private long thirdPartyIntrospectCacheTimeToLive;
    private String thirdPartyAuthorizationHeaderPassThru;
    private SecurityType thirdPartyIntrospectURLSecurity;
    private String thirdPartyIntrospectBasicAuthUserName;
    private ObjectReference<ConfigPasswordAlias> thirdPartyIntrospectBasicAuthPassword;
    private String thirdPartyBasicAuthHeaderName;
    private String thirdPartyCustomHeaderNameFormat;
    private ObjectReference<ConfigSSLClientProfile> thirdPartyIntrospectSSLProfile;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="EnableDebugMode", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-debug-mode", refType="", isEnumeration=true, javaName="enableDebugMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable debug headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnableDebugMode() {
        return this.enableDebugMode;
    }

    @XMLInfo(elementType="element", elementName="EnableDebugMode", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-debug-mode", refType="", isEnumeration=true, javaName="enableDebugMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable debug headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnableDebugMode(String enableDebugMode) {
        if (enableDebugMode == null || Comparison.isIn(enableDebugMode, DPEnumerations.TOGGLE)) {
            this.enableDebugMode = enableDebugMode;
        }
    }

    @XMLInfo(elementType="element", elementName="ProviderType", elementOrder=3, dataPowerType="dmOAuthProviderType", subType="", benign=false, isPassword=false, cliAlias="provider-type", refType="", isEnumeration=true, javaName="providerType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Provider type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getProviderType() {
        return this.providerType;
    }

    @XMLInfo(elementType="element", elementName="ProviderType", elementOrder=3, dataPowerType="dmOAuthProviderType", subType="", benign=false, isPassword=false, cliAlias="provider-type", refType="", isEnumeration=true, javaName="providerType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Provider type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setProviderType(String providerType) {
        if (Comparison.isIn(providerType, DPEnumerations.OAUTH_PROVIDER_TYPE)) {
            this.providerType = providerType;
        }
    }

    @XMLInfo(elementType="element", elementName="ScopesAllowed", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="scopes-allowed", refType="", isEnumeration=false, javaName="scopesAllowed", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Allowed scopes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getScopesAllowed() {
        return this.scopesAllowed;
    }

    @XMLInfo(elementType="element", elementName="ScopesAllowed", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="scopes-allowed", refType="", isEnumeration=false, javaName="scopesAllowed", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Allowed scopes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setScopesAllowed(String scopesAllowed) {
        this.scopesAllowed = scopesAllowed;
    }

    @XMLInfo(elementType="element", elementName="DefaultScopes", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="default-scopes", refType="", isEnumeration=false, javaName="defaultScopes", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Default scopes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDefaultScopes() {
        return this.defaultScopes;
    }

    @XMLInfo(elementType="element", elementName="DefaultScopes", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="default-scopes", refType="", isEnumeration=false, javaName="defaultScopes", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Default scopes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDefaultScopes(String defaultScopes) {
        this.defaultScopes = defaultScopes;
    }

    @XMLInfo(elementType="element", elementName="SupportedGrantTypes", elementOrder=6, dataPowerType="dmOAuthProviderGrantType", subType="", benign=false, isPassword=false, cliAlias="supported-grant-types", refType="", isEnumeration=false, javaName="supportedGrantTypes", javaType="OAuthProviderGrantType", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Supported grant types", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public OAuthProviderGrantType getSupportedGrantTypes() {
        return this.supportedGrantTypes;
    }

    @XMLInfo(elementType="element", elementName="SupportedGrantTypes", elementOrder=6, dataPowerType="dmOAuthProviderGrantType", subType="", benign=false, isPassword=false, cliAlias="supported-grant-types", refType="", isEnumeration=false, javaName="supportedGrantTypes", javaType="OAuthProviderGrantType", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Supported grant types", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSupportedGrantTypes(OAuthProviderGrantType supportedGrantTypes) {
        this.supportedGrantTypes = supportedGrantTypes;
    }

    @XMLInfo(elementType="element", elementName="SupportedClientTypes", elementOrder=7, dataPowerType="dmAllowedClientType", subType="", benign=false, isPassword=false, cliAlias="supported-client-types", refType="", isEnumeration=false, javaName="supportedClientTypes", javaType="AllowedClientType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Supported client types", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public AllowedClientType getSupportedClientTypes() {
        return this.supportedClientTypes;
    }

    @XMLInfo(elementType="element", elementName="SupportedClientTypes", elementOrder=7, dataPowerType="dmAllowedClientType", subType="", benign=false, isPassword=false, cliAlias="supported-client-types", refType="", isEnumeration=false, javaName="supportedClientTypes", javaType="AllowedClientType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Supported client types", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSupportedClientTypes(AllowedClientType supportedClientTypes) {
        this.supportedClientTypes = supportedClientTypes;
    }

    @XMLInfo(elementType="element", elementName="APICProviderBasePath", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-provider-base-path", refType="", isEnumeration=false, javaName="aPICProviderBasePath", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="/", displayOrder=0, displayValue="Provider base path", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICProviderBasePath() {
        return this.aPICProviderBasePath;
    }

    @XMLInfo(elementType="element", elementName="APICProviderBasePath", elementOrder=8, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-provider-base-path", refType="", isEnumeration=false, javaName="aPICProviderBasePath", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="/", displayValue="Provider base path", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICProviderBasePath(String aPICProviderBasePath) {
        this.aPICProviderBasePath = aPICProviderBasePath;
    }

    @XMLInfo(elementType="element", elementName="APICAuthorizeEndpoint", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-authorize-endpoint", refType="", isEnumeration=false, javaName="aPICAuthorizeEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="/oauth2/authorize", displayOrder=0, displayValue="Authorization endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICAuthorizeEndpoint() {
        return this.aPICAuthorizeEndpoint;
    }

    @XMLInfo(elementType="element", elementName="APICAuthorizeEndpoint", elementOrder=9, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-authorize-endpoint", refType="", isEnumeration=false, javaName="aPICAuthorizeEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="/oauth2/authorize", displayValue="Authorization endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICAuthorizeEndpoint(String aPICAuthorizeEndpoint) {
        this.aPICAuthorizeEndpoint = aPICAuthorizeEndpoint;
    }

    @XMLInfo(elementType="element", elementName="APICTokenEndpoint", elementOrder=10, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-token-endpoint", refType="", isEnumeration=false, javaName="aPICTokenEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="/oauth2/token", displayOrder=0, displayValue="Token endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICTokenEndpoint() {
        return this.aPICTokenEndpoint;
    }

    @XMLInfo(elementType="element", elementName="APICTokenEndpoint", elementOrder=10, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-token-endpoint", refType="", isEnumeration=false, javaName="aPICTokenEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="/oauth2/token", displayValue="Token endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICTokenEndpoint(String aPICTokenEndpoint) {
        this.aPICTokenEndpoint = aPICTokenEndpoint;
    }

    @XMLInfo(elementType="element", elementName="APICEnableIntrospection", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-enable-introspection", refType="", isEnumeration=true, javaName="aPICEnableIntrospection", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable token introspection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICEnableIntrospection() {
        return this.aPICEnableIntrospection;
    }

    @XMLInfo(elementType="element", elementName="APICEnableIntrospection", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-enable-introspection", refType="", isEnumeration=true, javaName="aPICEnableIntrospection", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable token introspection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICEnableIntrospection(String aPICEnableIntrospection) {
        if (aPICEnableIntrospection == null || Comparison.isIn(aPICEnableIntrospection, DPEnumerations.TOGGLE)) {
            this.aPICEnableIntrospection = aPICEnableIntrospection;
        }
    }

    @XMLInfo(elementType="element", elementName="APICIntrospectEndpoint", elementOrder=12, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-introspect-endpoint", refType="", isEnumeration=false, javaName="aPICIntrospectEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="/oauth2/introspect", displayOrder=0, displayValue="Introspection endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICIntrospectEndpoint() {
        return this.aPICIntrospectEndpoint;
    }

    @XMLInfo(elementType="element", elementName="APICIntrospectEndpoint", elementOrder=12, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-introspect-endpoint", refType="", isEnumeration=false, javaName="aPICIntrospectEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="/oauth2/introspect", displayValue="Introspection endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICIntrospectEndpoint(String aPICIntrospectEndpoint) {
        this.aPICIntrospectEndpoint = aPICIntrospectEndpoint;
    }

    @XMLInfo(elementType="element", elementName="APICTokenSecret", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="apic-token-secret", refType="CryptoSSKey", isEnumeration=false, javaName="aPICTokenSecret", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Token secret", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoSSKey> getAPICTokenSecret() {
        return this.aPICTokenSecret;
    }

    @XMLInfo(elementType="element", elementName="APICTokenSecret", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="apic-token-secret", refType="CryptoSSKey", isEnumeration=false, javaName="aPICTokenSecret", javaType="ObjectReference<ConfigCryptoSSKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Token secret", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICTokenSecret(ObjectReference<ConfigCryptoSSKey> aPICTokenSecret) {
        this.aPICTokenSecret = aPICTokenSecret;
    }

    @XMLInfo(elementType="element", elementName="APICOneTimeUseAccesstoken", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-enable-one-time-use-access-token", refType="", isEnumeration=true, javaName="aPICOneTimeUseAccesstoken", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="One-time use access token", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICOneTimeUseAccesstoken() {
        return this.aPICOneTimeUseAccesstoken;
    }

    @XMLInfo(elementType="element", elementName="APICOneTimeUseAccesstoken", elementOrder=14, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-enable-one-time-use-access-token", refType="", isEnumeration=true, javaName="aPICOneTimeUseAccesstoken", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="One-time use access token", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICOneTimeUseAccesstoken(String aPICOneTimeUseAccesstoken) {
        if (aPICOneTimeUseAccesstoken == null || Comparison.isIn(aPICOneTimeUseAccesstoken, DPEnumerations.TOGGLE)) {
            this.aPICOneTimeUseAccesstoken = aPICOneTimeUseAccesstoken;
        }
    }

    @XMLInfo(elementType="element", elementName="APICAccessTokenTTL", elementOrder=15, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="apic-access-token-ttl", refType="", isEnumeration=false, javaName="aPICAccessTokenTTL", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=63244800L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="3600", displayOrder=0, displayValue="Access token TTL", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getAPICAccessTokenTTL() {
        return this.aPICAccessTokenTTL;
    }

    @XMLInfo(elementType="element", elementName="APICAccessTokenTTL", elementOrder=15, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="apic-access-token-ttl", refType="", isEnumeration=false, javaName="aPICAccessTokenTTL", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=63244800L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="3600", displayValue="Access token TTL", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICAccessTokenTTL(long aPICAccessTokenTTL) {
        this.aPICAccessTokenTTL = aPICAccessTokenTTL;
    }

    @XMLInfo(elementType="element", elementName="APICAuthCodeTTL", elementOrder=16, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="apic-auth-code-ttl", refType="", isEnumeration=false, javaName="aPICAuthCodeTTL", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=600L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="300", displayOrder=0, displayValue="Authorization code TTL", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getAPICAuthCodeTTL() {
        return this.aPICAuthCodeTTL;
    }

    @XMLInfo(elementType="element", elementName="APICAuthCodeTTL", elementOrder=16, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="apic-auth-code-ttl", refType="", isEnumeration=false, javaName="aPICAuthCodeTTL", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=600L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="300", displayValue="Authorization code TTL", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICAuthCodeTTL(long aPICAuthCodeTTL) {
        this.aPICAuthCodeTTL = aPICAuthCodeTTL;
    }

    @XMLInfo(elementType="element", elementName="APICEnableRefreshToken", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-enable-refresh-token", refType="", isEnumeration=true, javaName="aPICEnableRefreshToken", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable refresh tokens", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICEnableRefreshToken() {
        return this.aPICEnableRefreshToken;
    }

    @XMLInfo(elementType="element", elementName="APICEnableRefreshToken", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-enable-refresh-token", refType="", isEnumeration=true, javaName="aPICEnableRefreshToken", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable refresh tokens", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICEnableRefreshToken(String aPICEnableRefreshToken) {
        if (aPICEnableRefreshToken == null || Comparison.isIn(aPICEnableRefreshToken, DPEnumerations.TOGGLE)) {
            this.aPICEnableRefreshToken = aPICEnableRefreshToken;
        }
    }

    @XMLInfo(elementType="element", elementName="APICOneTimeUseRefreshtoken", elementOrder=18, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-enable-one-time-use-refresh-token", refType="", isEnumeration=true, javaName="aPICOneTimeUseRefreshtoken", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="One-time use refresh token", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICOneTimeUseRefreshtoken() {
        return this.aPICOneTimeUseRefreshtoken;
    }

    @XMLInfo(elementType="element", elementName="APICOneTimeUseRefreshtoken", elementOrder=18, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-enable-one-time-use-refresh-token", refType="", isEnumeration=true, javaName="aPICOneTimeUseRefreshtoken", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="One-time use refresh token", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICOneTimeUseRefreshtoken(String aPICOneTimeUseRefreshtoken) {
        if (aPICOneTimeUseRefreshtoken == null || Comparison.isIn(aPICOneTimeUseRefreshtoken, DPEnumerations.TOGGLE)) {
            this.aPICOneTimeUseRefreshtoken = aPICOneTimeUseRefreshtoken;
        }
    }

    @XMLInfo(elementType="element", elementName="APICRefreshTokenLimit", elementOrder=19, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="apic-refresh-token-limit", refType="", isEnumeration=false, javaName="aPICRefreshTokenLimit", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=4096L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="10", displayOrder=0, displayValue="APIC refresh token count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getAPICRefreshTokenLimit() {
        return this.aPICRefreshTokenLimit;
    }

    @XMLInfo(elementType="element", elementName="APICRefreshTokenLimit", elementOrder=19, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="apic-refresh-token-limit", refType="", isEnumeration=false, javaName="aPICRefreshTokenLimit", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=4096L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="10", displayValue="APIC refresh token count", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICRefreshTokenLimit(long aPICRefreshTokenLimit) {
        this.aPICRefreshTokenLimit = aPICRefreshTokenLimit;
    }

    @XMLInfo(elementType="element", elementName="APICRefreshTokenTTL", elementOrder=20, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="apic-refresh-token-ttl", refType="", isEnumeration=false, javaName="aPICRefreshTokenTTL", javaType="long", isRequired=false, squelchNull=false, minimum=2, maximum=252979200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="5400", displayOrder=0, displayValue="Refresh token TTL", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getAPICRefreshTokenTTL() {
        return this.aPICRefreshTokenTTL;
    }

    @XMLInfo(elementType="element", elementName="APICRefreshTokenTTL", elementOrder=20, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="apic-refresh-token-ttl", refType="", isEnumeration=false, javaName="aPICRefreshTokenTTL", javaType="long", isRequired=false, squelchNull=false, minimum=2, maximum=252979200L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="5400", displayValue="Refresh token TTL", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICRefreshTokenTTL(long aPICRefreshTokenTTL) {
        this.aPICRefreshTokenTTL = aPICRefreshTokenTTL;
    }

    @XMLInfo(elementType="element", elementName="APICMaximumConsentTTL", elementOrder=21, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="apic-maximum-consent-ttl", refType="", isEnumeration=false, javaName="aPICMaximumConsentTTL", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=2529792000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Consent TTL", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getAPICMaximumConsentTTL() {
        return this.aPICMaximumConsentTTL;
    }

    @XMLInfo(elementType="element", elementName="APICMaximumConsentTTL", elementOrder=21, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="apic-maximum-consent-ttl", refType="", isEnumeration=false, javaName="aPICMaximumConsentTTL", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=2529792000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Consent TTL", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICMaximumConsentTTL(long aPICMaximumConsentTTL) {
        this.aPICMaximumConsentTTL = aPICMaximumConsentTTL;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeValidationEnabled", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-validation-enabled", refType="", isEnumeration=true, javaName="advScopeValidationEnabled", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable advanced scope validation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAdvScopeValidationEnabled() {
        return this.advScopeValidationEnabled;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeValidationEnabled", elementOrder=22, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-validation-enabled", refType="", isEnumeration=true, javaName="advScopeValidationEnabled", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable advanced scope validation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdvScopeValidationEnabled(String advScopeValidationEnabled) {
        if (advScopeValidationEnabled == null || Comparison.isIn(advScopeValidationEnabled, DPEnumerations.TOGGLE)) {
            this.advScopeValidationEnabled = advScopeValidationEnabled;
        }
    }

    @XMLInfo(elementType="element", elementName="AdvancedScopeURLOverride", elementOrder=23, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-url-from-security", refType="", isEnumeration=true, javaName="advancedScopeURLOverride", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Use URL from API Security Definition", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAdvancedScopeURLOverride() {
        return this.advancedScopeURLOverride;
    }

    @XMLInfo(elementType="element", elementName="AdvancedScopeURLOverride", elementOrder=23, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-url-from-security", refType="", isEnumeration=true, javaName="advancedScopeURLOverride", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Use URL from API Security Definition", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdvancedScopeURLOverride(String advancedScopeURLOverride) {
        if (advancedScopeURLOverride == null || Comparison.isIn(advancedScopeURLOverride, DPEnumerations.TOGGLE)) {
            this.advancedScopeURLOverride = advancedScopeURLOverride;
        }
    }

    @XMLInfo(elementType="element", elementName="AdvancedScopeURL", elementOrder=24, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-url", refType="", isEnumeration=false, javaName="advancedScopeURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Advanced scope URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAdvancedScopeURL() {
        return this.advancedScopeURL;
    }

    @XMLInfo(elementType="element", elementName="AdvancedScopeURL", elementOrder=24, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-url", refType="", isEnumeration=false, javaName="advancedScopeURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Advanced scope URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdvancedScopeURL(String advancedScopeURL) {
        this.advancedScopeURL = advancedScopeURL;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeTLSProfile", elementOrder=25, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-tls-profile", refType="SSLClientProfile", isEnumeration=false, javaName="advScopeTLSProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS profile to access advanced scope URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getAdvScopeTLSProfile() {
        return this.advScopeTLSProfile;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeTLSProfile", elementOrder=25, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-tls-profile", refType="SSLClientProfile", isEnumeration=false, javaName="advScopeTLSProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS profile to access advanced scope URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdvScopeTLSProfile(ObjectReference<ConfigSSLClientProfile> advScopeTLSProfile) {
        this.advScopeTLSProfile = advScopeTLSProfile;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeURLSecurityEnabled", elementOrder=26, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-url-security-enabled", refType="", isEnumeration=true, javaName="advScopeURLSecurityEnabled", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Enable advanced scope endpoint security", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAdvScopeURLSecurityEnabled() {
        return this.advScopeURLSecurityEnabled;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeURLSecurityEnabled", elementOrder=26, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-url-security-enabled", refType="", isEnumeration=true, javaName="advScopeURLSecurityEnabled", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Enable advanced scope endpoint security", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdvScopeURLSecurityEnabled(String advScopeURLSecurityEnabled) {
        if (advScopeURLSecurityEnabled == null || Comparison.isIn(advScopeURLSecurityEnabled, DPEnumerations.TOGGLE)) {
            this.advScopeURLSecurityEnabled = advScopeURLSecurityEnabled;
        }
    }

    @XMLInfo(elementType="element", elementName="AdvScopeURLSecurity", elementOrder=27, dataPowerType="dmSecurityType", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-url-security", refType="", isEnumeration=false, javaName="advScopeURLSecurity", javaType="SecurityType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="basic-auth", displayOrder=0, displayValue="Advanced scope endpoint security", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public SecurityType getAdvScopeURLSecurity() {
        return this.advScopeURLSecurity;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeURLSecurity", elementOrder=27, dataPowerType="dmSecurityType", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-url-security", refType="", isEnumeration=false, javaName="advScopeURLSecurity", javaType="SecurityType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="basic-auth", displayValue="Advanced scope endpoint security", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdvScopeURLSecurity(SecurityType advScopeURLSecurity) {
        this.advScopeURLSecurity = advScopeURLSecurity;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeBasicAuthUserName", elementOrder=28, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-basic-auth-username", refType="", isEnumeration=false, javaName="advScopeBasicAuthUserName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Basic authentication username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAdvScopeBasicAuthUserName() {
        return this.advScopeBasicAuthUserName;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeBasicAuthUserName", elementOrder=28, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-basic-auth-username", refType="", isEnumeration=false, javaName="advScopeBasicAuthUserName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Basic authentication username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdvScopeBasicAuthUserName(String advScopeBasicAuthUserName) {
        this.advScopeBasicAuthUserName = advScopeBasicAuthUserName;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeBasicAuthPassword", elementOrder=29, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-basic-auth-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="advScopeBasicAuthPassword", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Basic authentication password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getAdvScopeBasicAuthPassword() {
        return this.advScopeBasicAuthPassword;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeBasicAuthPassword", elementOrder=29, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-basic-auth-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="advScopeBasicAuthPassword", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Basic authentication password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdvScopeBasicAuthPassword(ObjectReference<ConfigPasswordAlias> advScopeBasicAuthPassword) {
        this.advScopeBasicAuthPassword = advScopeBasicAuthPassword;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeBasicAuthHeaderName", elementOrder=30, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-basic-auth-headername", refType="", isEnumeration=false, javaName="advScopeBasicAuthHeaderName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Basic authentication header name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAdvScopeBasicAuthHeaderName() {
        return this.advScopeBasicAuthHeaderName;
    }

    @XMLInfo(elementType="element", elementName="AdvScopeBasicAuthHeaderName", elementOrder=30, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-basic-auth-headername", refType="", isEnumeration=false, javaName="advScopeBasicAuthHeaderName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Basic authentication header name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdvScopeBasicAuthHeaderName(String advScopeBasicAuthHeaderName) {
        this.advScopeBasicAuthHeaderName = advScopeBasicAuthHeaderName;
    }

    @XMLInfo(elementType="element", elementName="AdvancedScopeCustomHeaders", elementOrder=31, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-request-headers", refType="", isEnumeration=false, javaName="advancedScopeCustomHeaders", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Request headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAdvancedScopeCustomHeaders() {
        return this.advancedScopeCustomHeaders;
    }

    @XMLInfo(elementType="element", elementName="AdvancedScopeCustomHeaders", elementOrder=31, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-request-headers", refType="", isEnumeration=false, javaName="advancedScopeCustomHeaders", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Request headers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdvancedScopeCustomHeaders(String advancedScopeCustomHeaders) {
        this.advancedScopeCustomHeaders = advancedScopeCustomHeaders;
    }

    @XMLInfo(elementType="element", elementName="AdvancedScopeCustomContexts", elementOrder=32, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-response-contexts", refType="", isEnumeration=false, javaName="advancedScopeCustomContexts", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Response context variables", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAdvancedScopeCustomContexts() {
        return this.advancedScopeCustomContexts;
    }

    @XMLInfo(elementType="element", elementName="AdvancedScopeCustomContexts", elementOrder=32, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="advanced-scope-response-contexts", refType="", isEnumeration=false, javaName="advancedScopeCustomContexts", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Response context variables", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAdvancedScopeCustomContexts(String advancedScopeCustomContexts) {
        this.advancedScopeCustomContexts = advancedScopeCustomContexts;
    }

    @XMLInfo(elementType="element", elementName="APICEnableOIDC", elementOrder=33, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-enable-oidc", refType="", isEnumeration=true, javaName="aPICEnableOIDC", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Enable OIDC", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICEnableOIDC() {
        return this.aPICEnableOIDC;
    }

    @XMLInfo(elementType="element", elementName="APICEnableOIDC", elementOrder=33, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-enable-oidc", refType="", isEnumeration=true, javaName="aPICEnableOIDC", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Enable OIDC", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICEnableOIDC(String aPICEnableOIDC) {
        if (aPICEnableOIDC == null || Comparison.isIn(aPICEnableOIDC, DPEnumerations.TOGGLE)) {
            this.aPICEnableOIDC = aPICEnableOIDC;
        }
    }

    @XMLInfo(elementType="element", elementName="APICOIDCHybridResponseTypes", elementOrder=34, dataPowerType="dmOIDCHybridResponseType", subType="", benign=false, isPassword=false, cliAlias="apic-oidc-hybrid-response-types", refType="", isEnumeration=false, javaName="aPICOIDCHybridResponseTypes", javaType="OIDCHybridResponseType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="OIDC Hybrid Flow Response Types", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public OIDCHybridResponseType getAPICOIDCHybridResponseTypes() {
        return this.aPICOIDCHybridResponseTypes;
    }

    @XMLInfo(elementType="element", elementName="APICOIDCHybridResponseTypes", elementOrder=34, dataPowerType="dmOIDCHybridResponseType", subType="", benign=false, isPassword=false, cliAlias="apic-oidc-hybrid-response-types", refType="", isEnumeration=false, javaName="aPICOIDCHybridResponseTypes", javaType="OIDCHybridResponseType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="OIDC Hybrid Flow Response Types", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICOIDCHybridResponseTypes(OIDCHybridResponseType aPICOIDCHybridResponseTypes) {
        this.aPICOIDCHybridResponseTypes = aPICOIDCHybridResponseTypes;
    }

    @XMLInfo(elementType="element", elementName="APICSupportPKCE", elementOrder=35, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-support-pkce", refType="", isEnumeration=true, javaName="aPICSupportPKCE", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Support PKCE", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICSupportPKCE() {
        return this.aPICSupportPKCE;
    }

    @XMLInfo(elementType="element", elementName="APICSupportPKCE", elementOrder=35, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-support-pkce", refType="", isEnumeration=true, javaName="aPICSupportPKCE", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Support PKCE", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICSupportPKCE(String aPICSupportPKCE) {
        if (aPICSupportPKCE == null || Comparison.isIn(aPICSupportPKCE, DPEnumerations.TOGGLE)) {
            this.aPICSupportPKCE = aPICSupportPKCE;
        }
    }

    @XMLInfo(elementType="element", elementName="APICRequirePKCE", elementOrder=36, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-require-pkce", refType="", isEnumeration=true, javaName="aPICRequirePKCE", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require PKCE", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICRequirePKCE() {
        return this.aPICRequirePKCE;
    }

    @XMLInfo(elementType="element", elementName="APICRequirePKCE", elementOrder=36, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-require-pkce", refType="", isEnumeration=true, javaName="aPICRequirePKCE", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require PKCE", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICRequirePKCE(String aPICRequirePKCE) {
        if (aPICRequirePKCE == null || Comparison.isIn(aPICRequirePKCE, DPEnumerations.TOGGLE)) {
            this.aPICRequirePKCE = aPICRequirePKCE;
        }
    }

    @XMLInfo(elementType="element", elementName="APICSupportPKCEPlain", elementOrder=37, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-support-pkce-plain", refType="", isEnumeration=true, javaName="aPICSupportPKCEPlain", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Support PKCE 'plain' challenge method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICSupportPKCEPlain() {
        return this.aPICSupportPKCEPlain;
    }

    @XMLInfo(elementType="element", elementName="APICSupportPKCEPlain", elementOrder=37, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-support-pkce-plain", refType="", isEnumeration=true, javaName="aPICSupportPKCEPlain", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Support PKCE 'plain' challenge method", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICSupportPKCEPlain(String aPICSupportPKCEPlain) {
        if (aPICSupportPKCEPlain == null || Comparison.isIn(aPICSupportPKCEPlain, DPEnumerations.TOGGLE)) {
            this.aPICSupportPKCEPlain = aPICSupportPKCEPlain;
        }
    }

    @XMLInfo(elementType="element", elementName="APICTokenTypeToGenerate", elementOrder=38, dataPowerType="dmTokenType", subType="", benign=false, isPassword=false, cliAlias="apic-token-type-to-generate", refType="", isEnumeration=true, javaName="aPICTokenTypeToGenerate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Type of token to generate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAPICTokenTypeToGenerate() {
        return this.aPICTokenTypeToGenerate;
    }

    @XMLInfo(elementType="element", elementName="APICTokenTypeToGenerate", elementOrder=38, dataPowerType="dmTokenType", subType="", benign=false, isPassword=false, cliAlias="apic-token-type-to-generate", refType="", isEnumeration=true, javaName="aPICTokenTypeToGenerate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Type of token to generate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPICTokenTypeToGenerate(String aPICTokenTypeToGenerate) {
        if (aPICTokenTypeToGenerate == null || Comparison.isIn(aPICTokenTypeToGenerate, DPEnumerations.TOKEN_TYPE)) {
            this.aPICTokenTypeToGenerate = aPICTokenTypeToGenerate;
        }
    }

    @XMLInfo(elementType="element", elementName="MetadataFrom", elementOrder=39, dataPowerType="dmMetadataFromType", subType="", benign=false, isPassword=false, cliAlias="metadata-from", refType="", isEnumeration=false, javaName="metadataFrom", javaType="MetadataFromType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Obtain metadata from", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public MetadataFromType getMetadataFrom() {
        return this.metadataFrom;
    }

    @XMLInfo(elementType="element", elementName="MetadataFrom", elementOrder=39, dataPowerType="dmMetadataFromType", subType="", benign=false, isPassword=false, cliAlias="metadata-from", refType="", isEnumeration=false, javaName="metadataFrom", javaType="MetadataFromType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Obtain metadata from", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMetadataFrom(MetadataFromType metadataFrom) {
        this.metadataFrom = metadataFrom;
    }

    @XMLInfo(elementType="element", elementName="MetadataURL", elementOrder=40, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="metadata-url", refType="", isEnumeration=false, javaName="metadataURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="External metadata URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMetadataURL() {
        return this.metadataURL;
    }

    @XMLInfo(elementType="element", elementName="MetadataURL", elementOrder=40, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="metadata-url", refType="", isEnumeration=false, javaName="metadataURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="External metadata URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMetadataURL(String metadataURL) {
        this.metadataURL = metadataURL;
    }

    @XMLInfo(elementType="element", elementName="MetadataSSLProfile", elementOrder=41, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="metadata-ssl-profile", refType="SSLClientProfile", isEnumeration=false, javaName="metadataSSLProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS profile to access metadata URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getMetadataSSLProfile() {
        return this.metadataSSLProfile;
    }

    @XMLInfo(elementType="element", elementName="MetadataSSLProfile", elementOrder=41, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="metadata-ssl-profile", refType="SSLClientProfile", isEnumeration=false, javaName="metadataSSLProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS profile to access metadata URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMetadataSSLProfile(ObjectReference<ConfigSSLClientProfile> metadataSSLProfile) {
        this.metadataSSLProfile = metadataSSLProfile;
    }

    @XMLInfo(elementType="element", elementName="MetadataHeaderForAccessToken", elementOrder=42, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="mdheader-for-accesstoken", refType="", isEnumeration=false, javaName="metadataHeaderForAccessToken", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="X-API-OAuth-Metadata-For-AccessToken", displayOrder=0, displayValue="Response header for access token", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMetadataHeaderForAccessToken() {
        return this.metadataHeaderForAccessToken;
    }

    @XMLInfo(elementType="element", elementName="MetadataHeaderForAccessToken", elementOrder=42, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="mdheader-for-accesstoken", refType="", isEnumeration=false, javaName="metadataHeaderForAccessToken", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="X-API-OAuth-Metadata-For-AccessToken", displayValue="Response header for access token", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMetadataHeaderForAccessToken(String metadataHeaderForAccessToken) {
        this.metadataHeaderForAccessToken = metadataHeaderForAccessToken;
    }

    @XMLInfo(elementType="element", elementName="MetadataHeaderForPayload", elementOrder=43, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="mdheader-for-payload", refType="", isEnumeration=false, javaName="metadataHeaderForPayload", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="X-API-OAuth-Metadata-For-Payload", displayOrder=0, displayValue="Response header for payload", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getMetadataHeaderForPayload() {
        return this.metadataHeaderForPayload;
    }

    @XMLInfo(elementType="element", elementName="MetadataHeaderForPayload", elementOrder=43, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="mdheader-for-payload", refType="", isEnumeration=false, javaName="metadataHeaderForPayload", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="X-API-OAuth-Metadata-For-Payload", displayValue="Response header for payload", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMetadataHeaderForPayload(String metadataHeaderForPayload) {
        this.metadataHeaderForPayload = metadataHeaderForPayload;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationURL", elementOrder=44, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="external-revocation-url", refType="", isEnumeration=false, javaName="externalRevocationURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="External management URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getExternalRevocationURL() {
        return this.externalRevocationURL;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationURL", elementOrder=44, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="external-revocation-url", refType="", isEnumeration=false, javaName="externalRevocationURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="External management URL", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExternalRevocationURL(String externalRevocationURL) {
        this.externalRevocationURL = externalRevocationURL;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationSSLProfile", elementOrder=45, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="external-revocation-ssl-profile", refType="SSLClientProfile", isEnumeration=false, javaName="externalRevocationSSLProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="External management TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getExternalRevocationSSLProfile() {
        return this.externalRevocationSSLProfile;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationSSLProfile", elementOrder=45, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="external-revocation-ssl-profile", refType="SSLClientProfile", isEnumeration=false, javaName="externalRevocationSSLProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="External management TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExternalRevocationSSLProfile(ObjectReference<ConfigSSLClientProfile> externalRevocationSSLProfile) {
        this.externalRevocationSSLProfile = externalRevocationSSLProfile;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationURLSecurity", elementOrder=46, dataPowerType="dmSecurityType", subType="", benign=false, isPassword=false, cliAlias="external-revocation-url-security", refType="", isEnumeration=false, javaName="externalRevocationURLSecurity", javaType="SecurityType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="basic-auth", displayOrder=0, displayValue="External management security", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public SecurityType getExternalRevocationURLSecurity() {
        return this.externalRevocationURLSecurity;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationURLSecurity", elementOrder=46, dataPowerType="dmSecurityType", subType="", benign=false, isPassword=false, cliAlias="external-revocation-url-security", refType="", isEnumeration=false, javaName="externalRevocationURLSecurity", javaType="SecurityType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="basic-auth", displayValue="External management security", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExternalRevocationURLSecurity(SecurityType externalRevocationURLSecurity) {
        this.externalRevocationURLSecurity = externalRevocationURLSecurity;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationBasicAuthUserName", elementOrder=47, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="external-revocation-basic-auth-username", refType="", isEnumeration=false, javaName="externalRevocationBasicAuthUserName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Basic authentication username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getExternalRevocationBasicAuthUserName() {
        return this.externalRevocationBasicAuthUserName;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationBasicAuthUserName", elementOrder=47, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="external-revocation-basic-auth-username", refType="", isEnumeration=false, javaName="externalRevocationBasicAuthUserName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Basic authentication username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExternalRevocationBasicAuthUserName(String externalRevocationBasicAuthUserName) {
        this.externalRevocationBasicAuthUserName = externalRevocationBasicAuthUserName;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationBasicAuthPassword", elementOrder=48, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="external-revocation-basic-auth-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="externalRevocationBasicAuthPassword", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Basic authentication password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getExternalRevocationBasicAuthPassword() {
        return this.externalRevocationBasicAuthPassword;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationBasicAuthPassword", elementOrder=48, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="external-revocation-basic-auth-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="externalRevocationBasicAuthPassword", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Basic authentication password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExternalRevocationBasicAuthPassword(ObjectReference<ConfigPasswordAlias> externalRevocationBasicAuthPassword) {
        this.externalRevocationBasicAuthPassword = externalRevocationBasicAuthPassword;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationBasicAuthHeaderName", elementOrder=49, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="external-revocation-basic-auth-headername", refType="", isEnumeration=false, javaName="externalRevocationBasicAuthHeaderName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Basic authentication header name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getExternalRevocationBasicAuthHeaderName() {
        return this.externalRevocationBasicAuthHeaderName;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationBasicAuthHeaderName", elementOrder=49, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="external-revocation-basic-auth-headername", refType="", isEnumeration=false, javaName="externalRevocationBasicAuthHeaderName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Basic authentication header name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExternalRevocationBasicAuthHeaderName(String externalRevocationBasicAuthHeaderName) {
        this.externalRevocationBasicAuthHeaderName = externalRevocationBasicAuthHeaderName;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationCustomHeaderFormat", elementOrder=50, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="external-revocation-custom-headername-format", refType="", isEnumeration=false, javaName="externalRevocationCustomHeaderFormat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Custom header pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getExternalRevocationCustomHeaderFormat() {
        return this.externalRevocationCustomHeaderFormat;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationCustomHeaderFormat", elementOrder=50, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="external-revocation-custom-headername-format", refType="", isEnumeration=false, javaName="externalRevocationCustomHeaderFormat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Custom header pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExternalRevocationCustomHeaderFormat(String externalRevocationCustomHeaderFormat) {
        this.externalRevocationCustomHeaderFormat = externalRevocationCustomHeaderFormat;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationCacheType", elementOrder=51, dataPowerType="dmThirdPartyCacheType", subType="", benign=false, isPassword=false, cliAlias="external-revocation-cache-type", refType="", isEnumeration=true, javaName="externalRevocationCacheType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="NoCache", displayOrder=0, displayValue="Cache type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getExternalRevocationCacheType() {
        return this.externalRevocationCacheType;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationCacheType", elementOrder=51, dataPowerType="dmThirdPartyCacheType", subType="", benign=false, isPassword=false, cliAlias="external-revocation-cache-type", refType="", isEnumeration=true, javaName="externalRevocationCacheType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="NoCache", displayValue="Cache type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExternalRevocationCacheType(String externalRevocationCacheType) {
        if (externalRevocationCacheType == null || Comparison.isIn(externalRevocationCacheType, DPEnumerations.THIRD_PARTY_CACHE_TYPE)) {
            this.externalRevocationCacheType = externalRevocationCacheType;
        }
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationCacheTimeToLive", elementOrder=52, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="external-revocation-cache-ttl", refType="", isEnumeration=false, javaName="externalRevocationCacheTimeToLive", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="900", displayOrder=0, displayValue="Time to live", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getExternalRevocationCacheTimeToLive() {
        return this.externalRevocationCacheTimeToLive;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationCacheTimeToLive", elementOrder=52, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="external-revocation-cache-ttl", refType="", isEnumeration=false, javaName="externalRevocationCacheTimeToLive", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="900", displayValue="Time to live", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExternalRevocationCacheTimeToLive(long externalRevocationCacheTimeToLive) {
        this.externalRevocationCacheTimeToLive = externalRevocationCacheTimeToLive;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationFailOnError", elementOrder=53, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="external-revocation-fail-on-error", refType="", isEnumeration=true, javaName="externalRevocationFailOnError", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Fail on error", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getExternalRevocationFailOnError() {
        return this.externalRevocationFailOnError;
    }

    @XMLInfo(elementType="element", elementName="ExternalRevocationFailOnError", elementOrder=53, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="external-revocation-fail-on-error", refType="", isEnumeration=true, javaName="externalRevocationFailOnError", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Fail on error", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setExternalRevocationFailOnError(String externalRevocationFailOnError) {
        if (externalRevocationFailOnError == null || Comparison.isIn(externalRevocationFailOnError, DPEnumerations.TOGGLE)) {
            this.externalRevocationFailOnError = externalRevocationFailOnError;
        }
    }

    @XMLInfo(elementType="element", elementName="EnableTokenManagement", elementOrder=54, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-token-management", refType="", isEnumeration=true, javaName="enableTokenManagement", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Enable token management", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnableTokenManagement() {
        return this.enableTokenManagement;
    }

    @XMLInfo(elementType="element", elementName="EnableTokenManagement", elementOrder=54, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-token-management", refType="", isEnumeration=true, javaName="enableTokenManagement", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Enable token management", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnableTokenManagement(String enableTokenManagement) {
        if (enableTokenManagement == null || Comparison.isIn(enableTokenManagement, DPEnumerations.TOGGLE)) {
            this.enableTokenManagement = enableTokenManagement;
        }
    }

    @XMLInfo(elementType="element", elementName="TokenManagerType", elementOrder=55, dataPowerType="dmTokenManagerType", subType="", benign=false, isPassword=false, cliAlias="token-manager-type", refType="", isEnumeration=true, javaName="tokenManagerType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="native", displayOrder=0, displayValue="Token manager type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTokenManagerType() {
        return this.tokenManagerType;
    }

    @XMLInfo(elementType="element", elementName="TokenManagerType", elementOrder=55, dataPowerType="dmTokenManagerType", subType="", benign=false, isPassword=false, cliAlias="token-manager-type", refType="", isEnumeration=true, javaName="tokenManagerType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="native", displayValue="Token manager type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTokenManagerType(String tokenManagerType) {
        if (tokenManagerType == null || Comparison.isIn(tokenManagerType, DPEnumerations.TOKEN_MANAGER_TYPE)) {
            this.tokenManagerType = tokenManagerType;
        }
    }

    @XMLInfo(elementType="element", elementName="APISecurityTokenManager", elementOrder=56, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="api-security-token-manager", refType="APISecurityTokenManager", isEnumeration=false, javaName="aPISecurityTokenManager", javaType="ObjectReference<ConfigAPISecurityTokenManager>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default", displayOrder=0, displayValue="API security token manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigAPISecurityTokenManager> getAPISecurityTokenManager() {
        return this.aPISecurityTokenManager;
    }

    @XMLInfo(elementType="element", elementName="APISecurityTokenManager", elementOrder=56, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="api-security-token-manager", refType="APISecurityTokenManager", isEnumeration=false, javaName="aPISecurityTokenManager", javaType="ObjectReference<ConfigAPISecurityTokenManager>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default", displayValue="API security token manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAPISecurityTokenManager(ObjectReference<ConfigAPISecurityTokenManager> aPISecurityTokenManager) {
        this.aPISecurityTokenManager = aPISecurityTokenManager;
    }

    @XMLInfo(elementType="element", elementName="EnableApplicationRevocation", elementOrder=57, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-app-revoke-enable", refType="", isEnumeration=true, javaName="enableApplicationRevocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Application revocation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnableApplicationRevocation() {
        return this.enableApplicationRevocation;
    }

    @XMLInfo(elementType="element", elementName="EnableApplicationRevocation", elementOrder=57, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-app-revoke-enable", refType="", isEnumeration=true, javaName="enableApplicationRevocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Application revocation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnableApplicationRevocation(String enableApplicationRevocation) {
        if (enableApplicationRevocation == null || Comparison.isIn(enableApplicationRevocation, DPEnumerations.TOGGLE)) {
            this.enableApplicationRevocation = enableApplicationRevocation;
        }
    }

    @XMLInfo(elementType="element", elementName="ApplicationRevocationEndpoint", elementOrder=58, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-app-revoke-endpoint", refType="", isEnumeration=false, javaName="applicationRevocationEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="/oauth2/revoke", displayOrder=0, displayValue="Application revocation endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getApplicationRevocationEndpoint() {
        return this.applicationRevocationEndpoint;
    }

    @XMLInfo(elementType="element", elementName="ApplicationRevocationEndpoint", elementOrder=58, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-app-revoke-endpoint", refType="", isEnumeration=false, javaName="applicationRevocationEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="/oauth2/revoke", displayValue="Application revocation endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setApplicationRevocationEndpoint(String applicationRevocationEndpoint) {
        this.applicationRevocationEndpoint = applicationRevocationEndpoint;
    }

    @XMLInfo(elementType="element", elementName="EnableOwnerRevocation", elementOrder=59, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-owner-revoke-enable", refType="", isEnumeration=true, javaName="enableOwnerRevocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Resource owner revocation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnableOwnerRevocation() {
        return this.enableOwnerRevocation;
    }

    @XMLInfo(elementType="element", elementName="EnableOwnerRevocation", elementOrder=59, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="apic-owner-revoke-enable", refType="", isEnumeration=true, javaName="enableOwnerRevocation", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Resource owner revocation", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnableOwnerRevocation(String enableOwnerRevocation) {
        if (enableOwnerRevocation == null || Comparison.isIn(enableOwnerRevocation, DPEnumerations.TOGGLE)) {
            this.enableOwnerRevocation = enableOwnerRevocation;
        }
    }

    @XMLInfo(elementType="element", elementName="OwnerRevocationEndpoint", elementOrder=60, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-owner-revoke-endpoint", refType="", isEnumeration=false, javaName="ownerRevocationEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="/oauth2/issued", displayOrder=0, displayValue="Resource owner revocation endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOwnerRevocationEndpoint() {
        return this.ownerRevocationEndpoint;
    }

    @XMLInfo(elementType="element", elementName="OwnerRevocationEndpoint", elementOrder=60, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="apic-owner-revoke-endpoint", refType="", isEnumeration=false, javaName="ownerRevocationEndpoint", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="/oauth2/issued", displayValue="Resource owner revocation endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOwnerRevocationEndpoint(String ownerRevocationEndpoint) {
        this.ownerRevocationEndpoint = ownerRevocationEndpoint;
    }

    @XMLInfo(elementType="element", elementName="TokenValidationReq", elementOrder=61, dataPowerType="dmTokenValidationReq", subType="", benign=false, isPassword=false, cliAlias="token-validation-requirement", refType="", isEnumeration=true, javaName="tokenValidationReq", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Token validation requirement", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTokenValidationReq() {
        return this.tokenValidationReq;
    }

    @XMLInfo(elementType="element", elementName="TokenValidationReq", elementOrder=61, dataPowerType="dmTokenValidationReq", subType="", benign=false, isPassword=false, cliAlias="token-validation-requirement", refType="", isEnumeration=true, javaName="tokenValidationReq", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Token validation requirement", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTokenValidationReq(String tokenValidationReq) {
        if (tokenValidationReq == null || Comparison.isIn(tokenValidationReq, DPEnumerations.TOKEN_VALIDATION_REQ)) {
            this.tokenValidationReq = tokenValidationReq;
        }
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyAZURL", elementOrder=62, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="third-party-az-url", refType="", isEnumeration=false, javaName="thirdPartyAZURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Authorization endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getThirdPartyAZURL() {
        return this.thirdPartyAZURL;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyAZURL", elementOrder=62, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="third-party-az-url", refType="", isEnumeration=false, javaName="thirdPartyAZURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Authorization endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyAZURL(String thirdPartyAZURL) {
        this.thirdPartyAZURL = thirdPartyAZURL;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyTokenURL", elementOrder=63, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="third-party-token-url", refType="", isEnumeration=false, javaName="thirdPartyTokenURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Token endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getThirdPartyTokenURL() {
        return this.thirdPartyTokenURL;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyTokenURL", elementOrder=63, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="third-party-token-url", refType="", isEnumeration=false, javaName="thirdPartyTokenURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Token endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyTokenURL(String thirdPartyTokenURL) {
        this.thirdPartyTokenURL = thirdPartyTokenURL;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectURL", elementOrder=64, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-url", refType="", isEnumeration=false, javaName="thirdPartyIntrospectURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Introspection endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getThirdPartyIntrospectURL() {
        return this.thirdPartyIntrospectURL;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectURL", elementOrder=64, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-url", refType="", isEnumeration=false, javaName="thirdPartyIntrospectURL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Introspection endpoint", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyIntrospectURL(String thirdPartyIntrospectURL) {
        this.thirdPartyIntrospectURL = thirdPartyIntrospectURL;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectCacheType", elementOrder=65, dataPowerType="dmThirdPartyCacheType", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-cache-type", refType="", isEnumeration=true, javaName="thirdPartyIntrospectCacheType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="NoCache", displayOrder=0, displayValue="Cache type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getThirdPartyIntrospectCacheType() {
        return this.thirdPartyIntrospectCacheType;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectCacheType", elementOrder=65, dataPowerType="dmThirdPartyCacheType", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-cache-type", refType="", isEnumeration=true, javaName="thirdPartyIntrospectCacheType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="NoCache", displayValue="Cache type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyIntrospectCacheType(String thirdPartyIntrospectCacheType) {
        if (thirdPartyIntrospectCacheType == null || Comparison.isIn(thirdPartyIntrospectCacheType, DPEnumerations.THIRD_PARTY_CACHE_TYPE)) {
            this.thirdPartyIntrospectCacheType = thirdPartyIntrospectCacheType;
        }
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectCacheTimeToLive", elementOrder=66, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-cache-ttl", refType="", isEnumeration=false, javaName="thirdPartyIntrospectCacheTimeToLive", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="900", displayOrder=0, displayValue="Time to live", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getThirdPartyIntrospectCacheTimeToLive() {
        return this.thirdPartyIntrospectCacheTimeToLive;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectCacheTimeToLive", elementOrder=66, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-cache-ttl", refType="", isEnumeration=false, javaName="thirdPartyIntrospectCacheTimeToLive", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="900", displayValue="Time to live", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyIntrospectCacheTimeToLive(long thirdPartyIntrospectCacheTimeToLive) {
        this.thirdPartyIntrospectCacheTimeToLive = thirdPartyIntrospectCacheTimeToLive;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyAuthorizationHeaderPassThru", elementOrder=67, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="third-party-authorization-header-pass-thru", refType="", isEnumeration=true, javaName="thirdPartyAuthorizationHeaderPassThru", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Retain Authorization header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getThirdPartyAuthorizationHeaderPassThru() {
        return this.thirdPartyAuthorizationHeaderPassThru;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyAuthorizationHeaderPassThru", elementOrder=67, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="third-party-authorization-header-pass-thru", refType="", isEnumeration=true, javaName="thirdPartyAuthorizationHeaderPassThru", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Retain Authorization header", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyAuthorizationHeaderPassThru(String thirdPartyAuthorizationHeaderPassThru) {
        if (thirdPartyAuthorizationHeaderPassThru == null || Comparison.isIn(thirdPartyAuthorizationHeaderPassThru, DPEnumerations.TOGGLE)) {
            this.thirdPartyAuthorizationHeaderPassThru = thirdPartyAuthorizationHeaderPassThru;
        }
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectURLSecurity", elementOrder=68, dataPowerType="dmSecurityType", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-url-security", refType="", isEnumeration=false, javaName="thirdPartyIntrospectURLSecurity", javaType="SecurityType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="basic-auth", displayOrder=0, displayValue="Introspection endpoint security", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public SecurityType getThirdPartyIntrospectURLSecurity() {
        return this.thirdPartyIntrospectURLSecurity;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectURLSecurity", elementOrder=68, dataPowerType="dmSecurityType", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-url-security", refType="", isEnumeration=false, javaName="thirdPartyIntrospectURLSecurity", javaType="SecurityType", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="basic-auth", displayValue="Introspection endpoint security", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyIntrospectURLSecurity(SecurityType thirdPartyIntrospectURLSecurity) {
        this.thirdPartyIntrospectURLSecurity = thirdPartyIntrospectURLSecurity;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectBasicAuthUserName", elementOrder=69, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-basic-auth-username", refType="", isEnumeration=false, javaName="thirdPartyIntrospectBasicAuthUserName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Basic authentication username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getThirdPartyIntrospectBasicAuthUserName() {
        return this.thirdPartyIntrospectBasicAuthUserName;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectBasicAuthUserName", elementOrder=69, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-basic-auth-username", refType="", isEnumeration=false, javaName="thirdPartyIntrospectBasicAuthUserName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Basic authentication username", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyIntrospectBasicAuthUserName(String thirdPartyIntrospectBasicAuthUserName) {
        this.thirdPartyIntrospectBasicAuthUserName = thirdPartyIntrospectBasicAuthUserName;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectBasicAuthPassword", elementOrder=70, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-basic-auth-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="thirdPartyIntrospectBasicAuthPassword", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Basic authentication password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getThirdPartyIntrospectBasicAuthPassword() {
        return this.thirdPartyIntrospectBasicAuthPassword;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectBasicAuthPassword", elementOrder=70, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-basic-auth-password-alias", refType="PasswordAlias", isEnumeration=false, javaName="thirdPartyIntrospectBasicAuthPassword", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Basic authentication password", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyIntrospectBasicAuthPassword(ObjectReference<ConfigPasswordAlias> thirdPartyIntrospectBasicAuthPassword) {
        this.thirdPartyIntrospectBasicAuthPassword = thirdPartyIntrospectBasicAuthPassword;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyBasicAuthHeaderName", elementOrder=71, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-basic-auth-headername", refType="", isEnumeration=false, javaName="thirdPartyBasicAuthHeaderName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Basic authentication header name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getThirdPartyBasicAuthHeaderName() {
        return this.thirdPartyBasicAuthHeaderName;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyBasicAuthHeaderName", elementOrder=71, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-basic-auth-headername", refType="", isEnumeration=false, javaName="thirdPartyBasicAuthHeaderName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Basic authentication header name", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyBasicAuthHeaderName(String thirdPartyBasicAuthHeaderName) {
        this.thirdPartyBasicAuthHeaderName = thirdPartyBasicAuthHeaderName;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyCustomHeaderNameFormat", elementOrder=72, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-custom-headername-format", refType="", isEnumeration=false, javaName="thirdPartyCustomHeaderNameFormat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Custom header pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getThirdPartyCustomHeaderNameFormat() {
        return this.thirdPartyCustomHeaderNameFormat;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyCustomHeaderNameFormat", elementOrder=72, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-custom-headername-format", refType="", isEnumeration=false, javaName="thirdPartyCustomHeaderNameFormat", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Custom header pattern", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyCustomHeaderNameFormat(String thirdPartyCustomHeaderNameFormat) {
        this.thirdPartyCustomHeaderNameFormat = thirdPartyCustomHeaderNameFormat;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectSSLProfile", elementOrder=73, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-ssl-profile", refType="SSLClientProfile", isEnumeration=false, javaName="thirdPartyIntrospectSSLProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getThirdPartyIntrospectSSLProfile() {
        return this.thirdPartyIntrospectSSLProfile;
    }

    @XMLInfo(elementType="element", elementName="ThirdPartyIntrospectSSLProfile", elementOrder=73, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="third-party-introspect-ssl-profile", refType="SSLClientProfile", isEnumeration=false, javaName="thirdPartyIntrospectSSLProfile", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setThirdPartyIntrospectSSLProfile(ObjectReference<ConfigSSLClientProfile> thirdPartyIntrospectSSLProfile) {
        this.thirdPartyIntrospectSSLProfile = thirdPartyIntrospectSSLProfile;
    }

    @Override
    public int compareTo(ConfigOAuthProviderSettings that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "enableDebugMode", "providerType", "scopesAllowed", "defaultScopes", "supportedGrantTypes", "supportedClientTypes", "aPICProviderBasePath", "aPICAuthorizeEndpoint", "aPICTokenEndpoint", "aPICEnableIntrospection", "aPICIntrospectEndpoint", "aPICTokenSecret", "aPICOneTimeUseAccesstoken", "aPICAccessTokenTTL", "aPICAuthCodeTTL", "aPICEnableRefreshToken", "aPICOneTimeUseRefreshtoken", "aPICRefreshTokenLimit", "aPICRefreshTokenTTL", "aPICMaximumConsentTTL", "advScopeValidationEnabled", "advancedScopeURLOverride", "advancedScopeURL", "advScopeTLSProfile", "advScopeURLSecurityEnabled", "advScopeURLSecurity", "advScopeBasicAuthUserName", "advScopeBasicAuthPassword", "advScopeBasicAuthHeaderName", "advancedScopeCustomHeaders", "advancedScopeCustomContexts", "aPICEnableOIDC", "aPICOIDCHybridResponseTypes", "aPICSupportPKCE", "aPICRequirePKCE", "aPICSupportPKCEPlain", "aPICTokenTypeToGenerate", "metadataFrom", "metadataURL", "metadataSSLProfile", "metadataHeaderForAccessToken", "metadataHeaderForPayload", "externalRevocationURL", "externalRevocationSSLProfile", "externalRevocationURLSecurity", "externalRevocationBasicAuthUserName", "externalRevocationBasicAuthPassword", "externalRevocationBasicAuthHeaderName", "externalRevocationCustomHeaderFormat", "externalRevocationCacheType", "externalRevocationCacheTimeToLive", "externalRevocationFailOnError", "enableTokenManagement", "tokenManagerType", "aPISecurityTokenManager", "enableApplicationRevocation", "applicationRevocationEndpoint", "enableOwnerRevocation", "ownerRevocationEndpoint", "tokenValidationReq", "thirdPartyAZURL", "thirdPartyTokenURL", "thirdPartyIntrospectURL", "thirdPartyIntrospectCacheType", "thirdPartyIntrospectCacheTimeToLive", "thirdPartyAuthorizationHeaderPassThru", "thirdPartyIntrospectURLSecurity", "thirdPartyIntrospectBasicAuthUserName", "thirdPartyIntrospectBasicAuthPassword", "thirdPartyBasicAuthHeaderName", "thirdPartyCustomHeaderNameFormat", "thirdPartyIntrospectSSLProfile");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.enableDebugMode, this.providerType, this.scopesAllowed, this.defaultScopes, this.supportedGrantTypes, this.supportedClientTypes, this.aPICProviderBasePath, this.aPICAuthorizeEndpoint, this.aPICTokenEndpoint, this.aPICEnableIntrospection, this.aPICIntrospectEndpoint, this.aPICTokenSecret, this.aPICOneTimeUseAccesstoken, this.aPICAccessTokenTTL, this.aPICAuthCodeTTL, this.aPICEnableRefreshToken, this.aPICOneTimeUseRefreshtoken, this.aPICRefreshTokenLimit, this.aPICRefreshTokenTTL, this.aPICMaximumConsentTTL, this.advScopeValidationEnabled, this.advancedScopeURLOverride, this.advancedScopeURL, this.advScopeTLSProfile, this.advScopeURLSecurityEnabled, this.advScopeURLSecurity, this.advScopeBasicAuthUserName, this.advScopeBasicAuthPassword, this.advScopeBasicAuthHeaderName, this.advancedScopeCustomHeaders, this.advancedScopeCustomContexts, this.aPICEnableOIDC, this.aPICOIDCHybridResponseTypes, this.aPICSupportPKCE, this.aPICRequirePKCE, this.aPICSupportPKCEPlain, this.aPICTokenTypeToGenerate, this.metadataFrom, this.metadataURL, this.metadataSSLProfile, this.metadataHeaderForAccessToken, this.metadataHeaderForPayload, this.externalRevocationURL, this.externalRevocationSSLProfile, this.externalRevocationURLSecurity, this.externalRevocationBasicAuthUserName, this.externalRevocationBasicAuthPassword, this.externalRevocationBasicAuthHeaderName, this.externalRevocationCustomHeaderFormat, this.externalRevocationCacheType, this.externalRevocationCacheTimeToLive, this.externalRevocationFailOnError, this.enableTokenManagement, this.tokenManagerType, this.aPISecurityTokenManager, this.enableApplicationRevocation, this.applicationRevocationEndpoint, this.enableOwnerRevocation, this.ownerRevocationEndpoint, this.tokenValidationReq, this.thirdPartyAZURL, this.thirdPartyTokenURL, this.thirdPartyIntrospectURL, this.thirdPartyIntrospectCacheType, this.thirdPartyIntrospectCacheTimeToLive, this.thirdPartyAuthorizationHeaderPassThru, this.thirdPartyIntrospectURLSecurity, this.thirdPartyIntrospectBasicAuthUserName, this.thirdPartyIntrospectBasicAuthPassword, this.thirdPartyBasicAuthHeaderName, this.thirdPartyCustomHeaderNameFormat, this.thirdPartyIntrospectSSLProfile);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "enableDebugMode", "providerType", "scopesAllowed", "defaultScopes", "supportedGrantTypes", "supportedClientTypes", "aPICProviderBasePath", "aPICAuthorizeEndpoint", "aPICTokenEndpoint", "aPICEnableIntrospection", "aPICIntrospectEndpoint", "aPICTokenSecret", "aPICOneTimeUseAccesstoken", "aPICAccessTokenTTL", "aPICAuthCodeTTL", "aPICEnableRefreshToken", "aPICOneTimeUseRefreshtoken", "aPICRefreshTokenLimit", "aPICRefreshTokenTTL", "aPICMaximumConsentTTL", "advScopeValidationEnabled", "advancedScopeURLOverride", "advancedScopeURL", "advScopeTLSProfile", "advScopeURLSecurityEnabled", "advScopeURLSecurity", "advScopeBasicAuthUserName", "advScopeBasicAuthPassword", "advScopeBasicAuthHeaderName", "advancedScopeCustomHeaders", "advancedScopeCustomContexts", "aPICEnableOIDC", "aPICOIDCHybridResponseTypes", "aPICSupportPKCE", "aPICRequirePKCE", "aPICSupportPKCEPlain", "aPICTokenTypeToGenerate", "metadataFrom", "metadataURL", "metadataSSLProfile", "metadataHeaderForAccessToken", "metadataHeaderForPayload", "externalRevocationURL", "externalRevocationSSLProfile", "externalRevocationURLSecurity", "externalRevocationBasicAuthUserName", "externalRevocationBasicAuthPassword", "externalRevocationBasicAuthHeaderName", "externalRevocationCustomHeaderFormat", "externalRevocationCacheType", "externalRevocationCacheTimeToLive", "externalRevocationFailOnError", "enableTokenManagement", "tokenManagerType", "aPISecurityTokenManager", "enableApplicationRevocation", "applicationRevocationEndpoint", "enableOwnerRevocation", "ownerRevocationEndpoint", "tokenValidationReq", "thirdPartyAZURL", "thirdPartyTokenURL", "thirdPartyIntrospectURL", "thirdPartyIntrospectCacheType", "thirdPartyIntrospectCacheTimeToLive", "thirdPartyAuthorizationHeaderPassThru", "thirdPartyIntrospectURLSecurity", "thirdPartyIntrospectBasicAuthUserName", "thirdPartyIntrospectBasicAuthPassword", "thirdPartyBasicAuthHeaderName", "thirdPartyCustomHeaderNameFormat", "thirdPartyIntrospectSSLProfile");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "enableDebugMode", "providerType", "scopesAllowed", "defaultScopes", "supportedGrantTypes", "supportedClientTypes", "aPICProviderBasePath", "aPICAuthorizeEndpoint", "aPICTokenEndpoint", "aPICEnableIntrospection", "aPICIntrospectEndpoint", "aPICTokenSecret", "aPICOneTimeUseAccesstoken", "aPICAccessTokenTTL", "aPICAuthCodeTTL", "aPICEnableRefreshToken", "aPICOneTimeUseRefreshtoken", "aPICRefreshTokenLimit", "aPICRefreshTokenTTL", "aPICMaximumConsentTTL", "advScopeValidationEnabled", "advancedScopeURLOverride", "advancedScopeURL", "advScopeTLSProfile", "advScopeURLSecurityEnabled", "advScopeURLSecurity", "advScopeBasicAuthUserName", "advScopeBasicAuthPassword", "advScopeBasicAuthHeaderName", "advancedScopeCustomHeaders", "advancedScopeCustomContexts", "aPICEnableOIDC", "aPICOIDCHybridResponseTypes", "aPICSupportPKCE", "aPICRequirePKCE", "aPICSupportPKCEPlain", "aPICTokenTypeToGenerate", "metadataFrom", "metadataURL", "metadataSSLProfile", "metadataHeaderForAccessToken", "metadataHeaderForPayload", "externalRevocationURL", "externalRevocationSSLProfile", "externalRevocationURLSecurity", "externalRevocationBasicAuthUserName", "externalRevocationBasicAuthPassword", "externalRevocationBasicAuthHeaderName", "externalRevocationCustomHeaderFormat", "externalRevocationCacheType", "externalRevocationCacheTimeToLive", "externalRevocationFailOnError", "enableTokenManagement", "tokenManagerType", "aPISecurityTokenManager", "enableApplicationRevocation", "applicationRevocationEndpoint", "enableOwnerRevocation", "ownerRevocationEndpoint", "tokenValidationReq", "thirdPartyAZURL", "thirdPartyTokenURL", "thirdPartyIntrospectURL", "thirdPartyIntrospectCacheType", "thirdPartyIntrospectCacheTimeToLive", "thirdPartyAuthorizationHeaderPassThru", "thirdPartyIntrospectURLSecurity", "thirdPartyIntrospectBasicAuthUserName", "thirdPartyIntrospectBasicAuthPassword", "thirdPartyBasicAuthHeaderName", "thirdPartyCustomHeaderNameFormat", "thirdPartyIntrospectSSLProfile"));
    }
}

