/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigSSLClientProfile;
import com.kumbasoft.core.beans.config.ConfigSSLProxyProfile;
import com.kumbasoft.core.beans.config.ConfigXMLManager;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.ODRConnProperty;
import com.kumbasoft.core.beans.types.ODRConnector;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigODRConnectorGroup
extends ConfigConfigBase {
    private String userSummary;
    private ArrayList<ODRConnector> oDRGroupConnectors;
    private ObjectReference<ConfigSSLProxyProfile> sSLProxy;
    private int maxRetryInterval;
    private ObjectReference<ConfigXMLManager> xMLManager;
    private ArrayList<ODRConnProperty> oDRConnGroupProperties;
    private String sSLClientConfigType;
    private ObjectReference<ConfigSSLClientProfile> sSLClient;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    public void addODRGroupConnectors(ODRConnector element) {
        if (element == null) {
            return;
        }
        if (this.oDRGroupConnectors == null) {
            this.oDRGroupConnectors = new ArrayList();
        }
        this.oDRGroupConnectors.add(element);
    }

    public boolean removeODRGroupConnectors(ODRConnector element) {
        if (element == null || this.oDRGroupConnectors == null) {
            return false;
        }
        return this.oDRGroupConnectors.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ODRGroupConnectors", elementOrder=2, dataPowerType="dmODRConnector", subType="", benign=false, isPassword=false, cliAlias="odr-connector", refType="", isEnumeration=false, javaName="oDRGroupConnectors", javaType="ODRConnector", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="ODR connectors", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ODRConnector> getODRGroupConnectors() {
        return this.oDRGroupConnectors;
    }

    @XMLInfo(elementType="element", elementName="ODRGroupConnectors", elementOrder=2, dataPowerType="dmODRConnector", subType="", benign=false, isPassword=false, cliAlias="odr-connector", refType="", isEnumeration=false, javaName="oDRGroupConnectors", javaType="ODRConnector", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="ODR connectors", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setODRGroupConnectors(ArrayList<ODRConnector> oDRGroupConnectors) {
        this.oDRGroupConnectors = oDRGroupConnectors;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLProxyProfile> getSSLProxy() {
        return this.sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="SSLProxy", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl", refType="SSLProxyProfile", isEnumeration=false, javaName="sSLProxy", javaType="ObjectReference<ConfigSSLProxyProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS proxy profile (deprecated)", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLProxy(ObjectReference<ConfigSSLProxyProfile> sSLProxy) {
        this.sSLProxy = sSLProxy;
    }

    @XMLInfo(elementType="element", elementName="MaxRetryInterval", elementOrder=4, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-retry-interval", refType="", isEnumeration=false, javaName="maxRetryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=120L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="60", displayOrder=0, displayValue="Maximum retry interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMaxRetryInterval() {
        return this.maxRetryInterval;
    }

    @XMLInfo(elementType="element", elementName="MaxRetryInterval", elementOrder=4, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="max-retry-interval", refType="", isEnumeration=false, javaName="maxRetryInterval", javaType="int", isRequired=false, squelchNull=false, minimum=1, maximum=120L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="60", displayValue="Maximum retry interval", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxRetryInterval(int maxRetryInterval) {
        this.maxRetryInterval = maxRetryInterval;
    }

    @XMLInfo(elementType="element", elementName="XMLManager", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xml-manager", refType="XMLManager", isEnumeration=false, javaName="xMLManager", javaType="ObjectReference<ConfigXMLManager>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="default", displayOrder=0, displayValue="XML manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigXMLManager> getXMLManager() {
        return this.xMLManager;
    }

    @XMLInfo(elementType="element", elementName="XMLManager", elementOrder=5, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="xml-manager", refType="XMLManager", isEnumeration=false, javaName="xMLManager", javaType="ObjectReference<ConfigXMLManager>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="default", displayValue="XML manager", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXMLManager(ObjectReference<ConfigXMLManager> xMLManager) {
        this.xMLManager = xMLManager;
    }

    public void addODRConnGroupProperties(ODRConnProperty element) {
        if (element == null) {
            return;
        }
        if (this.oDRConnGroupProperties == null) {
            this.oDRConnGroupProperties = new ArrayList();
        }
        this.oDRConnGroupProperties.add(element);
    }

    public boolean removeODRConnGroupProperties(ODRConnProperty element) {
        if (element == null || this.oDRConnGroupProperties == null) {
            return false;
        }
        return this.oDRConnGroupProperties.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ODRConnGroupProperties", elementOrder=6, dataPowerType="dmODRConnProperty", subType="", benign=false, isPassword=false, cliAlias="odr-conn-group-properties", refType="", isEnumeration=false, javaName="oDRConnGroupProperties", javaType="ODRConnProperty", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Custom properties", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<ODRConnProperty> getODRConnGroupProperties() {
        return this.oDRConnGroupProperties;
    }

    @XMLInfo(elementType="element", elementName="ODRConnGroupProperties", elementOrder=6, dataPowerType="dmODRConnProperty", subType="", benign=false, isPassword=false, cliAlias="odr-conn-group-properties", refType="", isEnumeration=false, javaName="oDRConnGroupProperties", javaType="ODRConnProperty", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Custom properties", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setODRConnGroupProperties(ArrayList<ODRConnProperty> oDRConnGroupProperties) {
        this.oDRConnGroupProperties = oDRConnGroupProperties;
    }

    @XMLInfo(elementType="element", elementName="SSLClientConfigType", elementOrder=7, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-client-type", refType="", isEnumeration=true, javaName="sSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="proxy", displayOrder=0, displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSSLClientConfigType() {
        return this.sSLClientConfigType;
    }

    @XMLInfo(elementType="element", elementName="SSLClientConfigType", elementOrder=7, dataPowerType="dmSSLClientConfigType", subType="", benign=false, isPassword=false, cliAlias="ssl-client-type", refType="", isEnumeration=true, javaName="sSLClientConfigType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="proxy", displayValue="TLS client type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClientConfigType(String sSLClientConfigType) {
        if (sSLClientConfigType == null || Comparison.isIn(sSLClientConfigType, DPEnumerations.SSLCLIENT_CONFIG_TYPE)) {
            this.sSLClientConfigType = sSLClientConfigType;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigSSLClientProfile> getSSLClient() {
        return this.sSLClient;
    }

    @XMLInfo(elementType="element", elementName="SSLClient", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-client", refType="SSLClientProfile", isEnumeration=false, javaName="sSLClient", javaType="ObjectReference<ConfigSSLClientProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS client profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLClient(ObjectReference<ConfigSSLClientProfile> sSLClient) {
        this.sSLClient = sSLClient;
    }

    @Override
    public int compareTo(ConfigODRConnectorGroup that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "oDRGroupConnectors", "sSLProxy", "maxRetryInterval", "xMLManager", "oDRConnGroupProperties", "sSLClientConfigType", "sSLClient");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.oDRGroupConnectors, this.sSLProxy, this.maxRetryInterval, this.xMLManager, this.oDRConnGroupProperties, this.sSLClientConfigType, this.sSLClient);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "oDRGroupConnectors", "sSLProxy", "maxRetryInterval", "xMLManager", "oDRConnGroupProperties", "sSLClientConfigType", "sSLClient");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "oDRGroupConnectors", "sSLProxy", "maxRetryInterval", "xMLManager", "oDRConnGroupProperties", "sSLClientConfigType", "sSLClient"));
    }
}

