/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigCryptoCertificate;
import com.kumbasoft.core.beans.config.ConfigCryptoKey;
import com.kumbasoft.core.beans.config.ConfigPasswordAlias;
import com.kumbasoft.core.beans.config.ConfigRaidVolume;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigQuotaEnforcementServer
extends ConfigConfigBase {
    private String userSummary;
    private ObjectReference<ConfigPasswordAlias> passwordAlias;
    private ObjectReference<ConfigRaidVolume> raidVolume;
    private int serverPort;
    private int monitorPort;
    private String enablePeerGroup;
    private String enableSSL;
    private ObjectReference<ConfigCryptoKey> sSLCryptoKey;
    private ObjectReference<ConfigCryptoCertificate> sSLCryptoCertificate;
    private String iPAddress;
    private ArrayList<String> peers;
    private int priority;
    private String strictMode;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=2, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigPasswordAlias> getPasswordAlias() {
        return this.passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=2, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="password-alias", refType="PasswordAlias", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference<ConfigPasswordAlias>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Password alias", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasswordAlias(ObjectReference<ConfigPasswordAlias> passwordAlias) {
        this.passwordAlias = passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="RaidVolume", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="raid-volume", refType="RaidVolume", isEnumeration=false, javaName="raidVolume", javaType="ObjectReference<ConfigRaidVolume>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Data storage location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigRaidVolume> getRaidVolume() {
        return this.raidVolume;
    }

    @XMLInfo(elementType="element", elementName="RaidVolume", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="raid-volume", refType="RaidVolume", isEnumeration=false, javaName="raidVolume", javaType="ObjectReference<ConfigRaidVolume>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Data storage location", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRaidVolume(ObjectReference<ConfigRaidVolume> raidVolume) {
        this.raidVolume = raidVolume;
    }

    @XMLInfo(elementType="element", elementName="ServerPort", elementOrder=4, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="server-port", refType="", isEnumeration=false, javaName="serverPort", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="16379", displayOrder=0, displayValue="Server port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getServerPort() {
        return this.serverPort;
    }

    @XMLInfo(elementType="element", elementName="ServerPort", elementOrder=4, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="server-port", refType="", isEnumeration=false, javaName="serverPort", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="16379", displayValue="Server port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    @XMLInfo(elementType="element", elementName="MonitorPort", elementOrder=5, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="monitor-port", refType="", isEnumeration=false, javaName="monitorPort", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="26379", displayOrder=0, displayValue="Monitor port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMonitorPort() {
        return this.monitorPort;
    }

    @XMLInfo(elementType="element", elementName="MonitorPort", elementOrder=5, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="monitor-port", refType="", isEnumeration=false, javaName="monitorPort", javaType="int", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="26379", displayValue="Monitor port", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMonitorPort(int monitorPort) {
        this.monitorPort = monitorPort;
    }

    @XMLInfo(elementType="element", elementName="EnablePeerGroup", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-peer-group", refType="", isEnumeration=true, javaName="enablePeerGroup", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Peer group mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnablePeerGroup() {
        return this.enablePeerGroup;
    }

    @XMLInfo(elementType="element", elementName="EnablePeerGroup", elementOrder=6, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-peer-group", refType="", isEnumeration=true, javaName="enablePeerGroup", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Peer group mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnablePeerGroup(String enablePeerGroup) {
        if (enablePeerGroup == null || Comparison.isIn(enablePeerGroup, DPEnumerations.TOGGLE)) {
            this.enablePeerGroup = enablePeerGroup;
        }
    }

    @XMLInfo(elementType="element", elementName="EnableSSL", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-ssl", refType="", isEnumeration=true, javaName="enableSSL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Enable TLS", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEnableSSL() {
        return this.enableSSL;
    }

    @XMLInfo(elementType="element", elementName="EnableSSL", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="enable-ssl", refType="", isEnumeration=true, javaName="enableSSL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Enable TLS", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEnableSSL(String enableSSL) {
        if (enableSSL == null || Comparison.isIn(enableSSL, DPEnumerations.TOGGLE)) {
            this.enableSSL = enableSSL;
        }
    }

    @XMLInfo(elementType="element", elementName="SSLCryptoKey", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-key", refType="CryptoKey", isEnumeration=false, javaName="sSLCryptoKey", javaType="ObjectReference<ConfigCryptoKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Crypto key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoKey> getSSLCryptoKey() {
        return this.sSLCryptoKey;
    }

    @XMLInfo(elementType="element", elementName="SSLCryptoKey", elementOrder=8, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-key", refType="CryptoKey", isEnumeration=false, javaName="sSLCryptoKey", javaType="ObjectReference<ConfigCryptoKey>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Crypto key", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLCryptoKey(ObjectReference<ConfigCryptoKey> sSLCryptoKey) {
        this.sSLCryptoKey = sSLCryptoKey;
    }

    @XMLInfo(elementType="element", elementName="SSLCryptoCertificate", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-cert", refType="CryptoCertificate", isEnumeration=false, javaName="sSLCryptoCertificate", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoCertificate> getSSLCryptoCertificate() {
        return this.sSLCryptoCertificate;
    }

    @XMLInfo(elementType="element", elementName="SSLCryptoCertificate", elementOrder=9, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="ssl-cert", refType="CryptoCertificate", isEnumeration=false, javaName="sSLCryptoCertificate", javaType="ObjectReference<ConfigCryptoCertificate>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Certificate", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSSLCryptoCertificate(ObjectReference<ConfigCryptoCertificate> sSLCryptoCertificate) {
        this.sSLCryptoCertificate = sSLCryptoCertificate;
    }

    @XMLInfo(elementType="element", elementName="IPAddress", elementOrder=10, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="ip-address", refType="", isEnumeration=false, javaName="iPAddress", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(?!(127.0.0.1|0.0.0.0|::|::1)$).*$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getIPAddress() {
        return this.iPAddress;
    }

    @XMLInfo(elementType="element", elementName="IPAddress", elementOrder=10, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="ip-address", refType="", isEnumeration=false, javaName="iPAddress", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(?!(127.0.0.1|0.0.0.0|::|::1)$).*$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="IP address", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIPAddress(String iPAddress) {
        if (iPAddress != null && iPAddress.matches("^(?!(127.0.0.1|0.0.0.0|::|::1)$).*$")) {
            this.iPAddress = iPAddress;
        }
    }

    public void addPeers(String element) {
        if (element == null) {
            return;
        }
        if (this.peers == null) {
            this.peers = new ArrayList();
        }
        this.peers.add(element);
    }

    public boolean removePeers(String element) {
        if (element == null || this.peers == null) {
            return false;
        }
        return this.peers.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Peers", elementOrder=11, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="peer", refType="", isEnumeration=false, javaName="peers", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(?!(127.0.0.1|0.0.0.0|::|::1)$).*$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Peers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getPeers() {
        return this.peers;
    }

    @XMLInfo(elementType="element", elementName="Peers", elementOrder=11, dataPowerType="dmLocalIPHostAddress", subType="", benign=false, isPassword=false, cliAlias="peer", refType="", isEnumeration=false, javaName="peers", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(?!(127.0.0.1|0.0.0.0|::|::1)$).*$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Peers", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPeers(ArrayList<String> peers) {
        this.peers = peers;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=false, javaName="priority", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=255L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="100", displayOrder=0, displayValue="Priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getPriority() {
        return this.priority;
    }

    @XMLInfo(elementType="element", elementName="Priority", elementOrder=12, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="priority", refType="", isEnumeration=false, javaName="priority", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=255L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="100", displayValue="Priority", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @XMLInfo(elementType="element", elementName="StrictMode", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="strict-mode", refType="", isEnumeration=true, javaName="strictMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Strict mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStrictMode() {
        return this.strictMode;
    }

    @XMLInfo(elementType="element", elementName="StrictMode", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="strict-mode", refType="", isEnumeration=true, javaName="strictMode", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Strict mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStrictMode(String strictMode) {
        if (strictMode == null || Comparison.isIn(strictMode, DPEnumerations.TOGGLE)) {
            this.strictMode = strictMode;
        }
    }

    @Override
    public int compareTo(ConfigQuotaEnforcementServer that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "passwordAlias", "raidVolume", "serverPort", "monitorPort", "enablePeerGroup", "enableSSL", "sSLCryptoKey", "sSLCryptoCertificate", "iPAddress", "peers", "priority", "strictMode");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.passwordAlias, this.raidVolume, this.serverPort, this.monitorPort, this.enablePeerGroup, this.enableSSL, this.sSLCryptoKey, this.sSLCryptoCertificate, this.iPAddress, this.peers, this.priority, this.strictMode);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "passwordAlias", "raidVolume", "serverPort", "monitorPort", "enablePeerGroup", "enableSSL", "sSLCryptoKey", "sSLCryptoCertificate", "iPAddress", "peers", "priority", "strictMode");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "passwordAlias", "raidVolume", "serverPort", "monitorPort", "enablePeerGroup", "enableSSL", "sSLCryptoKey", "sSLCryptoCertificate", "iPAddress", "peers", "priority", "strictMode"));
    }
}

