/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.WeekdayBitmap;
import java.util.Objects;

public class ConfigSLMSchedule
extends ConfigConfigBase {
    private String userSummary;
    private WeekdayBitmap daysOfWeek;
    private String startTime;
    private long duration;
    private String startDate;
    private String stopDate;
    private String timeZone;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="DaysOfWeek", elementOrder=2, dataPowerType="dmWeekdayBitmap", subType="", benign=false, isPassword=false, cliAlias="days", refType="", isEnumeration=false, javaName="daysOfWeek", javaType="WeekdayBitmap", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Week Days", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public WeekdayBitmap getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @XMLInfo(elementType="element", elementName="DaysOfWeek", elementOrder=2, dataPowerType="dmWeekdayBitmap", subType="", benign=false, isPassword=false, cliAlias="days", refType="", isEnumeration=false, javaName="daysOfWeek", javaType="WeekdayBitmap", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Week Days", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDaysOfWeek(WeekdayBitmap daysOfWeek) {
        this.daysOfWeek = daysOfWeek;
    }

    @XMLInfo(elementType="element", elementName="StartTime", elementOrder=3, dataPowerType="dmTimeOfDay", subType="", benign=false, isPassword=false, cliAlias="start", refType="", isEnumeration=false, javaName="startTime", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(([01][0-9])|(2[0-3])):[0-5][0-9]:[0-5][0-9]$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Start Time", units="hh:mm:ss", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStartTime() {
        return this.startTime;
    }

    @XMLInfo(elementType="element", elementName="StartTime", elementOrder=3, dataPowerType="dmTimeOfDay", subType="", benign=false, isPassword=false, cliAlias="start", refType="", isEnumeration=false, javaName="startTime", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^(([01][0-9])|(2[0-3])):[0-5][0-9]:[0-5][0-9]$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Start Time", units="hh:mm:ss", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStartTime(String startTime) {
        if (startTime != null && startTime.matches("^(([01][0-9])|(2[0-3])):[0-5][0-9]:[0-5][0-9]$")) {
            this.startTime = startTime;
        }
    }

    @XMLInfo(elementType="element", elementName="Duration", elementOrder=4, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="duration", refType="", isEnumeration=false, javaName="duration", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=1440L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="1440", displayOrder=0, displayValue="Duration", units="minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getDuration() {
        return this.duration;
    }

    @XMLInfo(elementType="element", elementName="Duration", elementOrder=4, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="duration", refType="", isEnumeration=false, javaName="duration", javaType="long", isRequired=true, squelchNull=false, minimum=1, maximum=1440L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="1440", displayValue="Duration", units="minutes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDuration(long duration) {
        this.duration = duration;
    }

    @XMLInfo(elementType="element", elementName="StartDate", elementOrder=5, dataPowerType="dmDate", subType="", benign=false, isPassword=false, cliAlias="start-date", refType="", isEnumeration=false, javaName="startDate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^20[0-9][0-9]-((0[1-9])|(1[0-2]))-((0[1-9])|([12][0-9])|(3[01]))$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Start date", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStartDate() {
        return this.startDate;
    }

    @XMLInfo(elementType="element", elementName="StartDate", elementOrder=5, dataPowerType="dmDate", subType="", benign=false, isPassword=false, cliAlias="start-date", refType="", isEnumeration=false, javaName="startDate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^20[0-9][0-9]-((0[1-9])|(1[0-2]))-((0[1-9])|([12][0-9])|(3[01]))$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Start date", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStartDate(String startDate) {
        if (startDate != null && startDate.matches("^20[0-9][0-9]-((0[1-9])|(1[0-2]))-((0[1-9])|([12][0-9])|(3[01]))$")) {
            this.startDate = startDate;
        }
    }

    @XMLInfo(elementType="element", elementName="StopDate", elementOrder=6, dataPowerType="dmDate", subType="", benign=false, isPassword=false, cliAlias="stop-date", refType="", isEnumeration=false, javaName="stopDate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^20[0-9][0-9]-((0[1-9])|(1[0-2]))-((0[1-9])|([12][0-9])|(3[01]))$", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Stop date", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getStopDate() {
        return this.stopDate;
    }

    @XMLInfo(elementType="element", elementName="StopDate", elementOrder=6, dataPowerType="dmDate", subType="", benign=false, isPassword=false, cliAlias="stop-date", refType="", isEnumeration=false, javaName="stopDate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="^20[0-9][0-9]-((0[1-9])|(1[0-2]))-((0[1-9])|([12][0-9])|(3[01]))$", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Stop date", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setStopDate(String stopDate) {
        if (stopDate != null && stopDate.matches("^20[0-9][0-9]-((0[1-9])|(1[0-2]))-((0[1-9])|([12][0-9])|(3[01]))$")) {
            this.stopDate = stopDate;
        }
    }

    @XMLInfo(elementType="element", elementName="TimeZone", elementOrder=7, dataPowerType="dmSLMTimeZone", subType="", benign=false, isPassword=false, cliAlias="timezone", refType="", isEnumeration=true, javaName="timeZone", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="LOCAL", displayOrder=0, displayValue="Time zone", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getTimeZone() {
        return this.timeZone;
    }

    @XMLInfo(elementType="element", elementName="TimeZone", elementOrder=7, dataPowerType="dmSLMTimeZone", subType="", benign=false, isPassword=false, cliAlias="timezone", refType="", isEnumeration=true, javaName="timeZone", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="LOCAL", displayValue="Time zone", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTimeZone(String timeZone) {
        if (timeZone == null || Comparison.isIn(timeZone, DPEnumerations.SLMTIME_ZONE)) {
            this.timeZone = timeZone;
        }
    }

    @Override
    public int compareTo(ConfigSLMSchedule that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "daysOfWeek", "startTime", "duration", "startDate", "stopDate", "timeZone");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.daysOfWeek, this.startTime, this.duration, this.startDate, this.stopDate, this.timeZone);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "daysOfWeek", "startTime", "duration", "startDate", "stopDate", "timeZone");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "daysOfWeek", "startTime", "duration", "startDate", "stopDate", "timeZone"));
    }
}

