/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigCrypto;
import com.kumbasoft.core.beans.config.ConfigCryptoProfile;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class ConfigSSLProxyProfile
extends ConfigCrypto {
    private String direction;
    private ObjectReference<ConfigCryptoProfile> forwardCryptoProfile;
    private ObjectReference<ConfigCryptoProfile> reverseCryptoProfile;
    private String serverCaching;
    private long sessionTimeout;
    private long cacheSize;
    private String clientCache;
    private long clientSessionTimeout;
    private long clientCacheSize;
    private String clientAuthOptional;
    private String clientAuthAlwaysRequest;
    private String permitInsecureServers;

    @XMLInfo(elementType="element", elementName="Direction", elementOrder=1, dataPowerType="dmSSLProxyDirection", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="direction", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="TLS direction", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDirection() {
        return this.direction;
    }

    @XMLInfo(elementType="element", elementName="Direction", elementOrder=1, dataPowerType="dmSSLProxyDirection", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="direction", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="TLS direction", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDirection(String direction) {
        if (Comparison.isIn(direction, DPEnumerations.SSLPROXY_DIRECTION)) {
            this.direction = direction;
        }
    }

    @XMLInfo(elementType="element", elementName="ForwardCryptoProfile", elementOrder=2, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="CryptoProfile", isEnumeration=false, javaName="forwardCryptoProfile", javaType="ObjectReference<ConfigCryptoProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Client crypto profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoProfile> getForwardCryptoProfile() {
        return this.forwardCryptoProfile;
    }

    @XMLInfo(elementType="element", elementName="ForwardCryptoProfile", elementOrder=2, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="CryptoProfile", isEnumeration=false, javaName="forwardCryptoProfile", javaType="ObjectReference<ConfigCryptoProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Client crypto profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setForwardCryptoProfile(ObjectReference<ConfigCryptoProfile> forwardCryptoProfile) {
        this.forwardCryptoProfile = forwardCryptoProfile;
    }

    @XMLInfo(elementType="element", elementName="ReverseCryptoProfile", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="CryptoProfile", isEnumeration=false, javaName="reverseCryptoProfile", javaType="ObjectReference<ConfigCryptoProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Server crypto profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigCryptoProfile> getReverseCryptoProfile() {
        return this.reverseCryptoProfile;
    }

    @XMLInfo(elementType="element", elementName="ReverseCryptoProfile", elementOrder=3, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="CryptoProfile", isEnumeration=false, javaName="reverseCryptoProfile", javaType="ObjectReference<ConfigCryptoProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Server crypto profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setReverseCryptoProfile(ObjectReference<ConfigCryptoProfile> reverseCryptoProfile) {
        this.reverseCryptoProfile = reverseCryptoProfile;
    }

    @XMLInfo(elementType="element", elementName="ServerCaching", elementOrder=4, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="serverCaching", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Server-side session caching", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getServerCaching() {
        return this.serverCaching;
    }

    @XMLInfo(elementType="element", elementName="ServerCaching", elementOrder=4, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="serverCaching", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Server-side session caching", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setServerCaching(String serverCaching) {
        if (serverCaching == null || Comparison.isIn(serverCaching, DPEnumerations.TOGGLE)) {
            this.serverCaching = serverCaching;
        }
    }

    @XMLInfo(elementType="element", elementName="SessionTimeout", elementOrder=5, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="sess-timeout", refType="", isEnumeration=false, javaName="sessionTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="300", displayOrder=0, displayValue="Server-side session cache timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    @XMLInfo(elementType="element", elementName="SessionTimeout", elementOrder=5, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="sess-timeout", refType="", isEnumeration=false, javaName="sessionTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="300", displayValue="Server-side session cache timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    @XMLInfo(elementType="element", elementName="CacheSize", elementOrder=6, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="cache-size", refType="", isEnumeration=false, javaName="cacheSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=500L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="20", displayOrder=0, displayValue="Server-side session cache size", units="entries (x 1024)", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getCacheSize() {
        return this.cacheSize;
    }

    @XMLInfo(elementType="element", elementName="CacheSize", elementOrder=6, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="cache-size", refType="", isEnumeration=false, javaName="cacheSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=500L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="20", displayValue="Server-side session cache size", units="entries (x 1024)", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheSize(long cacheSize) {
        this.cacheSize = cacheSize;
    }

    @XMLInfo(elementType="element", elementName="ClientCache", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="client-cache", refType="", isEnumeration=true, javaName="clientCache", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="on", displayOrder=0, displayValue="Client-side session caching", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getClientCache() {
        return this.clientCache;
    }

    @XMLInfo(elementType="element", elementName="ClientCache", elementOrder=7, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="client-cache", refType="", isEnumeration=true, javaName="clientCache", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="on", displayValue="Client-side session caching", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setClientCache(String clientCache) {
        if (clientCache == null || Comparison.isIn(clientCache, DPEnumerations.TOGGLE)) {
            this.clientCache = clientCache;
        }
    }

    @XMLInfo(elementType="element", elementName="ClientSessionTimeout", elementOrder=8, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="client-sess-timeout", refType="", isEnumeration=false, javaName="clientSessionTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="300", displayOrder=0, displayValue="Client-side session cache timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getClientSessionTimeout() {
        return this.clientSessionTimeout;
    }

    @XMLInfo(elementType="element", elementName="ClientSessionTimeout", elementOrder=8, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="client-sess-timeout", refType="", isEnumeration=false, javaName="clientSessionTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=86400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="300", displayValue="Client-side session cache timeout", units="seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setClientSessionTimeout(long clientSessionTimeout) {
        this.clientSessionTimeout = clientSessionTimeout;
    }

    @XMLInfo(elementType="element", elementName="ClientCacheSize", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="client-cache-size", refType="", isEnumeration=false, javaName="clientCacheSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=500000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="100", displayOrder=0, displayValue="Client-side session cache size", units="entries", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getClientCacheSize() {
        return this.clientCacheSize;
    }

    @XMLInfo(elementType="element", elementName="ClientCacheSize", elementOrder=9, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="client-cache-size", refType="", isEnumeration=false, javaName="clientCacheSize", javaType="long", isRequired=false, squelchNull=false, minimum=1, maximum=500000L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="100", displayValue="Client-side session cache size", units="entries", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setClientCacheSize(long clientCacheSize) {
        this.clientCacheSize = clientCacheSize;
    }

    @XMLInfo(elementType="element", elementName="ClientAuthOptional", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="client-auth-optional", refType="", isEnumeration=true, javaName="clientAuthOptional", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Require client authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getClientAuthOptional() {
        return this.clientAuthOptional;
    }

    @XMLInfo(elementType="element", elementName="ClientAuthOptional", elementOrder=10, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="client-auth-optional", refType="", isEnumeration=true, javaName="clientAuthOptional", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Require client authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setClientAuthOptional(String clientAuthOptional) {
        if (clientAuthOptional == null || Comparison.isIn(clientAuthOptional, DPEnumerations.TOGGLE)) {
            this.clientAuthOptional = clientAuthOptional;
        }
    }

    @XMLInfo(elementType="element", elementName="ClientAuthAlwaysRequest", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="client-auth-always-request", refType="", isEnumeration=true, javaName="clientAuthAlwaysRequest", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Always request client authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getClientAuthAlwaysRequest() {
        return this.clientAuthAlwaysRequest;
    }

    @XMLInfo(elementType="element", elementName="ClientAuthAlwaysRequest", elementOrder=11, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="client-auth-always-request", refType="", isEnumeration=true, javaName="clientAuthAlwaysRequest", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Always request client authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setClientAuthAlwaysRequest(String clientAuthAlwaysRequest) {
        if (clientAuthAlwaysRequest == null || Comparison.isIn(clientAuthAlwaysRequest, DPEnumerations.TOGGLE)) {
            this.clientAuthAlwaysRequest = clientAuthAlwaysRequest;
        }
    }

    @XMLInfo(elementType="element", elementName="PermitInsecureServers", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="permit-insecure-servers", refType="", isEnumeration=true, javaName="permitInsecureServers", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Permit connections to insecure TLS servers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPermitInsecureServers() {
        return this.permitInsecureServers;
    }

    @XMLInfo(elementType="element", elementName="PermitInsecureServers", elementOrder=12, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="permit-insecure-servers", refType="", isEnumeration=true, javaName="permitInsecureServers", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Permit connections to insecure TLS servers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPermitInsecureServers(String permitInsecureServers) {
        if (permitInsecureServers == null || Comparison.isIn(permitInsecureServers, DPEnumerations.TOGGLE)) {
            this.permitInsecureServers = permitInsecureServers;
        }
    }

    @Override
    public int compareTo(ConfigSSLProxyProfile that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "direction", "forwardCryptoProfile", "reverseCryptoProfile", "serverCaching", "sessionTimeout", "cacheSize", "clientCache", "clientSessionTimeout", "clientCacheSize", "clientAuthOptional", "clientAuthAlwaysRequest", "permitInsecureServers");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.direction, this.forwardCryptoProfile, this.reverseCryptoProfile, this.serverCaching, this.sessionTimeout, this.cacheSize, this.clientCache, this.clientSessionTimeout, this.clientCacheSize, this.clientAuthOptional, this.clientAuthAlwaysRequest, this.permitInsecureServers);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "direction", "forwardCryptoProfile", "reverseCryptoProfile", "serverCaching", "sessionTimeout", "cacheSize", "clientCache", "clientSessionTimeout", "clientCacheSize", "clientAuthOptional", "clientAuthAlwaysRequest", "permitInsecureServers");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("direction", "forwardCryptoProfile", "reverseCryptoProfile", "serverCaching", "sessionTimeout", "cacheSize", "clientCache", "clientSessionTimeout", "clientCacheSize", "clientAuthOptional", "clientAuthAlwaysRequest", "permitInsecureServers"));
    }
}

