/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigConfigBase;
import com.kumbasoft.core.beans.config.ConfigNameValueProfile;
import com.kumbasoft.core.beans.config.ConfigStylePolicyRule;
import com.kumbasoft.core.beans.config.ConfigWebAppErrorHandlingPolicy;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.HTTPResponseCodes;
import com.kumbasoft.core.beans.types.HTTPVersionMask;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigWebAppResponse
extends ConfigConfigBase {
    private String userSummary;
    private String policyType;
    private HTTPResponseCodes oKCodes;
    private HTTPVersionMask oKVersions;
    private long minBodySize;
    private long maxBodySize;
    private ObjectReference<ConfigNameValueProfile> headerGNVC;
    private ArrayList<String> contentTypes;
    private String xMLPolicy;
    private ObjectReference<ConfigStylePolicyRule> xMLRule;
    private String nonXMLPolicy;
    private ObjectReference<ConfigStylePolicyRule> nonXMLRule;
    private ObjectReference<ConfigWebAppErrorHandlingPolicy> errorPolicy;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="PolicyType", elementOrder=2, dataPowerType="dmSatisfactionPolicy", subType="", benign=false, isPassword=false, cliAlias="policy-type", refType="", isEnumeration=true, javaName="policyType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="admission", displayOrder=0, displayValue="Style", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPolicyType() {
        return this.policyType;
    }

    @XMLInfo(elementType="element", elementName="PolicyType", elementOrder=2, dataPowerType="dmSatisfactionPolicy", subType="", benign=false, isPassword=false, cliAlias="policy-type", refType="", isEnumeration=true, javaName="policyType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="admission", displayValue="Style", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPolicyType(String policyType) {
        if (Comparison.isIn(policyType, DPEnumerations.SATISFACTION_POLICY)) {
            this.policyType = policyType;
        }
    }

    @XMLInfo(elementType="element", elementName="OKCodes", elementOrder=3, dataPowerType="dmHTTPResponseCodes", subType="", benign=false, isPassword=false, cliAlias="response-codes", refType="", isEnumeration=false, javaName="oKCodes", javaType="HTTPResponseCodes", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0xAD5D", displayOrder=0, displayValue="Response Codes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public HTTPResponseCodes getOKCodes() {
        return this.oKCodes;
    }

    @XMLInfo(elementType="element", elementName="OKCodes", elementOrder=3, dataPowerType="dmHTTPResponseCodes", subType="", benign=false, isPassword=false, cliAlias="response-codes", refType="", isEnumeration=false, javaName="oKCodes", javaType="HTTPResponseCodes", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0xAD5D", displayValue="Response Codes", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOKCodes(HTTPResponseCodes oKCodes) {
        this.oKCodes = oKCodes;
    }

    @XMLInfo(elementType="element", elementName="OKVersions", elementOrder=4, dataPowerType="dmHTTPVersionMask", subType="", benign=false, isPassword=false, cliAlias="response-versions", refType="", isEnumeration=false, javaName="oKVersions", javaType="HTTPVersionMask", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0x03", displayOrder=0, displayValue="Response Versions", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public HTTPVersionMask getOKVersions() {
        return this.oKVersions;
    }

    @XMLInfo(elementType="element", elementName="OKVersions", elementOrder=4, dataPowerType="dmHTTPVersionMask", subType="", benign=false, isPassword=false, cliAlias="response-versions", refType="", isEnumeration=false, javaName="oKVersions", javaType="HTTPVersionMask", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0x03", displayValue="Response Versions", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOKVersions(HTTPVersionMask oKVersions) {
        this.oKVersions = oKVersions;
    }

    @XMLInfo(elementType="element", elementName="MinBodySize", elementOrder=5, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="response-body-min", refType="", isEnumeration=false, javaName="minBodySize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="Minimum Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMinBodySize() {
        return this.minBodySize;
    }

    @XMLInfo(elementType="element", elementName="MinBodySize", elementOrder=5, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="response-body-min", refType="", isEnumeration=false, javaName="minBodySize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="Minimum Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMinBodySize(long minBodySize) {
        this.minBodySize = minBodySize;
    }

    @XMLInfo(elementType="element", elementName="MaxBodySize", elementOrder=6, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="response-body-max", refType="", isEnumeration=false, javaName="maxBodySize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="128000000", displayOrder=0, displayValue="Maximum Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getMaxBodySize() {
        return this.maxBodySize;
    }

    @XMLInfo(elementType="element", elementName="MaxBodySize", elementOrder=6, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="response-body-max", refType="", isEnumeration=false, javaName="maxBodySize", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="128000000", displayValue="Maximum Size", units="bytes", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxBodySize(long maxBodySize) {
        this.maxBodySize = maxBodySize;
    }

    @XMLInfo(elementType="element", elementName="HeaderGNVC", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="response-header-profile", refType="NameValueProfile", isEnumeration=false, javaName="headerGNVC", javaType="ObjectReference<ConfigNameValueProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Header Name-Value Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigNameValueProfile> getHeaderGNVC() {
        return this.headerGNVC;
    }

    @XMLInfo(elementType="element", elementName="HeaderGNVC", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="response-header-profile", refType="NameValueProfile", isEnumeration=false, javaName="headerGNVC", javaType="ObjectReference<ConfigNameValueProfile>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Header Name-Value Profile", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHeaderGNVC(ObjectReference<ConfigNameValueProfile> headerGNVC) {
        this.headerGNVC = headerGNVC;
    }

    public void addContentTypes(String element) {
        if (element == null) {
            return;
        }
        if (this.contentTypes == null) {
            this.contentTypes = new ArrayList();
        }
        this.contentTypes.add(element);
    }

    public boolean removeContentTypes(String element) {
        if (element == null || this.contentTypes == null) {
            return false;
        }
        return this.contentTypes.remove(element);
    }

    @XMLInfo(elementType="element", elementName="ContentTypes", elementOrder=8, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="response-content-type", refType="", isEnumeration=false, javaName="contentTypes", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue=".*", displayOrder=0, displayValue="Content-Type List", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getContentTypes() {
        return this.contentTypes;
    }

    @XMLInfo(elementType="element", elementName="ContentTypes", elementOrder=8, dataPowerType="dmPCRE", subType="", benign=false, isPassword=false, cliAlias="response-content-type", refType="", isEnumeration=false, javaName="contentTypes", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue=".*", displayValue="Content-Type List", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setContentTypes(ArrayList<String> contentTypes) {
        this.contentTypes = contentTypes;
    }

    @XMLInfo(elementType="element", elementName="XMLPolicy", elementOrder=9, dataPowerType="dmWebAppXMLPolicy", subType="", benign=false, isPassword=false, cliAlias="response-xml-policy", refType="", isEnumeration=true, javaName="xMLPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="nothing", displayOrder=0, displayValue="XML Processing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getXMLPolicy() {
        return this.xMLPolicy;
    }

    @XMLInfo(elementType="element", elementName="XMLPolicy", elementOrder=9, dataPowerType="dmWebAppXMLPolicy", subType="", benign=false, isPassword=false, cliAlias="response-xml-policy", refType="", isEnumeration=true, javaName="xMLPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="nothing", displayValue="XML Processing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXMLPolicy(String xMLPolicy) {
        if (xMLPolicy == null || Comparison.isIn(xMLPolicy, DPEnumerations.WEB_APP_XMLPOLICY)) {
            this.xMLPolicy = xMLPolicy;
        }
    }

    @XMLInfo(elementType="element", elementName="XMLRule", elementOrder=10, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="response-xml-rule", refType="StylePolicyRule", isEnumeration=false, javaName="xMLRule", javaType="ObjectReference<ConfigStylePolicyRule>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="XML Transformation Rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigStylePolicyRule> getXMLRule() {
        return this.xMLRule;
    }

    @XMLInfo(elementType="element", elementName="XMLRule", elementOrder=10, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="response-xml-rule", refType="StylePolicyRule", isEnumeration=false, javaName="xMLRule", javaType="ObjectReference<ConfigStylePolicyRule>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="XML Transformation Rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setXMLRule(ObjectReference<ConfigStylePolicyRule> xMLRule) {
        this.xMLRule = xMLRule;
    }

    @XMLInfo(elementType="element", elementName="NonXMLPolicy", elementOrder=11, dataPowerType="dmWebAppNonXMLPolicy", subType="", benign=false, isPassword=false, cliAlias="response-nonxml-policy", refType="", isEnumeration=true, javaName="nonXMLPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="nothing", displayOrder=0, displayValue="Non-XML Processing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getNonXMLPolicy() {
        return this.nonXMLPolicy;
    }

    @XMLInfo(elementType="element", elementName="NonXMLPolicy", elementOrder=11, dataPowerType="dmWebAppNonXMLPolicy", subType="", benign=false, isPassword=false, cliAlias="response-nonxml-policy", refType="", isEnumeration=true, javaName="nonXMLPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="nothing", displayValue="Non-XML Processing", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setNonXMLPolicy(String nonXMLPolicy) {
        if (nonXMLPolicy == null || Comparison.isIn(nonXMLPolicy, DPEnumerations.WEB_APP_NON_XMLPOLICY)) {
            this.nonXMLPolicy = nonXMLPolicy;
        }
    }

    @XMLInfo(elementType="element", elementName="NonXMLRule", elementOrder=12, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="response-nonxml-rule", refType="StylePolicyRule", isEnumeration=false, javaName="nonXMLRule", javaType="ObjectReference<ConfigStylePolicyRule>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Non-XML Processing Rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigStylePolicyRule> getNonXMLRule() {
        return this.nonXMLRule;
    }

    @XMLInfo(elementType="element", elementName="NonXMLRule", elementOrder=12, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="response-nonxml-rule", refType="StylePolicyRule", isEnumeration=false, javaName="nonXMLRule", javaType="ObjectReference<ConfigStylePolicyRule>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Non-XML Processing Rule", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setNonXMLRule(ObjectReference<ConfigStylePolicyRule> nonXMLRule) {
        this.nonXMLRule = nonXMLRule;
    }

    @XMLInfo(elementType="element", elementName="ErrorPolicy", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="error-policy-override", refType="WebAppErrorHandlingPolicy", isEnumeration=false, javaName="errorPolicy", javaType="ObjectReference<ConfigWebAppErrorHandlingPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Error Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigWebAppErrorHandlingPolicy> getErrorPolicy() {
        return this.errorPolicy;
    }

    @XMLInfo(elementType="element", elementName="ErrorPolicy", elementOrder=13, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="error-policy-override", refType="WebAppErrorHandlingPolicy", isEnumeration=false, javaName="errorPolicy", javaType="ObjectReference<ConfigWebAppErrorHandlingPolicy>", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Error Policy", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setErrorPolicy(ObjectReference<ConfigWebAppErrorHandlingPolicy> errorPolicy) {
        this.errorPolicy = errorPolicy;
    }

    @Override
    public int compareTo(ConfigWebAppResponse that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "policyType", "oKCodes", "oKVersions", "minBodySize", "maxBodySize", "headerGNVC", "contentTypes", "xMLPolicy", "xMLRule", "nonXMLPolicy", "nonXMLRule", "errorPolicy");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.policyType, this.oKCodes, this.oKVersions, this.minBodySize, this.maxBodySize, this.headerGNVC, this.contentTypes, this.xMLPolicy, this.xMLRule, this.nonXMLPolicy, this.nonXMLRule, this.errorPolicy);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "policyType", "oKCodes", "oKVersions", "minBodySize", "maxBodySize", "headerGNVC", "contentTypes", "xMLPolicy", "xMLRule", "nonXMLPolicy", "nonXMLRule", "errorPolicy");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "policyType", "oKCodes", "oKVersions", "minBodySize", "maxBodySize", "headerGNVC", "contentTypes", "xMLPolicy", "xMLRule", "nonXMLPolicy", "nonXMLRule", "errorPolicy"));
    }
}

