/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.config;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.config.ConfigAccessControl;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.ArrayList;
import java.util.Objects;

public class ConfigXACMLPDP
extends ConfigAccessControl {
    private String userSummary;
    private String equalPolicies;
    private String generalPolicy;
    private String combiningAlg;
    private ArrayList<String> dependentPolicy;
    private ArrayList<String> directory;
    private long cacheTTL;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="summary", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Comments", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="EqualPolicies", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="equal-policies", refType="", isEnumeration=true, javaName="equalPolicies", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="off", displayOrder=0, displayValue="Evaluate Individual Policies Equally", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEqualPolicies() {
        return this.equalPolicies;
    }

    @XMLInfo(elementType="element", elementName="EqualPolicies", elementOrder=2, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="equal-policies", refType="", isEnumeration=true, javaName="equalPolicies", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="off", displayValue="Evaluate Individual Policies Equally", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEqualPolicies(String equalPolicies) {
        if (equalPolicies == null || Comparison.isIn(equalPolicies, DPEnumerations.TOGGLE)) {
            this.equalPolicies = equalPolicies;
        }
    }

    @XMLInfo(elementType="element", elementName="GeneralPolicy", elementOrder=3, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="general-policy", refType="", isEnumeration=false, javaName="generalPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="General Policy File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getGeneralPolicy() {
        return this.generalPolicy;
    }

    @XMLInfo(elementType="element", elementName="GeneralPolicy", elementOrder=3, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="general-policy", refType="", isEnumeration=false, javaName="generalPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="General Policy File", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setGeneralPolicy(String generalPolicy) {
        this.generalPolicy = generalPolicy;
    }

    @XMLInfo(elementType="element", elementName="CombiningAlg", elementOrder=4, dataPowerType="dmXACMLCombiningAlg", subType="", benign=false, isPassword=false, cliAlias="combining-alg", refType="", isEnumeration=true, javaName="combiningAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Dependent Policies Combining", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getCombiningAlg() {
        return this.combiningAlg;
    }

    @XMLInfo(elementType="element", elementName="CombiningAlg", elementOrder=4, dataPowerType="dmXACMLCombiningAlg", subType="", benign=false, isPassword=false, cliAlias="combining-alg", refType="", isEnumeration=true, javaName="combiningAlg", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Dependent Policies Combining", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCombiningAlg(String combiningAlg) {
        if (combiningAlg == null || Comparison.isIn(combiningAlg, DPEnumerations.XACMLCOMBINING_ALG)) {
            this.combiningAlg = combiningAlg;
        }
    }

    public void addDependentPolicy(String element) {
        if (element == null) {
            return;
        }
        if (this.dependentPolicy == null) {
            this.dependentPolicy = new ArrayList();
        }
        this.dependentPolicy.add(element);
    }

    public boolean removeDependentPolicy(String element) {
        if (element == null || this.dependentPolicy == null) {
            return false;
        }
        return this.dependentPolicy.remove(element);
    }

    @XMLInfo(elementType="element", elementName="DependentPolicy", elementOrder=5, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="dependent-policy", refType="", isEnumeration=false, javaName="dependentPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Dependent Policy Files", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getDependentPolicy() {
        return this.dependentPolicy;
    }

    @XMLInfo(elementType="element", elementName="DependentPolicy", elementOrder=5, dataPowerType="dmURL", subType="", benign=false, isPassword=false, cliAlias="dependent-policy", refType="", isEnumeration=false, javaName="dependentPolicy", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Dependent Policy Files", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDependentPolicy(ArrayList<String> dependentPolicy) {
        this.dependentPolicy = dependentPolicy;
    }

    public void addDirectory(String element) {
        if (element == null) {
            return;
        }
        if (this.directory == null) {
            this.directory = new ArrayList();
        }
        this.directory.add(element);
    }

    public boolean removeDirectory(String element) {
        if (element == null || this.directory == null) {
            return false;
        }
        return this.directory.remove(element);
    }

    @XMLInfo(elementType="element", elementName="Directory", elementOrder=6, dataPowerType="dmFSDirectory", subType="", benign=false, isPassword=false, cliAlias="directory", refType="", isEnumeration=false, javaName="directory", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Other Policy Files from Directory", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<String> getDirectory() {
        return this.directory;
    }

    @XMLInfo(elementType="element", elementName="Directory", elementOrder=6, dataPowerType="dmFSDirectory", subType="", benign=false, isPassword=false, cliAlias="directory", refType="", isEnumeration=false, javaName="directory", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Other Policy Files from Directory", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDirectory(ArrayList<String> directory) {
        this.directory = directory;
    }

    @XMLInfo(elementType="element", elementName="CacheTTL", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="cache-ttl", refType="", isEnumeration=false, javaName="cacheTTL", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=2678400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="0", displayOrder=0, displayValue="XACML Policies Cache Lifetime", units="Seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getCacheTTL() {
        return this.cacheTTL;
    }

    @XMLInfo(elementType="element", elementName="CacheTTL", elementOrder=7, dataPowerType="dmUInt32", subType="", benign=false, isPassword=false, cliAlias="cache-ttl", refType="", isEnumeration=false, javaName="cacheTTL", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=2678400L, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="0", displayValue="XACML Policies Cache Lifetime", units="Seconds", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setCacheTTL(long cacheTTL) {
        this.cacheTTL = cacheTTL;
    }

    @Override
    public int compareTo(ConfigXACMLPDP that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "equalPolicies", "generalPolicy", "combiningAlg", "dependentPolicy", "directory", "cacheTTL");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.equalPolicies, this.generalPolicy, this.combiningAlg, this.dependentPolicy, this.directory, this.cacheTTL);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "equalPolicies", "generalPolicy", "combiningAlg", "dependentPolicy", "directory", "cacheTTL");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "equalPolicies", "generalPolicy", "combiningAlg", "dependentPolicy", "directory", "cacheTTL"));
    }
}

