/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.modify;

import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.modify.ModifyConfigBase;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.beans.types.SQLDataSourceConfigNVPair;
import com.kumbasoft.core.beans.types.SQLServer;
import java.util.ArrayList;
import java.util.Objects;

public class ModifySQLDataSource
extends ModifyConfigBase {
    private String userSummary;
    private String database;
    private String username;
    private ObjectReference passwordAlias;
    private String dataSourceID;
    private String dataSourceHost;
    private int dataSourcePort;
    private String limitReturnedData;
    private int limitReturnedDataSize;
    private ArrayList<SQLDataSourceConfigNVPair> sQLDataSourceConfigNVPairs;
    private int maxConnection;
    private String oracleDataSourceType;
    private String oracleObjects;
    private long connectTimeout;
    private long queryTimeout;
    private long idleTimeout;
    private String loadBalancing;
    private ArrayList<SQLServer> ancillaryServers;
    private String encryptionMethodMSSQL;
    private String encryptionMethodOracle;
    private String encryptionMethodDB2;
    private ObjectReference truststoreRef;
    private String validateServerCertificate;
    private String hostNameInCertificate;
    private String validateHostName;
    private ObjectReference keystoreRef;
    private String password;

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUserSummary() {
        return this.userSummary;
    }

    @XMLInfo(elementType="element", elementName="UserSummary", elementOrder=1, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="userSummary", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUserSummary(String userSummary) {
        this.userSummary = userSummary;
    }

    @XMLInfo(elementType="element", elementName="Database", elementOrder=2, dataPowerType="dmSQLDatabaseType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="database", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDatabase() {
        return this.database;
    }

    @XMLInfo(elementType="element", elementName="Database", elementOrder=2, dataPowerType="dmSQLDatabaseType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="database", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDatabase(String database) {
        if (database == null || Comparison.isIn(database, DPEnumerations.SQLDATABASE_TYPE)) {
            this.database = database;
        }
    }

    @XMLInfo(elementType="element", elementName="Username", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="username", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUsername() {
        return this.username;
    }

    @XMLInfo(elementType="element", elementName="Username", elementOrder=3, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="username", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUsername(String username) {
        this.username = username;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getPasswordAlias() {
        return this.passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="PasswordAlias", elementOrder=4, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="passwordAlias", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPasswordAlias(ObjectReference passwordAlias) {
        this.passwordAlias = passwordAlias;
    }

    @XMLInfo(elementType="element", elementName="DataSourceID", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="dataSourceID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDataSourceID() {
        return this.dataSourceID;
    }

    @XMLInfo(elementType="element", elementName="DataSourceID", elementOrder=5, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="dataSourceID", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDataSourceID(String dataSourceID) {
        this.dataSourceID = dataSourceID;
    }

    @XMLInfo(elementType="element", elementName="DataSourceHost", elementOrder=6, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="dataSourceHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDataSourceHost() {
        return this.dataSourceHost;
    }

    @XMLInfo(elementType="element", elementName="DataSourceHost", elementOrder=6, dataPowerType="dmHostname", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="dataSourceHost", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDataSourceHost(String dataSourceHost) {
        this.dataSourceHost = dataSourceHost;
    }

    @XMLInfo(elementType="element", elementName="DataSourcePort", elementOrder=7, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="dataSourcePort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getDataSourcePort() {
        return this.dataSourcePort;
    }

    @XMLInfo(elementType="element", elementName="DataSourcePort", elementOrder=7, dataPowerType="dmIPPort", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="dataSourcePort", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDataSourcePort(int dataSourcePort) {
        this.dataSourcePort = dataSourcePort;
    }

    @XMLInfo(elementType="element", elementName="LimitReturnedData", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="limitReturnedData", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLimitReturnedData() {
        return this.limitReturnedData;
    }

    @XMLInfo(elementType="element", elementName="LimitReturnedData", elementOrder=8, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="limitReturnedData", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLimitReturnedData(String limitReturnedData) {
        if (limitReturnedData == null || Comparison.isIn(limitReturnedData, DPEnumerations.TOGGLE)) {
            this.limitReturnedData = limitReturnedData;
        }
    }

    @XMLInfo(elementType="element", elementName="LimitReturnedDataSize", elementOrder=9, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="limitReturnedDataSize", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getLimitReturnedDataSize() {
        return this.limitReturnedDataSize;
    }

    @XMLInfo(elementType="element", elementName="LimitReturnedDataSize", elementOrder=9, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="limitReturnedDataSize", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLimitReturnedDataSize(int limitReturnedDataSize) {
        this.limitReturnedDataSize = limitReturnedDataSize;
    }

    public void addSQLDataSourceConfigNVPairs(SQLDataSourceConfigNVPair element) {
        if (element == null) {
            return;
        }
        if (this.sQLDataSourceConfigNVPairs == null) {
            this.sQLDataSourceConfigNVPairs = new ArrayList();
        }
        this.sQLDataSourceConfigNVPairs.add(element);
    }

    public boolean removeSQLDataSourceConfigNVPairs(SQLDataSourceConfigNVPair element) {
        if (element == null || this.sQLDataSourceConfigNVPairs == null) {
            return false;
        }
        return this.sQLDataSourceConfigNVPairs.remove(element);
    }

    @XMLInfo(elementType="element", elementName="SQLDataSourceConfigNVPairs", elementOrder=10, dataPowerType="dmSQLDataSourceConfigNVPair", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sQLDataSourceConfigNVPairs", javaType="SQLDataSourceConfigNVPair", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<SQLDataSourceConfigNVPair> getSQLDataSourceConfigNVPairs() {
        return this.sQLDataSourceConfigNVPairs;
    }

    @XMLInfo(elementType="element", elementName="SQLDataSourceConfigNVPairs", elementOrder=10, dataPowerType="dmSQLDataSourceConfigNVPair", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="sQLDataSourceConfigNVPairs", javaType="SQLDataSourceConfigNVPair", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSQLDataSourceConfigNVPairs(ArrayList<SQLDataSourceConfigNVPair> sQLDataSourceConfigNVPairs) {
        this.sQLDataSourceConfigNVPairs = sQLDataSourceConfigNVPairs;
    }

    @XMLInfo(elementType="element", elementName="MaxConnection", elementOrder=11, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxConnection", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public int getMaxConnection() {
        return this.maxConnection;
    }

    @XMLInfo(elementType="element", elementName="MaxConnection", elementOrder=11, dataPowerType="dmUInt16", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="maxConnection", javaType="int", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setMaxConnection(int maxConnection) {
        this.maxConnection = maxConnection;
    }

    @XMLInfo(elementType="element", elementName="OracleDataSourceType", elementOrder=12, dataPowerType="dmSQLOracleDataSourceType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="oracleDataSourceType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOracleDataSourceType() {
        return this.oracleDataSourceType;
    }

    @XMLInfo(elementType="element", elementName="OracleDataSourceType", elementOrder=12, dataPowerType="dmSQLOracleDataSourceType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="oracleDataSourceType", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOracleDataSourceType(String oracleDataSourceType) {
        if (oracleDataSourceType == null || Comparison.isIn(oracleDataSourceType, DPEnumerations.SQLORACLE_DATA_SOURCE_TYPE)) {
            this.oracleDataSourceType = oracleDataSourceType;
        }
    }

    @XMLInfo(elementType="element", elementName="OracleObjects", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="oracleObjects", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getOracleObjects() {
        return this.oracleObjects;
    }

    @XMLInfo(elementType="element", elementName="OracleObjects", elementOrder=13, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="oracleObjects", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setOracleObjects(String oracleObjects) {
        if (oracleObjects == null || Comparison.isIn(oracleObjects, DPEnumerations.TOGGLE)) {
            this.oracleObjects = oracleObjects;
        }
    }

    @XMLInfo(elementType="element", elementName="ConnectTimeout", elementOrder=14, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="connectTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    @XMLInfo(elementType="element", elementName="ConnectTimeout", elementOrder=14, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="connectTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @XMLInfo(elementType="element", elementName="QueryTimeout", elementOrder=15, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="queryTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getQueryTimeout() {
        return this.queryTimeout;
    }

    @XMLInfo(elementType="element", elementName="QueryTimeout", elementOrder=15, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="queryTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setQueryTimeout(long queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    @XMLInfo(elementType="element", elementName="IdleTimeout", elementOrder=16, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="idleTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @XMLInfo(elementType="element", elementName="IdleTimeout", elementOrder=16, dataPowerType="dmTimeInterval", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="idleTimeout", javaType="long", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    @XMLInfo(elementType="element", elementName="LoadBalancing", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="loadBalancing", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getLoadBalancing() {
        return this.loadBalancing;
    }

    @XMLInfo(elementType="element", elementName="LoadBalancing", elementOrder=17, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="loadBalancing", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setLoadBalancing(String loadBalancing) {
        if (loadBalancing == null || Comparison.isIn(loadBalancing, DPEnumerations.TOGGLE)) {
            this.loadBalancing = loadBalancing;
        }
    }

    public void addAncillaryServers(SQLServer element) {
        if (element == null) {
            return;
        }
        if (this.ancillaryServers == null) {
            this.ancillaryServers = new ArrayList();
        }
        this.ancillaryServers.add(element);
    }

    public boolean removeAncillaryServers(SQLServer element) {
        if (element == null || this.ancillaryServers == null) {
            return false;
        }
        return this.ancillaryServers.remove(element);
    }

    @XMLInfo(elementType="element", elementName="AncillaryServers", elementOrder=18, dataPowerType="dmSQLServer", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="ancillaryServers", javaType="SQLServer", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ArrayList<SQLServer> getAncillaryServers() {
        return this.ancillaryServers;
    }

    @XMLInfo(elementType="element", elementName="AncillaryServers", elementOrder=18, dataPowerType="dmSQLServer", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="ancillaryServers", javaType="SQLServer", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=0x7FFFFFFF, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAncillaryServers(ArrayList<SQLServer> ancillaryServers) {
        this.ancillaryServers = ancillaryServers;
    }

    @XMLInfo(elementType="element", elementName="EncryptionMethodMSSQL", elementOrder=19, dataPowerType="dmEncryptionMethodMSSQLType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="encryptionMethodMSSQL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncryptionMethodMSSQL() {
        return this.encryptionMethodMSSQL;
    }

    @XMLInfo(elementType="element", elementName="EncryptionMethodMSSQL", elementOrder=19, dataPowerType="dmEncryptionMethodMSSQLType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="encryptionMethodMSSQL", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptionMethodMSSQL(String encryptionMethodMSSQL) {
        if (encryptionMethodMSSQL == null || Comparison.isIn(encryptionMethodMSSQL, DPEnumerations.ENCRYPTION_METHOD_MSSQLTYPE)) {
            this.encryptionMethodMSSQL = encryptionMethodMSSQL;
        }
    }

    @XMLInfo(elementType="element", elementName="EncryptionMethodOracle", elementOrder=20, dataPowerType="dmEncryptionMethodOracleType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="encryptionMethodOracle", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncryptionMethodOracle() {
        return this.encryptionMethodOracle;
    }

    @XMLInfo(elementType="element", elementName="EncryptionMethodOracle", elementOrder=20, dataPowerType="dmEncryptionMethodOracleType", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="encryptionMethodOracle", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptionMethodOracle(String encryptionMethodOracle) {
        if (encryptionMethodOracle == null || Comparison.isIn(encryptionMethodOracle, DPEnumerations.ENCRYPTION_METHOD_ORACLE_TYPE)) {
            this.encryptionMethodOracle = encryptionMethodOracle;
        }
    }

    @XMLInfo(elementType="element", elementName="EncryptionMethodDB2", elementOrder=21, dataPowerType="dmEncryptionMethodDB2Type", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="encryptionMethodDB2", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncryptionMethodDB2() {
        return this.encryptionMethodDB2;
    }

    @XMLInfo(elementType="element", elementName="EncryptionMethodDB2", elementOrder=21, dataPowerType="dmEncryptionMethodDB2Type", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="encryptionMethodDB2", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptionMethodDB2(String encryptionMethodDB2) {
        if (encryptionMethodDB2 == null || Comparison.isIn(encryptionMethodDB2, DPEnumerations.ENCRYPTION_METHOD_DB2TYPE)) {
            this.encryptionMethodDB2 = encryptionMethodDB2;
        }
    }

    @XMLInfo(elementType="element", elementName="TruststoreRef", elementOrder=22, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="truststoreRef", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getTruststoreRef() {
        return this.truststoreRef;
    }

    @XMLInfo(elementType="element", elementName="TruststoreRef", elementOrder=22, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="truststoreRef", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setTruststoreRef(ObjectReference truststoreRef) {
        this.truststoreRef = truststoreRef;
    }

    @XMLInfo(elementType="element", elementName="ValidateServerCertificate", elementOrder=23, dataPowerType="dmValidateServerCertificate", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="validateServerCertificate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getValidateServerCertificate() {
        return this.validateServerCertificate;
    }

    @XMLInfo(elementType="element", elementName="ValidateServerCertificate", elementOrder=23, dataPowerType="dmValidateServerCertificate", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="validateServerCertificate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setValidateServerCertificate(String validateServerCertificate) {
        if (validateServerCertificate == null || Comparison.isIn(validateServerCertificate, DPEnumerations.VALIDATE_SERVER_CERTIFICATE)) {
            this.validateServerCertificate = validateServerCertificate;
        }
    }

    @XMLInfo(elementType="element", elementName="HostNameInCertificate", elementOrder=24, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="hostNameInCertificate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getHostNameInCertificate() {
        return this.hostNameInCertificate;
    }

    @XMLInfo(elementType="element", elementName="HostNameInCertificate", elementOrder=24, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="hostNameInCertificate", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setHostNameInCertificate(String hostNameInCertificate) {
        this.hostNameInCertificate = hostNameInCertificate;
    }

    @XMLInfo(elementType="element", elementName="ValidateHostName", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="validateHostName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getValidateHostName() {
        return this.validateHostName;
    }

    @XMLInfo(elementType="element", elementName="ValidateHostName", elementOrder=25, dataPowerType="dmToggle", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="validateHostName", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setValidateHostName(String validateHostName) {
        if (validateHostName == null || Comparison.isIn(validateHostName, DPEnumerations.TOGGLE)) {
            this.validateHostName = validateHostName;
        }
    }

    @XMLInfo(elementType="element", elementName="KeystoreRef", elementOrder=26, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="keystoreRef", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference getKeystoreRef() {
        return this.keystoreRef;
    }

    @XMLInfo(elementType="element", elementName="KeystoreRef", elementOrder=26, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="keystoreRef", javaType="ObjectReference", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setKeystoreRef(ObjectReference keystoreRef) {
        this.keystoreRef = keystoreRef;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="password", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPassword() {
        return this.password;
    }

    @XMLInfo(elementType="element", elementName="Password", elementOrder=4, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="password", javaType="String", isRequired=false, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public int compareTo(ModifySQLDataSource that) {
        int cmp = super.compareTo(that);
        if (cmp != 0) {
            return cmp;
        }
        return this.compareTo(that, "userSummary", "database", "username", "passwordAlias", "dataSourceID", "dataSourceHost", "dataSourcePort", "limitReturnedData", "limitReturnedDataSize", "sQLDataSourceConfigNVPairs", "maxConnection", "oracleDataSourceType", "oracleObjects", "connectTimeout", "queryTimeout", "idleTimeout", "loadBalancing", "ancillaryServers", "encryptionMethodMSSQL", "encryptionMethodOracle", "encryptionMethodDB2", "truststoreRef", "validateServerCertificate", "hostNameInCertificate", "validateHostName", "keystoreRef", "password");
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userSummary, this.database, this.username, this.passwordAlias, this.dataSourceID, this.dataSourceHost, this.dataSourcePort, this.limitReturnedData, this.limitReturnedDataSize, this.sQLDataSourceConfigNVPairs, this.maxConnection, this.oracleDataSourceType, this.oracleObjects, this.connectTimeout, this.queryTimeout, this.idleTimeout, this.loadBalancing, this.ancillaryServers, this.encryptionMethodMSSQL, this.encryptionMethodOracle, this.encryptionMethodDB2, this.truststoreRef, this.validateServerCertificate, this.hostNameInCertificate, this.validateHostName, this.keystoreRef, this.password);
    }

    @Override
    public boolean equals(Object that) {
        if (!super.equals(that)) {
            return false;
        }
        return this.equals(that, "userSummary", "database", "username", "passwordAlias", "dataSourceID", "dataSourceHost", "dataSourcePort", "limitReturnedData", "limitReturnedDataSize", "sQLDataSourceConfigNVPairs", "maxConnection", "oracleDataSourceType", "oracleObjects", "connectTimeout", "queryTimeout", "idleTimeout", "loadBalancing", "ancillaryServers", "encryptionMethodMSSQL", "encryptionMethodOracle", "encryptionMethodDB2", "truststoreRef", "validateServerCertificate", "hostNameInCertificate", "validateHostName", "keystoreRef", "password");
    }

    @Override
    public String toString() {
        return String.format("%s%s%s", super.toString(), this.getToStringDelimiter(), this.toString("userSummary", "database", "username", "passwordAlias", "dataSourceID", "dataSourceHost", "dataSourcePort", "limitReturnedData", "limitReturnedDataSize", "sQLDataSourceConfigNVPairs", "maxConnection", "oracleDataSourceType", "oracleObjects", "connectTimeout", "queryTimeout", "idleTimeout", "loadBalancing", "ancillaryServers", "encryptionMethodMSSQL", "encryptionMethodOracle", "encryptionMethodDB2", "truststoreRef", "validateServerCertificate", "hostNameInCertificate", "validateHostName", "keystoreRef", "password"));
    }
}

