/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.probe;

import com.jmorgan.io.filefilter.ExtensionFileFilter;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.lang.Application;
import com.jmorgan.lang.MultiThreadInvocationListener;
import com.jmorgan.util.Comparison;
import com.jmorgan.util.Date;
import com.jmorgan.util.DateTime;
import com.jmorgan.util.Time;
import com.jmorgan.util.comparator.BeanComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.app.KumbaCoreApplicationProperties;
import com.kumbasoft.core.app.KumbaCoreConstants;
import com.kumbasoft.core.beans.ExportOptions;
import com.kumbasoft.core.beans.KumbaCoreApplicationParameters;
import com.kumbasoft.core.beans.probe.ProbeCaptureProcessor;
import com.kumbasoft.core.beans.probe.TransactionIdentity;
import com.kumbasoft.core.beans.probe.TransactionIdentityXMLBeanMap;
import com.kumbasoft.core.beans.probe.TransactionManifest;
import com.kumbasoft.core.beans.status.StatusObjectStatus;
import com.kumbasoft.core.beans.types.DPEnumerations;
import com.kumbasoft.core.tools.AbstractTool;
import com.kumbasoft.core.tools.ExportConfiguration;
import com.kumbasoft.core.tools.ThreadManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class ProbeController
extends AbstractTool {
    private ProbeController() {
    }

    public static ArrayList<TransactionManifest> captureProbes(ArrayList<StatusObjectStatus> dpObjects) {
        AbstractTool.logger.finer(() -> LMG.log("(dpObjects):  Starting - exporting %d objects", () -> dpObjects.size()));
        HashMap<StatusObjectStatus, File> probeCaptureFiles = ProbeController.exportConfigurations(dpObjects);
        AbstractTool.logger.finer(() -> LMG.log("(dpObjects):  Received %d probe capture files from export.", () -> probeCaptureFiles.size()));
        HashMap<StatusObjectStatus, File> zipOutputDirectories = new HashMap<StatusObjectStatus, File>(probeCaptureFiles.size());
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        for (StatusObjectStatus dpObject : dpObjects) {
            File probeCaptureFile = probeCaptureFiles.get(dpObject);
            AbstractTool.logger.finer(() -> LMG.log("(dpObjects):  Processing '%s' for '%s'.", () -> probeCaptureFile.getAbsolutePath(), () -> dpObject.getFQON()));
            ProbeCaptureProcessor probeCaptureProcessor = new ProbeCaptureProcessor(probeCaptureFile);
            mtil.addThread(probeCaptureProcessor.getProcessThread());
            zipOutputDirectories.put(dpObject, probeCaptureProcessor.getOutputBaseDirectory());
        }
        ThreadManager.monitorAsynchThreadLifeCycle("ProbeController.captureProbes(...)", mtil, dpObjects.size() * KumbaCoreConstants.STARTUP_DELAY, 0);
        ArrayList<TransactionManifest> manifests = new ArrayList<TransactionManifest>();
        block1: for (StatusObjectStatus dpObject : dpObjects) {
            AbstractTool.logger.finer(() -> LMG.log("(dpObjects):  Building manifests for '%s'.", () -> dpObject.getFQON()));
            File outputBaseDirectory = (File)zipOutputDirectories.get(dpObject);
            File[] unzippedFiles = outputBaseDirectory.listFiles();
            HashMap<String, File> fileSystemDirectories = ProbeController.getFileSystemDirectories(unzippedFiles);
            File[] fileArray = unzippedFiles;
            int n = unzippedFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File unzippedFile = fileArray[n2];
                if (unzippedFile.isDirectory() && unzippedFile.getName().contains("@")) {
                    File[] transactionDirectories = unzippedFile.listFiles();
                    AbstractTool.logger.finer(() -> LMG.log("(dpObjects):  Found %d transactions in directory '%s' for '%s'.", () -> transactionDirectories.length, () -> unzippedFile.getAbsolutePath(), () -> dpObject.getFQON()));
                    File[] fileArray2 = transactionDirectories;
                    int n3 = transactionDirectories.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File transactionDirectory = fileArray2[n4];
                        File[] ruleDirectories = transactionDirectory.listFiles();
                        AbstractTool.logger.finer(() -> LMG.log("(dpObjects):  Found %d rules in transaction '%s' for '%s'.", () -> ruleDirectories.length, () -> transactionDirectory.getName(), () -> dpObject.getFQON()));
                        File[] fileArray3 = ruleDirectories;
                        int n5 = ruleDirectories.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            File ruleDirectory = fileArray3[n6];
                            if (ruleDirectory.getName().equals("0")) {
                                AbstractTool.logger.finer(() -> LMG.log("(dpObjects):  Processing rule '%s' in '%s' for '%s'.", () -> ruleDirectory.getAbsolutePath(), () -> transactionDirectory.getName(), () -> dpObject.getFQON()));
                                File[] contextFiles = ruleDirectory.listFiles(new ExtensionFileFilter(new String[]{"xml"}));
                                TransactionManifest transactionManifest = new TransactionManifest();
                                transactionManifest.setFileSystemDirectories(fileSystemDirectories);
                                File[] fileArray4 = contextFiles;
                                int n7 = contextFiles.length;
                                int n8 = 0;
                                while (n8 < n7) {
                                    File contextFile = fileArray4[n8];
                                    if (contextFile.getName().equals("0.xml")) {
                                        AbstractTool.logger.finer(() -> LMG.log("(dpObjects):  Processing '%s' context of the '%s' rule in the '%s' transaction for '%s'.", () -> contextFile.getName(), () -> ruleDirectory.getName(), () -> transactionDirectory.getName(), () -> dpObject.getFQON()));
                                        rootNode = XMLElement.parseXMLFile(contextFile);
                                        XMLElement debugNode = rootNode.getNode("dp:debug");
                                        XMLElement transactionIdentityNode = debugNode.getNode("transaction-ident");
                                        TransactionIdentity transactionIdentity = new TransactionIdentity();
                                        new TransactionIdentityXMLBeanMap(transactionIdentityNode, transactionIdentity);
                                        DateTime transactionTime = transactionIdentity.getTimestamp();
                                        transactionTime.getTime().setFormat(Time.FULL_FORMAT);
                                        transactionTime.setToStringDelimiter(" ");
                                        XMLElement auxDebugInfo = debugNode.getNode("aux-debug-info");
                                        XMLElement transactionHistory = auxDebugInfo.getNode("max-history");
                                        XMLElement protocolHeadersNode = debugNode.getNode("protocol-headers");
                                        ArrayList headerNodes = (ArrayList)protocolHeadersNode.getNodes();
                                        String globalTransactionID = "";
                                        for (XMLElement headerNode : headerNodes) {
                                            XMLElement keyNode = headerNode.getNode("key");
                                            if (!keyNode.getValue().equals("X-Global-Transaction-ID")) continue;
                                            XMLElement valueNode = headerNode.getNode("value");
                                            globalTransactionID = valueNode.getValue();
                                            break;
                                        }
                                        transactionManifest.setTransactionDirectory(transactionDirectory);
                                        transactionManifest.setAppliance(dpObject.getAppliance());
                                        transactionManifest.setDomain(dpObject.getSourceDomain());
                                        transactionManifest.setGlobalTransactionID(globalTransactionID);
                                        transactionManifest.setTransactionID(transactionIdentity.getTransactionID());
                                        transactionManifest.setTransactionTime(transactionTime);
                                        transactionManifest.setServiceType(dpObject.getDataPowerClass());
                                        transactionManifest.setServiceName(transactionIdentity.getServiceName());
                                        transactionManifest.setMatchedRuleName(transactionIdentity.getRuleName());
                                        transactionManifest.setInURL(transactionIdentity.getUrlIn());
                                        transactionManifest.setOutURL(transactionIdentity.getUrlOut());
                                        transactionManifest.setPolicyName(transactionIdentity.getStylePolicyName());
                                        transactionManifest.setPassthruMode(transactionIdentity.getPassThroughMode());
                                        transactionManifest.setClientIP(transactionIdentity.getClientIP());
                                        transactionManifest.setTransactionHistory(transactionHistory.getValue());
                                        manifests.add(transactionManifest);
                                    } else if (contextFile.getName().equals("manifest.xml")) {
                                        AbstractTool.logger.finer(() -> LMG.log("(dpObjects):  Processing manifest of the '%s' rule in the '%s' transaction for '%s'.", () -> ruleDirectory.getName(), () -> transactionDirectory.getName(), () -> dpObject.getFQON()));
                                        rootNode = XMLElement.parseXMLFile(contextFile);
                                        if (rootNode == null) {
                                            AbstractTool.logger.warning(() -> LMG.log("(dpObjects):  Rootnode is NULL for 'manifest.xml' for the '%s' rule in the '%s' transaction for '%s'.", () -> ruleDirectory.getName(), () -> transactionDirectory.getName(), () -> dpObject.getFQON()));
                                        } else {
                                            XMLElement manifestNode = rootNode.getNode("transaction-manifest");
                                            XMLElement transactionAborted = manifestNode.getNode("transaction-aborted");
                                            transactionManifest.setTransactionAborted(Boolean.parseBoolean(transactionAborted.getValue()));
                                        }
                                    }
                                    ++n8;
                                }
                                break;
                            }
                            ++n6;
                        }
                        ++n4;
                    }
                    continue block1;
                }
                ++n2;
            }
        }
        BeanComparator manifestSorter = new BeanComparator();
        manifestSorter.addCompareProperty("transactionTime");
        AbstractTool.logger.finer(() -> LMG.log("(dpObjects):  Sorting %d manifests", () -> manifests.size()));
        Collections.sort(manifests, manifestSorter);
        AbstractTool.logger.finer("(dpObjects):  Done");
        return manifests;
    }

    private static HashMap<String, File> getFileSystemDirectories(File[] exportedFiles) {
        HashMap<String, File> fileSystemDirectories = new HashMap<String, File>();
        File[] fileArray = exportedFiles;
        int n = exportedFiles.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName;
            String fileStoreName;
            File file = fileArray[n2];
            if (file.isDirectory() && Comparison.isIn(fileStoreName = (fileName = file.getName()) + ":", DPEnumerations.FILE_STORE)) {
                fileSystemDirectories.put(fileName, file);
            }
            ++n2;
        }
        return fileSystemDirectories;
    }

    private static HashMap<StatusObjectStatus, File> exportConfigurations(ArrayList<StatusObjectStatus> dpObjects) {
        AbstractTool.logger.finer("(dpObjects):  Starting");
        KumbaCoreApplicationParameters applicationParameters = (KumbaCoreApplicationParameters)Application.getApplication().getApplicationParametersBean();
        AbstractTool.logger.finer(() -> LMG.log("(dpObjects): Connection timeout: %d, Read timeout: %s", () -> applicationParameters.getSomaConnectionTimeout(), () -> applicationParameters.getSomaReadTimeout()));
        KumbaCoreApplicationProperties applicationProperties = (KumbaCoreApplicationProperties)Application.getApplication().getApplicationProperties();
        String probeCaptureDirectory = applicationProperties.getProbeCaptureDirectory();
        DateTime captureTime = new DateTime();
        captureTime.getDate().setFormat(Date.SQL_FORMAT);
        captureTime.getTime().setFormat(Time.FILENAME_FRIENDLY_FORMAT);
        captureTime.setToStringDelimiter("_");
        String captureFileName = String.format("%s.zip", captureTime.toString());
        String formatString = "%s".repeat(10);
        MultiThreadInvocationListener mtil = new MultiThreadInvocationListener();
        HashMap<StatusObjectStatus, File> outputFiles = new HashMap<StatusObjectStatus, File>();
        for (StatusObjectStatus objectStatus : dpObjects) {
            AbstractTool.logger.finer(() -> LMG.log("(dpObjects):  Exporting %s", () -> objectStatus.getFQON()));
            String dpClassName = objectStatus.getDataPowerClass();
            String dpObjectName = objectStatus.getName();
            String captureOutputDirectoryName = String.format(formatString, probeCaptureDirectory, File.separator, objectStatus.getAppliance().getName(), File.separator, objectStatus.getSourceDomain().getName(), File.separator, dpClassName, File.separator, dpObjectName, File.separator);
            File captureDirectory = new File(captureOutputDirectoryName);
            if (!captureDirectory.exists()) {
                captureDirectory.mkdirs();
            }
            File outputFile = new File(captureDirectory, captureFileName);
            outputFiles.put(objectStatus, outputFile);
            AbstractTool.logger.fine(() -> LMG.log("(dpObjects):  Starting export of %s", () -> objectStatus.getFQON()));
            ExportOptions exportOptions = ExportConfiguration.createDefaultExportOptions();
            exportOptions.setOutputDirectory(probeCaptureDirectory);
            exportOptions.setExportDebug(true);
            exportOptions.setExportFormat(DPEnumerations.EXPORT_FORMAT[0]);
            ExportConfiguration exportConfiguration = new ExportConfiguration(objectStatus, exportOptions);
            exportConfiguration.setExportFileName(outputFile.getAbsolutePath());
            exportConfiguration.setConnectionTimeout(applicationParameters.getSomaConnectionTimeout());
            exportConfiguration.setReadTimeout(applicationParameters.getSomaReadTimeout());
            mtil.addThread(exportConfiguration.getProcessThread());
        }
        AbstractTool.logger.finer("(dpObjects):  Waiting for all exports to complete.");
        boolean completedOnTime = ThreadManager.monitorAsynchThreadLifeCycle("ProbeController.exportConfigurations(...)", mtil, dpObjects.size() * KumbaCoreConstants.STARTUP_DELAY, applicationParameters.getSomaConnectionTimeout() + applicationParameters.getSomaReadTimeout());
        if (completedOnTime) {
            AbstractTool.logger.finer("(dpObjects):  Done");
        } else {
            AbstractTool.logger.warning("(dpObjecs):  Did not complete exports on time.  Not holding up user.");
        }
        return outputFiles;
    }
}

