/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.probe;

import com.jmorgan.j2ee.xml.XMLBeanMap;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.util.DateTime;
import com.kumbasoft.core.beans.probe.Call;
import com.kumbasoft.core.beans.probe.Parameter;
import com.kumbasoft.core.beans.probe.ParameterXMLBeanMap;
import com.kumbasoft.core.beans.probe.TransactionIdentity;
import com.kumbasoft.core.beans.probe.Variable;
import com.kumbasoft.core.beans.probe.VariableXMLBeanMap;
import java.util.ArrayList;
import java.util.HashMap;

public class TransactionIdentityXMLBeanMap
extends XMLBeanMap<TransactionIdentity> {
    private static final HashMap<String, String> ELEMENT_TO_NAME_MAP = new HashMap();

    static {
        ELEMENT_TO_NAME_MAP.put("timestamp", "timestamp");
        ELEMENT_TO_NAME_MAP.put("service-domain", "domainName");
        ELEMENT_TO_NAME_MAP.put("service-type", "serviceType");
        ELEMENT_TO_NAME_MAP.put("service-name", "serviceName");
        ELEMENT_TO_NAME_MAP.put("transaction-id", "transactionID");
        ELEMENT_TO_NAME_MAP.put("rule-name", "ruleName");
        ELEMENT_TO_NAME_MAP.put("rule-dir", "ruleDirection");
        ELEMENT_TO_NAME_MAP.put("in-url", "urlIn");
        ELEMENT_TO_NAME_MAP.put("out-url", "urlOut");
        ELEMENT_TO_NAME_MAP.put("stylepolicy", "stylePolicyName");
        ELEMENT_TO_NAME_MAP.put("passthru-mode", "passThroughMode");
        ELEMENT_TO_NAME_MAP.put("prev-action", "previousAction");
        ELEMENT_TO_NAME_MAP.put("prev-op", "previousOperation");
        ELEMENT_TO_NAME_MAP.put("curr-action", "currentAction");
        ELEMENT_TO_NAME_MAP.put("curr-op", "currentOperation");
        ELEMENT_TO_NAME_MAP.put("next-action", "nextAction");
        ELEMENT_TO_NAME_MAP.put("next-op", "nextOperation");
        ELEMENT_TO_NAME_MAP.put("input-context", "inputContext");
        ELEMENT_TO_NAME_MAP.put("client-ip", "clientIP");
        ELEMENT_TO_NAME_MAP.put("variables", "variables");
        ELEMENT_TO_NAME_MAP.put("parameters", "parameters");
        ELEMENT_TO_NAME_MAP.put("calls", "calls");
    }

    public TransactionIdentityXMLBeanMap(XMLElement rootNode, TransactionIdentity bean) {
        super(rootNode, bean, ELEMENT_TO_NAME_MAP);
    }

    public TransactionIdentityXMLBeanMap(XMLElement rootNode, TransactionIdentity bean, boolean debug) {
        super(rootNode, bean, ELEMENT_TO_NAME_MAP, debug);
    }

    @Override
    public Object getValueFor(String property, Object value) {
        switch (property) {
            case "timestamp": {
                String timeStampValue = (String)value;
                long timestamp = Long.parseLong(timeStampValue);
                return new DateTime(timestamp);
            }
            case "variables": {
                if (value != null) {
                    ArrayList variableNodes = (ArrayList)value;
                    ArrayList<Variable> variables = new ArrayList<Variable>(variableNodes.size());
                    for (XMLElement variableNode : variableNodes) {
                        Variable variable = new Variable();
                        new VariableXMLBeanMap(variableNode, variable, false);
                        variables.add(variable);
                    }
                    return variables;
                }
                return value;
            }
            case "parameters": {
                if (value != null) {
                    ArrayList parameterNodes = (ArrayList)value;
                    ArrayList<Parameter> parameters = new ArrayList<Parameter>(parameterNodes.size());
                    for (XMLElement parameterNode : parameterNodes) {
                        Parameter parameter = new Parameter();
                        new ParameterXMLBeanMap(parameterNode, parameter, false);
                        parameters.add(parameter);
                    }
                    return parameters;
                }
                return value;
            }
            case "calls": {
                if (value != null) {
                    ArrayList callNodes = (ArrayList)value;
                    ArrayList<Call> calls = new ArrayList<Call>(callNodes.size());
                    for (XMLElement callNode : callNodes) {
                        String strValue = callNode.getValue();
                        Call call = new Call(Integer.parseInt(strValue));
                        calls.add(call);
                    }
                    return calls;
                }
                return value;
            }
        }
        return super.getValueFor(property, value);
    }
}

