/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.probe;

import com.jmorgan.io.filefilter.ExtensionFileFilter;
import com.jmorgan.j2ee.xml.XMLElement;
import com.jmorgan.util.StringUtility;
import com.jmorgan.util.comparator.FileNameComparator;
import com.jmorgan.util.logging.LMG;
import com.kumbasoft.core.beans.ConfigurationManager;
import com.kumbasoft.core.beans.config.ConfigStylePolicyAction;
import com.kumbasoft.core.beans.probe.AttachmentTrace;
import com.kumbasoft.core.beans.probe.CallTrace;
import com.kumbasoft.core.beans.probe.CallTraceXMLBeanMap;
import com.kumbasoft.core.beans.probe.ProtocolHeader;
import com.kumbasoft.core.beans.probe.TransactionContext;
import com.kumbasoft.core.beans.probe.TransactionIdentity;
import com.kumbasoft.core.beans.probe.TransactionIdentityXMLBeanMap;
import com.kumbasoft.core.beans.probe.TransactionManifest;
import com.kumbasoft.core.beans.probe.TransactionRule;
import com.kumbasoft.core.beans.probe.TransactionRuleXMLBeanMap;
import com.kumbasoft.core.beans.probe.Variable;
import com.kumbasoft.core.beans.probe.VariableXMLBeanMap;
import com.kumbasoft.core.tools.AbstractTool;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public final class TransactionRuleReader
extends AbstractTool {
    private TransactionRuleReader() {
    }

    public static void readTransactionData(TransactionManifest manifest) {
        AbstractTool.logger.finer("(TransactionManifest manifest): Starting");
        File transactionDirectory = manifest.getTransactionDirectory();
        String transactionDirectoryName = transactionDirectory.getName();
        File[] ruleDirectories = transactionDirectory.listFiles();
        if (ruleDirectories == null) {
            AbstractTool.logger.severe(() -> LMG.log("(TransactionManifest manifest): Cannot read rule data due to empty directory:\n\t\t'%s'.", () -> transactionDirectoryName));
            return;
        }
        FileNameComparator fileNameComparator = new FileNameComparator();
        fileNameComparator.setUseAbsolutePath(false);
        Arrays.sort(ruleDirectories, fileNameComparator);
        AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Processing %d rules from transaction directory '%s'", () -> ruleDirectories.length, () -> transactionDirectoryName));
        File[] fileArray = ruleDirectories;
        int n = ruleDirectories.length;
        int n2 = 0;
        while (n2 < n) {
            File ruleDirectory = fileArray[n2];
            String ruleDirectoryName = ruleDirectory.getName();
            AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Processing '%s' rule directory within transaction directory '%s'", () -> ruleDirectoryName, () -> transactionDirectoryName));
            File manifestFile = new File(ruleDirectory, "manifest.xml");
            XMLElement ruleManifestRootNode = XMLElement.parseXMLFile(manifestFile);
            if (ruleManifestRootNode == null) {
                AbstractTool.logger.info(() -> LMG.log("(TransactionManifest manifest): Missing 'manifest.xml' within '%s' for transaction in directory '%s'", () -> ruleDirectoryName, () -> transactionDirectoryName));
            } else {
                TransactionRule rule = new TransactionRule(manifest);
                rule.setRuleNumber(Integer.parseInt(ruleDirectoryName));
                AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Processing manifest for '%s' rule within transaction directory '%s'", () -> ruleDirectoryName, () -> transactionDirectoryName));
                XMLElement transactionManifestNode = ruleManifestRootNode.getNode("transaction-manifest");
                new TransactionRuleXMLBeanMap(transactionManifestNode, rule);
                manifest.addTransactionRule(rule);
                File[] contextFiles = ruleDirectory.listFiles(new ExtensionFileFilter(new String[]{"xml"}));
                Arrays.sort(contextFiles, fileNameComparator);
                AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Processing %d contexts for '%s' rule within transaction directory '%s'", () -> contextFiles.length, () -> ruleDirectoryName, () -> transactionDirectoryName));
                TransactionContext previousContext = null;
                File[] fileArray2 = contextFiles;
                int n3 = contextFiles.length;
                int n4 = 0;
                while (n4 < n3) {
                    File contextFile = fileArray2[n4];
                    String contextFileName = contextFile.getName();
                    if (!contextFileName.endsWith(".gz") && !contextFileName.contains("manifest")) {
                        XMLElement configNode;
                        XMLElement actionNode;
                        AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Processing '%s' context for '%s' rule within transaction directory '%s'", () -> contextFileName, () -> ruleDirectoryName, () -> transactionDirectoryName));
                        TransactionContext transactionContext = new TransactionContext(rule);
                        String contextFileNumber = contextFileName;
                        contextFileNumber = StringUtility.substringBefore(contextFileNumber, ".xml");
                        transactionContext.setContextNumber(Integer.parseInt(contextFileNumber));
                        rule.addTransactionContext(transactionContext);
                        XMLElement rootNode = XMLElement.parseXMLFile(contextFile);
                        XMLElement debugNode = rootNode.getNode("dp:debug");
                        AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Processing transaction identify for '%s' context for '%s' rule within transaction directory '%s'", () -> contextFileName, () -> ruleDirectoryName, () -> transactionDirectoryName));
                        XMLElement transactionIdent = debugNode.getNode("transaction-ident");
                        TransactionIdentity transactionIdentity = new TransactionIdentity();
                        new TransactionIdentityXMLBeanMap(transactionIdent, transactionIdentity, false);
                        transactionContext.setTransactionIdentity(transactionIdentity);
                        AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Processing transaction input for '%s' context for '%s' rule within transaction directory '%s'", () -> contextFileName, () -> ruleDirectoryName, () -> transactionDirectoryName));
                        XMLElement transactionInputNode = debugNode.getNode("transaction-input");
                        String transactionInput = transactionInputNode.getValue();
                        transactionContext.setTransactionInput(transactionInput);
                        AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Processing transaction variables for '%s' context for '%s' rule within transaction directory '%s'", () -> contextFileName, () -> ruleDirectoryName, () -> transactionDirectoryName));
                        XMLElement transactionVariablesNode = debugNode.getNode("transaction-variables");
                        Collection<XMLElement> transactionVariableNodes = transactionVariablesNode.getNodes();
                        ArrayList<Variable> transactionVariables = new ArrayList<Variable>(transactionVariableNodes.size());
                        for (XMLElement variableNode : transactionVariableNodes) {
                            Variable variable = new Variable();
                            new VariableXMLBeanMap(variableNode, variable, false);
                            transactionVariables.add(variable);
                        }
                        transactionContext.setVariables(transactionVariables);
                        AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Processing protocol headers for '%s' context for '%s' rule within transaction directory '%s'", () -> contextFileName, () -> ruleDirectoryName, () -> transactionDirectoryName));
                        XMLElement protocolHeadersNode = debugNode.getNode("protocol-headers");
                        Collection<XMLElement> protocolHeaderNodes = protocolHeadersNode.getNodes();
                        ArrayList<ProtocolHeader> protocolHeaders = new ArrayList<ProtocolHeader>(protocolHeaderNodes.size());
                        for (XMLElement protocolHeaderNode : protocolHeaderNodes) {
                            ProtocolHeader header = new ProtocolHeader();
                            XMLElement keyNode = protocolHeaderNode.getNode("key");
                            XMLElement valueNode = protocolHeaderNode.getNode("value");
                            header.setName(keyNode.getValue());
                            header.setValue(valueNode.getValue());
                            protocolHeaders.add(header);
                        }
                        transactionContext.setProtocolHeaders(protocolHeaders);
                        AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Processing attachment traces for '%s' context for '%s' rule within transaction directory '%s'", () -> contextFileName, () -> ruleDirectoryName, () -> transactionDirectoryName));
                        XMLElement attachmentTracesNode = debugNode.getNode("attachment-traces");
                        Collection<XMLElement> attachmentTraceNodes = attachmentTracesNode.getNodes();
                        ArrayList<AttachmentTrace> attachmentTraces = new ArrayList<AttachmentTrace>(attachmentTraceNodes.size());
                        transactionContext.setAttachmentTraces(attachmentTraces);
                        AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Processing extension (call) traces for '%s' context for '%s' rule within transaction directory '%s'", () -> contextFileName, () -> ruleDirectoryName, () -> transactionDirectoryName));
                        XMLElement callTracesNode = debugNode.getNode("call-traces");
                        Collection<XMLElement> callTraceNodes = callTracesNode.getNodes();
                        ArrayList<CallTrace> callTraces = new ArrayList<CallTrace>(callTraceNodes.size());
                        for (XMLElement callTraceNode : callTraceNodes) {
                            CallTrace callTrace = new CallTrace();
                            new CallTraceXMLBeanMap(callTraceNode, callTrace, false);
                            callTraces.add(callTrace);
                        }
                        AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Adding %d call traces for '%s' context (%s) for '%s' rule within transaction directory '%s'", () -> callTraces.size(), () -> contextFileName, () -> transactionContext.getContextNumber(), () -> ruleDirectoryName, () -> transactionDirectoryName));
                        if (previousContext != null) {
                            previousContext.setCallTraces(callTraces);
                        }
                        if ((actionNode = (configNode = debugNode.getNode("action-config")).getNode("StylePolicyAction")) != null) {
                            AbstractTool.logger.finer(() -> LMG.log("(TransactionManifest manifest): Building Style Policy Action Config for '%s' context for '%s' rule within transaction directory '%s'", () -> contextFileName, () -> ruleDirectoryName, () -> transactionDirectoryName));
                            ConfigStylePolicyAction actionConfig = (ConfigStylePolicyAction)ConfigurationManager.xmlToObject(manifest.getAppliance(), manifest.getDomain(), actionNode);
                            transactionContext.setActionConfig(actionConfig);
                        }
                        XMLElement auxilliaryNode = debugNode.getNode("aux-debug-info");
                        XMLElement transactionAbortedNode = auxilliaryNode.getNode("transaction-aborted");
                        boolean transactionAborted = Boolean.valueOf(transactionAbortedNode.getValue());
                        transactionContext.setErrorContext(transactionAborted);
                        previousContext = transactionContext;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        AbstractTool.logger.finer("(TransactionManifest manifest): Done");
    }
}

