/*
 * Decompiled with CFR 0.152.
 */
package com.kumbasoft.core.beans.types;

import com.jmorgan.beans.JMBean;
import com.jmorgan.util.Comparison;
import com.kumbasoft.core.annotations.XMLInfo;
import com.kumbasoft.core.beans.ObjectReference;
import com.kumbasoft.core.beans.config.ConfigFTPQuoteCommands;
import com.kumbasoft.core.beans.types.DPEnumerations;
import java.util.Objects;

public class FTPPolicy
extends JMBean
implements Comparable<FTPPolicy> {
    private String regExp;
    private String passive;
    private String authTLS;
    private String useCCC;
    private String encryptData;
    private String dataType;
    private String slashSTOU;
    private ObjectReference<ConfigFTPQuoteCommands> quotedCommands;
    private String sizeCheck;

    @XMLInfo(elementType="element", elementName="RegExp", elementOrder=0, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="regExp", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="URL matching expression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getRegExp() {
        return this.regExp;
    }

    @XMLInfo(elementType="element", elementName="RegExp", elementOrder=0, dataPowerType="dmString", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=false, javaName="regExp", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="URL matching expression", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setRegExp(String regExp) {
        this.regExp = regExp;
    }

    @XMLInfo(elementType="element", elementName="Passive", elementOrder=1, dataPowerType="dmFTPPassivePolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="passive", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="pasv-req", displayOrder=0, displayValue="Passive mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getPassive() {
        return this.passive;
    }

    @XMLInfo(elementType="element", elementName="Passive", elementOrder=1, dataPowerType="dmFTPPassivePolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="passive", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="pasv-req", displayValue="Passive mode", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setPassive(String passive) {
        if (Comparison.isIn(passive, DPEnumerations.FTPPASSIVE_POLICY)) {
            this.passive = passive;
        }
    }

    @XMLInfo(elementType="element", elementName="AuthTLS", elementOrder=2, dataPowerType="dmFTPAuthPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="authTLS", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="auth-off", displayOrder=0, displayValue="Encrypt command connection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getAuthTLS() {
        return this.authTLS;
    }

    @XMLInfo(elementType="element", elementName="AuthTLS", elementOrder=2, dataPowerType="dmFTPAuthPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="authTLS", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="auth-off", displayValue="Encrypt command connection", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setAuthTLS(String authTLS) {
        if (Comparison.isIn(authTLS, DPEnumerations.FTPAUTH_POLICY)) {
            this.authTLS = authTLS;
        }
    }

    @XMLInfo(elementType="element", elementName="UseCCC", elementOrder=3, dataPowerType="dmFTPCCCPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="useCCC", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="ccc-off", displayOrder=0, displayValue="Stop command encryption after authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getUseCCC() {
        return this.useCCC;
    }

    @XMLInfo(elementType="element", elementName="UseCCC", elementOrder=3, dataPowerType="dmFTPCCCPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="useCCC", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="ccc-off", displayValue="Stop command encryption after authentication", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setUseCCC(String useCCC) {
        if (Comparison.isIn(useCCC, DPEnumerations.FTPCCCPOLICY)) {
            this.useCCC = useCCC;
        }
    }

    @XMLInfo(elementType="element", elementName="EncryptData", elementOrder=4, dataPowerType="dmFTPDataEncryptionPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="encryptData", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="enc-data-off", displayOrder=0, displayValue="Encrypt file transfers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getEncryptData() {
        return this.encryptData;
    }

    @XMLInfo(elementType="element", elementName="EncryptData", elementOrder=4, dataPowerType="dmFTPDataEncryptionPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="encryptData", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="enc-data-off", displayValue="Encrypt file transfers", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setEncryptData(String encryptData) {
        if (Comparison.isIn(encryptData, DPEnumerations.FTPDATA_ENCRYPTION_POLICY)) {
            this.encryptData = encryptData;
        }
    }

    @XMLInfo(elementType="element", elementName="DataType", elementOrder=5, dataPowerType="dmFTPDataTypePolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="dataType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="binary", displayOrder=0, displayValue="Data type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getDataType() {
        return this.dataType;
    }

    @XMLInfo(elementType="element", elementName="DataType", elementOrder=5, dataPowerType="dmFTPDataTypePolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="dataType", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="binary", displayValue="Data type", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setDataType(String dataType) {
        if (Comparison.isIn(dataType, DPEnumerations.FTPDATA_TYPE_POLICY)) {
            this.dataType = dataType;
        }
    }

    @XMLInfo(elementType="element", elementName="SlashSTOU", elementOrder=6, dataPowerType="dmFTPSlashSTOUPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="slashSTOU", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="slash-stou-on", displayOrder=0, displayValue="Write unique file name if trailing slash", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSlashSTOU() {
        return this.slashSTOU;
    }

    @XMLInfo(elementType="element", elementName="SlashSTOU", elementOrder=6, dataPowerType="dmFTPSlashSTOUPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="slashSTOU", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="slash-stou-on", displayValue="Write unique file name if trailing slash", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSlashSTOU(String slashSTOU) {
        if (Comparison.isIn(slashSTOU, DPEnumerations.FTPSLASH_STOUPOLICY)) {
            this.slashSTOU = slashSTOU;
        }
    }

    @XMLInfo(elementType="element", elementName="QuotedCommands", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="FTPQuoteCommands", isEnumeration=false, javaName="quotedCommands", javaType="ObjectReference<ConfigFTPQuoteCommands>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="", displayOrder=0, displayValue="Quoted commands", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public ObjectReference<ConfigFTPQuoteCommands> getQuotedCommands() {
        return this.quotedCommands;
    }

    @XMLInfo(elementType="element", elementName="QuotedCommands", elementOrder=7, dataPowerType="dmReference", subType="", benign=false, isPassword=false, cliAlias="", refType="FTPQuoteCommands", isEnumeration=false, javaName="quotedCommands", javaType="ObjectReference<ConfigFTPQuoteCommands>", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="", displayValue="Quoted commands", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setQuotedCommands(ObjectReference<ConfigFTPQuoteCommands> quotedCommands) {
        this.quotedCommands = quotedCommands;
    }

    @XMLInfo(elementType="element", elementName="SizeCheck", elementOrder=8, dataPowerType="dmFTPSizeCheckPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sizeCheck", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, defaultValue="size-check-optional", displayOrder=0, displayValue="Size check", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public String getSizeCheck() {
        return this.sizeCheck;
    }

    @XMLInfo(elementType="element", elementName="SizeCheck", elementOrder=8, dataPowerType="dmFTPSizeCheckPolicy", subType="", benign=false, isPassword=false, cliAlias="", refType="", isEnumeration=true, javaName="sizeCheck", javaType="String", isRequired=true, squelchNull=false, minimum=0, maximum=0x7FFFFFFFL, minimumLength=0, maximumLength=0x7FFFFFFF, validationRegex="", allowedValues={}, displayOrder=0, defaultValue="size-check-optional", displayValue="Size check", units="", label="", multiplicity=1, status="", isDeprecated=false, deprecatedIn="", isObsolete=false, obsoletedIn="")
    public void setSizeCheck(String sizeCheck) {
        if (Comparison.isIn(sizeCheck, DPEnumerations.FTPSIZE_CHECK_POLICY)) {
            this.sizeCheck = sizeCheck;
        }
    }

    @Override
    public int compareTo(FTPPolicy that) {
        return this.compareTo(that, "regExp", "passive", "authTLS", "useCCC", "encryptData", "dataType", "slashSTOU", "quotedCommands", "sizeCheck");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.regExp, this.passive, this.authTLS, this.useCCC, this.encryptData, this.dataType, this.slashSTOU, this.quotedCommands, this.sizeCheck);
    }

    public boolean equals(Object that) {
        return this.equals(that, "regExp", "passive", "authTLS", "useCCC", "encryptData", "dataType", "slashSTOU", "quotedCommands", "sizeCheck");
    }

    @Override
    public String toString() {
        return this.toString("regExp", "passive", "authTLS", "useCCC", "encryptData", "dataType", "slashSTOU", "quotedCommands", "sizeCheck");
    }
}

